/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef DEFINITIONPARSER_H
#define DEFINITIONPARSER_H

#include <QRegExp>
#include <QMap>
#include <QVariant>

/**
* Definition parser.
*
* This class parses a definition string formatted according to the WebIssues protocol.
*
* @see DefinitionBuilder
*/
class DefinitionParser
{
public:
    /**
    * Default constructor.
    */
    DefinitionParser();

    /**
    * Destructor.
    */
    ~DefinitionParser();

public:
    /**
    * Parse the formatted string into type and metadata.
    */
    bool parse( const QString& text );

    /**
    * Return the type string.
    */
    const QString& type() const { return m_type; }

    /**
    * Return the metadata values.
    */
    const QMap<QString, QVariant>& metadata() const { return m_metadata; }

private:
    QStringList parseStringArray( const QString& value );
    QString parseString( const QString& value );

private:
    QRegExp m_stringRegExp;
    QRegExp m_attributeRegExp;

    QString m_type;

    QMap<QString, QVariant> m_metadata;
};

#endif
