/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef VIEWERWINDOW_H
#define VIEWERWINDOW_H

#include <QMainWindow>

#include "xmlui/client.h"

namespace XmlUi
{
class Builder;
}

namespace WebIssues
{

class View;

/**
* Container window which can contain any kind of view.
*
* The window adds the view's actions to its menu and toolbar,
* handles the view's signals and provides session management
* for the view.
*
* The viewer window is automatically created by the view manager
* when a view is opened.
*/
class ViewerWindow : public QMainWindow, public XmlUi::Client
{
    Q_OBJECT
public:
    /**
    * Constructor.
    */
    ViewerWindow();

    /**
    * Destructor.
    */
    ~ViewerWindow();

public:
    /**
    * Embed the given view in the window.
    */
    void setView( View* view );

    /**
    * Return the view contained in the window.
    */
    View* view() const { return m_view; }

public: // overrides
    QMenu* createPopupMenu();

protected: // overrides
    void closeEvent( QCloseEvent* e );

private slots:
    void configure();

    void captionChanged( const QString& caption );

    void enabledChanged( bool enabled );

private:
    XmlUi::Builder* m_builder;

    View* m_view;
};

}

#endif
