/* ==================================================== ======== ======= *
 *
 *  uuview.cc
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuview.cc	ubit:001.11.6"
#include <udefs.hh>
#include <ubrick.hh>
#include <ucolor.hh>
#include <ustr.hh>
#include <ucontext.hh>
#include <uborder.hh>
#include <uview.hh>
#include <uviewImpl.hh>
#include <uwin.hh>
#include <uappli.hh>
#include <ugraph.hh>
#include <upix.hh>
#include <ucall.hh>

#include <uobs.hh>    //!!tmp


/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

const UClass UViewStyle::uclass("UViewStyle");

UViewStyle::UViewStyle(UView* (*make_view)(UBoxLink*, UView*, UWinGraph*),
		       u_modes bm) : UMode(bm) {
  makeView = make_view;
}

void UViewStyle::update() {
//  fromLinks.updateParents(true, true, false); !!!! A REVOIR!!!!
}

void UViewStyle::addingTo(ULink *selflink, UGroup *parent) {
  UBrick::addingTo(selflink, parent);
  parent->setCmodes(UMode::HAS_RENDERER, true);
}

void UViewStyle::removingFrom(ULink *prevlink, UGroup *parent) {
  parent->setCmodes(UMode::HAS_RENDERER, false);
  UBrick::removingFrom(prevlink, parent);
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UViewExt::UViewExt() {
  old_region = null;
  //more to come...
}

UViewExt::~UViewExt() {
  if (old_region) delete old_region;
  //more to come...
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

UViewStyle UView::style(&UView::makeView, UMode::UCONST);

// "static" constructor used by UViewStyle to make a new view
UView* UView::makeView(UBoxLink*bl, UView* parview, UWinGraph* wgraph) {
  return new UView(bl, parview, wgraph);
}

UView::UView(UBoxLink *box_link, UView* par_view, UWinGraph *wgraph) {
  x = 0, y = 0;
  width = 0; height = 0;
  favoriteWidth = favoriteHeight = 0;
  boxlink = box_link;
  parview = par_view;
  wingraph = wgraph;
  vmodes = 0;
  ext = null;
}

UView::~UView() {
  if (ext) delete ext;
  // previent l'appli que cette vue est detruite
  //wingraph->getAppli()->deleteViewNotify(this); voir note dans uuappli.cc
  wingraph->getAppli()->deleteNotify(this);
}

void UView::_setXwin(int x_in_win) {x = x_in_win;}
void UView::_setYwin(int y_in_win) {y = y_in_win;}

// local coordinates of the origin of this View
// (location is relative to the parent View)
int UView::getX() const {
  if (parview) return x - parview->getXwin();
  else return 0;
}
int UView::getY() const {
  if (parview) return y - parview->getYwin();
  else return 0;
}

u_bool UView::where(u_pos &xloc, u_pos &yloc) const {
  if (parview) {
    xloc = x - parview->getXwin();
    yloc = y - parview->getYwin();
    return true;
  }
  else {
    //xloc = -1; yloc = -1;
    xloc = 0; yloc = 0;
    return false;
  }
}

u_bool UView::whereInWin(u_pos &xloc, u_pos &yloc) const {
  xloc = x; yloc = y;
  return true;
}

// returns false if undefined
u_bool UView::whereOnScreen(u_pos &xloc, u_pos &yloc) const {
  UWin *win = getHardwin();  //returns hardwin

  if (win && win->whereOnScreen(xloc, yloc)) {
    //dans le cas des hardwin et softwin il n'y a rien a ajouter
    //(et dans le cas des sotwins on ajouterait 2 fois x et y)
    if (!isDef(UView::WIN_SHARED)) {
      xloc += x;
      yloc += y;
    }
    return true;
  }
  else {
    //xloc = -1; yloc = -1;
    xloc = 0; yloc = 0;
    return false;
  }
}

/* ==================================================== ======== ======= */

//!!PAS DE UPDATE!!!
void UView::setWidth(u_dim w)  {width = w;}
void UView::setHeight(u_dim h) {height = h;}
void UView::resize(u_dim w, u_dim h) {width = w; height = h;}

// favorite size of this View
u_dim UView::getFavoriteWidth()  const {return favoriteWidth;}
u_dim UView::getFavoriteHeight() const {return favoriteHeight;}

UDisp*  UView::getDisp() const {
  return wingraph ? wingraph->getDisp() : null;
}
UAppli* UView::getAppli() const {
  return wingraph ? wingraph->getAppli() : null;
}
u_bool UView::isRealized() const {
  return wingraph ? wingraph->isWinRealized() : null;
}

//!!ATT: ces fcts renvoient la HARDWIN !!
UWin* UView::getHardwin() const {
  return wingraph ? wingraph->getHardwin() : null;
}
UView* UView::getHardwinView() const {
  UWin *win = getHardwin();
  return win ? win->getWinView() : null; 
}

// !ATT: returns null if parent is a Window
UBox* UView::getContainingParent() const {
  //return boxlink ? boxlink->parent() : null;
  if (boxlink && boxlink->parent()) 
    // normalement boxCast() est toujours verifie par construction
    return boxlink->parent()->boxCast();
  else return null;
}

UBox* UView::getBox() const {
  // normalement boxCast() est toujours verifie par construction
  return boxlink ? dynamic_cast<UBox*>(boxlink->brick()) : null;
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

void UMultiList::addSoftwinList(UGroup *grp) {
 UWin *hardwin = dynamic_cast<UWin*>(grp);
 ULink *link;
 if (hardwin && (link = hardwin->getSubSoftwinLinks()))
   addList(link);
}

// adds an Elem (and its followers) as a sublist of the MultiList

void UMultiList::addList(ULink *l) {
  if (!l) return;  // nop (nb: test important: sauter listes nulles)
  else if (count < MAXCOUNT) list_tab[count++] = l;
  else uerror("MultiList::addList", "too many elements");
}

// PRELUDE: tout ce qui n'est pas subclass d'item ou group
// parses the child list of grp, finds the 1st visible Elem (Item or Group)
// and adds it (and its followers) as a sublist

UMultiList::UMultiList(UContext& curp, UGroup* grp) {
  for (count = 0; count < MAXCOUNT; count++) list_tab[count] = null;
  count = 0;

  UProp *prop;
  for (ULink *ch = grp->getChildLinks(); ch != null; ch = ch->next()) {
    if (ch->brick()->itemCast() || ch->brick()->groupCast()) {
      addList(ch);
      break;  		// passer a la suite
    }
    else if ((prop = ch->brick()->propCast())) {
      if (ch->verifies(&curp, grp))  prop->putProp(&curp, grp);
    }
  }

  //!!!NEW:
  if (grp->isDef(0,UMode::HARDWIN)) addSoftwinList(grp);
  is_softwin_list = grp->isDef(0,UMode::SOFTWIN_LIST);
}

/* ===================================================== [Elc:01 ======= */
/* ==================================================== ======== ======= */

struct UViewLayoutData : public ULayoutData {
  //obs: u_bool keepSize;
  unsigned char orient;
  unsigned short flexCount;
  int children_w, children_h;

  UViewLayoutData(UView *v) : ULayoutData(v) {
    //obs: keepSize = keep_size;
    // orient initialise plus tard en fct de curp
    orient     = 0;
    flexCount  = 0;
    //NB: on utilise des vars intermediaires car 'favorite_*' doit rester
    //inchangee dans certains cas (voir note en bas de fct)
    children_w = 0;
    children_h = 0;
  }
};

/* ==================================================== ======== ======= */
// OBSOLETE: keepSize : ne pas changer la taille (w,h) de la view
// utilise qunad on fait un update partiel A L"INTERIEUR d'une autre vue
// pour eviter de deborder ou de deconner sur le reste
// !!PAR CONTRE: keepSize doit etre false sur les objets inclus ou
// qunad on refait un update global


static void viewDoLayout(UViewLayoutData &vd, UContext &curp, 
			 UGroup *grp, UViewLayout &vl);


u_bool UView::doLayout(UContext &parp, UViewLayout &vl) {
  UViewLayoutData vd(this /*,vl.keepSize*/); 
  UBox *box = getBox();
  UContext curp(box, this, parp);
  
  viewDoLayout(vd, curp, box, vl);

  box->flexCount = vd.flexCount; // !!
  ////shown = false;
  vl.cmin_w = vl.cmax_w = width;
  vl.cmin_h = vl.cmax_h = height;

  // IMPORTANT:  Height depend de Width pour les UFlowView
  // ceci impose de refaire une seconde fois le layout du parent
  // (sauf dans le cas ou Width est fixe a priori auquel cas Height
  // (peut directement etre determine des la premier passe)
  return vd.mustLayoutAgain;
};

/* ==================================================== ======== ======= */

static void viewDoLayout(UViewLayoutData &vd, UContext &curp, 
			 UGroup *grp, UViewLayout &vl) {
  UMultiList mlist(curp, grp);
  //fait aussi:
  //a) if (grp->isDef(0,UMode::HARDWIN)) mlist.addSoftwinList(grp);
  //b) u_bool is_softwin_list = grp->isDef(0,UMode::SOFTWIN_LIST);
 
  UGroup *chgrp = null;
  UBrick *b = null;
  UView *chboxview = null;
  ULink *ch = null;

  // interdiction de tenir compte de l'orient dans les UGroups
  if (grp->boxCast()) vd.orient = curp.local.orient;

  // if this group is not null (which generally is the case) the object
  // it contains are added to children for normal display
  // (can for instance be used for adding list-item markers, checkboxes...

  if (curp.local.content) {
    UGroup *content = curp.local.content;
    curp.local.content = null;	// avoid infinite recursion
    viewDoLayout(vd, curp, content, vl);    // pas de curp, meme vd
  }

  if (vd.orient == UOrient::vertical.get()) {
    for (ch = mlist.first(); ch != null; ch = mlist.next(ch))
      if (ch->verifies(&curp, grp)) {
	b = ch->brick();
	chboxview = null;
	UViewLayout chvl; //!att: reinit by constr.
	chgrp = null;

	// UProps
	if (b->propCast())  
	  b->propCast()->putProp(&curp, grp);

	// UItems
	else if (b->itemCast()) {
	  b->itemCast()->getSize(&curp, &chvl.cmax_w, &chvl.cmax_h);

	  //add spacing if something before
	  if (vd.visibleElemCount > 0) vd.children_h += curp.local.vspacing;

	  //NOTE: only take into account Ubox or Uitem
	  // (not Ugroup, not floating)
	  vd.visibleElemCount++;

	  // add element size
	  vd.children_h += chvl.cmax_h;
	  // take max
	  if (chvl.cmax_w > vd.children_w) vd.children_w = chvl.cmax_w;
	}

	// UGroups, UBoxes, UWins
	else if ((chgrp = b->groupCast()) && chgrp->isShowable()) {
	  
	  if (chgrp->boxCast()) {  //QUE BoxCast
	  
	    if (chgrp->isDef(0,UMode::BOX)  // UBox ou UWin incrust
		// this==hardwin && child==softwin :
		|| (mlist.isSoftwinList() && chgrp->isDef(0,UMode::SOFTWIN))
		) {
	      
	      if ((chboxview = ((UBoxLink*)ch)->getView(vd.view))) {

		if (chgrp->isDef(0, UMode::FLOATING) || ch->floatingCast()) {
		  //ne pas les compter dans taille globale
		  vd.mustLayoutAgain |= chboxview->doLayout(curp, chvl);
		}
		else {
		  // number of vertically "flex"ible child objects
		  if (curp.local.valign == UView::VFLEX) vd.flexCount++;
		  
		  vd.mustLayoutAgain |= chboxview->doLayout(curp, chvl);

		  //add spacing if something before
		  if (vd.visibleElemCount > 0) 
		    vd.children_h += curp.local.vspacing;
		  vd.visibleElemCount++;

		  // add element size
		  vd.children_h += chvl.cmax_h;
		  // take max
		  if (chvl.cmax_w > vd.children_w) vd.children_w = chvl.cmax_w;
		}
	      }
	    } //endif(INBOX)
	  } //endif(boxCast)
	  
	  else {  // just an UGroup
	    UContext chcurp(chgrp, vd.view, curp);
	    viewDoLayout(vd, chcurp, chgrp, vl);   //own curp, same vd
	  }
	}
      }
  } //endif(vertical)


  //***HORIZONTAL******************************************************

  else if (vd.orient == UOrient::horizontal.get()) {
    for (ch = mlist.first(); ch != null; ch = mlist.next(ch))
      if (ch->verifies(&curp, grp)) {
	b = ch->brick();
	chboxview = null;
	UViewLayout chvl; //!att: reset by constr.
	chgrp = null;

	// UProps
	if (b->propCast())
	  b->propCast()->putProp(&curp, grp);

	// UItems
	else if (b->itemCast()) {
	  b->itemCast()->getSize(&curp, &chvl.cmax_w, &chvl.cmax_h);

	  //add spacing if something before
	  if (vd.visibleElemCount > 0) vd.children_w += curp.local.hspacing;
	  vd.visibleElemCount++;

	  // add element size
	  vd.children_w += chvl.cmax_w;
	  // take max
	  if (chvl.cmax_h > vd.children_h) vd.children_h = chvl.cmax_h;
	}
	
	// UGroups, UBoxes, UWins
	else if ((chgrp = b->groupCast()) && chgrp->isShowable()) {

	  if (chgrp->boxCast()) {  // QUE boxCast
	    
	    if (chgrp->isDef(0, UMode::BOX)  // UBox ou UWin incrust
		// this==hardwin && child==softwin :
		|| (mlist.isSoftwinList() && chgrp->isDef(0,UMode::SOFTWIN))
		) {

	      if ((chboxview = ((UBoxLink*)ch)->getView(vd.view))) {
		
		if (chgrp->isDef(0, UMode::FLOATING)
		    || ch->floatingCast()) {
		  vd.mustLayoutAgain |= chboxview->doLayout(curp, chvl);
		}
		else {
		  // number of horizontally "flex"ible child objects
		  if (curp.local.halign == UView::HFLEX) vd.flexCount++;

		  vd.mustLayoutAgain |= chboxview->doLayout(curp, chvl);
		  
		  //add spacing if something before
		  if (vd.visibleElemCount > 0)
		    vd.children_w += curp.local.hspacing;
		  vd.visibleElemCount++;

		  // add element size
		  vd.children_w += chvl.cmax_w;
		  // take max
		  if (chvl.cmax_h > vd.children_h) vd.children_h = chvl.cmax_h;
		}
	      }	
	    } //endif(INBOX)
	  } //endif(boxCast)

	  else { // just an UGroup
	    UContext chcurp(chgrp, vd.view, curp);
	    viewDoLayout(vd, chcurp, chgrp, vl);  //own curp, same vd
	  }
	}
      }
  } //endif(horizontal)

  // la suite ne concerne pas les UGroup
  if (grp->boxCast()) {

    // Border and Box size
    UMargin margin(0, 0);
    if (curp.local.border)
      //curp.local.border->getSize(vd.view,  &curp, &margin);
      curp.local.border->doLayout(vd.view, curp, margin);

    //!att a 'favorite_*' : il y a des cas ou cette valeur reste inchangee
    //(si width ou height ext fixe : 'favorite_*' est initalisee la 1ere
    //(fois puis reste inchangee ensuite sauf en cas de 'flex'ibles)

    vl.spec_w = curp.local.width;  // < keepSize si indefini

    // -- uwidth(int) with int >= 0 : size fixed by argument and won't change
    // -- uwidth(UWidth::keepSize) : will take initial size and won't change

    if (curp.local.width >= UWidth::keepSize) {
      //@@vl.wmode = UViewLayout::FIXED_BY_CHILD; // NEWTEST!!!!!!!

      if (!curp.boxIsHFlex || vd.view->width <=0) {   // w <=0 : initialization
	// favorite_w initialisee, ne changera pas sauf si 'flex'ible
	//BUG: w = favorite_w = curp.local.width;
	vd.children_w += margin.left + margin.right 
	  + curp.local.padding.left + curp.local.padding.right;
 
	// favorite doit etre le MAX de la taille desiree et de la taille
	// requise par les enfants (sinon le scroll ne marchera pas dans
	// le 1e cas et le 'flex' ne marchera pas dans le second)
	vd.view->favoriteWidth = U_MAX(curp.local.width, vd.children_w);
      }
      if (vd.view->width <= 0) {   //!!!
	vd.view->setVmodes(UView::FIXED_WIDTH, true);
	if (curp.local.width == UWidth::keepSize)
	  vd.view->width = vd.view->favoriteWidth; //init to favorite
	else
	  vd.view->width = curp.local.width; //init to spec.
      }
    }

    else {
      vd.view->favoriteWidth =
	vd.children_w + margin.left + margin.right 
	+ curp.local.padding.left + curp.local.padding.right;
      //if (!vd.keepSize) vd.view->width = vd.view->favoriteWidth;
      vd.view->width = vd.view->favoriteWidth;
    }
    

    vl.spec_h = curp.local.height;  // < keepSize si indefini
    
    // see note above
    if (curp.local.height >= UHeight::keepSize) {
      //@@ vl.hmode = UViewLayout::FIXED_BY_CHILD; // NEWTEST!!!!!!!
      
      if (!curp.boxIsVFlex || vd.view->height <=0) {  // w <=0 : initialization
	// favorite_h initialisee, ne changera pas sauf si 'flex'ible
	//BUG::h = favorite_h = curp.local.height;
	
	// voir note pour favorite_w ci-dessus.
	vd.children_h += margin.top + margin.bottom 
	  + curp.local.padding.top + curp.local.padding.bottom ;
	
	vd.view->favoriteHeight = U_MAX(curp.local.height,  vd.children_h);
      }
      if (vd.view->height <=0) {  //!!!
	vd.view->setVmodes(UView::FIXED_HEIGHT, true);
	
	if (curp.local.height == UHeight::keepSize)
	  vd.view->height = vd.view->favoriteHeight; //init to favorite
	else
	  vd.view->height = curp.local.height; //init to spec.
      }
    }

    else {
      vd.view->favoriteHeight =
	vd.children_h + margin.top + margin.bottom
	+ curp.local.padding.top + curp.local.padding.bottom ;
      //if (!vd.keepSize) vd.view->height = vd.view->favoriteHeight;
      vd.view->height = vd.view->favoriteHeight;
    }
  }
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:01] ======= */
// UPDATE
/* ==================================================== ======== ======= */

//il faudra rajouter le scale

inline void DrawWallPaperLine(UWinGraph& g, int y, int hali, 
			      const UIma *wallp, u_dim ima_w,
			      const URegion &r, const URegion &clip) {
  int x;
  if (hali == UView::HCENTER) {
    x = (r.width - ima_w) / 2 + r.x;
    g.drawIma(wallp, x, y);
  }
  else if (hali == UView::HFLEX) {
    x = (r.width - ima_w) / 2 + r.x;           // A REVOIR!!!
    g.drawIma(wallp, x, y);
  }
  else {
    for (x = r.x; x < r.x + r.width; x += ima_w)
      if (x + ima_w >= clip.x && x < clip.x + clip.width)
	g.drawIma(wallp, x, y);
  }
}

static void drawWallPaper(UWinGraph& g, 
			  const UHalign *halign, const UValign *valign, 
                          const UIma *wallp, 
			  u_dim ima_w, u_dim ima_h,
			  const URegion &r, const URegion &clip) {

  //NB: les if ne servent qu'a eviter des appels de fct inutiles:
  // de toute facon l'intersection sera faite via le clip
  // (qui a ete prealablement affecte a 'g')

  int y;
  int vali = (valign ? valign->get() : UValign::top.get());
  int hali = (halign ? halign->get() : UHalign::left.get());
      
  if (vali == UView::VCENTER) {
    y = (r.height - ima_h) / 2 + r.y;
    DrawWallPaperLine(g, y, hali, wallp, ima_w, r, clip);
  }

  else if (vali == UView::VFLEX) {
    y = (r.height - ima_h) / 2 + r.y;        // A REVOIR!!!
    DrawWallPaperLine(g, y, hali, wallp, ima_w, r, clip);
  }

  else {
    for (y = r.y; y < r.y + r.height; y += ima_h)
      if (y + ima_h >= clip.y && y < clip.y + clip.height) {
	DrawWallPaperLine(g, y, hali, wallp, ima_w, r, clip);
      }
  }
}

/* ==================================================== ======== ======= */

void UUpdateImpl::backgroundAndBorder(UWinGraph& g, 
				      UContext &curp, const URegion &r) {
  //NB: logiquement faudrait d'abord afficher le bord pour eviter
  // d'abimer le "wallpaper" dans le cas des pixmaps

  // wallpaper a afficher (s'il existe)
  const UIma *wallp = null;
  u_dim ima_w = 0, ima_h = 0;

  // pixmap a afficher en wallpaper (si on le trouve!)
  if (curp.local.background) {

    if (curp.local.background->getColor()) {
      curp.bgcolor = curp.local.background->getColor();
    }

    // PAS exclusif (pas de else!)  
    if (curp.local.background->getIma()) {
      wallp = curp.local.background->getIma();

      //NB: getSize charge l'image si pas deja fait
      wallp->getSize(&curp, &ima_w, &ima_h);
      
      // n'afficher que si on a vraiment reussi a charger l'image
      // sinon passer en mode transparent
      // !att: ne pas afficher UnknownPixmap en background en cas d'echec!
      
      if (!wallp->isRealized() || ima_w <= 0 || ima_h <= 0)
	wallp = null;  // inutilisable
      else
	curp.bgcolor = &UBgcolor::none;
    }
  }

  if (wallp) {
    // il y a un wallpaper et on reussi a le charger

    //cas des pixmaps transparents: afficher ce qu'il y a en dessous
    //ET le pixmap en superposition

    // wallpaper has transparent background ?
    view->setVmodes(UView::TRANSPARENT, wallp->isTransparent());

    if (can_paint) drawWallPaper(g, curp.local.background->getHalign(), 
				 curp.local.background->getValign(),
				 //wallp, ima_w, ima_h, r, clip);
				 wallp, ima_w, ima_h, r, chclip);
  }

  else {   // si pas de wallpaper ou pas trouve
    // !!ATT BUG DU 'devient' transparent!!!
    if (curp.bgcolor->equals(UBgcolor::none)) {
      view->setVmodes(UView::TRANSPARENT, true); //transparent: on n'affiche rien
      // !!!!!!
      // !!!!!! PROBABLEMENT FAUX ICI : faut remettre a jour parfois !!!!!!
      // !!!!!!
    }
    else {
      view->setVmodes(UView::TRANSPARENT, false);
      if (can_paint) {
	g.setColor(curp.bgcolor);
	// NB: fillRect fera l'intersection avec le clip
	// (qui a ete prealablement affecte a 'g')
	g.fillRect(r.x, r.y, r.width, r.height);
      }
    }
  }

  margin.set(0, 0, 0, 0);
    
  if (curp.local.border) {
    curp.local.border->doUpdate(*this, g, curp, r);
    /*
    if (vd.can_paint)
      curp.local.border->doUpdate(g, this, curp, r, clip, vd.margin, vup);
    else
      curp.local.border->doLayout(this, curp, vd.margin);
    if (vd.can_paint)
      curp.local.border->paint(g, &curp, r, this, &(vd.margin));
    else
      //curp.local.border->getSize(this, &curp, &(vd.margin));
    */ 
 } 

  // add margin between border and content
  margin.add(curp.local.padding);
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

void UUpdateImpl::callbacks(UGroup *grp, UView* win_view) {

  if (grp->isDef(UMode::VIEW_CHANGE_CB,0)) {
    if (!view->ext) view->ext = new UViewExt();
    if (!view->ext->old_region) {
      //nb: init: on n'appelle rien
      view->ext->old_region = new URegion(view);
    }
    else {
      URegion* oldr = view->ext->old_region;

      if (oldr->x != view->x || oldr->y != view->y) {
	UEvent e(UEvent::viewMove, win_view, null);
	e.setViewSource(view);
	e.redrawClip.set(chclip);
	//printf("%s pos changed\n", grp->cname());
	grp->fire(e, UOn::viewMove);
	oldr->x = view->x;
	oldr->y = view->y;
      }
      if (oldr->width != view->width || oldr->height != view->height) {
	UEvent e(UEvent::viewResize, win_view, null);
	e.setViewSource(view);
	e.redrawClip.set(chclip);
	//printf("%s size changed\n", grp->cname());
	grp->fire(e, UOn::viewResize);
	oldr->width  = view->width;
	oldr->height = view->height;
      }
    }
  }
  // tester d'abor si INIT ?
  UEvent e(UEvent::viewPaint, win_view, null);
  e.setViewSource(view);
  e.redrawClip.set(chclip);
  grp->fire(e, UOn::viewPaint);
  grp->fire(e, UOn::repaint);  //obs equivalent to viewPaint
}

/* ==================================================== ======== ======= */
//!NB: ne doit etre appele QUE pour UMode::FLOATING

void UUpdateImpl::setFloating(UContext& curp, UGroup* grp, URegion& r) {
  // rajouter d'eventuelles coords relatives ajoutees par UPos 
  // (= cas UMode::FLOATING) mais PAS en mode search !!!
  // !!!NB: devrait tenir compte du scale!!!
    
  if (upmode.mode < UViewUpdate::LOCATE_ITEM_POS) {
    //ne rien faire dans les autres cas sinon les coords peuvent 
    //etre ajoutees plusieurs fois
    view->x = (r.x += curp.local.xpos);
    curp.local.xpos = 0; //eviter pbm si recursion avec content
    view->y = (r.y += curp.local.ypos);
    curp.local.ypos = 0;
    //les coords ont ete remises a jour
    view->setVmodes(UView::OBSOLETE_COORDS, false);
  }
  //NB: y'a peut etre des cas ou les coords sont pas a jour ?    
}

/* ==================================================== ======== ======= */

UUpdateImpl::UUpdateImpl(UView *v, const URegion &r, UViewUpdate &_upmode)
  : upmode(_upmode) {
  view = v;
  can_paint = false;
  
  //if (vup.getMode() == UViewUpdate::PAINT_CHANGED) {
  //  //att aux floatings: pas encore deplaces ?
  //  if (v->x == r.x && v->y == r.y
  //	&& v->width == r.width && v->height == r.height)
  //    return;  //nothing changed
  //  else can_paint = true;
  //}
  
  //if (v->width != r.width || v->height != r.height)
  //  size_changed = true;
  //  else
  //  size_changed = false;

  v->x = r.x;
  v->y = r.y;
  v->width  = r.width;
  v->height = r.height;
   
  if (upmode.mode == UViewUpdate::PAINT_ALL) {
    can_paint = true;
    v->setVmodes(UView::DAMAGED, false);
  }

  else if (upmode.mode == UViewUpdate::PAINT_DAMAGED 
	   && (v->isDef(UView::DAMAGED))) {
    can_paint = true;
    v->setVmodes(UView::DAMAGED, false);
    // on change UViewUpdate::mode afin de reafficher tous les enfants
    // recursivement, MAIS AUSSI toutes les vues soeurs qui suivent
    // raison: il peut y avoir des objets superposes (des floatings)
    // (en fait il ne faudrait reafficher que ces derniers)
    upmode.setMode(UViewUpdate::PAINT_ALL);
  }

  else if (upmode.mode == UViewUpdate::UPDATE_DATA) {
    if (v->isDef(UView::DAMAGED))  upmode.overlapp = 1;
    else if (upmode.overlapp > 0)  upmode.overlapp = 2;
  }
  // NB: can_paint reste a false pour les ITEM_OPS
}

/* ==================================================== ======== ======= */

UUpdateImpl::~UUpdateImpl() {
  if (upmode.mode == UViewUpdate::UPDATE_DATA 
      && view->isDef(UView::DAMAGED)) {
    view->setVmodes(UView::DAMAGED, false);
    // ecrase les autres overlapp, y compris ceux mis par enfants
    // et ceux mis par objets qui sont avant dans les listes d'affichage
    upmode.overlapp = 1;
  }
  // restaurer la valeur initiale de UViewUpdate::mode
  //marche pas: voir note ci-dessus
  //upmode.setMode(view_mode);
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

static void viewDoUpdate(UViewUpdateImpl&, UContext &curp, 
			 UGroup *grp, URegion &r, URegion &clip, 
			 UViewUpdate& upmode);

void UView::doUpdate(UContext &parp, URegion r, URegion clip, 
		     UViewUpdate& upmode) {
  UBox *box = getBox();
  // item is not visible because of scrolling, etc... 
  // l'intersection de clip et de r est affectee dans clip
  // (test pas valable pour les FLOATING car coords changees ENSUITE)
  if (!box->isDef(0, UMode::FLOATING)) { //!!att
    if (clip.setInter(r) == 0) return;
  }

  UViewUpdateImpl vd(this, r, upmode, box->flexCount);
  UContext curp(box, this, parp);

  viewDoUpdate(vd, curp, box, r, clip, upmode);

  //NB: finalisation par destructeur de UViewUpdateImpl vd
}

/* ==================================================== ======== ======= */
// - mode SearchItem: juste recuperer l'item et sa position sans redessiner
//   !ATT il faut IMPERATIVEMENT itemData != null dans le mode SearchItem !
// - clip est passe en valeur, pas r
// - noter que coords de r et views sont != dans le cas des UWIn INBOX

static void viewDoUpdate(UViewUpdateImpl &vd, UContext& curp, UGroup* grp, 
			 URegion& r, URegion& clip, UViewUpdate& vup) {
  UMultiList mlist(curp, grp);
  //fait aussi:
  //a) if (grp->isDef(0,UMode::HARDWIN)) mlist.addSoftwinList(grp);
  //b) u_bool is_softwin_list = grp->isDef(0,UMode::SOFTWIN_LIST);

  if (grp->isDef(0, UMode::FLOATING)) {
    vd.setFloating(curp, grp, r);
    if (clip.setInter(r) == 0) return;
  }

  UWinGraph &g = curp.winview->wg();
  int gmode = 0;

  if (grp->boxCast()) {  // que pour les Boxes (bof!)
    //desormais fait par init de mlist:
    //if (grp->isDef(0,UMode::HARDWIN)) mlist.addSoftwinList(grp);

    // setClip peut provoquer un seg fault si appele avec des donnees non
    // initialisee (et c'est le cas pour les operations LOCATE sans PAINT)
    if (vup.mode < UViewUpdate::LOCATE_ITEM_POS) {   // ou < UPDATE_DATA ???
      //sub-hardwin incrustee X -> decaler les coords
      if (grp->isDef(0, UMode::SUB_HARDWIN))
	gmode = g.beginShifted(clip,-r.x,-r.y); 
      //pas de blending (mais le background est peut etre none)
      else if (curp.local.alpha == 1.)
	gmode = g.begin(clip);
      //translucent --> NB: serait OK pour les groups ???
      else {
	gmode = g.beginBlended(clip, r);
	//!!!penser locate;
      }
      //NB: ne pas oublier de TOUJOURS faire g.end() !
    }

    // interdiction de tenir compte de l'orient dans les UGroups
    vd.orient = curp.local.orient;

    vd.chclip.set(clip);
    // (nb: vd.margin init. by updateBackgroundAndBorder)
    vd.backgroundAndBorder(g, curp, r);
    //quelle soit la valeur affectee par backgroundAndBorder
    if (gmode == UWinGraph::BLENDED)
      vd.view->setVmodes(UView::TRANSPARENT, true);

    /*****TEST
    // si la boite est plus petite que les enfants => add scrollers
    if (r.width < link->chw + vd.margin.left  + vd.margin.right) {
      g.drawRect(r.x+2, r.y+4, 4, r.height - 8, &UColor::black);
      g.drawRect(r.x + r.width -6, r.y+4, 4, r.height - 8, &UColor::black);
      vd.margin.left += 6;
      vd.margin.right += 6;
    }
    *****/

    // clipping limits
    // (nb: vd.margin init. by updateBackgroundAndBorder)
    vd.chclip.set(r.x + vd.margin.left, r.y + vd.margin.top,
		  r.width - vd.margin.right, r.height - vd.margin.bottom);

    // pas la peine de chercher a afficher les enfants
    // s'ils sont hors zone de clip
    if (vd.chclip.setInter(clip) == 0) {
      g.endAll(gmode, r);
      return;
    }
  }

  //printf("boxclip: kk=%d - clip = %d,%d %dx%d  - chclip = %d,%d %dx%d \n", 
  //	  kk, clip.x, clip.y, clip.width, clip.height,
  //	  chclip.x, chclip.y, chclip.width, chclip.height);

  u_dim ww, hh;
  UBrick *b = null;
  UView *chboxview = null;
  UItem *it = null; 
  URegion fl_chr; //chr for floatings
  UGroup *chgrp = null;
  ULink *ch = null;

  //=========================== VERTICAL ==================================

  if (vd.orient == UOrient::vertical.get()) {

    if (grp->boxCast()) {  // que pour les Boxes !!

      vd.flex_space = 0;

      //!!TOUTES CES OPTIONS DEVRAIENT ETRE RE-TESTEES POUR **CHAQUE** ELEMENT!!

      // there are flexible objects => use all space
      if (vd.flexCount > 0)  {
	vd.chr.y = r.y + vd.margin.top;
	vd.flex_space = (r.height - vd.view->favoriteHeight) / vd.flexCount;
	vd.view->favoriteHeight = r.height;  //!att
      }
      else switch (curp.local.valign) {
      case UView::TOP:
	vd.chr.y = r.y + vd.margin.top;
	break;
	
      case UView::VCENTER:
	//vd.chr.y = (r.height - chh) / 2;
	vd.chr.y = (r.height - vd.view->favoriteHeight + vd.margin.top + vd.margin.bottom) / 2;
	// box smaller than child ==> impose top vd.margin
	if (vd.chr.y < vd.margin.top)  vd.chr.y = vd.margin.top;
	vd.chr.y += r.y;
	break;

      case UView::BOTTOM:
	//vd.chr.y = r.height - chh - vd.margin.bottom;
	vd.chr.y = r.height - vd.view->favoriteHeight + vd.margin.top;
	// box smaller than child ==> impose top vd.margin
	if (vd.chr.y < vd.margin.top)  vd.chr.y = vd.margin.top;
	vd.chr.y += r.y;
	break;

      default:
	// cas d'erreur: comme TOP
	// VOIR note pour HORIZONTAL
	vd.chr.y = r.y + vd.margin.top;
	break;
      }
    } //endif(grp->boxCast())

    // if this group is not null (which generally is the case) the object
    // it contains are added to children for normal display
    // (can for instance be used for adding list-item markers, checkboxes...

    if (curp.local.content) {
      UGroup *content = curp.local.content; // SAME curp, same vd
      curp.local.content = null;	// avoid infinite recursion
      viewDoUpdate(vd, curp, content, r, clip, vup);
    }

    for (ch = mlist.first(); ch != null; ch = mlist.next(ch))
      if (ch->verifies(&curp, grp)) {
	b = ch->brick();
	chboxview = null;
	it = null; 
	chgrp = null; //!!reinit necessaire

	if (b->propCast())
	  b->propCast()->putProp(&curp, grp);

	else if ((chgrp = dynamic_cast<UGroup*>(b))
		 && chgrp->isDef(0, UMode::GROUP)
		 ) {
	  if (chgrp->isShowable()) {
	    UContext chcurp(chgrp, vd.view, curp); //own curp, same vd
	    viewDoUpdate(vd, chcurp, chgrp, r, clip, vup);
	  }
	}

	// UItems + UBoxes, UWins
	else if ( 
		 (  (it = b->itemCast())
		    && (it->getSize(&curp, &ww, &hh), true) )
		 ||
		 (chgrp
		  && chgrp->isShowable()
		  && (chgrp->isDef(0, UMode::BOX)
		      // this==hardwin && child==softwin :
		      || (mlist.isSoftwinList() && chgrp->isDef(0,UMode::SOFTWIN))
		      )
		  && (chboxview = ((UBoxLink*)ch)->getViewSize(vd.view, &ww, &hh))
		  )
		 ) {

	  // 1::cas des Floating
	  if ((chgrp && chgrp->isDef(0, UMode::FLOATING)) || ch->floatingCast()){
	    //ajout de fl_chr pour ne pas abimer vd.chr
	    //qui est cumulatif soit en x soit en y
	    fl_chr.width  = ww;
	    fl_chr.height = hh;

	    if (ch->floatingCast()) {
	      // transformer les coords relatives en coords absolues
	      // puis afficher l'objet a cet endroit precis
	      fl_chr.x = r.x + vd.margin.left + ch->floatingCast()->getX();
	      fl_chr.y = r.y + vd.margin.top + ch->floatingCast()->getY();
	    }
	    else {
	      //!att: on rajoute la MARGE: les coords sont locales 
	      // % a l'INTERIEUR du CADRE et non % a l'origine de la Box.
	      fl_chr.x = r.x + vd.margin.left;
	      fl_chr.y = r.y + vd.margin.top;
	      // coords relatives rajoutees ENSUITE via setCoords
	    }

	    chboxview->doUpdate(curp, fl_chr, vd.chclip, vup);
	  }

	  // 2::tous les autres objets
	  else {

	    switch (curp.local.halign) {
	    case UView::LEFT:
	      vd.chr.width = ww;
	      vd.chr.x = r.x + vd.margin.left;
	      break;
	    
	    case UView::HFLEX:  
	    case UView::HCENTER:
	      // !NOTE: pour les Items, HFLEX est identique a HCENTER
	    
	      // Cas: Box *et* FLEX
	      if (!it && curp.local.halign ==UView:: HFLEX) {
		// - tous les enfants sont justifies horizontalement
		// sur celui qui a la plus grande largeur
		// - selon les cas (voir ligne precedente) ils sont ou non
		// egalement adaptes par rapport a laur parent
		
		//NB: ! NE PAS changer chw sinon le scroll va deconner
		vd.chr.width = r.width - vd.margin.left - vd.margin.right;
		vd.chr.x = r.x + vd.margin.left; 
	      }

	      // Cas CENTER *ou* Item(que ce soit FLEX ou CENTER)
	      else {
		vd.chr.width = ww; 
		vd.chr.x = (r.width - vd.chr.width) / 2; 
		// box smaller than child ==> impose left vd.margin
		if (vd.chr.x < vd.margin.left) vd.chr.x = vd.margin.left;
		vd.chr.x += r.x;
	      }
	      break;
	      
	    case UView::RIGHT:
	      vd.chr.width = ww;
	      vd.chr.x = r.width - vd.margin.right - vd.chr.width;
	      // box smaller than child ==> impose left vd.margin
	      if (vd.chr.x < vd.margin.left) vd.chr.x = vd.margin.left;
	      vd.chr.x += r.x;
	      break;

	    } //endswitch(halign)


	    // flexible vertical object  ==>  add flexible height space
	    // !!==> sauf pour les Items qui sont jamais flexibles
	    if (curp.local.valign == UView::VFLEX && !it)
	      vd.chr.height = hh + vd.flex_space;
	    else vd.chr.height = hh;


	    if (vd.chr.width > 0 && vd.chr.height > 0) {
	    
	      //pas un item => c'est forcement un Box
	      if (!it) chboxview->doUpdate(curp, vd.chr, vd.chclip, vup);
	      else {

		//NB: ITEM_OPS => vd.can_paint_item == false mais pas l'inverse !
		if (vd.can_paint 
		    && vd.chr.y + vd.chr.height > vd.chclip.y
		    && vd.chr.y < vd.chclip.y + vd.chclip.height) {
		  g.setClip(vd.chclip);
		  it->paint(g, &curp, vd.chr);
		}
	 
		else if (vup.mode >= UViewUpdate::LOCATE_ITEM_POS) {
		  // do not draw, just find 
		  // !att: il faut que e->itemData soit =!null
		  // nb: s'arrete de cherche qunad true est renvoye'

		  if (vup.mode == UViewUpdate::LOCATE_ITEM_POS) {
		    if (vd.view->locateItemVPos(curp, ch, g, vd.chr, vup))
		      return;
		  }
		  else if (vup.mode == UViewUpdate::LOCATE_ITEM_PTR) {
		    if (vd.view->locateItemPtr(curp, ch, g, vd.chr, vup))
		      return;
		  }
		} //endif(ITEM_OPS)
	      }

	      // increment vd.chr.x in all cases 
	      // (sauf si floating mais cas deja exclus)
	      vd.chr.y += vd.chr.height + curp.local.vspacing;
	      
	    } // endif (vd.chr.width > 0 && vd.chr.height > 0)
	  }
	}
      }
  }

  //=========================== HORIZONTAL ==================================

  else if (vd.orient == UOrient::horizontal.get()) {
    
    if (grp->boxCast()) {  // que pour les Boxes !!

      vd.flex_space = 0;

      //!!TOUTES CES OPTIONS DEVRAIENT ETRE RE-TESTEES POUR **CHAQUE** ELEMENT!!

      // there are flexible objects => use all space
      if (vd.flexCount > 0)  {
	vd.chr.x = r.x + vd.margin.left;
	//flex_width =
	//  (r.width - chw - vd.margin.left -vd.margin.right) / grp->hflexChildCount;
	//chw = r.width - vd.margin.left - vd.margin.right;
	vd.flex_space = (r.width - vd.view->favoriteWidth) / vd.flexCount;
	vd.view->favoriteWidth = r.width;   //!att
      }
      else switch (curp.local.halign) {
      case UView::LEFT:
	vd.chr.x = r.x + vd.margin.left;
	break;
	
      case UView::HCENTER:
	//vd.chr.x = (r.width - chw) / 2;
	vd.chr.x = (r.width - vd.view->favoriteWidth + vd.margin.left + vd.margin.right) / 2;
	// box smaller than child ==> impose left vd.margin
	if (vd.chr.x < vd.margin.left)  vd.chr.x = vd.margin.left;
	vd.chr.x += r.x;
	break;

      case UView::RIGHT: 
	//vd.chr.x = r.width - chw - vd.margin.right;
	vd.chr.x = r.width - vd.view->favoriteWidth + vd.margin.left;
	// box smaller than child ==> impose left vd.margin
	if (vd.chr.x < vd.margin.left)  vd.chr.x = vd.margin.left;
	vd.chr.x += r.x;
	break;

      default:
	// cas d'erreur: comme LEFT
	// se produit en particulier qd il y a une deconnade entre doLayout
	// et doUpdate et que flexCount==0 avec UView::HFLEX
	// (ca vient du fait que toutes les options qui precedent devraient
	// etre retestees pour chaque element)
	vd.chr.x = r.x + vd.margin.left;
	break;
      }
    } //endif(grp->boxCast())

    if (curp.local.content) {
      UGroup *content = curp.local.content; // same curp, same vd
      curp.local.content = null;	// avoid infinite recursion
      viewDoUpdate(vd, curp, content, r, clip, vup);
    }

    for (ch = mlist.first(); ch != null; ch = mlist.next(ch))
      if (ch->verifies(&curp, grp)) {
	b = ch->brick();
	chboxview = null;
	it = null; 
	chgrp = null; //!!reinit necessaire

	if (b->propCast())
	  b->propCast()->putProp(&curp, grp);

	//else if ((chgrp = b->groupNotBoxCast())) { 
	else if ((chgrp = dynamic_cast<UGroup*>(b))
		 && chgrp->isDef(0, UMode::GROUP)
		 ) {
	  if (chgrp->isShowable()) {
	    UContext chcurp(chgrp, vd.view, curp); //own curp, same vd
	    viewDoUpdate(vd, chcurp, chgrp, r, clip, vup);
	  }
	}

	// UItems + UBoxes, UWins
	else if ( 
		 (  (it = b->itemCast())
		    && (it->getSize(&curp, &ww, &hh), true) )
		 ||
		 (  //(chgrp = b->boxCast()) 
		    chgrp
		    && chgrp->isShowable()
		    && (chgrp->isDef(0, UMode::BOX)
			// this==hardwin && child==softwin :
			|| (mlist.isSoftwinList() && chgrp->isDef(0,UMode::SOFTWIN))
			)
		    && (chboxview = ((UBoxLink*)ch)->getViewSize(vd.view, &ww, &hh))
		    )
		 ) {

	  // 1::cas des Floating
	  if ((chgrp && chgrp->isDef(0, UMode::FLOATING))
	      || ch->floatingCast()) {
	    //fl_chr pour ne pas abimer vd.chr qui est
	    //soit cumulatif en x soit en y !!!
	    fl_chr.width  = ww;
	    fl_chr.height = hh;

	    if (ch->floatingCast()) {
	      fl_chr.x = r.x + vd.margin.left + ch->floatingCast()->getX();
	      fl_chr.y = r.y + vd.margin.top + ch->floatingCast()->getY();
	    }
	    else {
	      fl_chr.x = r.x + vd.margin.left;
	      fl_chr.y = r.y + vd.margin.top;
	      // coords relatives rajoutees ensuite via setCoords
	    }

	    chboxview->doUpdate(curp, fl_chr, vd.chclip, vup);
	  }

	  // 2::tous les autres objets
	  else {

	    switch (curp.local.valign) {
	    case UView::TOP:
	      vd.chr.height = hh;
	      vd.chr.y = r.y + vd.margin.top; 
	      break;

	    case UView::VFLEX:
	    case UView::VCENTER:
	      // !NOTE: pour les Items, VFLEX est identique a VCENTER

	      // Cas: BOX + FLEX
	      if (!it && curp.local.valign == UView::VFLEX) {
		// - tous les enfants sont justifies horizontalement
		// sur celui qui a la plus grande hauteur
		// - selon les cas (voir ligne precedente) ils sont ou non
		// egalement adaptes par rapport a laur parent

		//NB: ! NE PAS changer chh sinon le scroll va deconner
		vd.chr.height = r.height - vd.margin.top - vd.margin.bottom;
		vd.chr.y = r.y + vd.margin.top; 
	      }

	      // Cas CENTER ou Item{FLEXouCENTER})
	      else {
		vd.chr.height = hh;
		vd.chr.y = (r.height - vd.chr.height) / 2;
		// box smaller than child ==> impose top vd.margin
		if (vd.chr.y < vd.margin.top)  vd.chr.y = vd.margin.top;
		vd.chr.y += r.y;
	      }
	      break;

	    case UView::BOTTOM:
	      vd.chr.height = hh;
	      vd.chr.y = r.height - vd.margin.bottom - vd.chr.height;
	      // box smaller than child ==> impose top vd.margin
	      if (vd.chr.y < vd.margin.top)  vd.chr.y = vd.margin.top;
	      vd.chr.y += r.y;
	      break;
	    }


	    // flexible horizontal object  ==>  add flexible width space
	    // !!==> sauf pour les Items qui sont jamais flexibles
	    if (curp.local.halign ==  UView::HFLEX && !it)
	      vd.chr.width = ww + vd.flex_space;
	    else vd.chr.width = ww;
	    
	    if (vd.chr.width > 0 && vd.chr.height > 0) {

	      //pas un item => Box
	      if (!it) chboxview->doUpdate(curp, vd.chr, vd.chclip, vup);
	      else {

		//NB: ITEM_OPS => vd.can_paint == false mais pas l'inverse !
		if (vd.can_paint 
		    && vd.chr.x + vd.chr.width > vd.chclip.x
		    && vd.chr.x < vd.chclip.x + vd.chclip.width) {
		  g.setClip(vd.chclip);
		  it->paint(g, &curp, vd.chr);
		}
		
		else if (vup.mode >= UViewUpdate::LOCATE_ITEM_POS) {
		  // do not draw, just find
		  // !att: il faut que e->itemData soit =!null
		  // nb: s'arrete de cherche qunad true est renvoye'

		  if (vup.mode == UViewUpdate::LOCATE_ITEM_POS) {
		    if (vd.view->locateItemHPos(curp, ch, g, vd.chr, vup))
		      return;
		  }
		  else if (vup.mode == UViewUpdate::LOCATE_ITEM_PTR) {
		    if (vd.view->locateItemPtr(curp, ch, g, vd.chr, vup))
		      return;
		  }

		} //endif(ITEM_OPS)
	      }

	      // increment vd.chr.x in all cases
	      // (sauf si floating mais cas deja exclus)
	      vd.chr.x += vd.chr.width + curp.local.hspacing;

	    } // endif (vd.chr.width > 0 && vd.chr.height > 0)
	  }
	}
      }
  }

  //NB: ne fait rien si gmode=0 (cas des group)
  g.endAll(gmode, r);

  // call paint and resize callback: 
  // NB: desormais appele en FIN de traitement pour permettre utilisation
  // cohererente de UGraph ds traitements clients)
  if (vd.can_paint 
      && grp->isDef(UMode::VIEW_PAINT_CB|UMode::VIEW_CHANGE_CB,0)) 
    vd.callbacks(grp, curp.winview);
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
// NOTE: Cette fct accumule les props heritees via le graphe d'instanciation
// dans le ucontext: le contect complete' est renvoyee bia e->props
// ATTENTION: 
// -1 e->props ne prend pas en compte les props de la trouvee UBox
//       (ie. l'heritage s'arrete au PARENT de cette UBox)
// -2- cette fct n'a de sens et ne doit etre utilisee QUE SI l'objet 
//     est VISIBLE


UView* UView::contains(u_pos xmouse, u_pos ymouse, URegion &clip) { //mofifies clip
  // Notes:
  // 1)- cas View rectangulaire
  // 2)- clip est l'intersection de this et du clip initial
  //     ==> necessaire pour calculer le bon redrawClip qd les objets 
  //         sont scrolles ou clippes 

  /* obsolete
     UBox *box = getBox();
     if (box->isDef(0, UMode::SUB_HARDWIN)) {
    // cas part. des subwindow (UIncrust) ne pas prendre en compte view->x,y
    // car les UEvent sont relatifs a cette subwindow
    if (clip.setInter(0,0,width,height) == 0) return null;
  }
  else {
    if (clip.setInter(*this) == 0) return null;
  }
  */

  if (clip.setInter(*this) == 0) return null;
  if (xmouse < clip.x 
      || ymouse < clip.y 
      || xmouse >= (clip.x + clip.width) 
      || ymouse >= (clip.y + clip.height))
    return null;

  return this;
}

UView* UView::contains(UView *searchv, URegion &clip) { //mofifies clip
  // Notes:
  // 1)- cas View rectangulaire
  // 2)- clip est l'intersection de this et du clip initial
  //     ==> necessaire pour calculer le bon redrawClip qd les objets 
  //         sont scrolles ou clippes 

  /* obsolete
     UBox *box = getBox();
  if (box->isDef(0, UMode::SUB_HARDWIN)) {
    // cas part. des subwindow (UIncrust) ne pas prendre en compte view->x,y
    // car les UEvent sont relatifs a cette subwindow
    if (clip.setInter(0,0,width,height) == 0) return null;//suprime
  }
  else {  
    if (clip.setInter(*this) == 0) return null;
  }
  */
    if (clip.setInter(*this) == 0) return null;
  if (this != searchv)  return null;
  else return this;
}

/* ==================================================== ======== ======= */
/****

//layers (depth)
//ugroups et formes qq
//cas du serachview
// FAUT FAIRE UNE RECHERCHE EN LARGEUR D'ABORD !!!

static UView* viewLocateSource(UView *view, UEvent *e, UContext *parp, 
			       UGroup *grp, const URegion clip);
// this function sets:
// -- e->{source, sourceView, sourceProps, redrawnClip}

UView* UView::locateSource(UEvent *e, UContext *parp, URegion clip) {
  UBox *box = getBox();
  if (! box->isShowable() 
      //|| box->isDef(0, UMode::IGNORE_EVENTS)
      || box->isDef(UMode::IGNORE_EVENTS,0)
      || box == e->through 
      )
    return null;

  if (!contains(e->xmouse, e->ymouse, clip)) return null;

  // mouse coords must be defined in order to determine which objects
  // are traversed by events
  // ==> ceci implique que seules les UBox peuvent flagger les events
  //     (car les UGroup n'ont pas de coords)
  //if (box->isDef(0, UMode::FLAG_EVENTS)) {
  if (box->isDef(UMode::FLAG_EVENTS,0)) {
    e->sourceView = this;
    box->fire(e, UOn::traverse);
  }

  UView *subview = viewLocateSource(this, e, parp, box, clip);

  if (subview) return subview;
  //sinon c'est bien dans cette view et aucune subview que se trouve mouse
  else {
    e->setSource(this);
    e->redrawStatus = 1;
    e->redrawClip = clip;

    // e->firstTranspView = the first view that is transparent in the tree
    // !att: curp.transpView ET NON parp.transpView
    if (isDef(TRANSPARENT)) {
      if (!parp || !parp->firstTranspView) e->firstTranspView = this;
      else e->firstTranspView = parp->firstTranspView; 
     }
    // si cette vue est opaque il est alors inutile de tenir compte
    // des vues transparentes precedentes ==> ecraser firstTranspView
    else e->firstTranspView = null;

    // !att: en final il faut tenir compte de fixedSizes pour la vue courante
    // et non pour son parent ==> recopie de firstLayoutView dans parp
    // lui-meme recopie dans un champ de l'event 'e'
    // de plus: si FLOATING, inutile de recalculer le layout des parents

    if (parp && (box->isDef(0,UMode::FLOATING)
		 || isAllDef(FIXED_WIDTH|FIXED_HEIGHT)))
      parp->firstLayoutView = this;

    //!ATT: recopie le PARENT context!!
    if (parp) e->dumpParentContext(*parp);
    return this;
  }
}

// ==================================================== ======== =======

static UView* viewLocateSource(UView *view, UEvent *e, UContext *parp, 
			       UGroup *grp, const URegion clip) {
  UContext curp(grp, view, *parp);
  //mlist.parseProps(grp, curp);
  //mlist.addList(grp->getChildLinks());
  //if (grp->isDef(0,UMode::HARDWIN)) mlist.addSoftwinList(grp);
  //u_bool is_softwin_list = grp->isDef(0,UMode::SOFTWIN_LIST);

  UMultiList mlist(curp, grp);
  //fait aussi:
  //a) if (grp->isDef(0,UMode::HARDWIN)) mlist.addSoftwinList(grp);
  //b) u_bool is_softwin_list = grp->isDef(0,UMode::SOFTWIN_LIST);

  // on continue gentiment de scanner la liste jusqu'au bout car
  // il peut y avoir une autre 'found_view' superposee
  // et c'est cette derniere qu'on veut recuperer

  UView *subview = null;
  for (ULink* ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {
      UBrick *b = ch->brick();
      UProp  *prop;
      UGroup *chgrp;

      if ((prop = b->propCast()))
	prop->putProp(&curp,  grp);
      
      else if ((chgrp = dynamic_cast<UGroup*>(b))
	       && chgrp->isShowable() 
	       //&& (!chgrp->isDef(0, UMode::IGNORE_EVENTS))
	       && (!chgrp->isDef(UMode::IGNORE_EVENTS,0))
	       && chgrp != e->through 
	       ) {
	UView  *chview;

	if (chgrp->isDef(0,UMode::GROUP)
	    && (chview = viewLocateSource(view, e, &curp, chgrp, clip))){
	  subview = chview;
	}
	else if ((chgrp->isDef(0,UMode::BOX)      //elimine les UWin
		  // this==hardwin && child==softwin :
		  || (mlist.isSoftwinList() && chgrp->isDef(0,UMode::SOFTWIN))
		  )
		 // ch est un UBoxLink par construction
		 && (chview = ((UBoxLink*)ch)->getView(view))){
	  URegion chclip(clip);
	  if (chview->contains(e->xmouse, e->ymouse, chclip))
	    subview = chview;
	}
      }
    } //endfor

  if (subview) {
    UView* subsubview = subview->locateSource(e, &curp, clip);
    if (subsubview) subview = subsubview;
  }
  return subview;
}

// ==================================================== ======== =======

static UView* viewLocateSource(UEvent *e, UView *view, UContext *parp, 
			       UGroup *grp, const URegion clip, UView *sv);

UView* UView::locateSource(UEvent *e, UContext *parp, URegion clip, UView *sv) {
  UBox *box = getBox();
  if (!contains(sv, clip)) {
    UView *subview = viewLocateSource(e, this, parp, box, clip, sv);
    //cf cas des group pas initailises
    if (subview) return subview;
    else return null;
  }
  //sinon c'est bien cette view que l'on cherche
  else {
    e->setSource(this);
    e->redrawStatus = 1;
    e->redrawClip = clip;

    // e->firstTranspView = the first view that is transparent in the tree
    // !att: curp.transpView ET NON parp.transpView
    if (isDef(TRANSPARENT)) {
      if (!parp || !parp->firstTranspView) e->firstTranspView = this;
      else e->firstTranspView = parp->firstTranspView; 
     }
    // si cette vue est opaque il est alors inutile de tenir compte
    // des vues transparentes precedentes ==> ecraser firstTranspView
    else e->firstTranspView = null;

    // !att: en final il faut tenir compte de fixedSizes pour la vue courante
    // et non pour son parent ==> recopie de firstLayoutView dans parp
    // lui-meme recopie dans un champ de l'event 'e'
    // de plus: si FLOATING, inutile de recalculer le layout des parents

    if (parp && (box->isDef(0,UMode::FLOATING) 
		 || isAllDef(FIXED_WIDTH|FIXED_HEIGHT)))
      parp->firstLayoutView = this;

    //!ATT: recopie le PARENT context!!
    if (parp) e->dumpParentContext(*parp);
    return this;
  }
}

// ==================================================== ======== ======= 

static UView* viewLocateSource(UEvent *e, UView *view, UContext *parp, 
			       UGroup *grp, const URegion clip, UView *sv) {
  UContext curp(grp, view, *parp);
  //mlist.parseProps(grp, curp);
  //mlist.addList(grp->getChildLinks());

  UMultiList mlist(curp, grp);
  //fait aussi:
  //a) if (grp->isDef(0,UMode::HARDWIN)) mlist.addSoftwinList(grp);
  //b) u_bool is_softwin_list = grp->isDef(0,UMode::SOFTWIN_LIST);

  UView *subview = null;
  for (ULink* ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {
      UBrick *b = ch->brick();
      UProp  *prop;
      UGroup *chgrp;

      if ((prop = b->propCast()))
	prop->putProp(&curp,  grp);
      
      else if ((chgrp = dynamic_cast<UGroup*>(b))) {
	UView *chview;

	if (chgrp->isDef(0,UMode::GROUP) && chgrp->isShowable()) {
	  if (view == sv) return view;
	  else if ((subview = viewLocateSource(e, view, &curp, chgrp, clip, sv)))
	    return subview;
	}
	else if (chgrp->isDef(0,UMode::BOX)  //elimine les UWin
		 // ch est un UBoxLink par construction
		 && (chview = ((UBoxLink*)ch)->getView(view))){
	  if ((subview = chview->locateSource(e, &curp, clip, sv))) 
	    return subview;
	}
      }
    } //endfor

  return null;
}
****/

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */

static UView* locateSource2(UView *v, UGroup *grp, 
			    UEvent *e, UContext *parp,
			    URegion clip, UView *searchedView) {
  UView *last_found_view = null;
  UContext curp(grp, v, *parp);

  //mlist.parseProps(grp, curp);
  //mlist.addList(grp->getChildLinks());
  //if (grp->isDef(0,UMode::HARDWIN)) mlist.addSoftwinList(grp);
  //u_bool is_softwin_list = grp->isDef(0,UMode::SOFTWIN_LIST);

  UMultiList mlist(curp, grp);
  //fait aussi:
  //a) if (grp->isDef(0,UMode::HARDWIN)) mlist.addSoftwinList(grp);
  //b) u_bool is_softwin_list = grp->isDef(0,UMode::SOFTWIN_LIST);

  for (ULink* ch = mlist.first(); ch != null; ch = mlist.next(ch))
    if (ch->verifies(&curp, grp)) {
      UBrick *b = ch->brick();
      UProp  *prop;
      UView  *chview, *found_view = null;
      UGroup *chgrp;    

      if ((prop = b->propCast()))
	prop->putProp(&curp,  grp);
      
      else if ((chgrp = dynamic_cast<UGroup*>(b))
	       && chgrp->isDef(0,UMode::GROUP)
	       && chgrp->isShowable() 
	       //&& (!chgrp->isDef(0, UMode::IGNORE_EVENTS))
	       && (!chgrp->isDef(UMode::IGNORE_EVENTS,0))
	       //!!! on a oublie la transp du background!!
	       && ( (curp.local.alpha == 1.)
		    ? v->setVmodes(UView::TRANSPARENT, true), true
		    : true )
	       && (found_view = locateSource2(v, b->groupCast(),
					      e, &curp, clip, searchedView))
	       ) {
	last_found_view = found_view;
      }

      else if (chgrp
	       && (chgrp->isDef(0,UMode::BOX) //elimine les UWin
		   // this==hardwin && child==softwin :
		   || (mlist.isSoftwinList() && chgrp->isDef(0,UMode::SOFTWIN))
		   )
	       // ch est donc un UBoxLink par construction
	       && (chview = ((UBoxLink*)ch)->getView(v))
	       && (found_view = chview->locateSource(e, &curp, 
						     clip, searchedView))
	       ) {
	// on continue gentiment de scanner la liste jusqu'au bout car
	// il peut y avoir une autre 'found_view' superposee
	// et c'est cette derniere qu'on veut recuperer
	last_found_view = found_view;
      }

    } //endfor

  return last_found_view;
}

UView* UView::locateSource(UEvent *e, UContext *parp, URegion clip,
			   UView *searchedView) {
  UBox *box = getBox();
  if (!box) {
    uerror("UView::locateSource",
	   "Internal error: View points to null box");
    return null;
  }
  if (! box->isShowable() 
      //|| box->isDef(0, UMode::IGNORE_EVENTS)
      || box->isDef(UMode::IGNORE_EVENTS,0)
      || box == e->through 
      )
    return null;

  if (clip.setInter(*this) == 0) return null;
  if (searchedView) {
    if (searchedView == this) goto TROUVE;
    //sinon on va chercher dans la liste des enfants via la boucle
    //'for ()' ci-apres
  }
  else {
    // Notes:
    // 1)- cas View rectangulaire
    // 2)- clip est l'intersection de this et du clip initial
    //     ==> necessaire pour calculer le bon redrawClip qd les objets 
    //         sont scrolles ou clippes 

    if (e->xmouse < clip.x 
	|| e->ymouse < clip.y 
	|| e->xmouse >= (clip.x + clip.width) 
	|| e->ymouse >= (clip.y + clip.height))
      return null;

    // NB: event flagging is meaningless in 'searchedView' mode:
    // mouse coords must be defined in order to determine which objects
    // are traversed by events
    // ==> ceci implique que seules les UBox peuvent flagger les events
    //     (car les UGroup n'ont pas de coords)
    //if (box->isDef(0, UMode::FLAG_EVENTS)) {
    if (box->isDef(UMode::FLAG_EVENTS,0)) {
      e->sourceView = this;
      box->fire(*e, UOn::traverse);
    }
  }

  { // la { est impose par syntaxe du goto
    UView *found_view = locateSource2(this, box, e, parp, clip, 
				      searchedView);
    if (found_view) return found_view;
  }

  // sinon on n'a pas trouve de vue incluse et il faudra donc retourner
  // la vue courante. Pour ce faire on continue en sequence jusqu'au
  // tag 'TROUVE'

  // si uc.mode searchedView et qu'on n'est PAS alle' directement au
  // tag 'TROUVE' c'est qu'on a pas trouve le bon objet
  if (searchedView) return null;

 TROUVE:
  // si l'objet n'a pas d'enfant ou si la souris n'est contenue dans aucun 
  // de ses enfants alors retourner l'objet en personne. (apres avoir
  // copie' toutes les infos desirees)
  /*
  if (e->eid == 1 || e->eid == 2) {
    printf("setSourceView: eID=%d, v:%d, box:%d %s\n\n",
	   e->eid, this, this->getBox(), this->getBox()->cname());
  }
  */
  e->setViewSource(this);
  e->redrawStatus = 1;
  e->redrawClip = clip;

  // !!! LE CHAMP firstTranspView dans 'e' est inutile !            !!!
  // !!! le ucontext parp devrait suffire comme pour firstLayoutView !!!

  // e->transpView = the first view that is transparent in the tree
  // !att: curp.transpView ET NON parp.transpView
 
  //TRANSPARENT: propr maintenant relative a UView
  if (isDef(TRANSPARENT)) {
    if (!parp || !parp->firstTranspView) e->firstTranspView = this;
    else e->firstTranspView = parp->firstTranspView; 
  }
  // si cette vue est opaque il est alors inutile de tenir compte
  // des vues transparentes precedentes ==> ecraser firstTranspView
  else e->firstTranspView = null;

  // !att: en final il faut tenir compte de fixedSizes pour la vue courante
  // et non pour son parent ==> recopie de firstLayoutView dans parp
  // lui-meme recopie dans un champ de l'event 'e'
  // de plus: si FLOATING, inutile de recalculer le layout des parents
  if (parp && (box->isDef(0, UMode::FLOATING)
	       || isAllDef(FIXED_WIDTH | FIXED_HEIGHT)))
    parp->firstLayoutView = this;

  //!ATT: recopie le PARENT context!!
  if (parp) e->dumpParentContext(*parp);
  return this;
}

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

static void saveItemData(UContext &props, 
			 ULink *link, UWinGraph &g, 
			 const URegion &r, UViewUpdate &uc,
			 u_bool exact_match) {
  //printf("--foo1: e = %d, e->xmouse = %d, exact_match:%d\n",
  //	 uc.e, uc.e->xmouse, exact_match);
  int strpos = -1;
  UItem *item = link->brick()->itemCast();
  UStr *str;
  //if (item && (str = dynamic_cast<UStr*>(item))) {
  if (item && (str = item->strCast())) {
    // search the strpos
    strpos = g.getCharPos(&props.fontdesc, str->chars(), str->length(),
			  uc.e->getXwin() - r.x);
  }
  uc.itemData->set(props, item, link, r, strpos, exact_match);
}

// Horizontal Search. 
// retrieves item and info from x,y position
//!!ATT: 
// - suppose que itemData!= null !
// - return==true signifie: ne pas chercher davantage car:
//                trouve' OU pas trouve' mais plus la peine de chercher
// - return==false signifie: continuer a chercher car:
//                pas trouve' mais on peut encore trouver 

u_bool UView::locateItemHPos(UContext &props, ULink *link, UWinGraph &g, 
			     const URegion &r, UViewUpdate &uc) {

  if (r.x > uc.e->xmouse) return true;  // plus rien a chercher (not found)

  if (r.y <= uc.e->ymouse && uc.e->ymouse < r.y + r.height) {
    if (uc.e->xmouse < r.x + r.width) {
      // item exactly found
      saveItemData(props, link, g, r, uc, true);
      return true;  // trouve' => finir la recherche
    }
    // item approximatively found
    else saveItemData(props, link, g, r, uc, false);
  }

  return false;	// continuer a chercher (dans les 2cas)
}

u_bool UView::locateItemVPos(UContext &props, ULink *link, UWinGraph &g, 
			     const URegion &r, UViewUpdate &uc) {

  if (r.y > uc.e->ymouse) return true;  // plus rien a chercher (not found)

  if (r.x <= uc.e->xmouse && uc.e->xmouse < r.x + r.width) {
    if (uc.e->ymouse < r.y + r.height) {
      saveItemData(props, link, g, r, uc, true);
      return true;
    }
    else saveItemData(props, link, g, r, uc, false);
    
  }
  return false;	// continuer a chercher (dans les 2cas)
}

u_bool UView::locateItemPtr(UContext &props, ULink *link, UWinGraph &g, 
			    const URegion &r, UViewUpdate &uc) {
  UItem *item;

  // retrieves info from Item link or Item ptr
  if ((uc.itemData->itemLink == link || uc.itemData->item == link->brick())
      && ((item = link->brick()->itemCast()))
      ) {
    uc.itemData->set(props, item, link, r, uc.itemData->strpos, true);
    return true;    //trouve, inutile de continuer a chercher
  }

  //tous les cas pas trouve (PAS de else!)
  return false;
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

int UView::updateWinData(const URegion &region) {
  UView *winview = wg().getHardwin()->getWinView();
  if (!winview) return -1;

  UViewUpdate vup(UViewUpdate::UPDATE_DATA);
  UWinContext winctx(winview);
  setVmodes(UView::DAMAGED, true);
  winview->doUpdate(winctx, winview, region, vup);
  setVmodes(UView::DAMAGED, false);
  return vup.overlapp;
}

// update view paint in window coordinates:
// ATT: CHANGEMENT:  updateAllLayers = false par DEFAUT !!!

void UView::updateWinPaint(const URegion &region, u_bool doublebuff, 
			   UView *firstTranspView, u_bool mode) {
  UWinGraph &g = wg();
  UView *winview = g.getHardwin()->getWinView();
  if (!winview) return;

  UWinContext winctx(winview);
  UViewUpdate upmode(UViewUpdate::PAINT_ALL);

  /* NOTE:
   * le mode PAINT_DAMAGED est incompatible avec le DoubleBuffering
   * puisque justement on ne reaffiche pas tout (ce qui generera
   * un fond non initialise donc blanc dans certains cas)
   * ==> imposer PAINT_ALL
   * (une autre solution coherente consisterait d'abord a recopier
   * le fond existant puis a ne generer que les parties a modifier
   * grace a PAINT_DAMAGED)
   */
  if (mode == 1) {             //update all layers
    //upmode.setMode(UViewUpdate::PAINT_ALL);
    winview->doUpdate(winctx, winview, region, upmode);
  }
  //else if (mode == 2) {      //update all CHANGED layers ???
  //  upmode.setMode(UViewUpdate::PAINT_CHANGED);
  //  winview->doUpdate(winctx, winview, region, upmode);
  //}
  else if (doublebuff) {
    g.beginDoubleBuffering(region);
    //upmode.setMode(UViewUpdate::PAINT_ALL);
    winview->doUpdate(winctx, winview, region, upmode);
    g.endDoubleBuffering(region);
  }
  /***translate' dans update et UWingraph::begin
  else if (winview->getBox()->isDef(0, UMode::SUB_HARDWIN)) {
    // cas part. des UIncrust : vraie XWindow inclue dans UBox
    // ==> 'view' garde coords. logiques x,y tandis qu'il faut dessiner
    //     a partir de coords physiques (r.x,r.y) = (0,0) (et decaler clip)
    g.subwin = true;
    g.natgraph->setDest(g.natwin, -winview->x, -winview->y);
    g.natgraph->setClip(0, 0, winview->width, winview->height); 
    //upmode.setMode(UViewUpdate::PAINT_ALL);
    winview->doUpdate(winctx, winview, region, upmode);
    g.natgraph->setDest(g.natwin, 0, 0);
    g.subwin = false;
  }
  ***/
  else {
    // s'il y a un transp egalement afficher a partir du PARENT du transp
    if (firstTranspView && firstTranspView->getParentView()) 
      firstTranspView->getParentView()->setVmodes(UView::DAMAGED, true);
    setVmodes(UView::DAMAGED, true);
    upmode.setMode(UViewUpdate::PAINT_DAMAGED); //!!
    winview->doUpdate(winctx, winview, region, upmode);
  }
}

// update view paint in view coordinates:
void UView::updatePaint(URegion *region, u_bool doublebuff) {
  if (!region) region = this;
  else {
    region->x += x;
    region->y += y;
  }
  updateWinPaint(*region, doublebuff, null, true);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
