/*
 * twlog:  A basic ham loging program using Motif
 * Copyright (C) 1997->2006 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
   License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139,
 * USA. See the COPYING file in this directory.
 *
 * Version: 2.3 -  Jan 2006
 */

/*
 * main Function
 * Main defines a structure for the application defined resources,
 * initializes the toolkit, builds the widgets, initializes some
 * variables, and then realizes the widgets. 
 */

#include "twlog.h"
//#include "adif.h"
#if 0
#include "twlog.xpm"
#endif

int main (int argc, char *argv[])
{
   XtAppContext ac;
   LogRes log_res;
   struct stat buf;
   Dimension h = 0, w = 0;

#if 0
   Widget iconwin;
   Pixmap pixmap, mask;
   XpmAttributes pix_attributes;
   XpmColorSymbol transparentColor[1] = { {NULL, "none", 0} };
   Pixel bg;
#endif

   /*
    * Describe the application defined resources. This struct is
    * for the app resources which are read in the resource
    * file.  See the resource file (Twlog) for more info.
    */
   XtResource app_res_desc[] = 
   {
      {
         XmNtzone,           /* Name */
         XmCTzone,           /* Class */
         XmRInt,             /* Target data type */
         sizeof (int),       /* Size of target type */
         XtOffsetOf (LogRes, tzone), /* Offset into LogRes */
         XtRImmediate,       /* Default data type */
         (XtPointer) 2       /* This will force an error if not found */
      },

      {
         XmNbands,           /* Same a above */
         XmCBands,
         XmRXmStringTable,
         sizeof (XmStringTable),
         XtOffsetOf (LogRes, bands),
         XtRString,
         "Not Found"         /* Default to "Not Found" */
      },

      {
         XmNdefault_band,    /* Same a above */
         XmCDefault_band,
         XmRInt,
         sizeof (int),
         XtOffsetOf (LogRes, default_band),
         XtRImmediate, 0     /* Default to first button */
      },

      {
         XmNmodes,           /* Same a above */
         XmCModes,
         XmRXmStringTable,
         sizeof (XmStringTable),
         XtOffsetOf (LogRes, modes),
         XtRString,
         "Not Found"         /* Default to "Not Found" */
      },

      {
         XmNdefault_mode,    /* Same a above */
         XmCDefault_mode,
         XmRInt,
         sizeof (int),
         XtOffsetOf (LogRes, default_mode),
         XtRImmediate, 0     /* Default to first button */
      },

      {
         XmNpower,           /* Same a above */
         XmCPower,
         XmRXmStringTable,
         sizeof (XmStringTable),
         XtOffsetOf (LogRes, power),
         XtRString,
         "Not Found"         /* Default to "Not Found" */
      },

      {
         XmNdefault_power,   /* Same a above */
         XmCDefault_power,
         XmRInt,
         sizeof (int),
         XtOffsetOf (LogRes, default_power),
         XtRImmediate, 0     /* Default to first button */
      }
   };

#ifdef XmVERSION_STRING
   extern const char _XmVersionString[];
   fprintf (stderr, "Compiled with %s\n", XmVERSION_STRING);
   fprintf (stderr, "Running  with %s\n", _XmVersionString);
#endif

   /*
    * Initialize the tool kit, create the application shell,
    * and get the app defined resources
    */
   logSH = XtVaAppInitialize (&ac, "Twlog", NULL, 0, &argc, argv, NULL,
      XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
      XmNtitle, "TWLOG",
      /* XmNiconName, "TWLOG", */
      NULL);


   XtGetApplicationResources (logSH, &log_res, app_res_desc,
      XtNumber (app_res_desc), NULL, 0);

#if 0
   /*
    * Create Icon window and its pixmap
    */
   iconwin = XtVaAppCreateShell ("Iconwin", "logSH",
      wmShellWidgetClass, XtDisplay (logSH),
      XmNmappedWhenManaged, False, XmNwidth, 60, XmNheight, 40, NULL);

   XtVaGetValues (iconwin, XmNbackground, &bg, NULL);

   transparentColor[0].pixel = bg;
   pix_attributes.closeness = 40000;
   pix_attributes.valuemask = XpmColorSymbols | XpmCloseness;
   pix_attributes.colorsymbols = transparentColor;
   pix_attributes.numsymbols = 1;

   XpmCreatePixmapFromData (XtDisplay (logSH),
      DefaultRootWindow (XtDisplay (logSH)),
      twlog_xpm, &pixmap, &mask, &pix_attributes);
#endif

   /*
    * Build the widgets
    */
   build_widgets (logSH, log_res);

   /*
    * Initialize dirpath and logpath.
    * Then, check that the path is valid.
    */
   if (stat (getenv ("HOME"), &buf) == -1)      /* Do you have a $HOME? */
   {
      perror ("twlog");
      fprintf (stderr, "twlog: Can't find your \"$HOME\"\n");
      exit (1);
   }

   strcpy (dirpath, getenv ("HOME"));   /* $HOME to dir path */
   strcat (dirpath, LOGDIR);            /* then add LOGDIR   */
   if (stat (dirpath, &buf) == -1)      /* does $HOME/LOGDIR exist? */
   {
      perror ("twlog");
      fprintf (stderr, "twlog: Can't find log directory %s\n", dirpath);
      exit (1);
   }

   strcpy (logpath, dirpath);   /* dirpath to logpath */
   strcat (logpath, LOGFILE);   /* add LOGFILE name   */
   if (stat (logpath, &buf) == -1)      /* and check that it exists */
   {
      perror ("twlog");
      fprintf (stderr, "twlog: Can't find %s\n", logpath);
      exit (1);
   }

   /*
    * Initialize the Timezone
    * Check the timezone resource and do a tzset if OK.  If the value
    * is bad or the resource was not found (default resource = 2
    * above) force an error and exit.
    */
   switch (log_res.tzone)
   {
      case 0:
         putenv ("TZ");
         break;

      case 1:
         putenv ("TZ=GMT");
         break;

      default:
         fprintf (stderr, "twlog: Warning - Invalid tzone in Twlog\n");
         fprintf (stderr, "Using GMT\n");
         putenv ("TZ=GMT");
   }
   tzset ();

   /*
    * Realize the widgets and set pixmap properties for logSH
    * and iconwin
    */
   XtRealizeWidget (logSH);

#if 0
   XtRealizeWidget (iconwin);

   XtVaSetValues (iconwin, XmNbackgroundPixmap, pixmap, NULL);

   XtVaSetValues (logSH, XmNiconWindow, XtWindow (iconwin), NULL);
#endif
   /*
    * Set max and min height to current height.  Set min width to 
    * current width.  Then, go into loop mode.
    */
   XtVaGetValues (logSH, XmNheight, &h, XmNwidth, &w, NULL);

   XtVaSetValues (logSH,
      XmNminHeight, h, XmNmaxHeight, h, XmNminWidth, w, NULL);

   XtAppMainLoop (ac);
   return 0;                    /* Never get here */
}
