// Copyright (C) 2002 Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
//                and David E. Stewart (david.stewart@anu.edu.au)
//                and Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MX_HOUSEHOLDER_INC
#define MX_HOUSEHOLDER_INC

#include "Mat.h"
#include "Vec.h"

namespace Torch {

/**
   Householder transformation routines.
   Contains routines for calculating householder transformations,
   applying them to vectors and matrices by both row and column.

   Based on the "Meschach Library", available at the
   anonymous ftp site thrain.anu.edu.au in the directory
   pub/meschach.
   
   @author David E. Stewart (david.stewart@anu.edu.au)
   @author Zbigniew Leyk (zbigniew.leyk@anu.edu.au)
   @author Ronan Collobert (collober@iro.umontreal.ca)
*/
//@{

/** Calulates Householder vector.
    To eliminate all entries after the i0 entry of the vector vec.
    It is returned as out. May be in-situ.
*/
void mxHhVec(Vec * vec, int i0, real * beta, Vec * out, real * newval);


/** Apply Householder transformation to vector. 
    May be in-situ. (#hh# is the Householder vector).
*/
void mxHhTrVec(Vec * hh, real beta, int i0, Vec * in, Vec * out);

/** Transform a matrix by a Householder vector by rows.
    Start at row i0 from column j0. In-situ.
*/
void mxHhTrRows(Mat * mat, int i0, int j0, Vec * hh, real beta);

/* Transform a matrix by a Householder vector by columns.
   Start at row i0 from column j0. In-situ.
*/
void mxHhTrCols(Mat * mat, int i0, int j0, Vec * hh, real beta);

//@}


}

#endif
