// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SVM_CLASSIFICATION_INC
#define SVM_CLASSIFICATION_INC

#include "SVM.h"

namespace Torch {


/** SVM in classification.

    Try to find the hyperplane $w.x+b = 0$
    as
    $(w,b)$ minimize $0.5*||w||^2 + \sum_j C_j |1- y_j*(w.x_j+b)|_+$

    (where $|x|_+ = x$ if $x > 0$, else $0$)

    (in fact, we use a #kernel# instead of a dot product)

    The $C_j$ coefficients are given in #C_# when you
    call the constructor. If this one is NULL, then
    the value given by the "C" option is used for
    all $C_j$.
    (The size of #C_# \emph{must be} #data->n_real_examples#)

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class SVMClassification : public SVM
{
  public:
    real *Cuser;

    //-----

    ///
    SVMClassification(Kernel *kernel_, real *C_=NULL);

    //-----

    virtual void checkSupportVectors();
    virtual void reset();
    virtual ~SVMClassification();
};


}

#endif
