// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SVM_CACHE_INC
#define SVM_CACHE_INC

#include "QCCache.h"
#include "Kernel.h"
#include "SVMClassification.h"
#include "SVMRegression.h"

namespace Torch {

typedef struct SVMCacheListe_
{
    real *adr;
    int index;
    SVMCacheListe_ *prev;
    SVMCacheListe_ *suiv;
} SVMCacheListe;

/** #QCCache# implementation for SVMs.
    Compute the Q matrix.

    @see SVM
    @see QCMachine
    @see QCTrainer

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class SVMCache : public QCCache
{
  public:
    int l;
    int taille;
    real taille_en_megs;
    real *memory_cache;
    
    SVMCacheListe *cached, *cached_sauve;
    SVMCacheListe **index_dans_liste;

    Kernel *kernel;

    bool booster_mode;
    int *n_active_var;
    int *active_var;

    //-----

    ///
    SVMCache(Kernel *kernel_, real taille_en_megs);

    //-----

    virtual void allocate();
    virtual void clear();
    virtual void destroy();
    virtual void setBoosterMode(int *n_active_var_, int *active_var_);

    //-----

    virtual real *adressCache(int index);  
    virtual void rempliColonne(int index, real *adr) = 0;    
    virtual ~SVMCache();
};

/** Cache for SVM classification.

    @author Ronan Collobert (collober@iro.umontreal.ca)
 */
class SVMCacheClassification : public SVMCache
{
  public:
    real *y;

    //-----

    ///
    SVMCacheClassification(SVMClassification *svm, real taille_en_megs);

    //-----

    virtual void allocate();
    virtual void rempliColonne(int index, real *adr);
};

/** Cache for SVM regression.

    @author Ronan Collobert (collober@iro.umontreal.ca)
 */
class SVMCacheRegression : public SVMCache
{
  public:
    int lm;

    //-----

    ///
    SVMCacheRegression(SVMRegression *svm, real taille_en_megs);

    //-----

    virtual void allocate();
    virtual void rempliColonne(int index, real *adr);
};


}

#endif
