// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SVM_INC
#define SVM_INC

#include "QCMachine.h"
#include "Kernel.h"
#include "DataSet.h"

namespace Torch {

/** Support Vector Machine.
    
    The Q matrix of #QCMachine# is in this case
    $q_{ij} = k(x_i, x_j)$, where $k$ is a kernel
    and $x_i$ is the i-th example of #data#/
    
    The goal is to looking for the #alpha# and #b#
    which are the best in a SVM-sense.

    The learning function is
    $f(x) = \sum_j y_j alpha_j k(x_i, x) + b$
    
    Options:
    \begin{tabular}{lcll}
      "C"  &  real &    trade off between the weight decay and the error & [100]
    \end{tabular}

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class SVM : public QCMachine
{
  public:
    /** The dataset associated to the SVM.
        (Given by the kernel)
    */
    DataSet *data;

    /// The kernel associated to the SVM.
    Kernel *kernel;

    /// The "C" constant.
    real C_cst;

    ///
    real b;

    /// The support vectors
    int *support_vectors;

    /// The real index of the support vectors in the dataset
    int *real_index;

    /// The number of support vectors
    int n_support_vectors;

    /// The number of support vectors which are at the bound "C"
    int n_support_vectors_bound;

    //-----
    
    ///
    SVM(Kernel *kernel_);

    /// Computes the #b#.
    bool bCompute();

    //-----

    virtual void init();
    virtual void forward(List *inputs);
    virtual void loadFILE(FILE *file);
    virtual void saveFILE(FILE *file);

    virtual ~SVM();    
};


}

#endif
