// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef LOG_SIGMOID_INC
#define LOG_SIGMOID_INC

#include "GradientMachine.h"

namespace Torch {

/** Log-sigmoid layer for #GradientMachine#.
    The number of inputs/outputs is the number
    of units of this machine.
    Formally speaking, $ouputs[i] = log(1/(1+exp(-inputs[i])))$

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class LogSigmoid : public GradientMachine
{
  public:
    real *buff;

    //-----
    
    /// Create a layer with <n_units> units.
    LogSigmoid(int n_units);

    //-----

    virtual void allocateMemory();
    virtual void freeMemory();
    virtual int numberOfParams();
    virtual void forward(List *inputs);
    virtual void backward(List *inputs, real *alpha);

    virtual ~LogSigmoid();
};


}

#endif
