// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "RBF.h"

namespace Torch {

RBF::RBF(int n_inputs_, int n_hidden_, int n_outputs_, bool is_linear_outputs_, bool inputs_to_outputs_,EMTrainer* kmeans_trainer)
{
  n_hidden = n_hidden_;
  is_linear_outputs = is_linear_outputs_;
  inputs_to_outputs = inputs_to_outputs_;
  add_layer = NULL;
  sum_layer = NULL;
  if (n_hidden>0) {
    log_rbf_layer= new LogRBF(n_inputs_,n_hidden,kmeans_trainer);
    log_rbf_layer->init();
    addMachine(log_rbf_layer);

    if (inputs_to_outputs_) {
      add_layer = new Linear(n_inputs_,n_outputs_);
      add_layer->init();
      addMachine(add_layer);
    }

    exp_layer = new Exp(n_hidden);
    exp_layer->init();
    addLayer();
    addMachine(exp_layer);
    connectOn(log_rbf_layer);

    addLayer();
    outputs_layer = new Linear(n_hidden,n_outputs_);
    outputs_layer->init();
    addMachine(outputs_layer);
    connectOn(exp_layer);

    if (inputs_to_outputs_) {
      sum_layer = new SumMachine(n_outputs_,2);
      sum_layer->init();
      addLayer();
      addMachine(sum_layer);
      connectOn(add_layer);
      connectOn(outputs_layer);
    }
  } else {
    outputs_layer = new Linear(n_inputs_,n_outputs_);
    outputs_layer->init();
    addFCL(outputs_layer);
  }
  if (!is_linear_outputs) {
    outputs_tanh_layer = new Tanh(n_outputs_);
    outputs_tanh_layer->init();
    addFCL(outputs_tanh_layer);
  }
}

RBF::~RBF()
{
  if (n_hidden>0) {
    delete log_rbf_layer;
    delete exp_layer;
  }
  delete outputs_layer;
  if (!is_linear_outputs)
    delete outputs_tanh_layer;
  if (add_layer)
    delete add_layer;
  if (inputs_to_outputs)
    delete sum_layer;
}


}

