[vset VERSION 0.1]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin canvas::highlight n [vset VERSION]]
[moddesc   {Variations on a canvas}]
[titledesc {Manage the highlighting of canvas items or item groups}]
[require Tcl 8.5]
[require Tk 8.5]
[require canvas::highlight [opt [vset VERSION]]]
[keywords canvas highlighting {enter callback} {leave callback}]
[description]

This package provides utility commands for setting up and tearing down
of highlights for canvas items or item groups, the latter identified
by a tag.

[section API]

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd ::canvas::highlight] [method on] [arg canvas] [arg tagOrId] [arg cmd]]

This command sets up a general highlight, with the items of canvas
[arg canvas] to highlight in this manner identified by [arg tagOrId]
and the [arg cmd] prefix providing the implementation, i.e. the how to
perform the highlight.

[para] The signature of the command prefix is described later, in
section [sectref {Highlight callback}].

[para] The result of the command is the empty string.

[para] Limitations: 
[list_begin enumerated]
[enum] When a highlight is active no other highlight can be activated.
       This means that nested highlights are not possible.
[enum] The system may break if a highlight is removed from within its
       highlight callback.
[list_end]

[call [cmd ::canvas::highlight] [method off] [arg canvas] [arg tagOrId]]

This command removes any highlight set on the items of canvas
[arg canvas] identified by [arg tagOrId].

[para] The result of the command is the empty string.

[list_end]

[subsection {Highlight callback}]

The highlight callback is a command prefix invoked in the following
two ways:

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd "{*}cmd"] [method on] [arg canvas] [arg item]]

This form is invoked when the mouse has entered (one of) the item(s)
the highlight was set up for. The callback now has to perform any
reconfiguration necessary to highlight the item (group).

[para] The result of the command can be anything. It is stored by the
system as client information and passed unchanged to the un-highlight
callback for its use. In this manner the highlight callback is able to
maintain custom state from highlighting to un-highlighting.

[para] Note that the callback does not have to maintain state, nor
does it have to actually reconfigure the item (group). In the latter
case the callback simply serves as easy enter/leave notification.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd "{*}cmd"] [method off] [arg canvas] [arg clientdata]]

This form is invoked when the mouse has left (one of) the item(s) of
the currently active the highlight. The callback now has to perform
any reconfiguration necessary to un-highlight the item (group).

[para] The result of the command must be a boolean value with the
usual value to be [const true]. By returning [const false] instead the
callback can veto the removal of the highlight.

[list_end]
[manpage_end]
