;;; tc-setup.el --- setup and/or loading routines for T-Code

;; Copyright (C) 1997-2001 KITAJIMA Akira.

;; Author: KITAJIMA Akira <kitajima@isc.osakac.ac.jp>
;; Created: 26 Apr 1997
;; Version: $Id: tc-setup.el,v 1.18 2002/03/23 00:32:00 kitajima Exp $

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.

;;; Code:

(defconst tcode-emacs-version
  (cond ((string-match "XEmacs" emacs-version)
	 'xemacs)
	((and (boundp 'mule-version)
	      (>= (string-to-int mule-version) 4))
	 'mule-4)
	((and (boundp 'mule-version)
	      (= (string-to-int mule-version) 3))
	 'mule-3)
	((numberp (string-match "^19" emacs-version))
	 'mule-2)
	((featurep 'mule)
	 'mule-1)
	(t
	 (or (boundp 'emacs-major-version)
	     (setq emacs-major-version 18))
	 'nemacs))
  "ܸEmacsΥס
nemacs, mule-1, mule-2, mule-3, mule-4, xemacsΤ줫")

(defvar tcode-load-immediate nil
  "nil ǤʤȤTѤΤ٤ƤΥ⥸塼٤˥ɤ롣")

(defvar tcode-init-file-name "~/.tc"
  "tc-setup.el ɤ߽ФȤɤޤĿե̾
ե̾ѹ tc-setup.el ɤ߽Фˤͤ
ꤷʤФʤʤ")

(defvar tcode-use-isearch nil
  "nil ǤʤȤTɤѤǤ褦isearchĥ롣")

(defconst tcode-isearch-type 
  (cond ((eq tcode-emacs-version 'nemacs)
	 'tc-is18)
	((memq tcode-emacs-version '(mule-1 mule-2 mule-3 xemacs))
	 'tc-is19)
	(t
	 'tc-is20))
  "isearchѤTѥ⥸塼Υס")

(defvar tcode-use-as-default-input-method nil
  "nil ǤʤȤTɤǥեȤinput methodˤ롣")

(defvar tcode-default-input-method "japanese-T-Code"
  "TϴĶǤΥǥեȤinput method
ѿ`tcode-package-name-alist'ϿƤ̾Ǥ롣")

(defvar tcode-data-directory nil
  "TɤγƼǡե֤Υǥ쥯ȥꡣ
\"/\"դʤФʤʤ")

;;; for toggle-input-method

(defvar tcode-current-package nil)

(defvar tcode-transparent-mode-indicator "--")

(defvar tcode-package-name-alist
  '(("japanese-T-Code" . "tc-tbl")
    ("japanese-TUT-Code" . "tutc-tbl"))
  "̾ȥơ֥̾Ȥб")

(defun tcode-use-package (package-name &rest libraries)
  "Start using T-Code package PACKAGE-NAME.
The remaining arguments are libraries to be loaded before using the package."
  (if (equal tcode-current-package package-name)
      ()
    (let ((table-name (cdr (assoc package-name
				  tcode-package-name-alist))))
      (or table-name
	  (error "No package named %s" package-name))
      (while libraries
	(load (car libraries))
	(setq libraries (cdr libraries)))
      (tcode-load-table table-name))
    (setq tcode-current-package package-name))
  (setq inactivate-current-input-method-function 'tcode-inactivate
	describe-current-input-method-function 'tcode-mode-help)
  (setq current-input-method-title 'tcode-mode-indicator)
  (tcode-activate))

(if (featurep 'tc-setup)
    ()
  ;; load configuration file
  (require 'tc-site)
  (setq tcode-data-directory tcode-site-data-directory)
  (and tcode-init-file-name
       (file-exists-p tcode-init-file-name)
       (let ((features (cons 'tc-setup features)))
	 (require 'tc-sysdep)
	 (setq tcode-use-isearch t
	       tcode-use-as-default-input-method t)
	 (load tcode-init-file-name)))
  ;; map toggle-input-method to `C-\'
  (if (or (memq tcode-emacs-version '(nemacs mule-1 mule-2))
	  (and (eq tcode-emacs-version 'xemacs)
	       (< emacs-major-version 21)
	       (< emacs-minor-version 3)))
      (autoload 'toggle-input-method "tc-sysdep" nil t)
    ;; Mule 3.* ʾѤ
    (register-input-method "japanese-TUT-Code"
			   "Japanese"
			   'tcode-use-package
			   "TUT"
			   "a kanji direct input method")
    (register-input-method "japanese-T-Code"
			   "Japanese"
			   'tcode-use-package
			   "TC"
			   "a kanji direct input method"))
  (if (and (<= (length (where-is-internal 'toggle-input-method)) 1)
	   (null (lookup-key global-map "\C-\\")))
      (global-set-key "\C-\\" 'toggle-input-method))
  (if tcode-use-as-default-input-method
      (progn
	(and (fboundp 'set-language-info)
	     (set-language-info "Japanese" 
				'input-method tcode-default-input-method))
	(setq-default default-input-method tcode-default-input-method)
	(setq default-input-method tcode-default-input-method)))
  ;; isearch
  (if (and tcode-use-isearch
	   tcode-use-as-default-input-method)
      (require tcode-isearch-type))
  ;; autoload
  (autoload 'tcode-activate "tc")
  (autoload 'tcode-load-table "tc" nil t)
  ;; functions in tc-jiscode.el
  (autoload 'tcode-start-jiscode "tc-jiscode" nil t)
  ;; functions in tc-help.el
  (autoload 'tcode-display-stroke-for-char "tc-help" nil t)
  (autoload 'tcode-query-stroke "tc-help" nil t)
  (autoload 'tcode-show-tables "tc-help" nil t)
  (autoload 'tcode-mode-help "tc-help" nil t)
  (autoload 'tcode-display-direct-stroke "tc-help")
  ;; functions in tc-bushu.el
  (autoload 'tcode-bushu-henkan "tc-bushu" nil t)
  (autoload 'tcode-bushu-henkan-interactively "tc-bushu" nil t)
  (autoload 'tcode-compose-char-interactively "tc-bushu" nil t)
  (autoload 'tcode-bushu-another-henkan "tc-bushu" nil t)
  (autoload 'tcode-bushu-compose "tc-bushu")
  ;; functions in tc-mazegaki.el
  (mapcar (function (lambda (command)
		      (autoload command "tc-mazegaki" nil t)))
	  '(tcode-mazegaki-switch-to-dictionary
	    tcode-mazegaki-start
	    tcode-mazegaki-toroku
	    tcode-mazegaki-toroku-and-kakutei
	    tcode-mazegaki-delete-kanji
	    tcode-mazegaki-ikkatu-toroku-region
	    tcode-mazegaki-ikkatu-toroku-buffer
	    tcode-mazegaki-ikkatu-delete-region
	    tcode-mazegaki-ikkatu-delete-buffer
	    tcode-mazegaki-delete-by-last-yomi
	    tcode-mazegaki-complete
	    tcode-mazegaki-complete-and-henkan
	    tcode-start-fixed-mazegaki
	    tcode-mazegaki-henkan))
  (autoload 'tcode-mazegaki-prefix "tc-mazegaki")
  ;; functions in tc-inst.el
  (autoload 'tcode-install "tc-inst" nil t)
  ;; functions in tc-mkmzdic.el
  (autoload 'tcode-make-mazegaki-dictionary "tc-mkmzdic" nil t)
  ;; functions in tc-util.el
  (autoload 'set-tcode-mode-key "tc-util" nil t)
  (and (not (eq tcode-emacs-version 'nemacs))
       window-system
       (autoload 'tcode-enable-cursor-to-change-color "tc-util" nil t))
  (autoload 'tcode-mazegaki-delete-kanji-from-dictionary "tc-util" nil t)
  (autoload 'tcode-mazegaki-get-yomi-max "tc-util" nil t)
  (autoload 'tcode-electric-space "tc-util" nil t)
  (autoload 'tcode-electric-comma "tc-util" nil t)
  (autoload 'tcode-insert-ya-outset "tc-util" nil t)
  (autoload 'tcode-transpose-strokes-or-chars "tc-util" nil t)
  (autoload 'tcode-mazegaki-show-yomi-region "tc-util" nil t)
  (autoload 'tcode-katakana-previous-char "tc-util" nil t)
  (autoload 'tcode-insert-kanji-by-kuten-code "tc-util" nil t)
  (autoload 'tcode-insert-kanji-by-jis-code "tc-util" nil t)
  (autoload 'tcode-katakana-preceding-chars "tc-util" nil t)
  (autoload 'tcode-kkc-region "tc-util" nil t)
  (autoload 'tcode-zap-to-char "tc-util" nil t)
  ;; EELLL
  (autoload 'eelll "eelll" nil t)
  (and (featurep 'frame)
       (autoload 'eelll-other-frame "eelll" nil t)))

(provide 'tc-setup)

(if tcode-load-immediate
    (progn
      ;; load all modules for T-Code
      (require 'tc-bushu)   ; tc.el will be loaded also.
      (require 'tc-help)
      (require 'tc-jiscode)
      (require 'tc-util)
      (require 'tc-mazegaki)))

;;; tc-setup.el ends here
