/*
 * DocProperties.c, DocProperties.h
 *
 * Functions to manage the index's Document Properties 
 *
 * File Created.
 * M. Gaulin 8/10/98
 */

#ifndef _DOCPROP_H_
#define _DOCPROP_H_

/*
** use _AP() for easier cross-compiler (non-ANSI) porting 
** <return value> <functionname> _AP( (<arg prototypes>) );
*/

void freeDocProperties _AP ((struct docPropertyEntry **docProperties));
void storeDocProperties _AP ((struct docPropertyEntry *docProperties, FILE *fp));

void addDocProperty _AP ((struct docPropertyEntry **docProperties, int metaName, char* propValue));

void fetchDocProperties _AP ((struct docPropertyEntry **docProperties, FILE* fp));

void initSearchResultProperties _AP (());
void addSearchResultDisplayProperty _AP ((char* propName));
void addSearchResultSortProperty _AP ((char* propName));
char* lookupDocPropertyValue _AP ((int metaName, long propPos, FILE *fp));
void printSearchResultProperties _AP ((char **prop));

void swapDocPropertyMetaNames _AP ((struct docPropertyEntry *docProperties, struct metaMergeEntry *metaFile));

void getResultProperties _AP ((long,char **,FILE *));
int isSortProp _AP ((void));
struct result *sortresultsbyproperty _AP ((struct result *rp, int structure, FILE *fp));

#endif _DOCPROP_H_
