#===================================
#           stack_api
#  Copyright 2010 - Nathan Osman
#
# Provides access to StackExchange
#          API methods
#
#   StackApplet is released under
#        the MIT license
#===================================

# Current api version

API_VERSION = "1.0"
API_KEY     = "_qlxmEAOH06hLA1_FsZIGQ"

import urllib
import urllib2
import zlib    # for handling GZIP compression

import time

# Now lets see if we can import the JSON
# module. We're going to make two tries at this
# to make sure we get one:

try:
	import json
except ImportError:
	import simplejson as json

# This class exists to abstract
# as much of the API requesting
# functionality as possible.

class stack_api:

	# Contructor
	
	def __init__ (self):
	
		# The very first thing we want to do is to
		# fetch the list of sites from StackAuth
		
		global API_VERSION, API_KEY
		
		# In case this information is not available for some
		# strange reason, we need to wrap this in a try block
		
		try:
			self.sites = self.fetch_json_data("http://stackauth.com/" + API_VERSION + "/sites?key=" + API_KEY)
			
		except urllib2.HTTPError:
			
			print "There was an error retrieving information from StackAuth."
			self.sites = None
	
	# Given a URL, this function will return
	# the results as JSON encoded data
	
	def fetch_json_data (self,url):
		
		# We don't want too many requests
		# so we'll spread them out a bit
		time.sleep(0.1)
		
		# Create the request
		request = urllib2.Request(url)
		request.add_header('Accept-Encoding', 'gzip,deflate')    # Required by the API
		
		opener = urllib2.build_opener()
		
		# Get the raw stream and decompress it
		gzipped_stream = opener.open(request)
		raw_data = zlib.decompress(gzipped_stream.read(), 16+zlib.MAX_WBITS)
		
		# parse the json
		json_data = json.loads(raw_data)
		
		# now simply return that data
		
		return json_data
	
	def fetch_sites (self):
		
		# Return the list of sites
		return self.sites
	
	def fetch_stats (self,site):
		
		# Return the list of sites
		
		global API_VERSION, API_KEY
		
		return self.fetch_json_data("http://api." + site + ".com/" + API_VERSION + "/stats?key=" + API_KEY)
		
	def fetch_user_profile (self,site,user_id):
		
		# Fetch and return the results
		
		global API_VERSION, API_KEY
		
		return self.fetch_json_data("http://api." + site + ".com/" + API_VERSION + "/users/" + str(user_id) + "?key=" + API_KEY)
	
	def fetch_user_mentioned (self,site,user_id):
		
		# Fetch and return the results
		
		global API_VERSION, API_KEY
		
		return self.fetch_json_data("http://api." + site + ".com/" + API_VERSION + "/users/" + str(user_id) + "/mentioned?key=" + API_KEY)
	
	def fetch_users_filter (self,site,search_str):
		
		# Fetch all users matching search_str
		
		global API_VERSION, API_KEY
		
		search_str = urllib.quote_plus(search_str)
		
		return self.fetch_json_data("http://api." + site + ".com/" + API_VERSION + "/users?key=" + API_KEY + "&filter=" + search_str)
	
	def fetch_associated_accounts (self,guid):
		
		# Fetch and return the results
		
		global API_VERSION, API_KEY
		
		return self.fetch_json_data("http://stackauth.com/" + API_VERSION + "/users/" + guid + "/associated?key=" + API_KEY)
	
	def fetch_users_questions (self,site,user_id):
		
		global API_VERSION, API_KEY
		
		return self.fetch_json_data("http://api." + site + ".com/" + API_VERSION + "/users/" + str(user_id) + "/questions?sort=creation&pagesize=50&key=" + API_KEY)
	
	def fetch_answers_to_questions (self,site,questions,last_time):
		
		global API_VERSION, API_KEY
		
		return self.fetch_json_data("http://api." + site + ".com/" + API_VERSION + "/questions/" + questions + "/answers?fromdate=" + str(last_time) + "&key=" + API_KEY)

# In order to make things as efficient
# as possible, we need to create one instance
# of the class and everyone can refer to that

api = stack_api()
