#===================================
#           select_user
#  Copyright 2010 - Nathan Osman
#
#   Displays a dialog that makes
#    finding a user_id easier
#
#   StackApplet is released under
#        the MIT license
#===================================

import gobject
import gtk

# import our API module
import stack_api

# The class itself
class select_user:
    
    # Constructor
    
    def __init__(self,site_endpoint):
        
        self.site = site_endpoint
        self.ret_val = 0
        
        # Load the file with the template
        self.builder = gtk.Builder()
        
        # We need to tell our builder instance what we're
	# doing translation-wise
	self.builder.set_translation_domain("stackapplet")
        
        self.builder.add_from_file("/usr/share/stackapplet/stackapplet.glade")
        
        # Now connect the signals
        signal_dict = { "on_button_name_clicked"   : self.OnName,
                        "on_button_select_clicked" : self.OnSelect,
                        "on_button_close_clicked"  : self.OnClose }
        
        # Setup the model for the treeview
        self.user_list = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_INT,gobject.TYPE_INT)
        
        self.builder.get_object('user_list').set_model(self.user_list)
        
        column1 = gtk.TreeViewColumn()
        cell1 = gtk.CellRendererText()
        column1.pack_start(cell1)
        column1.add_attribute(cell1,'text',0)
        column1.set_title("Username:")
        column1.set_min_width(145)
        
        column2 = gtk.TreeViewColumn()
        cell2 = gtk.CellRendererText()
        column2.pack_start(cell2)
        column2.add_attribute(cell2,'text',1)
        column2.set_title("Rep.:")
        
        self.builder.get_object('user_list').append_column(column1)
        self.builder.get_object('user_list').append_column(column2)
        
        self.builder.connect_signals(signal_dict)
        
        self.window = self.builder.get_object("select_dialog")
        self.window.show()
    
    def OnName(self,widget):
        
        # This is where we would do the search
        
        users = stack_api.api.fetch_users_filter(self.site,self.builder.get_object('entry_name').get_text())
        
        for user in users["users"]:
        
            self.user_list.append([user["display_name"],user["reputation"],user["user_id"]])
    
    def OnSelect(self,widget):
        
        self.ret_val = self.user_list[self.builder.get_object('user_list').get_selection().get_selected()[1]][2]
        
        self.window.destroy()
    
    def OnClose(self,widget):
        
        self.window.destroy()
    
    def run(self):
        
        self.window.run()
