from unittest import makeSuite

from base import SquishdotBase

from re import search

class PostingTests(SquishdotBase):

    def testAddArticle(self):
        "Check the SquishSite.addPosting method works"
        
        id = self._addPosting(title    = 'testSquishSiteAddPosting',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain',
                              subject  = 'test subject',
                              summary  = 'summary',
                              dept     = 'dept')
        
        Posting = self.Site[id]
        
        assert Posting.title    =='testSquishSiteAddPosting'
        assert Posting.author   =='tester'
        assert Posting.body     ==['body']
        assert Posting.email    =='email'
        assert Posting.notify   ==1
        assert Posting.encoding =='Plain'
        assert Posting.subject  =='test subject'
        assert Posting.summary  ==['summary']
        assert Posting.dept     =='dept'

    def testAddArticleTTW(self):
        "Check the SquishSite.addPosting method works TTW"
        
        REQUEST=self.Site.REQUEST
        RESPONSE=REQUEST.RESPONSE
        REQUEST['title']    = 'testSquishSiteAddPosting'
        REQUEST['author']   = 'tester'
        REQUEST['body']     = 'body'
        REQUEST['email']    = 'email'
        REQUEST['notify']   = 1
        REQUEST['encoding'] = 'Plain'
        REQUEST['subject']  = 'test subject'
        REQUEST['summary']  = 'summary'
        REQUEST['dept']     = 'dept'

        self.Site.addPosting(REQUEST=REQUEST,RESPONSE=RESPONSE)
        Posting = self._getPosting(title="testSquishSiteAddPosting")
        
        assert Posting.title    =='testSquishSiteAddPosting'
        assert Posting.author   =='tester'
        assert Posting.body     ==['body']
        assert Posting.email    =='email'
        assert Posting.notify   ==1
        assert Posting.encoding =='Plain'
        assert Posting.subject  =='test subject'
        assert Posting.summary  ==['summary']
        assert Posting.dept     =='dept'

    def testAddArticleIncomplete(self):
        "Check the SquishSite.addPosting handles incomplete postings correctly"
        
        self.Site.REQUEST.HTTP_REFERER='where I came from'
        result = self._addPosting(title    = 'testSquishSiteAddPostingIncomplete')
        assert search('<FORM ACTION="where I came from"',result) is not None

    def testAddComment(self):
        "Check the Article.addPosting method works"
        
        parent = self._getPosting()
        id = self._addPosting(object   = parent,
                              title    = 'testArticleAddPosting',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        
        Posting = self.Site[parent.id][id]
        
        assert Posting.title    =='testArticleAddPosting'
        assert Posting.author   =='tester'
        assert Posting.body     ==['body']
        assert Posting.email    =='email'
        assert Posting.notify   ==1
        assert Posting.encoding =='Plain'
        # Comments take their subject from their parent Article.
        assert Posting.subject  ==parent.subject
        return Posting

    def testAddCommentTTW(self):
        "Check the Posting.addPosting method works TTW"
        
        REQUEST=self.Site.REQUEST
        RESPONSE=REQUEST.RESPONSE
        REQUEST['title']    = 'testSquishSiteAddPosting'
        REQUEST['author']   = 'tester'
        REQUEST['body']     = 'body'
        REQUEST['email']    = 'email'
        REQUEST['notify']   = 1
        REQUEST['encoding'] = 'Plain'

        parent = self._getPosting()
        parent.addPosting(REQUEST=REQUEST,RESPONSE=RESPONSE)
        Posting = self._getPosting(title="testSquishSiteAddPosting")
        
        assert Posting.title    =='testSquishSiteAddPosting'
        assert Posting.author   =='tester'
        assert Posting.body     ==['body']
        assert Posting.email    =='email'
        assert Posting.notify   ==1
        assert Posting.encoding =='Plain'
        assert Posting.subject  ==parent.subject

    def testAddCommentIncomplete(self):
        "Check the Posting.addPosting handles incomplete postings correctly"
        
        self.Site.REQUEST.HTTP_REFERER='where I came from'
        result = self._addPosting(object = self._getPosting(),
                                  title    = 'testSquishSiteAddPostingIncomplete')
        assert search('<FORM ACTION="where I came from"',result) is not None

    def testEditArticle(self):
        "Check the edit method makes the necessary changes to Articles"
        REQUEST = {}
        Posting = self._getPosting()
        
        REQUEST['title']   ='testEditPosting'
        REQUEST['author']  ='tester'
        REQUEST['body']    ='body'
        REQUEST['email']   ='email'
        REQUEST['notify']  =1
        REQUEST['encoding']='Plain'
        REQUEST['subject'] ='test subject'
        REQUEST['summary'] ='summary'
        REQUEST['dept']    ='dept'
        
        Posting.edit(REQUEST=REQUEST)
        
        assert Posting.title    =='testEditPosting'
        assert Posting.author   =='tester'
        assert Posting.body     ==['body']
        assert Posting.email    =='email'
        assert Posting.notify   ==1
        assert Posting.encoding =='Plain'
        assert Posting.subject  =='test subject'
        assert Posting.summary  ==['summary']
        assert Posting.dept     =='dept'

    def testEditComment(self):
        "Check the edit method makes the necessary changes to Comments"
        Posting = self.testAddComment()
        old_subject = Posting.subject
        REQUEST = {}
        
        REQUEST['title']   ='testEditComment'
        REQUEST['author']  ='tester edit'
        REQUEST['body']    ='body edit'
        REQUEST['email']   ='email edit'
        REQUEST['notify']  =0
        REQUEST['encoding']='HTML'
        
        Posting.edit(REQUEST=REQUEST)
        
        assert Posting.title    =='testEditComment'
        assert Posting.author   =='tester edit'
        assert Posting.body     ==['body edit']
        assert Posting.email    =='email edit'
        assert Posting.notify   ==0
        assert Posting.encoding =='HTML'
        assert Posting.subject  ==old_subject

    def testPreviewPosting(self):
        "Check that previewPosting doesn't barf"
        self.Site.previewPosting(self.Site,self.Site.REQUEST)
        
def test_suite():
    return makeSuite(PostingTests)

def debug():
   test_suite().debug()
    
