#!/usr/bin/env python

"""
$Id: convert.py 354 2009-01-22 23:53:01Z inquisb $

This file is part of the sqlmap project, http://sqlmap.sourceforge.net.

Copyright (c) 2006-2009 Bernardo Damele A. G. <bernardo.damele@gmail.com>
                        and Daniele Bellucci <daniele.bellucci@gmail.com>

sqlmap is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation version 2 of the License.

sqlmap is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along
with sqlmap; if not, write to the Free Software Foundation, Inc., 51
Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""


try:
    import md5
    import sha
except DeprecationWarning, _:
    from hashlib import md5
    from hashlib import sha

import struct
import urllib


def base64decode(string):
    return string.decode("base64")


def base64encode(string):
    return string.encode("base64")[:-1]


def hexdecode(string):
    string = string.lower()

    if string.startswith("0x"):
        string = string[2:]

    return string.decode("hex")


def hexencode(string):
    return string.encode("hex")


def md5hash(string):
    return md5.new(string).hexdigest()


def orddecode(string):
    packedString = struct.pack("!"+"I" * len(string), *string)
    return "".join([chr(char) for char in struct.unpack("!"+"I"*(len(packedString)/4), packedString)])


def ordencode(string):
    return tuple([ord(char) for char in string])


def sha1hash(string):
    return sha.new(string).hexdigest()


def urldecode(string):
    if not string:
        return

    doublePercFreeString = string.replace("%%", "__DPERC__")
    unquotedString = urllib.unquote_plus(doublePercFreeString)
    unquotedString = unquotedString.replace("__DPERC__", "%%")

    return unquotedString


def urlencode(string, safe=":/?%&="):
    if not string:
        return

    return urllib.quote(string, safe)
