/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 4      *
*                (c) 2006-2009 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#ifndef SOFA_SIMULATION_TREE_TREESIMULATION_H
#define SOFA_SIMULATION_TREE_TREESIMULATION_H

#include <sofa/simulation/common/Simulation.h>
#include <sofa/simulation/common/Node.h>
#include <sofa/simulation/tree/GNode.h>
#include <sofa/simulation/tree/xml/XML.h>

namespace sofa
{

namespace simulation
{

namespace tree
{

/** Main controller of the scene.
Defines how the scene is inited at the beginning, and updated at each time step.
Derives from BaseObject in order to model the parameters as Datas, which makes their edition easy in the GUI.
*/
  class SOFA_SIMULATION_TREE_API TreeSimulation: public sofa::simulation::Simulation
    {
private:
	///load a scene from memory (typically : an xml into a string)
	static Node* loadFromMemory ( const char *filename, const char *data, unsigned int size );
	///load a scene from a file
	static Node* loadFromFile ( const char *filename );
	///generic function to process xml tree (after loading the xml structure from the 2 previous functions)
	static Node* processXML(xml::BaseElement* xml, const char *filename);
public:
	/** Load a scene from a file.
	This file can be a xml file or a script file which will generate a xml tree.
	*/

        Node* load(const char* filename);

	/// Delete a scene from memory. After this call the pointer is invalid
	void unload(Node* root);

        /// Create a new Node of the simulation
        Node* newNode(const std::string& name);


};

/** Get the (unique) simulation which controls the scene.
Automatically creates one if no Simulation has been set.
*/
SOFA_SIMULATION_TREE_API Simulation* getSimulation();
} // namespace tree

} // namespace simulation

} // namespace sofa

#endif
