/*
    Copyright (C) 2003-2006 Teus Benschop.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/


#include "libraries.h"
#include "utilities.h"
#include "constants.h"
#include "versification.h"


int main (int argc, char *argv[])
{
  bool option_names = false;
  ustring name;
  ustring book;
  ustring chapter;
  bool option_verses = false;
  // Process command line arguments.
  for (int i = 1; i < argc; i++) {
    ustring argument;
    argument = argv[i];
    if (argument.length() > 2) {
      if (argument.substr (0, 2) == "--") {
        argument.erase (0, 2);
        if (argument == "names")
          option_names = true;
        if (argument == "name")
          name = argv[++i];
        if (argument == "book")
          book = argv[++i];
        if (argument == "chapter")
          chapter = argv[++i];
        if (argument == "verses")
          option_verses = true;
        continue;
      }
    }
  }
  if (argc == 1) {
    cout << "sc-versification provides versification information on stdout." << endl;
    cout << "--names" << endl;
    cout << "  Available versification systems" << endl;
    cout << "--name <name>>" << endl;
    cout << "  Available books in this versification system, e.g. -- name Original" << endl;
    cout << "--name <name> --book <book>" << endl;
    cout << "  Available chapters in book, e.g. -- name Original --book Genesis" << endl;
    cout << "--name <name> --book <book> --chapter <chapter>" << endl;
    cout << "  Available verses in chapter of book" << endl;
    cout << "--name <name> --book <book> --verses" << endl;
    cout << "  Available verses per chapter of book" << endl;
  }
  if (option_names) {
    // Show all available systems.
    vector <ustring> names;
    names = versification_get_systems ();
    for (unsigned int i = 0; i < names.size(); i++)
      cout << names[i] << endl;
  }
  if (option_verses) {
    // Show available verses per chapter.
    vector <int> verses;
    verses = versification_get_verses (name, book);
    for (unsigned int i = 0; i < verses.size(); i++)
      cout << verses[i] << endl;
  }
  else if (!name.empty()) {
    if (book.empty() && chapter.empty()) {
      // Ok, show books in this versification system.
      vector <ustring> books;
      books = versification_get_books (name);
      for (unsigned int i = 0; i < books.size(); i++)
        cout << books[i] << endl;
    } else if (chapter.empty()) {
      // Ok, show highest chapter in this book.
      cout << versification_get_highest_chapter (name, book) << endl;
    } else {
      // Ok, show highest verse in thie chapter of this book.
      cout << versification_get_highest_verse (name, book, convert_to_int (chapter)) << endl;
    }
  }
  return 0;
}
