/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "../src/libraries.h"
#include "../src/utilities.h"
#include "../src/constants.h"


/*
This converter reads from stdin and writes to stdout.
The input file is a .vrs file from Paratext.
The output file is an xml mapping file as used in scripturechecks.
To allow for split verses, and overlapping ones, it produces mappings per verse,
not in ranges as is commonly done.
*/


int main (int argc, char *argv[])
{
  cout << "Original" << endl;
  GIOChannel* io;
  gchar* text;
  gsize length;
  io = g_io_channel_unix_new (0);
  bool mapping_input_has_started = false;
  ustring previous_book;
  while (g_io_channel_read_line (io, &text, &length, NULL, NULL) == G_IO_STATUS_NORMAL) {
    ustring utext (text);
    utext = trim (utext);
    g_free (text);
    if (utext.find ("Mapping") != string::npos)
      mapping_input_has_started = true;
    if (!mapping_input_has_started)
      continue;
    if (utext.empty())
      continue;
    if (utext.substr (0, 1) == "#")
      continue;
    // utext: GEN 31:55 = GEN 32:1 or GEN 32:1-32 = GEN 32:2-33
    // Get the bookname from the line.
    ustring book = utext.substr (0, 3);
    utext.erase (0, 4);
    utext.erase (utext.find (book), 4);
    book = id_to_biblebook_english (book);
    // utext: 31:55 = 32:1 or 32:1-32 = 32:2-33
    // Get original and hebrew/greek chapter and verse.
    Parse parse (utext, false);
    ustring original (parse.words[0]);
    size_t position = original.find(":");
    ustring origchapter (original.substr (0, position));
    original.erase (0, ++position);
    ustring origverse (original);
    vector<unsigned int> orig_verses;
    position = origverse.find ("-");
    if (position != string::npos) {
      unsigned int start = convert_to_int (origverse);
      origverse.erase (0, ++position);
      unsigned int end = convert_to_int (origverse);
      for (unsigned int i = start; i <= end; i++)
        orig_verses.push_back (i);
    } else {
      orig_verses.push_back (convert_to_int (origverse));
    }
    ustring hebrew_greek (parse.words[2]);
    position = hebrew_greek.find(":");
    ustring hebgrkchapter (hebrew_greek.substr (0, position));
    hebrew_greek.erase (0, ++position);
    unsigned int hebgrkverse (convert_to_int (hebrew_greek));
    if (book != previous_book) {
      cout << book << endl;
      previous_book = book;        
    }
    for (unsigned int i = 0; i < orig_verses.size(); i++) {
      ustring line;
      line =   origchapter + ":" + convert_to_string (orig_verses[i])
             + "=" 
             + hebgrkchapter + ":" + convert_to_string (hebgrkverse);
      cout << line << endl; 
      hebgrkverse++;
    }
  }
  g_io_channel_unref (io);     
  return 0;
}
