# -*- encoding:utf-8; warn-indent:false; frozen_string_literal: true  -*-

# line 1 "lib/parser/lexer.rl"

# line 3 "lib/parser/lexer.rl"
#
# === BEFORE YOU START ===
#
# Read the Ruby Hacking Guide chapter 11, available in English at
# http://whitequark.org/blog/2013/04/01/ruby-hacking-guide-ch-11-finite-state-lexer/
#
# Remember two things about Ragel scanners:
#
#   1) Longest match wins.
#
#   2) If two matches have the same length, the first
#      in source code wins.
#
# General rules of making Ragel and Bison happy:
#
#  * `p` (position) and `@te` contain the index of the character
#    they're pointing to ("current"), plus one. `@ts` contains the index
#    of the corresponding character. The code for extracting matched token is:
#
#       @source_buffer.slice(@ts...@te)
#
#  * If your input is `foooooooobar` and the rule is:
#
#       'f' 'o'+
#
#    the result will be:
#
#       foooooooobar
#       ^ ts=0   ^ p=te=9
#
#  * A Ragel lexer action should not emit more than one token, unless
#    you know what you are doing.
#
#  * All Ragel commands (fnext, fgoto, ...) end with a semicolon.
#
#  * If an action emits the token and transitions to another state, use
#    these Ragel commands:
#
#       emit($whatever)
#       fnext $next_state; fbreak;
#
#    If you perform `fgoto` in an action which does not emit a token nor
#    rewinds the stream pointer, the parser's side-effectful,
#    context-sensitive lookahead actions will break in a hard to detect
#    and debug way.
#
#  * If an action does not emit a token:
#
#       fgoto $next_state;
#
#  * If an action features lookbehind, i.e. matches characters with the
#    intent of passing them to another action:
#
#       p = @ts - 1
#       fgoto $next_state;
#
#    or, if the lookbehind consists of a single character:
#
#       fhold; fgoto $next_state;
#
#  * Ragel merges actions. So, if you have `e_lparen = '(' %act` and
#    `c_lparen = '('` and a lexer action `e_lparen | c_lparen`, the result
#    _will_ invoke the action `act`.
#
#    e_something stands for "something with **e**mbedded action".
#
#  * EOF is explicit and is matched by `c_eof`. If you want to introspect
#    the state of the lexer, add this rule to the state:
#
#       c_eof => do_eof;
#
#  * If you proceed past EOF, the lexer will complain:
#
#       NoMethodError: undefined method `ord' for nil:NilClass
#

class Parser::Lexer

  
# line 85 "lib/parser/lexer.rb"
class << self
	attr_accessor :_lex_trans_keys
	private :_lex_trans_keys, :_lex_trans_keys=
end
self._lex_trans_keys = [
	0, 0, 101, 101, 103, 103, 
	105, 105, 110, 110, 69, 
	69, 78, 78, 68, 68, 
	95, 95, 95, 95, 0, 26, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 45, 
	0, 77, 0, 77, 0, 92, 
	0, 26, 0, 26, 0, 
	45, 0, 99, 0, 26, 
	67, 99, 45, 45, 0, 92, 
	0, 77, 0, 102, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 45, 0, 77, 
	0, 77, 0, 92, 0, 
	26, 0, 26, 0, 45, 
	0, 99, 0, 26, 67, 99, 
	45, 45, 0, 92, 0, 
	77, 0, 102, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 26, 0, 
	127, 58, 58, 58, 58, 
	0, 127, 58, 58, 60, 60, 
	62, 62, 10, 10, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 115, 115, 
	99, 99, 117, 117, 101, 101, 
	108, 116, 101, 101, 115, 
	115, 115, 115, 105, 105, 
	108, 108, 105, 105, 108, 108, 
	58, 58, 0, 127, 10, 
	10, 0, 127, 58, 58, 
	98, 98, 101, 101, 103, 103, 
	105, 105, 110, 110, 0, 
	122, 61, 61, 0, 127, 
	0, 127, 61, 126, 0, 127, 
	0, 127, 93, 93, 0, 
	127, 0, 127, 10, 10, 
	10, 34, 10, 10, 10, 39, 
	0, 127, 10, 96, 0, 
	45, 0, 77, 0, 77, 
	0, 92, 0, 26, 0, 26, 
	0, 45, 0, 99, 0, 
	26, 67, 99, 45, 45, 
	0, 92, 0, 77, 0, 102, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 58, 58, 58, 58, 
	0, 127, 43, 57, 48, 
	57, 48, 57, 48, 57, 
	48, 57, 0, 127, 58, 58, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 9, 92, 
	9, 92, 60, 60, 10, 10, 
	9, 46, 46, 46, 0, 
	95, 9, 32, 0, 0, 
	10, 10, 10, 10, 98, 98, 
	9, 32, 10, 10, 95, 
	95, 0, 92, 9, 32, 
	36, 123, 0, 127, 48, 57, 
	0, 120, 0, 0, 0, 
	0, 48, 55, 48, 55, 
	0, 0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 
	0, 0, 92, 45, 45, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 0, 45, 0, 
	92, 0, 92, 0, 0, 
	0, 0, 0, 92, 0, 45, 
	10, 10, 0, 92, 0, 
	123, 0, 26, 0, 26, 
	0, 26, 0, 0, 0, 102, 
	0, 102, 0, 102, 0, 
	0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 0, 0, 125, 
	0, 26, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 125, 0, 0, 48, 
	102, 0, 0, 0, 92, 
	36, 123, 0, 127, 48, 57, 
	0, 120, 0, 0, 0, 
	0, 48, 55, 48, 55, 
	0, 0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 
	0, 0, 92, 45, 45, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 0, 45, 0, 
	92, 0, 92, 0, 0, 
	0, 0, 0, 92, 0, 45, 
	10, 10, 0, 92, 0, 
	123, 0, 26, 0, 26, 
	0, 26, 0, 0, 0, 102, 
	0, 102, 0, 102, 0, 
	0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 0, 0, 125, 
	0, 26, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 125, 0, 0, 48, 
	102, 0, 0, 0, 92, 
	9, 32, 0, 26, 0, 92, 
	0, 26, 0, 35, 36, 
	123, 0, 127, 48, 57, 
	0, 26, 0, 35, 9, 32, 
	36, 123, 0, 127, 48, 
	57, 0, 32, 9, 32, 
	65, 122, 65, 122, 36, 64, 
	0, 127, 48, 57, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 
	10, 0, 127, 0, 127, 
	48, 57, 115, 115, 38, 38, 
	42, 42, 64, 64, 58, 
	58, 60, 61, 62, 62, 
	61, 126, 61, 61, 61, 62, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 93, 93, 
	10, 10, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 124, 124, 
	0, 127, 0, 127, 9, 32, 
	10, 10, 10, 10, 10, 
	10, 0, 0, 0, 127, 
	0, 127, 61, 61, 0, 0, 
	9, 32, 0, 0, 61, 
	126, 10, 10, 10, 10, 
	38, 38, 42, 42, 64, 64, 
	60, 61, 62, 62, 61, 
	126, 61, 61, 61, 62, 
	0, 127, 93, 93, 10, 10, 
	124, 124, 0, 126, 0, 
	127, 0, 61, 9, 61, 
	9, 61, 0, 0, 9, 61, 
	9, 62, 46, 46, 46, 
	46, 58, 58, 9, 32, 
	0, 0, 0, 127, 0, 0, 
	9, 124, 0, 0, 10, 
	10, 10, 10, 0, 0, 
	9, 61, 58, 58, 60, 60, 
	62, 62, 9, 32, 10, 
	10, 0, 127, 102, 102, 
	101, 101, 110, 110, 104, 104, 
	0, 127, 0, 127, 0, 
	127, 0, 0, 0, 127, 
	10, 10, 0, 123, 9, 32, 
	10, 10, 10, 10, 10, 
	10, 0, 0, 111, 111, 
	0, 0, 0, 127, 0, 127, 
	9, 32, 0, 0, 10, 
	10, 10, 10, 10, 10, 
	0, 0, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	58, 61, 0, 0, 61, 
	126, 61, 61, 0, 0, 
	0, 0, 0, 0, 9, 32, 
	61, 61, 9, 32, 61, 
	126, 10, 10, 10, 10, 
	65, 122, 0, 122, 38, 61, 
	0, 0, 42, 61, 61, 
	61, 48, 61, 48, 62, 
	46, 46, 46, 46, 0, 26, 
	0, 127, 0, 127, 61, 
	61, 0, 0, 61, 126, 
	61, 62, 0, 0, 0, 0, 
	0, 0, 0, 0, 61, 
	126, 0, 127, 48, 57, 
	38, 38, 42, 42, 64, 64, 
	60, 61, 62, 62, 61, 
	61, 61, 62, 124, 124, 
	60, 61, 0, 0, 62, 62, 
	61, 126, 61, 62, 0, 
	122, 0, 0, 0, 127, 
	0, 127, 0, 120, 0, 0, 
	0, 0, 48, 55, 48, 
	55, 0, 0, 0, 0, 
	0, 92, 0, 0, 0, 0, 
	0, 0, 0, 92, 45, 
	45, 0, 0, 0, 0, 
	0, 0, 0, 92, 0, 45, 
	0, 92, 0, 92, 0, 
	0, 0, 0, 0, 92, 
	0, 45, 10, 10, 0, 92, 
	0, 123, 0, 26, 0, 
	26, 0, 26, 0, 0, 
	0, 102, 0, 102, 0, 102, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 26, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	0, 0, 0, 48, 102, 
	0, 0, 0, 127, 0, 127, 
	0, 127, 0, 0, 10, 
	10, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	61, 126, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	0, 61, 124, 0, 92, 
	9, 32, 0, 0, 10, 10, 
	10, 10, 10, 10, 0, 
	0, 0, 127, 0, 127, 
	9, 32, 0, 0, 10, 10, 
	10, 10, 10, 10, 0, 
	0, 0, 127, 0, 127, 
	61, 61, 0, 0, 9, 32, 
	0, 0, 61, 126, 10, 
	10, 10, 10, 0, 127, 
	0, 127, 48, 57, 61, 61, 
	38, 61, 0, 0, 0, 
	0, 42, 61, 61, 62, 
	46, 57, 46, 46, 48, 101, 
	48, 95, 46, 120, 48, 
	114, 43, 57, 48, 105, 
	0, 0, 105, 105, 0, 0, 
	48, 114, 48, 114, 48, 
	114, 48, 114, 105, 114, 
	0, 0, 105, 105, 0, 0, 
	48, 114, 48, 114, 48, 
	114, 48, 114, 48, 114, 
	48, 114, 48, 114, 48, 114, 
	46, 114, 48, 114, 46, 
	114, 48, 114, 58, 58, 
	60, 61, 62, 62, 61, 126, 
	61, 61, 61, 62, 0, 
	127, 0, 127, 0, 0, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 0, 10, 10, 
	0, 0, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 9, 92, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 0, 61, 124, 0, 0, 
	9, 46, 9, 46, 46, 
	46, 10, 61, 10, 10, 
	10, 101, 10, 110, 10, 100, 
	10, 10, 0
]

class << self
	attr_accessor :_lex_key_spans
	private :_lex_key_spans, :_lex_key_spans=
end
self._lex_key_spans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 27, 128, 128, 128, 128, 46, 
	78, 78, 93, 27, 27, 46, 100, 27, 
	33, 1, 93, 78, 103, 128, 128, 128, 
	128, 46, 78, 78, 93, 27, 27, 46, 
	100, 27, 33, 1, 93, 78, 103, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 27, 128, 1, 1, 
	128, 1, 1, 1, 1, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 1, 
	1, 1, 1, 9, 1, 1, 1, 1, 
	1, 1, 1, 1, 128, 1, 128, 1, 
	1, 1, 1, 1, 1, 123, 1, 128, 
	128, 66, 128, 128, 1, 128, 128, 1, 
	25, 1, 30, 128, 87, 46, 78, 78, 
	93, 27, 27, 46, 100, 27, 33, 1, 
	93, 78, 103, 128, 128, 128, 128, 128, 
	128, 1, 1, 128, 15, 10, 10, 10, 
	10, 128, 1, 84, 84, 84, 84, 84, 
	84, 1, 1, 38, 1, 96, 24, 0, 
	1, 1, 1, 24, 1, 1, 93, 24, 
	88, 128, 10, 121, 0, 0, 8, 8, 
	0, 0, 93, 0, 0, 0, 93, 1, 
	0, 0, 0, 93, 46, 93, 93, 0, 
	0, 93, 46, 1, 93, 124, 27, 27, 
	27, 0, 103, 103, 103, 0, 126, 126, 
	126, 126, 126, 0, 126, 126, 0, 126, 
	27, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 0, 126, 0, 55, 0, 93, 
	88, 128, 10, 121, 0, 0, 8, 8, 
	0, 0, 93, 0, 0, 0, 93, 1, 
	0, 0, 0, 93, 46, 93, 93, 0, 
	0, 93, 46, 1, 93, 124, 27, 27, 
	27, 0, 103, 103, 103, 0, 126, 126, 
	126, 126, 126, 0, 126, 126, 0, 126, 
	27, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 0, 126, 0, 55, 0, 93, 
	24, 27, 93, 27, 36, 88, 128, 10, 
	27, 36, 24, 88, 128, 10, 33, 24, 
	58, 58, 29, 128, 10, 128, 128, 128, 
	128, 24, 0, 66, 1, 1, 128, 128, 
	10, 1, 1, 1, 1, 1, 2, 1, 
	66, 1, 2, 128, 128, 128, 128, 128, 
	128, 128, 1, 1, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 1, 
	128, 128, 24, 1, 1, 1, 0, 128, 
	128, 1, 0, 24, 0, 66, 1, 1, 
	1, 1, 1, 2, 1, 66, 1, 2, 
	128, 1, 1, 1, 127, 128, 62, 53, 
	53, 0, 53, 54, 1, 1, 1, 24, 
	0, 128, 0, 116, 0, 1, 1, 0, 
	53, 1, 1, 1, 24, 1, 128, 1, 
	1, 1, 1, 128, 128, 128, 0, 128, 
	1, 124, 24, 1, 1, 1, 0, 1, 
	0, 128, 128, 24, 0, 1, 1, 1, 
	0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 4, 0, 66, 1, 0, 
	0, 0, 24, 1, 24, 66, 1, 1, 
	58, 123, 24, 0, 20, 1, 14, 15, 
	1, 1, 27, 128, 128, 1, 0, 66, 
	2, 0, 0, 0, 0, 66, 128, 10, 
	1, 1, 1, 2, 1, 1, 2, 1, 
	2, 0, 1, 66, 2, 123, 0, 128, 
	128, 121, 0, 0, 8, 8, 0, 0, 
	93, 0, 0, 0, 93, 1, 0, 0, 
	0, 93, 46, 93, 93, 0, 0, 93, 
	46, 1, 93, 124, 27, 27, 27, 0, 
	103, 103, 103, 0, 126, 126, 126, 126, 
	126, 0, 126, 126, 0, 126, 27, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 0, 0, 55, 
	0, 128, 128, 128, 0, 1, 0, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 66, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 0, 64, 93, 
	24, 0, 1, 1, 1, 0, 128, 128, 
	24, 0, 1, 1, 1, 0, 128, 128, 
	1, 0, 24, 0, 66, 1, 1, 128, 
	128, 10, 1, 24, 0, 0, 20, 2, 
	12, 1, 54, 48, 75, 67, 15, 58, 
	0, 1, 0, 67, 67, 67, 67, 10, 
	0, 1, 0, 67, 67, 67, 67, 67, 
	67, 67, 67, 69, 67, 69, 67, 1, 
	2, 1, 66, 1, 2, 128, 128, 0, 
	128, 128, 128, 128, 128, 128, 0, 1, 
	0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 84, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	0, 64, 0, 38, 38, 1, 52, 1, 
	92, 101, 91, 1
]

class << self
	attr_accessor :_lex_index_offsets
	private :_lex_index_offsets, :_lex_index_offsets=
end
self._lex_index_offsets = [
	0, 0, 2, 4, 6, 8, 10, 12, 
	14, 16, 18, 46, 175, 304, 433, 562, 
	609, 688, 767, 861, 889, 917, 964, 1065, 
	1093, 1127, 1129, 1223, 1302, 1406, 1535, 1664, 
	1793, 1922, 1969, 2048, 2127, 2221, 2249, 2277, 
	2324, 2425, 2453, 2487, 2489, 2583, 2662, 2766, 
	2895, 3024, 3153, 3282, 3411, 3540, 3669, 3798, 
	3927, 4056, 4185, 4314, 4443, 4471, 4600, 4602, 
	4604, 4733, 4735, 4737, 4739, 4741, 4870, 4999, 
	5128, 5257, 5386, 5515, 5644, 5773, 5902, 6031, 
	6160, 6289, 6418, 6547, 6676, 6805, 6934, 7063, 
	7065, 7067, 7069, 7071, 7081, 7083, 7085, 7087, 
	7089, 7091, 7093, 7095, 7097, 7226, 7228, 7357, 
	7359, 7361, 7363, 7365, 7367, 7369, 7493, 7495, 
	7624, 7753, 7820, 7949, 8078, 8080, 8209, 8338, 
	8340, 8366, 8368, 8399, 8528, 8616, 8663, 8742, 
	8821, 8915, 8943, 8971, 9018, 9119, 9147, 9181, 
	9183, 9277, 9356, 9460, 9589, 9718, 9847, 9976, 
	10105, 10234, 10236, 10238, 10367, 10383, 10394, 10405, 
	10416, 10427, 10556, 10558, 10643, 10728, 10813, 10898, 
	10983, 11068, 11070, 11072, 11111, 11113, 11210, 11235, 
	11236, 11238, 11240, 11242, 11267, 11269, 11271, 11365, 
	11390, 11479, 11608, 11619, 11741, 11742, 11743, 11752, 
	11761, 11762, 11763, 11857, 11858, 11859, 11860, 11954, 
	11956, 11957, 11958, 11959, 12053, 12100, 12194, 12288, 
	12289, 12290, 12384, 12431, 12433, 12527, 12652, 12680, 
	12708, 12736, 12737, 12841, 12945, 13049, 13050, 13177, 
	13304, 13431, 13558, 13685, 13686, 13813, 13940, 13941, 
	14068, 14096, 14223, 14350, 14477, 14604, 14731, 14858, 
	14985, 15112, 15239, 15240, 15367, 15368, 15424, 15425, 
	15519, 15608, 15737, 15748, 15870, 15871, 15872, 15881, 
	15890, 15891, 15892, 15986, 15987, 15988, 15989, 16083, 
	16085, 16086, 16087, 16088, 16182, 16229, 16323, 16417, 
	16418, 16419, 16513, 16560, 16562, 16656, 16781, 16809, 
	16837, 16865, 16866, 16970, 17074, 17178, 17179, 17306, 
	17433, 17560, 17687, 17814, 17815, 17942, 18069, 18070, 
	18197, 18225, 18352, 18479, 18606, 18733, 18860, 18987, 
	19114, 19241, 19368, 19369, 19496, 19497, 19553, 19554, 
	19648, 19673, 19701, 19795, 19823, 19860, 19949, 20078, 
	20089, 20117, 20154, 20179, 20268, 20397, 20408, 20442, 
	20467, 20526, 20585, 20615, 20744, 20755, 20884, 21013, 
	21142, 21271, 21296, 21297, 21364, 21366, 21368, 21497, 
	21626, 21637, 21639, 21641, 21643, 21645, 21647, 21650, 
	21652, 21719, 21721, 21724, 21853, 21982, 22111, 22240, 
	22369, 22498, 22627, 22629, 22631, 22760, 22889, 23018, 
	23147, 23276, 23405, 23534, 23663, 23792, 23921, 24050, 
	24179, 24308, 24437, 24566, 24695, 24824, 24953, 25082, 
	25211, 25340, 25469, 25598, 25727, 25856, 25985, 26114, 
	26243, 26372, 26501, 26630, 26759, 26888, 27017, 27146, 
	27275, 27404, 27533, 27662, 27791, 27920, 28049, 28178, 
	28307, 28436, 28565, 28694, 28823, 28952, 29081, 29210, 
	29339, 29468, 29597, 29726, 29855, 29984, 30113, 30242, 
	30371, 30500, 30629, 30758, 30887, 31016, 31145, 31274, 
	31403, 31532, 31661, 31790, 31919, 32048, 32177, 32306, 
	32435, 32564, 32693, 32822, 32951, 33080, 33209, 33338, 
	33340, 33469, 33598, 33623, 33625, 33627, 33629, 33630, 
	33759, 33888, 33890, 33891, 33916, 33917, 33984, 33986, 
	33988, 33990, 33992, 33994, 33997, 33999, 34066, 34068, 
	34071, 34200, 34202, 34204, 34206, 34334, 34463, 34526, 
	34580, 34634, 34635, 34689, 34744, 34746, 34748, 34750, 
	34775, 34776, 34905, 34906, 35023, 35024, 35026, 35028, 
	35029, 35083, 35085, 35087, 35089, 35114, 35116, 35245, 
	35247, 35249, 35251, 35253, 35382, 35511, 35640, 35641, 
	35770, 35772, 35897, 35922, 35924, 35926, 35928, 35929, 
	35931, 35932, 36061, 36190, 36215, 36216, 36218, 36220, 
	36222, 36223, 36352, 36481, 36610, 36739, 36868, 36997, 
	37126, 37255, 37384, 37513, 37642, 37771, 37900, 38029, 
	38158, 38287, 38416, 38545, 38550, 38551, 38618, 38620, 
	38621, 38622, 38623, 38648, 38650, 38675, 38742, 38744, 
	38746, 38805, 38929, 38954, 38955, 38976, 38978, 38993, 
	39009, 39011, 39013, 39041, 39170, 39299, 39301, 39302, 
	39369, 39372, 39373, 39374, 39375, 39376, 39443, 39572, 
	39583, 39585, 39587, 39589, 39592, 39594, 39596, 39599, 
	39601, 39604, 39605, 39607, 39674, 39677, 39801, 39802, 
	39931, 40060, 40182, 40183, 40184, 40193, 40202, 40203, 
	40204, 40298, 40299, 40300, 40301, 40395, 40397, 40398, 
	40399, 40400, 40494, 40541, 40635, 40729, 40730, 40731, 
	40825, 40872, 40874, 40968, 41093, 41121, 41149, 41177, 
	41178, 41282, 41386, 41490, 41491, 41618, 41745, 41872, 
	41999, 42126, 42127, 42254, 42381, 42382, 42509, 42537, 
	42664, 42791, 42918, 43045, 43172, 43299, 43426, 43553, 
	43680, 43807, 43934, 44061, 44188, 44315, 44316, 44317, 
	44373, 44374, 44503, 44632, 44761, 44762, 44764, 44765, 
	44894, 45023, 45152, 45281, 45410, 45539, 45668, 45797, 
	45926, 46055, 46184, 46313, 46442, 46571, 46700, 46829, 
	46958, 47087, 47216, 47345, 47474, 47603, 47732, 47861, 
	47990, 48119, 48248, 48377, 48506, 48635, 48764, 48893, 
	49022, 49151, 49280, 49409, 49538, 49667, 49796, 49925, 
	50054, 50183, 50312, 50441, 50570, 50699, 50828, 50957, 
	51086, 51215, 51344, 51473, 51602, 51731, 51860, 51989, 
	52118, 52247, 52376, 52505, 52572, 52701, 52830, 52959, 
	53088, 53217, 53346, 53475, 53604, 53733, 53862, 53991, 
	54120, 54249, 54378, 54507, 54636, 54765, 54894, 55023, 
	55152, 55281, 55410, 55539, 55668, 55797, 55798, 55863, 
	55957, 55982, 55983, 55985, 55987, 55989, 55990, 56119, 
	56248, 56273, 56274, 56276, 56278, 56280, 56281, 56410, 
	56539, 56541, 56542, 56567, 56568, 56635, 56637, 56639, 
	56768, 56897, 56908, 56910, 56935, 56936, 56937, 56958, 
	56961, 56974, 56976, 57031, 57080, 57156, 57224, 57240, 
	57299, 57300, 57302, 57303, 57371, 57439, 57507, 57575, 
	57586, 57587, 57589, 57590, 57658, 57726, 57794, 57862, 
	57930, 57998, 58066, 58134, 58204, 58272, 58342, 58410, 
	58412, 58415, 58417, 58484, 58486, 58489, 58618, 58747, 
	58748, 58877, 59006, 59135, 59264, 59393, 59522, 59523, 
	59525, 59526, 59655, 59784, 59913, 60042, 60171, 60300, 
	60429, 60558, 60687, 60816, 60945, 61074, 61203, 61332, 
	61461, 61590, 61719, 61848, 61977, 62106, 62235, 62364, 
	62493, 62622, 62751, 62880, 63009, 63138, 63267, 63396, 
	63525, 63654, 63783, 63912, 64041, 64170, 64299, 64384, 
	64513, 64642, 64771, 64900, 65029, 65158, 65287, 65416, 
	65545, 65674, 65803, 65932, 66061, 66190, 66319, 66448, 
	66577, 66706, 66835, 66964, 67093, 67222, 67351, 67480, 
	67609, 67738, 67867, 67996, 68125, 68254, 68383, 68512, 
	68641, 68770, 68899, 69028, 69157, 69286, 69415, 69544, 
	69673, 69802, 69931, 70060, 70189, 70318, 70447, 70576, 
	70705, 70834, 70963, 71092, 71221, 71350, 71479, 71608, 
	71737, 71866, 71995, 72124, 72253, 72382, 72511, 72640, 
	72769, 72770, 72835, 72836, 72875, 72914, 72916, 72969, 
	72971, 73064, 73166, 73258
]

class << self
	attr_accessor :_lex_indicies
	private :_lex_indicies, :_lex_indicies=
end
self._lex_indicies = [
	1, 0, 2, 0, 3, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 10, 0, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 12, 14, 12, 14, 14, 12, 12, 
	14, 14, 14, 15, 14, 14, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	14, 14, 14, 14, 14, 14, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 14, 12, 12, 13, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 12, 12, 14, 12, 13, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 12, 12, 12, 12, 12, 12, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 14, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 12, 14, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 12, 12, 12, 12, 12, 12, 
	17, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 13, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	13, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	12, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	13, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	12, 13, 18, 19, 19, 19, 18, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 18, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 20, 
	19, 18, 21, 21, 21, 18, 21, 21, 
	21, 21, 21, 22, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 18, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 23, 21, 
	18, 21, 21, 21, 18, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 18, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 24, 21, 18, 
	25, 25, 25, 18, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 18, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 26, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 27, 25, 18, 28, 28, 
	28, 18, 28, 28, 28, 28, 28, 29, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 18, 
	28, 18, 28, 28, 28, 18, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 18, 28, 18, 19, 19, 
	19, 18, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 18, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 30, 19, 18, 31, 31, 31, 
	18, 31, 31, 31, 31, 31, 32, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 18, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 33, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	34, 31, 31, 31, 31, 31, 31, 35, 
	31, 18, 31, 31, 31, 18, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 18, 31, 36, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 37, 18, 37, 
	18, 18, 38, 38, 38, 18, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 18, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	39, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 40, 38, 18, 
	21, 21, 21, 18, 21, 21, 21, 21, 
	21, 22, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 18, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 24, 21, 18, 41, 
	41, 41, 18, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	18, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	41, 41, 41, 41, 41, 41, 41, 42, 
	42, 42, 42, 42, 42, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 42, 
	42, 42, 42, 42, 42, 41, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 45, 
	45, 43, 45, 43, 45, 45, 43, 43, 
	45, 45, 45, 46, 45, 45, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	45, 45, 45, 45, 45, 45, 45, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 43, 45, 43, 43, 44, 45, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 43, 43, 43, 45, 43, 44, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 43, 43, 43, 43, 43, 43, 43, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 43, 43, 43, 43, 45, 43, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 43, 43, 43, 43, 43, 45, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 43, 43, 43, 43, 43, 43, 
	48, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 44, 
	43, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 43, 
	44, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 43, 
	43, 43, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 43, 43, 43, 43, 
	44, 43, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 43, 43, 43, 43, 
	43, 44, 49, 50, 50, 50, 49, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 49, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 51, 
	50, 49, 52, 52, 52, 49, 52, 52, 
	52, 52, 52, 53, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 49, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 54, 52, 
	49, 52, 52, 52, 49, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 49, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 55, 52, 49, 
	56, 56, 56, 49, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 49, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 57, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 58, 56, 49, 59, 59, 
	59, 49, 59, 59, 59, 59, 59, 60, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 49, 
	59, 49, 59, 59, 59, 49, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 49, 59, 49, 50, 50, 
	50, 49, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 49, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 61, 50, 49, 62, 62, 62, 
	49, 62, 62, 62, 62, 62, 63, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 49, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 64, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	65, 62, 62, 62, 62, 62, 62, 66, 
	62, 49, 62, 62, 62, 49, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 49, 62, 67, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 68, 49, 68, 
	49, 49, 69, 69, 69, 49, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 49, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	70, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 71, 69, 49, 
	52, 52, 52, 49, 52, 52, 52, 52, 
	52, 53, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 49, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 55, 52, 49, 72, 
	72, 72, 49, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	49, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	72, 72, 72, 72, 72, 72, 72, 73, 
	73, 73, 73, 73, 73, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 73, 
	73, 73, 73, 73, 73, 72, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 76, 
	76, 74, 76, 74, 76, 76, 74, 74, 
	76, 76, 76, 77, 76, 76, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	76, 76, 76, 76, 76, 76, 76, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 74, 76, 74, 74, 75, 76, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 74, 74, 74, 76, 74, 75, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 74, 74, 74, 74, 74, 74, 74, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 74, 74, 74, 74, 76, 74, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 74, 74, 74, 74, 74, 76, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 74, 74, 74, 74, 74, 74, 
	79, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 75, 
	74, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 74, 
	75, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 74, 
	74, 74, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 74, 74, 74, 74, 
	75, 74, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 74, 74, 74, 74, 
	74, 75, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 82, 82, 80, 82, 80, 
	82, 82, 80, 80, 82, 82, 82, 83, 
	82, 82, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 82, 82, 82, 82, 
	82, 82, 82, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 80, 82, 80, 
	80, 81, 82, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 80, 80, 80, 
	82, 80, 81, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 80, 80, 80, 
	80, 80, 80, 80, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 80, 80, 
	80, 80, 82, 80, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 80, 80, 
	80, 80, 80, 82, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 80, 80, 
	80, 80, 80, 80, 85, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 81, 80, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 80, 81, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 80, 80, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 81, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 80, 81, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 87, 
	87, 88, 87, 88, 87, 87, 88, 88, 
	87, 87, 87, 89, 87, 87, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	87, 87, 87, 87, 87, 87, 87, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 88, 87, 88, 88, 86, 87, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 88, 88, 88, 87, 88, 86, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 88, 88, 88, 88, 88, 88, 88, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 88, 88, 88, 88, 87, 88, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 88, 88, 88, 88, 88, 87, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 88, 88, 88, 88, 88, 88, 
	92, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 88, 88, 88, 88, 91, 
	88, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 88, 88, 88, 88, 88, 
	91, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 88, 88, 88, 88, 88, 
	88, 88, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 88, 88, 88, 88, 
	93, 88, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 88, 88, 88, 88, 
	88, 93, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 94, 94, 94, 94, 
	94, 94, 94, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 94, 94, 94, 
	94, 95, 94, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 94, 94, 94, 
	94, 94, 95, 96, 97, 97, 97, 96, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 96, 97, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	100, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 101, 98, 98, 98, 98, 100, 98, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 98, 98, 98, 98, 99, 98, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 98, 98, 98, 98, 98, 99, 
	101, 98, 98, 102, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 105, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 103, 
	103, 103, 103, 105, 103, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 103, 
	103, 103, 103, 104, 103, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 103, 
	103, 103, 103, 103, 104, 106, 103, 108, 
	107, 109, 107, 110, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 112, 107, 
	112, 112, 112, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 112, 107, 107, 
	107, 107, 113, 114, 107, 115, 107, 116, 
	117, 118, 119, 120, 113, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 121, 
	107, 122, 118, 123, 124, 107, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	125, 126, 118, 127, 111, 107, 111, 111, 
	111, 111, 111, 111, 111, 111, 128, 111, 
	111, 111, 111, 111, 111, 111, 111, 129, 
	111, 111, 130, 111, 131, 111, 111, 111, 
	132, 133, 107, 127, 107, 111, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 134, 
	107, 134, 134, 134, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 134, 107, 
	107, 107, 107, 135, 136, 107, 137, 107, 
	138, 139, 140, 141, 142, 135, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	143, 107, 144, 140, 145, 146, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 147, 148, 140, 109, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 149, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	150, 104, 104, 151, 104, 152, 104, 104, 
	104, 153, 154, 107, 109, 107, 104, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	105, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 106, 107, 107, 107, 107, 105, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 104, 107, 
	104, 104, 104, 104, 104, 155, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 107, 104, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 105, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 106, 107, 107, 107, 107, 105, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 104, 
	107, 104, 104, 104, 104, 156, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 107, 
	104, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 106, 107, 107, 107, 107, 
	105, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	104, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 157, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	107, 104, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 105, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 106, 107, 107, 107, 
	107, 105, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 104, 107, 104, 104, 158, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 107, 104, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 105, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 106, 107, 107, 
	107, 107, 105, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 104, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	159, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 107, 104, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 105, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 107, 
	107, 107, 107, 105, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 104, 107, 104, 104, 104, 
	104, 155, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 107, 104, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 105, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 106, 
	107, 107, 107, 107, 105, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 104, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 160, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 107, 104, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 105, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	106, 107, 107, 107, 107, 105, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 161, 104, 104, 104, 104, 104, 
	104, 104, 162, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 107, 104, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	105, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 106, 107, 107, 107, 107, 105, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 104, 107, 
	104, 104, 104, 104, 163, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 107, 104, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 105, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 106, 107, 107, 107, 107, 105, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 104, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 164, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 107, 
	104, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 106, 107, 107, 107, 107, 
	105, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	104, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 155, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	107, 104, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 105, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 106, 107, 107, 107, 
	107, 105, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 104, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 165, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 107, 104, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 105, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 106, 107, 107, 
	107, 107, 105, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 104, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 155, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 107, 104, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 105, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 107, 
	107, 107, 107, 105, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 104, 107, 104, 104, 104, 
	104, 104, 104, 104, 166, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 107, 104, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 105, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 106, 
	107, 107, 107, 107, 105, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 104, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 167, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 107, 104, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 105, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	106, 107, 107, 107, 107, 105, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 159, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 107, 104, 169, 
	168, 170, 168, 171, 168, 140, 168, 172, 
	168, 168, 168, 168, 168, 168, 168, 173, 
	168, 174, 168, 175, 168, 140, 168, 176, 
	168, 140, 168, 177, 168, 171, 168, 179, 
	178, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 182, 180, 182, 182, 182, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 182, 180, 180, 180, 180, 180, 180, 
	180, 183, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 180, 184, 180, 180, 
	181, 180, 181, 181, 181, 185, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 180, 180, 180, 180, 
	180, 181, 186, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 188, 180, 188, 
	188, 188, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 188, 180, 180, 180, 
	180, 180, 180, 180, 189, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 180, 
	190, 180, 180, 187, 180, 187, 187, 187, 
	191, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 180, 
	180, 180, 180, 180, 187, 192, 193, 195, 
	194, 196, 194, 197, 194, 198, 194, 199, 
	194, 200, 201, 201, 201, 200, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 200, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 201, 201, 201, 201, 
	201, 201, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 201, 203, 192, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	206, 206, 204, 206, 204, 206, 206, 204, 
	204, 206, 206, 206, 207, 206, 206, 208, 
	208, 208, 208, 208, 208, 208, 208, 208, 
	208, 206, 206, 206, 206, 206, 206, 206, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 204, 206, 204, 204, 205, 206, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 204, 204, 204, 206, 204, 205, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	206, 206, 206, 206, 206, 206, 206, 206, 
	206, 206, 204, 204, 204, 204, 204, 204, 
	204, 206, 206, 206, 206, 206, 206, 206, 
	206, 206, 206, 206, 206, 206, 206, 206, 
	206, 206, 206, 206, 206, 206, 206, 206, 
	206, 206, 206, 204, 204, 204, 204, 206, 
	204, 206, 206, 206, 206, 206, 206, 206, 
	206, 206, 206, 206, 206, 206, 206, 206, 
	206, 206, 206, 206, 206, 206, 206, 206, 
	206, 206, 206, 204, 204, 204, 204, 204, 
	206, 209, 206, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 206, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 210, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 204, 
	204, 204, 204, 205, 204, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 204, 
	204, 204, 204, 204, 205, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	204, 204, 204, 204, 205, 204, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	204, 204, 204, 204, 204, 205, 209, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 212, 204, 204, 204, 204, 213, 
	204, 204, 204, 204, 204, 214, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 203, 204, 204, 
	204, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 204, 204, 204, 204, 211, 
	215, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 204, 204, 204, 214, 204, 
	211, 217, 217, 217, 217, 217, 217, 217, 
	217, 217, 217, 218, 217, 217, 217, 217, 
	217, 217, 217, 217, 217, 217, 217, 217, 
	217, 217, 217, 217, 217, 217, 217, 217, 
	217, 217, 217, 217, 217, 217, 217, 217, 
	217, 217, 217, 217, 217, 217, 217, 217, 
	217, 216, 216, 216, 216, 216, 216, 216, 
	216, 216, 216, 217, 217, 217, 217, 217, 
	217, 217, 216, 216, 216, 216, 216, 216, 
	216, 216, 216, 216, 216, 216, 216, 216, 
	216, 216, 216, 216, 216, 216, 216, 216, 
	216, 216, 216, 216, 217, 217, 217, 217, 
	216, 217, 216, 216, 216, 216, 216, 216, 
	216, 216, 216, 216, 216, 216, 216, 216, 
	216, 216, 216, 216, 216, 216, 216, 216, 
	216, 216, 216, 216, 217, 217, 217, 217, 
	217, 216, 220, 219, 204, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 221, 212, 218, 217, 
	204, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 221, 213, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 212, 204, 204, 204, 204, 213, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 204, 204, 204, 204, 211, 215, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 204, 204, 204, 204, 204, 211, 
	204, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 215, 215, 
	215, 215, 215, 215, 215, 215, 221, 215, 
	222, 223, 223, 223, 222, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 222, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 224, 223, 222, 
	225, 225, 225, 222, 225, 225, 225, 225, 
	225, 226, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 222, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 227, 225, 222, 225, 
	225, 225, 222, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	222, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 228, 225, 222, 229, 229, 
	229, 222, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 222, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 230, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 231, 229, 222, 232, 232, 232, 222, 
	232, 232, 232, 232, 232, 233, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 222, 232, 222, 
	232, 232, 232, 222, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 222, 232, 222, 223, 223, 223, 222, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 222, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	234, 223, 222, 235, 235, 235, 222, 235, 
	235, 235, 235, 235, 236, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 222, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 237, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 238, 235, 
	235, 235, 235, 235, 235, 239, 235, 222, 
	235, 235, 235, 222, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 222, 235, 240, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 222, 222, 222, 222, 222, 
	222, 222, 222, 241, 222, 241, 222, 222, 
	242, 242, 242, 222, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 222, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 243, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 244, 242, 222, 225, 225, 
	225, 222, 225, 225, 225, 225, 225, 226, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 222, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 228, 225, 222, 245, 245, 245, 
	222, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 222, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 245, 245, 
	245, 245, 245, 245, 245, 246, 246, 246, 
	246, 246, 246, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 246, 246, 246, 
	246, 246, 246, 245, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 248, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 249, 192, 
	192, 250, 192, 248, 192, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 192, 
	192, 192, 192, 247, 192, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 192, 
	192, 192, 192, 192, 247, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 248, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 249, 
	204, 204, 250, 204, 248, 204, 247, 247, 
	247, 247, 247, 247, 251, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	204, 204, 204, 204, 247, 204, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	204, 204, 204, 204, 204, 247, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 248, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	249, 204, 204, 250, 204, 248, 204, 247, 
	247, 247, 247, 247, 247, 247, 247, 252, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 204, 204, 204, 204, 247, 204, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 204, 204, 204, 204, 204, 247, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	248, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 249, 204, 204, 250, 204, 248, 204, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 253, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 204, 204, 204, 204, 247, 204, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 204, 204, 204, 204, 204, 247, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	204, 248, 204, 204, 204, 204, 204, 204, 
	204, 204, 204, 204, 204, 204, 204, 204, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 249, 204, 204, 250, 204, 248, 
	204, 247, 247, 247, 253, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 204, 204, 204, 204, 247, 
	204, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 204, 204, 204, 204, 204, 
	247, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 256, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 257, 254, 254, 254, 254, 
	256, 254, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 254, 254, 254, 254, 
	255, 254, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 254, 254, 254, 254, 
	254, 255, 257, 254, 254, 258, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	259, 259, 259, 259, 259, 259, 259, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 259, 259, 259, 259, 260, 259, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 260, 260, 260, 260, 260, 260, 260, 
	260, 259, 259, 259, 259, 259, 260, 262, 
	261, 262, 261, 261, 263, 263, 263, 263, 
	263, 263, 263, 263, 263, 263, 261, 263, 
	263, 263, 263, 263, 263, 263, 263, 263, 
	263, 261, 264, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 261, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 266, 265, 
	267, 267, 267, 267, 267, 267, 267, 267, 
	267, 267, 265, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 259, 259, 259, 259, 259, 
	259, 259, 259, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 259, 259, 259, 
	259, 259, 259, 259, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 259, 259, 
	259, 259, 268, 259, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 259, 259, 
	259, 259, 259, 268, 269, 265, 270, 271, 
	270, 270, 270, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 270, 265, 265, 
	272, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 273, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 274, 265, 275, 276, 275, 275, 275, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 275, 265, 265, 277, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 278, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 279, 265, 
	281, 282, 281, 281, 281, 280, 280, 280, 
	280, 280, 280, 280, 280, 280, 280, 280, 
	280, 280, 280, 280, 280, 280, 280, 281, 
	280, 280, 283, 280, 280, 280, 280, 280, 
	280, 280, 280, 280, 280, 280, 280, 280, 
	280, 280, 280, 280, 280, 280, 280, 280, 
	280, 280, 280, 284, 280, 280, 280, 280, 
	280, 280, 280, 280, 280, 280, 280, 280, 
	280, 280, 280, 280, 280, 280, 280, 280, 
	280, 280, 280, 280, 280, 280, 280, 280, 
	280, 280, 280, 285, 280, 287, 288, 287, 
	287, 287, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 287, 286, 286, 289, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	290, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	291, 286, 287, 288, 287, 287, 287, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 287, 286, 286, 289, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 292, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 291, 286, 287, 
	293, 287, 287, 287, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 287, 286, 
	286, 289, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 290, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 291, 286, 294, 265, 271, 265, 
	296, 295, 296, 296, 296, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 296, 
	295, 295, 295, 295, 295, 297, 295, 295, 
	295, 295, 295, 295, 295, 298, 295, 299, 
	295, 301, 300, 300, 300, 301, 300, 300, 
	300, 300, 302, 303, 302, 302, 302, 300, 
	300, 300, 300, 300, 300, 300, 300, 300, 
	300, 300, 300, 301, 300, 300, 300, 300, 
	300, 302, 300, 300, 304, 300, 300, 300, 
	300, 300, 300, 300, 300, 300, 300, 300, 
	300, 300, 300, 300, 300, 300, 300, 300, 
	300, 300, 300, 300, 300, 300, 305, 300, 
	300, 300, 300, 300, 300, 300, 300, 300, 
	300, 300, 300, 300, 300, 300, 300, 300, 
	300, 300, 300, 300, 300, 300, 300, 300, 
	300, 300, 300, 300, 300, 306, 300, 300, 
	307, 300, 302, 308, 302, 302, 302, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 302, 308, 309, 310, 311, 312, 313, 
	315, 314, 317, 318, 317, 317, 317, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 316, 316, 316, 316, 316, 316, 316, 
	316, 317, 316, 303, 314, 319, 314, 321, 
	320, 320, 320, 321, 320, 320, 320, 320, 
	322, 323, 322, 322, 322, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 321, 320, 320, 320, 320, 320, 322, 
	320, 320, 324, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 320, 320, 320, 320, 320, 
	320, 320, 320, 325, 320, 322, 326, 322, 
	322, 322, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 326, 326, 326, 326, 
	326, 326, 326, 326, 322, 326, 328, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 329, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 327, 327, 327, 
	327, 327, 327, 327, 327, 330, 327, 331, 
	331, 331, 331, 331, 331, 331, 331, 331, 
	331, 331, 331, 331, 331, 331, 331, 331, 
	331, 331, 331, 331, 331, 331, 331, 331, 
	331, 331, 331, 331, 331, 331, 331, 331, 
	331, 331, 331, 331, 331, 331, 331, 331, 
	331, 331, 331, 331, 331, 331, 331, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 331, 331, 331, 331, 331, 331, 331, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 331, 331, 331, 331, 13, 331, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 331, 331, 331, 331, 331, 13, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 16, 331, 334, 333, 333, 333, 334, 
	333, 333, 333, 333, 333, 333, 333, 333, 
	333, 333, 333, 333, 333, 333, 333, 333, 
	333, 333, 333, 333, 333, 334, 333, 333, 
	333, 333, 333, 333, 333, 333, 333, 333, 
	333, 333, 333, 333, 333, 333, 333, 333, 
	333, 333, 333, 335, 335, 335, 335, 335, 
	335, 335, 335, 333, 333, 333, 333, 333, 
	333, 333, 333, 333, 333, 333, 336, 333, 
	333, 333, 333, 333, 333, 333, 333, 333, 
	337, 333, 333, 333, 333, 333, 333, 333, 
	333, 333, 333, 333, 333, 333, 333, 333, 
	333, 333, 333, 333, 333, 333, 338, 333, 
	333, 333, 333, 333, 333, 333, 333, 333, 
	333, 333, 333, 333, 333, 333, 333, 333, 
	339, 333, 333, 340, 333, 341, 342, 344, 
	344, 344, 344, 344, 344, 344, 344, 343, 
	345, 345, 345, 345, 345, 345, 345, 345, 
	343, 343, 346, 346, 38, 38, 38, 346, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 346, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 39, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 347, 
	38, 348, 349, 350, 350, 38, 38, 38, 
	350, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 350, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 39, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	351, 38, 37, 350, 352, 353, 354, 354, 
	25, 25, 25, 354, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 354, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 26, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 355, 25, 350, 19, 19, 
	19, 350, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 350, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 356, 19, 346, 25, 25, 25, 
	346, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 346, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 26, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	27, 25, 346, 357, 357, 357, 346, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 346, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 358, 357, 
	359, 360, 360, 357, 357, 357, 360, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 360, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 361, 357, 
	360, 19, 19, 19, 360, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 360, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 356, 19, 362, 
	360, 360, 25, 25, 25, 360, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 360, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	26, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 27, 25, 363, 
	364, 364, 364, 363, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 363, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 365, 
	365, 365, 365, 365, 365, 365, 365, 365, 
	365, 364, 364, 364, 364, 364, 364, 364, 
	365, 365, 365, 365, 365, 365, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	365, 365, 365, 365, 365, 365, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 364, 364, 364, 364, 364, 364, 
	364, 364, 366, 364, 363, 367, 367, 367, 
	363, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 363, 367, 
	363, 368, 368, 368, 363, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 363, 368, 363, 369, 369, 369, 
	363, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 363, 369, 
	363, 363, 367, 367, 367, 363, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 363, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 370, 370, 370, 370, 370, 370, 370, 
	370, 370, 370, 367, 367, 367, 367, 367, 
	367, 367, 370, 370, 370, 370, 370, 370, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 367, 367, 367, 367, 367, 367, 
	367, 367, 370, 370, 370, 370, 370, 370, 
	367, 363, 368, 368, 368, 363, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 363, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 371, 371, 371, 371, 371, 371, 371, 
	371, 371, 371, 368, 368, 368, 368, 368, 
	368, 368, 371, 371, 371, 371, 371, 371, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 368, 368, 368, 368, 368, 368, 
	368, 368, 371, 371, 371, 371, 371, 371, 
	368, 363, 369, 369, 369, 363, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 363, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 372, 372, 372, 372, 372, 372, 372, 
	372, 372, 372, 369, 369, 369, 369, 369, 
	369, 369, 372, 372, 372, 372, 372, 372, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 372, 372, 372, 372, 372, 372, 
	369, 373, 376, 375, 375, 375, 376, 375, 
	375, 375, 375, 375, 375, 375, 375, 375, 
	375, 375, 375, 375, 375, 375, 375, 375, 
	375, 375, 375, 375, 376, 375, 375, 375, 
	375, 375, 375, 375, 375, 375, 375, 375, 
	375, 375, 375, 375, 375, 375, 375, 375, 
	375, 375, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 375, 375, 375, 375, 
	375, 375, 375, 377, 377, 377, 377, 377, 
	377, 375, 375, 375, 375, 375, 375, 375, 
	375, 375, 375, 375, 375, 375, 375, 375, 
	375, 375, 375, 375, 375, 375, 375, 375, 
	375, 375, 375, 377, 377, 377, 377, 377, 
	377, 375, 375, 375, 375, 375, 375, 375, 
	375, 375, 375, 375, 375, 375, 375, 375, 
	375, 375, 375, 375, 375, 375, 375, 367, 
	375, 376, 378, 378, 378, 376, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 376, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 379, 379, 379, 379, 379, 379, 379, 
	379, 379, 379, 378, 378, 378, 378, 378, 
	378, 378, 379, 379, 379, 379, 379, 379, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 379, 379, 379, 379, 379, 379, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 380, 378, 
	376, 381, 381, 381, 376, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 376, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 381, 381, 381, 381, 381, 381, 
	381, 382, 382, 382, 382, 382, 382, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 382, 382, 382, 382, 382, 382, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 383, 381, 376, 
	384, 384, 384, 376, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 376, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 384, 384, 384, 384, 384, 384, 384, 
	385, 385, 385, 385, 385, 385, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	385, 385, 385, 385, 385, 385, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 376, 384, 376, 384, 
	384, 384, 376, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	376, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	384, 384, 384, 384, 384, 384, 384, 385, 
	385, 385, 385, 385, 385, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 385, 
	385, 385, 385, 385, 385, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 376, 384, 386, 376, 385, 
	385, 385, 376, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	376, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 386, 385, 376, 385, 385, 
	385, 376, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 376, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 374, 385, 374, 376, 382, 382, 
	382, 376, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 376, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 382, 382, 382, 382, 382, 382, 
	382, 382, 369, 382, 374, 369, 369, 369, 
	374, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 374, 369, 
	376, 378, 378, 378, 376, 378, 378, 378, 
	378, 387, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 376, 378, 378, 378, 378, 378, 
	387, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	388, 388, 388, 388, 388, 388, 388, 388, 
	388, 388, 378, 378, 378, 378, 378, 378, 
	378, 388, 388, 388, 388, 388, 388, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 388, 388, 388, 388, 388, 388, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 378, 378, 378, 
	378, 378, 378, 378, 378, 389, 378, 376, 
	384, 384, 384, 376, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 376, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 384, 384, 384, 384, 384, 384, 384, 
	390, 390, 390, 390, 390, 390, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	390, 390, 390, 390, 390, 390, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 376, 384, 376, 384, 
	384, 384, 376, 384, 384, 384, 384, 387, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	376, 384, 384, 384, 384, 384, 387, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	384, 384, 384, 384, 384, 384, 384, 391, 
	391, 391, 391, 391, 391, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 391, 
	391, 391, 391, 391, 391, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 389, 384, 376, 384, 384, 
	384, 376, 384, 384, 384, 384, 387, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 376, 
	384, 384, 384, 384, 384, 387, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 384, 
	384, 384, 384, 384, 384, 384, 392, 392, 
	392, 392, 392, 392, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 392, 392, 
	392, 392, 392, 392, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 389, 384, 376, 384, 384, 384, 
	376, 384, 384, 384, 384, 387, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 376, 384, 
	384, 384, 384, 384, 387, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 393, 393, 393, 393, 
	393, 393, 393, 393, 393, 393, 384, 384, 
	384, 384, 384, 384, 384, 393, 393, 393, 
	393, 393, 393, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 393, 393, 393, 
	393, 393, 393, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 389, 384, 376, 384, 384, 384, 376, 
	384, 384, 384, 384, 387, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 376, 384, 384, 
	384, 384, 384, 387, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 394, 394, 394, 394, 394, 
	394, 394, 394, 394, 394, 384, 384, 384, 
	384, 384, 384, 384, 394, 394, 394, 394, 
	394, 394, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 394, 394, 394, 394, 
	394, 394, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	389, 384, 376, 384, 384, 384, 376, 384, 
	384, 384, 384, 387, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 376, 384, 384, 384, 
	384, 384, 387, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 395, 395, 395, 395, 395, 395, 
	395, 395, 395, 395, 384, 384, 384, 384, 
	384, 384, 384, 395, 395, 395, 395, 395, 
	395, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 395, 395, 395, 395, 395, 
	395, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 389, 
	384, 376, 384, 384, 384, 376, 384, 384, 
	384, 384, 387, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 376, 384, 384, 384, 384, 
	384, 387, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 384, 384, 384, 384, 384, 
	384, 384, 396, 396, 396, 396, 396, 396, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 396, 396, 396, 396, 396, 396, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 389, 384, 
	376, 384, 384, 384, 376, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 376, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 384, 384, 384, 384, 384, 384, 
	384, 396, 396, 396, 396, 396, 396, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 396, 396, 396, 396, 396, 396, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 384, 384, 384, 
	384, 384, 384, 384, 384, 386, 384, 397, 
	376, 381, 381, 381, 376, 381, 381, 381, 
	381, 387, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 376, 381, 381, 381, 381, 381, 
	387, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 381, 381, 381, 381, 381, 381, 
	381, 392, 392, 392, 392, 392, 392, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 392, 392, 392, 392, 392, 392, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 381, 381, 381, 
	381, 381, 381, 381, 381, 389, 381, 398, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 399, 399, 399, 399, 399, 399, 
	399, 400, 400, 400, 400, 400, 400, 399, 
	399, 399, 399, 399, 399, 399, 399, 399, 
	399, 399, 399, 399, 399, 399, 399, 399, 
	399, 399, 399, 399, 399, 399, 399, 399, 
	399, 400, 400, 400, 400, 400, 400, 399, 
	399, 402, 401, 401, 401, 402, 401, 401, 
	401, 401, 401, 403, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 402, 401, 401, 401, 401, 
	401, 401, 401, 401, 404, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 405, 401, 407, 
	406, 406, 406, 406, 406, 406, 406, 406, 
	406, 406, 406, 406, 406, 406, 406, 406, 
	406, 406, 406, 406, 406, 406, 406, 406, 
	406, 406, 406, 408, 406, 406, 406, 406, 
	406, 406, 406, 406, 406, 406, 406, 406, 
	406, 406, 406, 406, 406, 406, 406, 406, 
	406, 406, 406, 406, 406, 406, 406, 406, 
	406, 406, 406, 406, 406, 406, 406, 406, 
	406, 406, 406, 406, 406, 406, 406, 406, 
	406, 406, 406, 406, 406, 406, 406, 406, 
	406, 406, 406, 406, 406, 406, 409, 406, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 410, 410, 410, 410, 410, 410, 
	410, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 410, 410, 410, 410, 44, 
	410, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 410, 410, 410, 410, 410, 
	44, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 410, 413, 412, 412, 412, 
	413, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 413, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 414, 414, 414, 414, 
	414, 414, 414, 414, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 415, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 416, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 417, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 412, 412, 412, 412, 412, 412, 412, 
	412, 418, 412, 412, 419, 412, 420, 421, 
	423, 423, 423, 423, 423, 423, 423, 423, 
	422, 424, 424, 424, 424, 424, 424, 424, 
	424, 422, 422, 425, 425, 69, 69, 69, 
	425, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 425, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 70, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	426, 69, 427, 428, 429, 429, 69, 69, 
	69, 429, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 429, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 70, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 430, 69, 68, 429, 431, 432, 433, 
	433, 56, 56, 56, 433, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 433, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 57, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 434, 56, 429, 50, 
	50, 50, 429, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	429, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 435, 50, 425, 56, 56, 
	56, 425, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 425, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 57, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 58, 56, 425, 436, 436, 436, 425, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 425, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 437, 
	436, 438, 439, 439, 436, 436, 436, 439, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 439, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 440, 
	436, 439, 50, 50, 50, 439, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 439, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 435, 50, 
	441, 439, 439, 56, 56, 56, 439, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 439, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 57, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 58, 56, 
	442, 443, 443, 443, 442, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 442, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	444, 444, 444, 444, 444, 444, 444, 444, 
	444, 444, 443, 443, 443, 443, 443, 443, 
	443, 444, 444, 444, 444, 444, 444, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 444, 444, 444, 444, 444, 444, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 445, 443, 442, 446, 446, 
	446, 442, 446, 446, 446, 446, 446, 446, 
	446, 446, 446, 446, 446, 446, 446, 446, 
	446, 446, 446, 446, 446, 446, 446, 442, 
	446, 442, 447, 447, 447, 442, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 442, 447, 442, 448, 448, 
	448, 442, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 448, 448, 448, 448, 442, 
	448, 442, 442, 446, 446, 446, 442, 446, 
	446, 446, 446, 446, 446, 446, 446, 446, 
	446, 446, 446, 446, 446, 446, 446, 446, 
	446, 446, 446, 446, 442, 446, 446, 446, 
	446, 446, 446, 446, 446, 446, 446, 446, 
	446, 446, 446, 446, 446, 446, 446, 446, 
	446, 446, 449, 449, 449, 449, 449, 449, 
	449, 449, 449, 449, 446, 446, 446, 446, 
	446, 446, 446, 449, 449, 449, 449, 449, 
	449, 446, 446, 446, 446, 446, 446, 446, 
	446, 446, 446, 446, 446, 446, 446, 446, 
	446, 446, 446, 446, 446, 446, 446, 446, 
	446, 446, 446, 449, 449, 449, 449, 449, 
	449, 446, 442, 447, 447, 447, 442, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 442, 447, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 447, 447, 447, 447, 
	447, 447, 447, 450, 450, 450, 450, 450, 
	450, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 447, 447, 450, 450, 450, 450, 450, 
	450, 447, 442, 448, 448, 448, 442, 448, 
	448, 448, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 448, 442, 448, 448, 448, 
	448, 448, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 448, 448, 448, 448, 448, 
	448, 448, 451, 451, 451, 451, 451, 451, 
	451, 451, 451, 451, 448, 448, 448, 448, 
	448, 448, 448, 451, 451, 451, 451, 451, 
	451, 448, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 451, 451, 451, 451, 451, 
	451, 448, 452, 455, 454, 454, 454, 455, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 455, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 456, 456, 456, 456, 456, 
	456, 456, 456, 456, 456, 454, 454, 454, 
	454, 454, 454, 454, 456, 456, 456, 456, 
	456, 456, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 456, 456, 456, 456, 
	456, 456, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	454, 454, 454, 454, 454, 454, 454, 454, 
	446, 454, 455, 457, 457, 457, 455, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 455, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 457, 457, 457, 457, 
	457, 457, 457, 458, 458, 458, 458, 458, 
	458, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 458, 458, 458, 458, 458, 
	458, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 459, 
	457, 455, 460, 460, 460, 455, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 455, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 460, 460, 460, 460, 460, 
	460, 460, 461, 461, 461, 461, 461, 461, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 461, 461, 461, 461, 461, 461, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 462, 460, 
	455, 463, 463, 463, 455, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 455, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 463, 463, 463, 463, 463, 463, 
	463, 464, 464, 464, 464, 464, 464, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 464, 464, 464, 464, 464, 464, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 455, 463, 455, 
	463, 463, 463, 455, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 455, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 463, 463, 463, 463, 463, 463, 463, 
	464, 464, 464, 464, 464, 464, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	464, 464, 464, 464, 464, 464, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 455, 463, 465, 455, 
	464, 464, 464, 455, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 455, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 465, 464, 455, 464, 
	464, 464, 455, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	455, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 464, 464, 464, 
	464, 464, 464, 453, 464, 453, 455, 461, 
	461, 461, 455, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	455, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 461, 461, 461, 461, 461, 
	461, 461, 461, 448, 461, 453, 448, 448, 
	448, 453, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 448, 448, 448, 448, 448, 
	448, 448, 448, 448, 448, 448, 448, 453, 
	448, 455, 457, 457, 457, 455, 457, 457, 
	457, 457, 466, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 455, 457, 457, 457, 457, 
	457, 466, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 467, 457, 457, 457, 457, 457, 
	457, 457, 467, 467, 467, 467, 467, 467, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 467, 467, 467, 467, 467, 467, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 457, 457, 
	457, 457, 457, 457, 457, 457, 468, 457, 
	455, 463, 463, 463, 455, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 455, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 463, 463, 463, 463, 463, 463, 
	463, 469, 469, 469, 469, 469, 469, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 469, 469, 469, 469, 469, 469, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 455, 463, 455, 
	463, 463, 463, 455, 463, 463, 463, 463, 
	466, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 455, 463, 463, 463, 463, 463, 466, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 463, 463, 463, 463, 463, 463, 463, 
	470, 470, 470, 470, 470, 470, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	470, 470, 470, 470, 470, 470, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 468, 463, 455, 463, 
	463, 463, 455, 463, 463, 463, 463, 466, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	455, 463, 463, 463, 463, 463, 466, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	463, 463, 463, 463, 463, 463, 463, 471, 
	471, 471, 471, 471, 471, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 471, 
	471, 471, 471, 471, 471, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 468, 463, 455, 463, 463, 
	463, 455, 463, 463, 463, 463, 466, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 455, 
	463, 463, 463, 463, 463, 466, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 472, 472, 472, 
	472, 472, 472, 472, 472, 472, 472, 463, 
	463, 463, 463, 463, 463, 463, 472, 472, 
	472, 472, 472, 472, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 472, 472, 
	472, 472, 472, 472, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 468, 463, 455, 463, 463, 463, 
	455, 463, 463, 463, 463, 466, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 455, 463, 
	463, 463, 463, 463, 466, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 473, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 463, 463, 
	463, 463, 463, 463, 463, 473, 473, 473, 
	473, 473, 473, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 473, 473, 473, 
	473, 473, 473, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 468, 463, 455, 463, 463, 463, 455, 
	463, 463, 463, 463, 466, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 455, 463, 463, 
	463, 463, 463, 466, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 474, 463, 463, 463, 
	463, 463, 463, 463, 474, 474, 474, 474, 
	474, 474, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 474, 474, 474, 474, 
	474, 474, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	468, 463, 455, 463, 463, 463, 455, 463, 
	463, 463, 463, 466, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 455, 463, 463, 463, 
	463, 463, 466, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 475, 463, 463, 463, 463, 
	463, 463, 463, 475, 475, 475, 475, 475, 
	475, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 475, 475, 475, 475, 475, 
	475, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 468, 
	463, 455, 463, 463, 463, 455, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 455, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 475, 475, 475, 475, 475, 475, 475, 
	475, 475, 475, 463, 463, 463, 463, 463, 
	463, 463, 475, 475, 475, 475, 475, 475, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 475, 475, 475, 475, 475, 475, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 465, 463, 
	476, 455, 460, 460, 460, 455, 460, 460, 
	460, 460, 466, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 455, 460, 460, 460, 460, 
	460, 466, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 460, 460, 460, 460, 460, 
	460, 460, 471, 471, 471, 471, 471, 471, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 471, 471, 471, 471, 471, 471, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 468, 460, 
	477, 479, 479, 479, 479, 479, 479, 479, 
	479, 479, 479, 478, 478, 478, 478, 478, 
	478, 478, 479, 479, 479, 479, 479, 479, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 478, 478, 478, 478, 478, 478, 
	478, 478, 479, 479, 479, 479, 479, 479, 
	478, 478, 481, 480, 480, 480, 481, 480, 
	480, 480, 480, 482, 483, 482, 482, 482, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 481, 480, 480, 480, 
	480, 480, 482, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 484, 480, 
	482, 485, 482, 482, 482, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 485, 
	485, 485, 485, 485, 485, 485, 485, 482, 
	485, 486, 487, 487, 487, 486, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 486, 487, 489, 488, 488, 
	488, 489, 488, 488, 488, 488, 488, 490, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 489, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 488, 488, 488, 488, 488, 488, 488, 
	488, 491, 488, 492, 493, 493, 493, 492, 
	493, 493, 493, 493, 493, 494, 493, 493, 
	493, 493, 493, 493, 493, 493, 493, 493, 
	493, 493, 493, 493, 493, 492, 493, 496, 
	495, 495, 495, 496, 495, 495, 495, 495, 
	495, 497, 495, 495, 495, 495, 495, 495, 
	495, 495, 495, 495, 495, 495, 495, 495, 
	495, 496, 495, 495, 495, 495, 495, 495, 
	495, 495, 498, 495, 500, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	501, 499, 499, 499, 499, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	499, 499, 499, 499, 499, 499, 499, 499, 
	499, 499, 499, 502, 499, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 503, 
	503, 503, 503, 503, 503, 503, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	503, 503, 503, 503, 75, 503, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	503, 503, 503, 503, 503, 75, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	503, 505, 504, 504, 504, 505, 504, 504, 
	504, 504, 504, 506, 504, 504, 504, 504, 
	504, 504, 504, 504, 504, 504, 504, 504, 
	504, 504, 504, 505, 504, 508, 507, 507, 
	507, 508, 507, 507, 507, 507, 509, 510, 
	509, 509, 509, 507, 507, 507, 507, 507, 
	507, 507, 507, 507, 507, 507, 507, 508, 
	507, 507, 507, 507, 507, 509, 507, 507, 
	511, 507, 509, 512, 509, 509, 509, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 509, 512, 514, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 515, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 513, 513, 513, 513, 513, 513, 
	513, 513, 516, 513, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 517, 517, 
	517, 517, 517, 517, 517, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 517, 
	517, 517, 517, 81, 517, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 517, 
	517, 517, 517, 517, 81, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 517, 
	519, 518, 518, 518, 519, 518, 518, 518, 
	518, 520, 521, 520, 520, 520, 518, 518, 
	518, 518, 518, 518, 518, 518, 518, 518, 
	518, 518, 519, 518, 518, 518, 518, 518, 
	520, 518, 520, 522, 520, 520, 520, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 520, 522, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 523, 523, 523, 
	523, 523, 523, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 523, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	525, 525, 525, 525, 525, 525, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 524, 524, 
	525, 526, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 527, 88, 528, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 528, 528, 528, 528, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 528, 528, 528, 528, 528, 528, 528, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 528, 528, 528, 528, 86, 528, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 528, 528, 528, 528, 528, 86, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 528, 529, 529, 529, 529, 529, 
	529, 529, 529, 529, 529, 529, 529, 529, 
	529, 529, 529, 529, 529, 529, 529, 529, 
	529, 529, 529, 529, 529, 529, 529, 529, 
	529, 529, 529, 529, 529, 529, 529, 529, 
	529, 529, 529, 529, 529, 529, 529, 529, 
	529, 529, 529, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 529, 529, 529, 
	529, 529, 529, 529, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 529, 529, 
	529, 529, 91, 529, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 529, 529, 
	529, 529, 529, 91, 530, 530, 530, 530, 
	530, 530, 530, 530, 530, 530, 530, 530, 
	530, 530, 530, 530, 530, 530, 530, 530, 
	530, 530, 530, 530, 530, 530, 530, 530, 
	530, 530, 530, 530, 530, 530, 530, 530, 
	530, 530, 530, 530, 530, 530, 530, 530, 
	530, 530, 530, 530, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 530, 530, 
	530, 530, 530, 530, 530, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 530, 
	530, 530, 530, 93, 530, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 530, 
	530, 530, 530, 530, 93, 532, 533, 533, 
	533, 532, 533, 533, 533, 533, 534, 535, 
	534, 534, 534, 533, 533, 533, 533, 533, 
	533, 533, 533, 533, 533, 533, 533, 532, 
	533, 533, 533, 533, 533, 534, 536, 533, 
	537, 538, 539, 540, 533, 533, 533, 541, 
	542, 533, 542, 533, 543, 533, 533, 533, 
	533, 533, 533, 533, 533, 533, 533, 544, 
	533, 545, 546, 547, 533, 533, 548, 549, 
	548, 548, 550, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	551, 552, 533, 543, 553, 543, 554, 555, 
	556, 557, 558, 559, 531, 531, 560, 531, 
	531, 531, 561, 562, 563, 531, 531, 564, 
	565, 566, 567, 531, 568, 531, 569, 531, 
	533, 570, 533, 542, 533, 531, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 572, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	571, 571, 571, 572, 571, 572, 571, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 571, 571, 571, 571, 531, 571, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 571, 571, 571, 571, 571, 531, 534, 
	573, 534, 534, 534, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 573, 573, 
	573, 573, 573, 573, 573, 573, 534, 573, 
	574, 543, 575, 575, 543, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 575, 575, 575, 575, 575, 575, 
	575, 575, 543, 575, 576, 577, 578, 579, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 95, 95, 580, 95, 580, 95, 95, 
	580, 580, 95, 95, 95, 582, 95, 95, 
	583, 583, 583, 583, 583, 583, 583, 583, 
	583, 583, 95, 95, 95, 95, 95, 95, 
	95, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 580, 95, 580, 580, 581, 
	95, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 580, 580, 580, 95, 580, 
	581, 584, 584, 584, 584, 584, 584, 584, 
	584, 584, 584, 584, 584, 584, 584, 584, 
	584, 584, 584, 584, 584, 584, 584, 584, 
	584, 584, 584, 584, 584, 584, 584, 584, 
	584, 584, 584, 584, 584, 584, 584, 584, 
	584, 584, 584, 584, 584, 584, 584, 584, 
	584, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 584, 584, 584, 584, 584, 
	584, 584, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 581, 584, 584, 584, 584, 
	581, 584, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	581, 581, 581, 581, 584, 584, 584, 584, 
	584, 581, 583, 583, 583, 583, 583, 583, 
	583, 583, 583, 583, 584, 585, 575, 543, 
	575, 543, 575, 543, 575, 587, 586, 543, 
	588, 575, 543, 575, 589, 543, 580, 580, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 580, 580, 580, 580, 580, 580, 580, 
	580, 580, 580, 580, 580, 543, 580, 543, 
	575, 543, 543, 575, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 572, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 571, 571, 
	571, 572, 571, 572, 571, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 571, 
	571, 571, 571, 548, 571, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 571, 
	571, 571, 571, 571, 548, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 572, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 590, 
	590, 590, 572, 590, 572, 590, 548, 548, 
	548, 548, 591, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	590, 590, 590, 590, 548, 590, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	590, 590, 590, 590, 590, 548, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 572, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	590, 590, 590, 572, 590, 572, 590, 548, 
	548, 548, 548, 548, 548, 592, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 590, 590, 590, 590, 548, 590, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 590, 590, 590, 590, 590, 548, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	572, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 590, 590, 590, 572, 590, 572, 590, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	593, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 590, 590, 590, 590, 548, 590, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 590, 590, 590, 590, 590, 548, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 572, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 590, 590, 590, 572, 590, 572, 
	590, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 594, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 590, 590, 590, 590, 548, 
	590, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 590, 590, 590, 590, 590, 
	548, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 572, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 590, 590, 590, 572, 590, 
	572, 590, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 595, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 590, 590, 590, 590, 
	548, 590, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 590, 590, 590, 590, 
	590, 548, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 590, 572, 590, 590, 590, 590, 
	590, 590, 590, 590, 590, 590, 590, 590, 
	590, 590, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 590, 590, 590, 572, 
	590, 572, 590, 548, 548, 548, 594, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 590, 590, 590, 
	590, 548, 590, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 548, 590, 590, 590, 
	590, 590, 548, 589, 580, 535, 580, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 597, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 598, 599, 531, 
	531, 531, 531, 531, 600, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 531, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 601, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	531, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 572, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 572, 
	596, 572, 596, 531, 531, 602, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 531, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 596, 531, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 572, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	572, 596, 572, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 603, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 531, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 596, 531, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 572, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 572, 596, 572, 596, 531, 531, 531, 
	604, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 531, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 596, 531, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 572, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 572, 596, 572, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 605, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 531, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 596, 531, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 572, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 572, 596, 572, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 606, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 531, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 596, 531, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 607, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 531, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 608, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	609, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 572, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 572, 
	596, 572, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 610, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 531, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 596, 531, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 572, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	572, 596, 572, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 611, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 531, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 596, 531, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 572, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 572, 596, 572, 596, 531, 531, 531, 
	531, 607, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 531, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 596, 531, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 572, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 572, 596, 572, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 612, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 531, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 596, 531, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 572, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 572, 596, 572, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 611, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 531, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 596, 531, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 531, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 613, 531, 614, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 531, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 615, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	531, 596, 616, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 572, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 572, 
	596, 572, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 531, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 609, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 596, 531, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 572, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	572, 596, 572, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 531, 596, 531, 531, 531, 609, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 596, 531, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 572, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 572, 596, 572, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 531, 596, 531, 531, 531, 
	531, 617, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 618, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 596, 531, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 572, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 572, 596, 572, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 531, 596, 531, 531, 
	531, 531, 531, 531, 619, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 596, 531, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 572, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 572, 596, 572, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 531, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 620, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 596, 531, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 531, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 609, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 531, 
	596, 531, 531, 531, 531, 621, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	531, 596, 622, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 572, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 572, 
	596, 572, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 531, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 609, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 596, 531, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 572, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	572, 596, 572, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 531, 596, 623, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 624, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 596, 531, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 572, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 572, 596, 572, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 531, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 625, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 596, 531, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 572, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 572, 596, 572, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 531, 596, 531, 531, 
	531, 531, 609, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 596, 531, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 572, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 572, 596, 572, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 531, 596, 626, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 596, 531, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 531, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 616, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 531, 
	596, 531, 531, 531, 531, 627, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 609, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	531, 596, 531, 531, 531, 531, 531, 628, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 629, 572, 629, 629, 629, 629, 
	629, 629, 629, 629, 629, 629, 629, 629, 
	629, 629, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 629, 629, 629, 572, 
	629, 572, 629, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 629, 629, 629, 
	629, 531, 629, 531, 531, 531, 531, 531, 
	531, 531, 531, 630, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 629, 629, 629, 
	629, 629, 531, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 572, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	572, 596, 572, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 531, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 631, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 596, 531, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 572, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 572, 596, 572, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 531, 596, 531, 531, 531, 
	531, 632, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 596, 531, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 572, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 572, 596, 572, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 531, 596, 531, 531, 
	531, 633, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 596, 531, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 572, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 572, 596, 634, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 531, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 596, 531, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 531, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 635, 531, 636, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 531, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 637, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	531, 596, 531, 531, 531, 531, 609, 531, 
	531, 531, 638, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 572, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 572, 
	596, 572, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 531, 596, 531, 531, 531, 531, 531, 
	609, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 596, 531, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 572, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	572, 596, 572, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 531, 596, 531, 531, 531, 609, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 639, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 596, 531, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 572, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 572, 596, 572, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 531, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 640, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 596, 531, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 572, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 572, 596, 572, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 531, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 625, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 596, 531, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 572, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 572, 596, 572, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 531, 596, 641, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 563, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 596, 531, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 531, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 623, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 531, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 609, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	531, 596, 531, 531, 531, 531, 531, 609, 
	531, 531, 531, 531, 531, 531, 531, 609, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 572, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 572, 
	596, 572, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 531, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 642, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 596, 531, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 572, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	572, 596, 572, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 531, 596, 531, 531, 531, 643, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 596, 531, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 572, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 572, 596, 572, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 531, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 644, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 596, 531, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 572, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 572, 596, 572, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 531, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 625, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 596, 531, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 572, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 572, 596, 572, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 531, 596, 531, 
	531, 531, 531, 645, 531, 531, 531, 646, 
	531, 531, 531, 531, 531, 647, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 596, 531, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 531, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 647, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 531, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 609, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	531, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 609, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 572, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 572, 
	596, 572, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 531, 596, 531, 531, 531, 531, 648, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 596, 531, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 572, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	572, 596, 572, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 531, 596, 531, 531, 531, 649, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 650, 651, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 596, 531, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 572, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 572, 596, 572, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 531, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 609, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 596, 531, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 572, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 572, 596, 572, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 531, 596, 531, 531, 
	652, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 596, 531, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 572, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 572, 596, 572, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 531, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 625, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 596, 531, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 531, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 653, 531, 531, 654, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 531, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 609, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	531, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 620, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 572, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 572, 
	596, 572, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 531, 596, 531, 531, 531, 531, 655, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 656, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 596, 531, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 572, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	572, 596, 572, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 531, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 638, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 596, 531, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 572, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 572, 596, 572, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 531, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 657, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 596, 531, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 572, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 572, 596, 572, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 531, 596, 531, 531, 
	531, 531, 563, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 596, 531, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 572, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 572, 596, 572, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 531, 596, 531, 
	531, 531, 531, 531, 531, 531, 658, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	652, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 596, 531, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 531, 596, 
	531, 531, 531, 531, 620, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 531, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 659, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	531, 596, 531, 531, 531, 660, 531, 531, 
	531, 531, 531, 531, 531, 661, 531, 531, 
	531, 531, 531, 531, 531, 662, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 572, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 572, 
	596, 572, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 531, 596, 531, 531, 531, 531, 638, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	596, 596, 531, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 572, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 596, 596, 596, 
	572, 596, 572, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 531, 596, 531, 531, 531, 531, 
	626, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 596, 596, 531, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 572, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 596, 596, 
	596, 572, 596, 572, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 531, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 646, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 596, 596, 531, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 572, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 596, 
	596, 596, 572, 596, 572, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 531, 596, 531, 531, 
	531, 531, 531, 531, 531, 663, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 596, 596, 531, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 572, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	596, 596, 596, 572, 596, 572, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 531, 596, 531, 
	531, 531, 531, 620, 531, 531, 531, 644, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 596, 596, 531, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	572, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 596, 596, 596, 572, 596, 572, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 531, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	664, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 596, 596, 531, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 572, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 596, 596, 596, 572, 596, 572, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 531, 
	596, 531, 531, 531, 531, 665, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 596, 596, 
	531, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 572, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 596, 596, 596, 572, 596, 
	572, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	531, 596, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 614, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 596, 596, 596, 596, 
	596, 531, 543, 575, 667, 668, 668, 668, 
	667, 668, 668, 668, 668, 669, 668, 669, 
	669, 669, 668, 668, 668, 668, 668, 668, 
	668, 668, 668, 668, 668, 668, 667, 668, 
	668, 668, 668, 668, 669, 668, 668, 670, 
	668, 668, 668, 668, 668, 668, 668, 668, 
	668, 668, 668, 668, 668, 668, 668, 668, 
	668, 668, 668, 668, 668, 668, 668, 668, 
	668, 668, 668, 668, 668, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 668, 
	671, 668, 668, 666, 668, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 666, 
	666, 666, 666, 666, 666, 666, 666, 668, 
	668, 668, 668, 668, 666, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 100, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 101, 
	672, 672, 672, 672, 100, 672, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	672, 672, 672, 672, 99, 672, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	672, 672, 672, 672, 672, 99, 669, 673, 
	669, 669, 669, 673, 673, 673, 673, 673, 
	673, 673, 673, 673, 673, 673, 673, 673, 
	673, 673, 673, 673, 673, 669, 673, 674, 
	675, 676, 677, 678, 672, 679, 681, 682, 
	682, 682, 681, 682, 682, 682, 682, 683, 
	684, 683, 683, 683, 682, 682, 682, 682, 
	682, 682, 682, 682, 682, 682, 682, 682, 
	681, 682, 682, 682, 682, 682, 683, 685, 
	682, 686, 682, 687, 688, 682, 682, 682, 
	689, 690, 682, 690, 682, 687, 682, 682, 
	682, 682, 682, 682, 682, 682, 682, 682, 
	682, 682, 691, 692, 693, 682, 682, 694, 
	694, 694, 694, 694, 694, 694, 694, 694, 
	694, 694, 694, 694, 694, 694, 694, 694, 
	694, 694, 694, 694, 694, 694, 694, 694, 
	694, 695, 696, 682, 687, 680, 687, 680, 
	680, 680, 680, 680, 680, 680, 680, 680, 
	680, 680, 680, 680, 680, 680, 680, 680, 
	680, 680, 680, 680, 680, 680, 680, 680, 
	680, 682, 697, 682, 690, 682, 680, 698, 
	698, 698, 698, 698, 698, 698, 698, 698, 
	698, 698, 698, 698, 698, 698, 698, 698, 
	698, 698, 698, 698, 698, 698, 698, 698, 
	698, 698, 698, 698, 698, 698, 698, 698, 
	699, 698, 698, 698, 698, 698, 698, 698, 
	698, 698, 698, 698, 698, 698, 698, 680, 
	680, 680, 680, 680, 680, 680, 680, 680, 
	680, 698, 698, 698, 698, 698, 699, 698, 
	680, 680, 680, 680, 680, 680, 680, 680, 
	680, 680, 680, 680, 680, 680, 680, 680, 
	680, 680, 680, 680, 680, 680, 680, 680, 
	680, 680, 698, 698, 698, 698, 680, 698, 
	680, 680, 680, 680, 680, 680, 680, 680, 
	680, 680, 680, 680, 680, 680, 680, 680, 
	680, 680, 680, 680, 680, 680, 680, 680, 
	680, 680, 698, 698, 698, 698, 698, 680, 
	701, 700, 702, 683, 703, 683, 683, 683, 
	703, 703, 703, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 703, 703, 703, 703, 
	703, 703, 683, 703, 704, 687, 705, 705, 
	687, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 705, 687, 705, 
	706, 707, 708, 709, 687, 705, 687, 705, 
	687, 705, 687, 710, 705, 687, 705, 712, 
	687, 711, 711, 711, 711, 711, 711, 711, 
	711, 711, 711, 711, 711, 711, 711, 711, 
	711, 711, 711, 711, 711, 711, 711, 711, 
	711, 711, 711, 711, 711, 711, 711, 711, 
	711, 711, 711, 711, 711, 711, 711, 711, 
	711, 711, 711, 711, 711, 711, 711, 711, 
	711, 711, 711, 711, 711, 711, 711, 711, 
	711, 711, 711, 711, 711, 711, 711, 711, 
	687, 711, 687, 705, 687, 687, 705, 713, 
	713, 713, 713, 713, 713, 713, 713, 713, 
	713, 713, 713, 713, 713, 713, 713, 713, 
	713, 713, 713, 713, 713, 713, 713, 713, 
	713, 713, 713, 713, 713, 713, 713, 713, 
	699, 713, 713, 713, 713, 713, 713, 713, 
	713, 713, 713, 713, 713, 713, 713, 694, 
	694, 694, 694, 694, 694, 694, 694, 694, 
	694, 713, 713, 713, 713, 713, 699, 713, 
	694, 694, 694, 694, 694, 694, 694, 694, 
	694, 694, 694, 694, 694, 694, 694, 694, 
	694, 694, 694, 694, 694, 694, 694, 694, 
	694, 694, 713, 713, 713, 713, 694, 713, 
	694, 694, 694, 694, 694, 694, 694, 694, 
	694, 694, 694, 694, 694, 694, 694, 694, 
	694, 694, 694, 694, 694, 694, 694, 694, 
	694, 694, 713, 713, 713, 713, 713, 694, 
	712, 711, 684, 711, 687, 705, 715, 714, 
	714, 714, 715, 714, 714, 714, 714, 716, 
	717, 716, 716, 716, 714, 714, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	715, 714, 714, 714, 714, 714, 716, 714, 
	714, 718, 714, 109, 719, 714, 720, 714, 
	721, 109, 140, 722, 142, 109, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	723, 714, 724, 140, 725, 726, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	714, 140, 727, 140, 109, 714, 714, 714, 
	714, 714, 714, 714, 714, 714, 714, 728, 
	714, 714, 714, 714, 714, 714, 714, 714, 
	729, 714, 714, 730, 714, 731, 714, 714, 
	714, 153, 154, 714, 109, 714, 732, 732, 
	732, 732, 732, 732, 732, 732, 732, 716, 
	732, 716, 716, 716, 732, 732, 732, 732, 
	732, 732, 732, 732, 732, 732, 732, 732, 
	732, 732, 732, 732, 732, 732, 716, 732, 
	732, 732, 732, 135, 136, 732, 137, 732, 
	138, 139, 140, 141, 142, 135, 732, 732, 
	732, 732, 732, 732, 732, 732, 732, 732, 
	143, 732, 144, 140, 145, 146, 732, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 147, 148, 140, 109, 104, 732, 104, 
	104, 104, 104, 104, 104, 104, 104, 149, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	150, 104, 104, 151, 104, 152, 104, 104, 
	104, 153, 154, 732, 109, 732, 104, 733, 
	734, 734, 734, 733, 734, 734, 734, 734, 
	140, 735, 140, 140, 140, 734, 734, 734, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 733, 734, 734, 734, 734, 734, 140, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 734, 734, 734, 140, 734, 140, 735, 
	140, 140, 140, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 140, 103, 103, 
	103, 103, 103, 109, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 140, 103, 140, 735, 140, 140, 
	140, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 140, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	140, 103, 736, 140, 735, 140, 140, 140, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 140, 737, 737, 737, 737, 737, 
	737, 737, 737, 737, 738, 737, 737, 737, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 737, 737, 737, 737, 140, 
	737, 140, 735, 140, 140, 140, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	140, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 140, 140, 103, 
	739, 733, 140, 733, 741, 740, 743, 744, 
	743, 743, 743, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 743, 742, 745, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 105, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 106, 733, 733, 733, 733, 105, 
	733, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 733, 733, 733, 733, 104, 
	733, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 733, 733, 733, 733, 733, 
	104, 746, 140, 735, 140, 140, 140, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 140, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 140, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 109, 733, 747, 
	748, 749, 750, 751, 752, 140, 735, 140, 
	140, 140, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 140, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 109, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 733, 733, 733, 733, 733, 733, 733, 
	733, 140, 733, 140, 740, 109, 753, 109, 
	753, 754, 755, 754, 754, 754, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	742, 742, 742, 742, 742, 742, 742, 742, 
	754, 742, 756, 753, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 112, 757, 112, 
	112, 112, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 112, 757, 757, 757, 
	757, 113, 114, 757, 115, 757, 116, 117, 
	118, 119, 120, 113, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 121, 757, 
	122, 118, 123, 124, 757, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 125, 
	126, 118, 127, 111, 757, 111, 111, 111, 
	111, 111, 111, 111, 111, 128, 111, 111, 
	111, 111, 111, 111, 111, 111, 129, 111, 
	111, 130, 111, 131, 111, 111, 111, 132, 
	133, 757, 127, 757, 111, 140, 753, 758, 
	753, 759, 753, 760, 753, 761, 179, 179, 
	179, 761, 179, 179, 179, 179, 762, 179, 
	762, 762, 762, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 761, 
	179, 179, 179, 179, 179, 762, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	179, 763, 179, 179, 181, 179, 181, 181, 
	181, 185, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	179, 179, 179, 179, 179, 181, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 764, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	179, 178, 178, 178, 178, 764, 178, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 178, 178, 178, 178, 181, 178, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 178, 178, 178, 178, 178, 181, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	182, 765, 182, 182, 182, 765, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 182, 
	765, 765, 765, 765, 765, 765, 765, 183, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 765, 184, 765, 765, 181, 765, 
	181, 181, 181, 185, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 765, 765, 765, 765, 765, 181, 
	766, 765, 765, 765, 765, 765, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	765, 765, 764, 765, 765, 765, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	765, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 179, 765, 765, 765, 765, 
	764, 765, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 765, 765, 765, 765, 
	181, 765, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	767, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 765, 765, 765, 765, 
	765, 181, 186, 765, 769, 768, 768, 768, 
	769, 768, 768, 768, 768, 770, 768, 770, 
	770, 770, 768, 768, 768, 768, 768, 768, 
	768, 768, 768, 768, 768, 768, 769, 768, 
	768, 768, 768, 768, 770, 768, 768, 771, 
	768, 768, 768, 768, 768, 768, 768, 768, 
	768, 768, 768, 768, 768, 768, 768, 768, 
	768, 768, 768, 768, 768, 768, 768, 768, 
	768, 768, 768, 768, 768, 768, 768, 768, 
	768, 768, 768, 768, 768, 768, 768, 768, 
	768, 768, 768, 768, 768, 768, 768, 768, 
	768, 768, 768, 768, 768, 768, 768, 768, 
	772, 768, 768, 768, 768, 768, 768, 768, 
	773, 768, 768, 768, 768, 768, 768, 768, 
	768, 768, 768, 768, 768, 768, 768, 768, 
	768, 768, 768, 768, 768, 768, 768, 774, 
	768, 770, 775, 770, 770, 770, 775, 775, 
	775, 775, 775, 775, 775, 775, 775, 775, 
	775, 775, 775, 775, 775, 775, 775, 775, 
	770, 775, 776, 777, 778, 779, 781, 780, 
	782, 783, 780, 784, 786, 787, 787, 787, 
	786, 787, 787, 787, 787, 788, 789, 788, 
	788, 788, 787, 787, 787, 787, 787, 787, 
	787, 787, 787, 787, 787, 787, 786, 787, 
	787, 787, 787, 787, 788, 787, 787, 790, 
	787, 787, 787, 787, 787, 787, 787, 787, 
	787, 787, 787, 787, 787, 787, 787, 787, 
	787, 787, 787, 787, 787, 787, 787, 787, 
	787, 787, 787, 787, 787, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 787, 
	791, 787, 787, 785, 787, 785, 785, 785, 
	785, 785, 785, 785, 785, 792, 785, 785, 
	785, 785, 785, 785, 785, 785, 793, 785, 
	785, 794, 785, 795, 785, 785, 785, 787, 
	787, 787, 787, 787, 785, 796, 796, 796, 
	796, 796, 796, 796, 796, 796, 796, 796, 
	796, 796, 796, 796, 796, 796, 796, 796, 
	796, 796, 796, 796, 796, 796, 796, 796, 
	796, 796, 796, 796, 796, 796, 796, 796, 
	796, 796, 796, 796, 796, 796, 796, 796, 
	796, 796, 796, 796, 796, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 796, 
	796, 796, 796, 796, 796, 796, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	796, 796, 796, 796, 785, 796, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	796, 796, 796, 796, 796, 785, 788, 797, 
	788, 788, 788, 797, 797, 797, 797, 797, 
	797, 797, 797, 797, 797, 797, 797, 797, 
	797, 797, 797, 797, 797, 788, 797, 798, 
	799, 800, 801, 802, 804, 803, 805, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 806, 806, 806, 806, 806, 806, 806, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 806, 806, 806, 806, 785, 806, 
	785, 785, 785, 785, 785, 807, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 806, 806, 806, 806, 806, 785, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 806, 806, 806, 806, 806, 806, 
	806, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 806, 806, 806, 806, 785, 
	806, 785, 785, 785, 785, 808, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 806, 806, 806, 806, 806, 
	785, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 806, 806, 806, 806, 806, 
	806, 806, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 806, 806, 806, 806, 
	785, 806, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 809, 785, 785, 785, 
	785, 785, 785, 785, 806, 806, 806, 806, 
	806, 785, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 806, 806, 806, 806, 
	806, 806, 806, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 806, 806, 806, 
	806, 785, 806, 785, 785, 810, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 806, 806, 806, 
	806, 806, 785, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 806, 806, 806, 
	806, 806, 806, 806, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 806, 806, 
	806, 806, 785, 806, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	811, 785, 785, 785, 785, 785, 806, 806, 
	806, 806, 806, 785, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 806, 806, 
	806, 806, 806, 806, 806, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 806, 
	806, 806, 806, 785, 806, 785, 785, 785, 
	785, 807, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 806, 
	806, 806, 806, 806, 785, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 806, 
	806, 806, 806, 806, 806, 806, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	806, 806, 806, 806, 785, 806, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 812, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	806, 806, 806, 806, 806, 785, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	806, 806, 806, 806, 806, 806, 806, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 806, 806, 806, 806, 785, 806, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 813, 785, 785, 785, 785, 785, 
	785, 785, 814, 785, 785, 785, 785, 785, 
	785, 806, 806, 806, 806, 806, 785, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 806, 806, 806, 806, 806, 806, 806, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 806, 806, 806, 806, 785, 806, 
	785, 785, 785, 785, 815, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 806, 806, 806, 806, 806, 785, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 806, 806, 806, 806, 806, 806, 
	806, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 806, 806, 806, 806, 785, 
	806, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 816, 785, 785, 785, 785, 
	785, 785, 785, 806, 806, 806, 806, 806, 
	785, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 806, 806, 806, 806, 806, 
	806, 806, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 806, 806, 806, 806, 
	785, 806, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 807, 785, 785, 785, 
	785, 785, 785, 785, 806, 806, 806, 806, 
	806, 785, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 806, 806, 806, 806, 
	806, 806, 806, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 806, 806, 806, 
	806, 785, 806, 785, 785, 785, 785, 785, 
	785, 785, 785, 817, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 806, 806, 806, 
	806, 806, 785, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 806, 806, 806, 
	806, 806, 806, 806, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 806, 806, 
	806, 806, 785, 806, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 807, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 806, 806, 
	806, 806, 806, 785, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 806, 806, 
	806, 806, 806, 806, 806, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 806, 
	806, 806, 806, 785, 806, 785, 785, 785, 
	785, 785, 785, 785, 818, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 806, 
	806, 806, 806, 806, 785, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 806, 
	806, 806, 806, 806, 806, 806, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	806, 806, 806, 806, 785, 806, 785, 785, 
	785, 785, 785, 785, 785, 785, 819, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	806, 806, 806, 806, 806, 785, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 806, 806, 
	806, 806, 806, 806, 806, 806, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	806, 806, 806, 806, 806, 806, 806, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 806, 806, 806, 806, 785, 806, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 785, 811, 785, 785, 785, 785, 785, 
	785, 785, 785, 785, 785, 785, 785, 785, 
	785, 806, 806, 806, 806, 806, 785, 821, 
	203, 203, 203, 821, 203, 203, 203, 203, 
	822, 823, 822, 822, 822, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 821, 203, 203, 203, 203, 203, 822, 
	824, 203, 825, 203, 826, 827, 203, 828, 
	203, 829, 830, 203, 831, 832, 833, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 834, 203, 835, 836, 837, 838, 203, 
	839, 840, 839, 839, 841, 839, 839, 839, 
	839, 839, 839, 839, 839, 839, 839, 839, 
	839, 839, 839, 839, 839, 839, 839, 839, 
	839, 839, 842, 843, 203, 844, 845, 203, 
	846, 847, 848, 849, 850, 851, 820, 820, 
	852, 820, 820, 820, 853, 854, 855, 820, 
	820, 856, 857, 858, 859, 820, 860, 820, 
	861, 820, 862, 863, 203, 844, 203, 820, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 248, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 192, 192, 250, 192, 248, 
	192, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 192, 192, 192, 192, 820, 
	192, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 192, 192, 192, 192, 192, 
	820, 865, 864, 864, 866, 864, 867, 869, 
	870, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	871, 868, 873, 872, 874, 875, 876, 822, 
	877, 822, 822, 822, 877, 877, 877, 877, 
	877, 877, 877, 877, 877, 877, 877, 877, 
	877, 877, 877, 877, 877, 877, 822, 877, 
	879, 878, 881, 882, 881, 881, 881, 880, 
	880, 880, 880, 880, 880, 880, 880, 880, 
	880, 880, 880, 880, 880, 880, 880, 880, 
	880, 881, 880, 203, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 203, 883, 884, 885, 
	886, 887, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 889, 889, 889, 889, 
	889, 889, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 890, 890, 890, 890, 
	890, 890, 890, 890, 889, 891, 201, 201, 
	201, 891, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 891, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	201, 201, 201, 201, 201, 201, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	201, 893, 892, 892, 892, 892, 892, 892, 
	892, 892, 892, 892, 892, 892, 892, 892, 
	892, 892, 892, 892, 892, 892, 892, 892, 
	203, 892, 894, 896, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 895, 895, 
	895, 895, 895, 895, 895, 895, 203, 895, 
	203, 192, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 892, 892, 892, 203, 
	892, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 892, 892, 892, 203, 203, 
	892, 898, 883, 203, 883, 883, 899, 899, 
	899, 883, 899, 899, 899, 899, 899, 899, 
	899, 899, 899, 899, 899, 899, 899, 899, 
	899, 899, 899, 899, 899, 899, 899, 883, 
	899, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 901, 902, 883, 903, 206, 904, 
	902, 883, 883, 905, 906, 883, 906, 883, 
	206, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 907, 883, 908, 909, 910, 
	883, 911, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 912, 883, 883, 206, 
	900, 206, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 883, 913, 883, 906, 
	883, 900, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 915, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 914, 914, 914, 916, 
	914, 915, 914, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 914, 914, 914, 
	914, 900, 914, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 914, 914, 914, 
	914, 914, 900, 918, 917, 919, 921, 922, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 920, 
	920, 920, 920, 920, 920, 920, 920, 923, 
	920, 925, 926, 924, 927, 928, 929, 930, 
	206, 914, 914, 206, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 206, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 914, 914, 914, 914, 914, 
	914, 914, 914, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 914, 914, 914, 
	914, 914, 914, 914, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 914, 914, 
	914, 914, 205, 914, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 205, 914, 914, 
	914, 914, 914, 205, 208, 208, 208, 208, 
	208, 208, 208, 208, 208, 208, 914, 206, 
	914, 206, 914, 206, 914, 206, 931, 914, 
	206, 914, 206, 914, 206, 206, 914, 206, 
	914, 932, 933, 883, 934, 203, 883, 844, 
	203, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	203, 883, 203, 893, 883, 937, 936, 936, 
	936, 937, 936, 936, 936, 936, 938, 939, 
	938, 938, 938, 936, 936, 936, 936, 936, 
	936, 936, 936, 936, 936, 936, 936, 937, 
	936, 936, 936, 936, 936, 938, 936, 936, 
	936, 936, 936, 936, 936, 936, 936, 936, 
	936, 936, 936, 936, 936, 936, 936, 936, 
	936, 936, 936, 936, 936, 936, 936, 936, 
	936, 936, 936, 936, 936, 936, 940, 940, 
	940, 940, 940, 940, 940, 940, 940, 940, 
	940, 940, 940, 940, 940, 940, 940, 940, 
	940, 940, 940, 940, 940, 940, 940, 940, 
	936, 941, 936, 936, 940, 936, 940, 940, 
	940, 940, 940, 940, 940, 940, 940, 940, 
	940, 940, 940, 940, 940, 940, 940, 940, 
	940, 940, 940, 940, 940, 940, 940, 940, 
	936, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 942, 942, 942, 
	942, 943, 942, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 942, 942, 942, 
	942, 942, 943, 944, 944, 944, 944, 944, 
	944, 944, 944, 944, 944, 944, 944, 944, 
	944, 944, 944, 944, 944, 944, 944, 944, 
	944, 944, 944, 944, 944, 944, 944, 944, 
	944, 944, 944, 944, 944, 944, 944, 944, 
	944, 944, 944, 944, 944, 944, 944, 944, 
	944, 944, 944, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 944, 944, 944, 
	944, 944, 944, 944, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 944, 944, 
	944, 944, 945, 944, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 945, 945, 
	945, 945, 945, 945, 945, 945, 944, 944, 
	944, 944, 944, 945, 948, 947, 947, 947, 
	948, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 948, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 949, 949, 949, 949, 
	949, 949, 949, 949, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 950, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 951, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 952, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 947, 947, 947, 947, 947, 947, 947, 
	947, 953, 947, 947, 954, 947, 955, 956, 
	958, 958, 958, 958, 958, 958, 958, 958, 
	957, 959, 959, 959, 959, 959, 959, 959, 
	959, 957, 957, 960, 960, 242, 242, 242, 
	960, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 960, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 243, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	961, 242, 962, 963, 964, 964, 242, 242, 
	242, 964, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 964, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 243, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 242, 
	242, 965, 242, 241, 964, 966, 967, 968, 
	968, 229, 229, 229, 968, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 968, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 230, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 969, 229, 964, 223, 
	223, 223, 964, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	964, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 970, 223, 960, 229, 229, 
	229, 960, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 960, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 230, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 231, 229, 960, 971, 971, 971, 960, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 960, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 972, 
	971, 973, 974, 974, 971, 971, 971, 974, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 974, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 975, 
	971, 974, 223, 223, 223, 974, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 974, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 970, 223, 
	976, 974, 974, 229, 229, 229, 974, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 974, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 230, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 231, 229, 
	977, 978, 978, 978, 977, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 977, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	979, 979, 979, 979, 979, 979, 979, 979, 
	979, 979, 978, 978, 978, 978, 978, 978, 
	978, 979, 979, 979, 979, 979, 979, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 979, 979, 979, 979, 979, 979, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 978, 978, 978, 978, 978, 
	978, 978, 978, 980, 978, 977, 981, 981, 
	981, 977, 981, 981, 981, 981, 981, 981, 
	981, 981, 981, 981, 981, 981, 981, 981, 
	981, 981, 981, 981, 981, 981, 981, 977, 
	981, 977, 982, 982, 982, 977, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 977, 982, 977, 983, 983, 
	983, 977, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 977, 
	983, 977, 977, 981, 981, 981, 977, 981, 
	981, 981, 981, 981, 981, 981, 981, 981, 
	981, 981, 981, 981, 981, 981, 981, 981, 
	981, 981, 981, 981, 977, 981, 981, 981, 
	981, 981, 981, 981, 981, 981, 981, 981, 
	981, 981, 981, 981, 981, 981, 981, 981, 
	981, 981, 984, 984, 984, 984, 984, 984, 
	984, 984, 984, 984, 981, 981, 981, 981, 
	981, 981, 981, 984, 984, 984, 984, 984, 
	984, 981, 981, 981, 981, 981, 981, 981, 
	981, 981, 981, 981, 981, 981, 981, 981, 
	981, 981, 981, 981, 981, 981, 981, 981, 
	981, 981, 981, 984, 984, 984, 984, 984, 
	984, 981, 977, 982, 982, 982, 977, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 977, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 985, 985, 985, 985, 985, 985, 
	985, 985, 985, 985, 982, 982, 982, 982, 
	982, 982, 982, 985, 985, 985, 985, 985, 
	985, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 985, 985, 985, 985, 985, 
	985, 982, 977, 983, 983, 983, 977, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 977, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 986, 986, 986, 986, 986, 986, 
	986, 986, 986, 986, 983, 983, 983, 983, 
	983, 983, 983, 986, 986, 986, 986, 986, 
	986, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 986, 986, 986, 986, 986, 
	986, 983, 987, 990, 989, 989, 989, 990, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 990, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 991, 991, 991, 991, 991, 
	991, 991, 991, 991, 991, 989, 989, 989, 
	989, 989, 989, 989, 991, 991, 991, 991, 
	991, 991, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 991, 991, 991, 991, 
	991, 991, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	989, 989, 989, 989, 989, 989, 989, 989, 
	981, 989, 990, 992, 992, 992, 990, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 990, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 993, 993, 993, 993, 993, 993, 
	993, 993, 993, 993, 992, 992, 992, 992, 
	992, 992, 992, 993, 993, 993, 993, 993, 
	993, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 993, 993, 993, 993, 993, 
	993, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 994, 
	992, 990, 995, 995, 995, 990, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 990, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 995, 995, 995, 995, 995, 
	995, 995, 996, 996, 996, 996, 996, 996, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 996, 996, 996, 996, 996, 996, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 997, 995, 
	990, 998, 998, 998, 990, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 990, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 998, 998, 998, 998, 998, 998, 
	998, 999, 999, 999, 999, 999, 999, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 999, 999, 999, 999, 999, 999, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 990, 998, 990, 
	998, 998, 998, 990, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 990, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 998, 998, 998, 998, 998, 998, 998, 
	999, 999, 999, 999, 999, 999, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	999, 999, 999, 999, 999, 999, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 990, 998, 1000, 990, 
	999, 999, 999, 990, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 990, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 1000, 999, 990, 999, 
	999, 999, 990, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	990, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 999, 988, 999, 988, 990, 996, 
	996, 996, 990, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	990, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 996, 996, 996, 996, 996, 
	996, 996, 996, 983, 996, 988, 983, 983, 
	983, 988, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 988, 
	983, 990, 992, 992, 992, 990, 992, 992, 
	992, 992, 1001, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 990, 992, 992, 992, 992, 
	992, 1001, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 
	1002, 1002, 1002, 992, 992, 992, 992, 992, 
	992, 992, 1002, 1002, 1002, 1002, 1002, 1002, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 1002, 1002, 1002, 1002, 1002, 1002, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 992, 992, 
	992, 992, 992, 992, 992, 992, 1003, 992, 
	990, 998, 998, 998, 990, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 990, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 998, 998, 998, 998, 998, 998, 
	998, 1004, 1004, 1004, 1004, 1004, 1004, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 1004, 1004, 1004, 1004, 1004, 1004, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 990, 998, 990, 
	998, 998, 998, 990, 998, 998, 998, 998, 
	1001, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 990, 998, 998, 998, 998, 998, 1001, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 998, 998, 998, 998, 998, 998, 998, 
	1005, 1005, 1005, 1005, 1005, 1005, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	1005, 1005, 1005, 1005, 1005, 1005, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 1000, 998, 990, 998, 
	998, 998, 990, 998, 998, 998, 998, 1001, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	990, 998, 998, 998, 998, 998, 1001, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	998, 998, 998, 998, 998, 998, 998, 1006, 
	1006, 1006, 1006, 1006, 1006, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 1006, 
	1006, 1006, 1006, 1006, 1006, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 1000, 998, 990, 998, 998, 
	998, 990, 998, 998, 998, 998, 1001, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 990, 
	998, 998, 998, 998, 998, 1001, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 998, 
	998, 998, 998, 998, 998, 998, 1007, 1007, 
	1007, 1007, 1007, 1007, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 1007, 1007, 
	1007, 1007, 1007, 1007, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 1000, 998, 990, 998, 998, 998, 
	990, 998, 998, 998, 998, 1001, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 990, 998, 
	998, 998, 998, 998, 1001, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 1008, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 998, 998, 
	998, 998, 998, 998, 998, 1008, 1008, 1008, 
	1008, 1008, 1008, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 1008, 1008, 1008, 
	1008, 1008, 1008, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 1000, 998, 990, 998, 998, 998, 990, 
	998, 998, 998, 998, 1001, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 990, 998, 998, 
	998, 998, 998, 1001, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 1009, 1009, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 998, 998, 998, 
	998, 998, 998, 998, 1009, 1009, 1009, 1009, 
	1009, 1009, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 1009, 1009, 1009, 1009, 
	1009, 1009, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	1000, 998, 990, 998, 998, 998, 990, 998, 
	998, 998, 998, 1001, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 990, 998, 998, 998, 
	998, 998, 1001, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 998, 998, 998, 998, 
	998, 998, 998, 1010, 1010, 1010, 1010, 1010, 
	1010, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 1010, 1010, 1010, 1010, 1010, 
	1010, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 1000, 
	998, 990, 998, 998, 998, 990, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 990, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 998, 998, 998, 998, 998, 
	998, 998, 1010, 1010, 1010, 1010, 1010, 1010, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 1010, 1010, 1010, 1010, 1010, 1010, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 1000, 998, 
	990, 995, 995, 995, 990, 995, 995, 995, 
	995, 1001, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 990, 995, 995, 995, 995, 995, 
	1001, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 
	1011, 1011, 995, 995, 995, 995, 995, 995, 
	995, 1011, 1011, 1011, 1011, 1011, 1011, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 1011, 1011, 1011, 1011, 1011, 1011, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 995, 995, 995, 
	995, 995, 995, 995, 995, 1003, 995, 990, 
	998, 998, 998, 990, 998, 998, 998, 998, 
	1001, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 990, 998, 998, 998, 998, 998, 1001, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 1012, 
	1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 
	1012, 998, 998, 998, 998, 998, 998, 998, 
	1012, 1012, 1012, 1012, 1012, 1012, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	1012, 1012, 1012, 1012, 1012, 1012, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 1003, 998, 990, 998, 
	998, 998, 990, 998, 998, 998, 998, 1001, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	990, 998, 998, 998, 998, 998, 1001, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 1013, 1013, 
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 
	998, 998, 998, 998, 998, 998, 998, 1013, 
	1013, 1013, 1013, 1013, 1013, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 1013, 
	1013, 1013, 1013, 1013, 1013, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 1003, 998, 990, 998, 998, 
	998, 990, 998, 998, 998, 998, 1001, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 990, 
	998, 998, 998, 998, 998, 1001, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 1014, 1014, 1014, 
	1014, 1014, 1014, 1014, 1014, 1014, 1014, 998, 
	998, 998, 998, 998, 998, 998, 1014, 1014, 
	1014, 1014, 1014, 1014, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 1014, 1014, 
	1014, 1014, 1014, 1014, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 1003, 998, 990, 998, 998, 998, 
	990, 998, 998, 998, 998, 1001, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 990, 998, 
	998, 998, 998, 998, 1001, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 1010, 1010, 1010, 1010, 
	1010, 1010, 1010, 1010, 1010, 1010, 998, 998, 
	998, 998, 998, 998, 998, 1010, 1010, 1010, 
	1010, 1010, 1010, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 1010, 1010, 1010, 
	1010, 1010, 1010, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 1003, 998, 1015, 1016, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1017, 
	1017, 1017, 1017, 1017, 1017, 1017, 1018, 1018, 
	1018, 1018, 1018, 1018, 1017, 1017, 1017, 1017, 
	1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 
	1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 
	1017, 1017, 1017, 1017, 1017, 1017, 1018, 1018, 
	1018, 1018, 1018, 1018, 1017, 1017, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 248, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	249, 192, 192, 250, 192, 248, 192, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 192, 192, 192, 192, 247, 192, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 192, 192, 192, 192, 192, 247, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	248, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 249, 883, 883, 250, 883, 248, 883, 
	247, 247, 247, 247, 1019, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 883, 883, 883, 883, 247, 883, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 883, 883, 883, 883, 883, 247, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 248, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 249, 883, 883, 250, 883, 248, 
	883, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 1020, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 883, 883, 883, 883, 247, 
	883, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 883, 883, 883, 883, 883, 
	247, 1021, 1022, 883, 878, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1024, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 1025, 1026, 820, 820, 820, 
	820, 820, 1027, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 820, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1028, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 820, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 248, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 1023, 1023, 250, 1023, 248, 
	1023, 820, 820, 1029, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 820, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 1023, 
	820, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 248, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 249, 1023, 1023, 250, 1023, 
	248, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1030, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	820, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	1023, 820, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 248, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 249, 1023, 1023, 250, 
	1023, 248, 1023, 820, 820, 820, 1031, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 820, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 1023, 820, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 248, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 249, 1023, 1023, 
	250, 1023, 248, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 1032, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 820, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 1023, 820, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1033, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 1034, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 820, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1035, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1036, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 248, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 1023, 1023, 250, 1023, 248, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 1037, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 820, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 1023, 
	820, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 248, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 249, 1023, 1023, 250, 1023, 
	248, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1038, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	820, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	1023, 820, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 248, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 249, 1023, 1023, 250, 
	1023, 248, 1023, 820, 820, 820, 820, 1034, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 820, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 1023, 820, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 248, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 249, 1023, 1023, 
	250, 1023, 248, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 1039, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 820, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 1023, 820, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1038, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 820, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1040, 820, 1041, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 820, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 1042, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 820, 1023, 
	1043, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 248, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 1023, 1023, 250, 1023, 248, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 820, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1036, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 1023, 
	820, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 248, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 249, 1023, 1023, 250, 1023, 
	248, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	820, 1023, 820, 820, 820, 1036, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	1023, 820, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 248, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 249, 1023, 1023, 250, 
	1023, 248, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 820, 1023, 820, 820, 820, 820, 1044, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1045, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 1023, 820, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 248, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 249, 1023, 1023, 
	250, 1023, 248, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 820, 1023, 820, 820, 820, 820, 
	820, 820, 1046, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 1023, 820, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 1047, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 820, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1036, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 820, 1023, 820, 
	820, 820, 820, 1048, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 820, 1023, 
	1049, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 248, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 1023, 1023, 250, 1023, 248, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 820, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1036, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 1023, 
	820, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 248, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 249, 1023, 1023, 250, 1023, 
	248, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	820, 1023, 1050, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1051, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	1023, 820, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 248, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 249, 1023, 1023, 250, 
	1023, 248, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 820, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1052, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 1023, 820, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 248, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 249, 1023, 1023, 
	250, 1023, 248, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 820, 1023, 820, 820, 820, 820, 
	1036, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 1023, 820, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 1053, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 820, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1043, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 820, 1023, 820, 
	820, 820, 820, 1054, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1036, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 820, 1023, 
	820, 820, 820, 820, 820, 1036, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 248, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 1023, 1023, 250, 1023, 248, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 820, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1055, 820, 1056, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 1023, 
	820, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 248, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 249, 1023, 1023, 250, 1023, 
	248, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	820, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1057, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	1023, 820, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 248, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 249, 1023, 1023, 250, 
	1023, 248, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 820, 1023, 820, 820, 820, 820, 1036, 
	820, 820, 820, 1054, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 1023, 820, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 248, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 249, 1023, 1023, 
	250, 1023, 248, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 820, 1023, 820, 820, 820, 1036, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1058, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 1023, 820, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1059, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 820, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1052, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 820, 1023, 1060, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 855, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 820, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1050, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 248, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 1023, 1023, 250, 1023, 248, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 820, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1036, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 1023, 
	820, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 248, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 249, 1023, 1023, 250, 1023, 
	248, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	820, 1023, 820, 820, 820, 820, 820, 1061, 
	820, 820, 820, 820, 820, 820, 820, 1036, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	1023, 820, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 248, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 249, 1023, 1023, 250, 
	1023, 248, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 820, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1062, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 1023, 820, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 248, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 249, 1023, 1023, 
	250, 1023, 248, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 820, 1023, 820, 820, 820, 1063, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 1023, 820, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1064, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 820, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1052, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 820, 1023, 820, 
	820, 820, 820, 1065, 820, 820, 820, 1066, 
	820, 820, 820, 820, 820, 1067, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 820, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1067, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 248, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 1023, 1023, 250, 1023, 248, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 820, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1036, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 1023, 
	820, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 248, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 249, 1023, 1023, 250, 1023, 
	248, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	820, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1036, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	1023, 820, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 248, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 249, 1023, 1023, 250, 
	1023, 248, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 820, 1023, 820, 820, 820, 820, 1068, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 1023, 820, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 248, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 249, 1023, 1023, 
	250, 1023, 248, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 820, 1023, 820, 820, 820, 1069, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1070, 1071, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 1023, 820, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1036, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 820, 1023, 820, 820, 
	1072, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 820, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1073, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 820, 1023, 
	820, 820, 820, 820, 1074, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1077, 1075, 1075, 1075, 1075, 1075, 1075, 
	1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075, 
	1076, 1076, 1076, 1076, 1076, 1076, 1076, 1076, 
	1076, 1076, 1078, 1075, 1075, 1079, 1075, 1077, 
	1075, 1076, 1076, 1076, 1076, 1076, 1076, 1076, 
	1076, 1076, 1076, 1076, 1076, 1076, 1076, 1076, 
	1076, 1076, 1076, 1076, 1076, 1076, 1076, 1076, 
	1076, 1076, 1076, 1075, 1075, 1075, 1075, 1076, 
	1075, 1076, 1076, 1076, 1076, 1076, 1076, 1076, 
	1076, 1076, 1076, 1076, 1076, 1076, 1076, 1076, 
	1076, 1076, 1076, 1076, 1076, 1076, 1076, 1076, 
	1076, 1076, 1076, 1075, 1075, 1075, 1075, 1075, 
	1076, 869, 1080, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 868, 868, 868, 868, 868, 868, 
	868, 868, 871, 868, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1081, 820, 
	820, 1082, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 820, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1036, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 820, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1047, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 820, 1023, 
	820, 820, 820, 820, 1083, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1084, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 248, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 1023, 1023, 250, 1023, 248, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 820, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1054, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 1023, 
	820, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 248, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 249, 1023, 1023, 250, 1023, 
	248, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	820, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1085, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	1023, 820, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 248, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 249, 1023, 1023, 250, 
	1023, 248, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 820, 1023, 820, 820, 820, 820, 855, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 1023, 820, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 248, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 249, 1023, 1023, 
	250, 1023, 248, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 820, 1023, 820, 820, 820, 820, 
	820, 820, 820, 1086, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1087, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 1023, 820, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 820, 820, 820, 
	820, 1047, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 820, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1052, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 820, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1088, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 820, 1023, 
	820, 820, 820, 1089, 820, 820, 820, 820, 
	820, 820, 820, 1090, 820, 820, 820, 820, 
	820, 820, 820, 1091, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 248, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 1023, 1023, 250, 1023, 248, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 820, 
	1023, 820, 820, 820, 820, 1054, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 1023, 
	820, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 248, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 249, 1023, 1023, 250, 1023, 
	248, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	820, 1023, 820, 820, 820, 820, 1092, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	1023, 820, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 248, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 249, 1023, 1023, 250, 
	1023, 248, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 820, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1093, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 1023, 820, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 248, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 249, 1023, 1023, 
	250, 1023, 248, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 820, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1061, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 1023, 820, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 1094, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 248, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 249, 
	1023, 1023, 250, 1023, 248, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 820, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1061, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1023, 1023, 1023, 1023, 1023, 820, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 248, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	249, 1023, 1023, 250, 1023, 248, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 820, 1023, 820, 
	820, 820, 820, 820, 820, 820, 1095, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 1023, 1023, 1023, 1023, 1023, 820, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	248, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 249, 1023, 1023, 250, 1023, 248, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 820, 1023, 
	820, 820, 820, 820, 1047, 820, 820, 820, 
	1096, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 1023, 1023, 1023, 1023, 1023, 820, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 248, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 249, 1023, 1023, 250, 1023, 248, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 820, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1097, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 1023, 1023, 1023, 1023, 1023, 
	820, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 248, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 249, 1023, 1023, 250, 1023, 
	248, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	820, 1023, 820, 820, 820, 820, 1061, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 1023, 1023, 1023, 1023, 
	1023, 820, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 248, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 249, 1023, 1023, 250, 
	1023, 248, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 820, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 1098, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 1023, 1023, 1023, 
	1023, 1023, 820, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 248, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 249, 1023, 1023, 
	250, 1023, 248, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 820, 1023, 820, 820, 820, 820, 
	1099, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 1023, 1023, 
	1023, 1023, 1023, 820, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 248, 1023, 1023, 
	1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1023, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 249, 1023, 
	1023, 250, 1023, 248, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 820, 1023, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	1041, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 1023, 
	1023, 1023, 1023, 1023, 820, 1100, 203, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 893, 883, 1102, 
	1101, 1101, 1101, 1102, 1101, 1101, 1101, 1101, 
	1103, 1104, 1103, 1103, 1103, 1101, 1101, 1101, 
	1101, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 
	1101, 1102, 1101, 1101, 1101, 1101, 1101, 1103, 
	1101, 1101, 1105, 1101, 1101, 1101, 1101, 1101, 
	1101, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 
	1101, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 
	1101, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 
	1101, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 
	1101, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 
	1101, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 
	1101, 1101, 1101, 1106, 1101, 1103, 1107, 1103, 
	1103, 1103, 1107, 1107, 1107, 1107, 1107, 1107, 
	1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
	1107, 1107, 1107, 1107, 1103, 1107, 1108, 1109, 
	1110, 1111, 1112, 1114, 1113, 1115, 1117, 1118, 
	1118, 1118, 1117, 1118, 1118, 1118, 1118, 1119, 
	1120, 1119, 1119, 1119, 1118, 1118, 1118, 1118, 
	1118, 1118, 1118, 1118, 1118, 1118, 1118, 1118, 
	1117, 1118, 1118, 1118, 1118, 1118, 1119, 1118, 
	1121, 1122, 1118, 1118, 1118, 1121, 1118, 1118, 
	1118, 1118, 1118, 1118, 1118, 1118, 1118, 1118, 
	1118, 1118, 1118, 1118, 1118, 1118, 1118, 1118, 
	1118, 1118, 1118, 1118, 1118, 1118, 1118, 1116, 
	1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 
	1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 
	1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 
	1116, 1118, 1123, 1118, 1118, 1116, 1118, 1116, 
	1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 
	1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 
	1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 
	1116, 1118, 1118, 1118, 1118, 1118, 1116, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	256, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 257, 1124, 1124, 1124, 1124, 256, 1124, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 1124, 1124, 1124, 1124, 255, 1124, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 1124, 1124, 1124, 1124, 1124, 255, 
	1119, 1125, 1119, 1119, 1119, 1125, 1125, 1125, 
	1125, 1125, 1125, 1125, 1125, 1125, 1125, 1125, 
	1125, 1125, 1125, 1125, 1125, 1125, 1125, 1119, 
	1125, 1126, 1127, 1128, 1129, 1130, 1131, 1124, 
	1132, 1134, 1135, 1135, 1135, 1134, 1135, 1135, 
	1135, 1135, 1136, 1137, 1136, 1136, 1136, 1135, 
	1135, 1135, 1135, 1135, 1135, 1135, 1135, 1135, 
	1135, 1135, 1135, 1134, 1135, 1135, 1135, 1135, 
	1135, 1136, 1138, 1139, 1140, 1141, 1142, 1143, 
	1139, 1144, 1145, 1146, 1142, 1147, 1148, 1149, 
	1142, 1150, 1151, 1151, 1151, 1151, 1151, 1151, 
	1151, 1151, 1151, 1152, 1153, 1154, 1155, 1156, 
	1157, 1158, 1159, 1160, 1159, 1159, 1161, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1162, 1163, 1164, 1142, 
	1165, 1139, 1166, 1167, 1168, 1169, 1170, 1171, 
	1133, 1133, 1172, 1133, 1133, 1133, 1173, 1174, 
	1175, 1133, 1133, 1176, 1177, 1178, 1179, 1133, 
	1180, 1133, 1181, 1133, 1182, 1183, 1184, 1142, 
	1135, 1133, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 1185, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 265, 265, 265, 265, 
	265, 1185, 265, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 265, 265, 265, 
	265, 1133, 265, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 265, 265, 265, 
	265, 265, 1133, 1187, 1186, 1188, 1136, 1189, 
	1136, 1136, 1136, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1189, 1189, 1189, 
	1189, 1189, 1189, 1189, 1189, 1136, 1189, 1190, 
	1192, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1192, 1191, 1193, 1194, 1195, 1196, 1197, 
	1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 
	1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 
	1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 
	1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 
	260, 260, 1197, 260, 1197, 260, 260, 1197, 
	1197, 260, 260, 260, 1198, 260, 260, 1199, 
	1199, 1199, 1199, 1199, 1199, 1199, 1199, 1199, 
	1199, 260, 260, 260, 260, 260, 260, 260, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 1197, 260, 1197, 1197, 268, 260, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 1197, 1197, 1197, 260, 1197, 268, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 1200, 1200, 1200, 1200, 1200, 1200, 
	1200, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 1200, 1200, 1200, 1200, 268, 
	1200, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 1200, 1200, 1200, 1200, 1200, 
	268, 1199, 1199, 1199, 1199, 1199, 1199, 1199, 
	1199, 1199, 1199, 1200, 1201, 1191, 1142, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1202, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1201, 1191, 1203, 
	1204, 1142, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1201, 1191, 1201, 1205, 
	1191, 1207, 1206, 264, 264, 264, 264, 264, 
	264, 264, 264, 264, 264, 1206, 1147, 1208, 
	264, 264, 264, 264, 264, 264, 264, 264, 
	264, 264, 1209, 1209, 1209, 1209, 1209, 1209, 
	1209, 1209, 1209, 1209, 1209, 1210, 1209, 1209, 
	1209, 1209, 1209, 1209, 1209, 1209, 1209, 1209, 
	1209, 1209, 1209, 1209, 1209, 1209, 1209, 1209, 
	1209, 1209, 1209, 1209, 1209, 1209, 1209, 1211, 
	1209, 1209, 1209, 1209, 1209, 1210, 1209, 263, 
	263, 263, 263, 263, 263, 263, 263, 263, 
	263, 1209, 1209, 1209, 1209, 1209, 1209, 1209, 
	1209, 1209, 1209, 1209, 1209, 1209, 1209, 1209, 
	1209, 1209, 1209, 1209, 1209, 1209, 1209, 1209, 
	1209, 1209, 1209, 1209, 1209, 1209, 1209, 1209, 
	1209, 1209, 1209, 1209, 1209, 1209, 262, 1209, 
	1213, 1212, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1212, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1215, 1212, 1216, 1217, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1218, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1219, 1212, 1212, 1212, 1212, 1212, 
	1212, 1220, 1212, 1212, 1215, 1212, 1216, 1217, 
	1212, 1212, 1212, 1221, 1212, 1212, 1212, 1212, 
	1212, 1218, 1212, 1212, 1222, 1212, 1212, 1212, 
	1212, 1212, 1219, 1212, 266, 266, 266, 266, 
	266, 266, 266, 266, 266, 266, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1224, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1225, 1223, 1223, 1223, 1223, 
	1223, 1224, 1223, 1223, 1223, 1226, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1227, 1223, 
	1228, 265, 1228, 265, 265, 267, 267, 267, 
	267, 267, 267, 267, 267, 267, 267, 265, 
	267, 267, 267, 267, 267, 267, 267, 267, 
	267, 267, 1229, 1229, 1229, 1229, 1229, 1229, 
	1229, 1229, 1229, 1229, 1229, 1229, 1229, 1229, 
	1229, 1229, 1229, 1229, 1229, 1229, 1229, 1229, 
	1229, 1229, 1229, 1229, 1229, 1229, 1229, 1229, 
	1229, 1229, 1229, 1229, 1229, 1229, 1229, 1228, 
	1229, 1229, 1229, 1229, 1229, 1229, 1229, 1229, 
	1229, 1230, 1229, 1231, 1233, 1232, 1234, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1220, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1221, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1222, 1212, 1235, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1236, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1221, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1222, 1212, 1238, 
	1238, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 
	1238, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1239, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1240, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1241, 1237, 1238, 1238, 1238, 1238, 1238, 
	1238, 1238, 1238, 1238, 1238, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1242, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1240, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1241, 1237, 1240, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1241, 1237, 1243, 1245, 1244, 1246, 1248, 1248, 
	1247, 1247, 1247, 1247, 1247, 1247, 1247, 1247, 
	1247, 1247, 1247, 1247, 1247, 1247, 1247, 1247, 
	1247, 1247, 1247, 1247, 1247, 1247, 1247, 1247, 
	1247, 1247, 1247, 1247, 1247, 1247, 1247, 1247, 
	1247, 1247, 1247, 1247, 1247, 1247, 1247, 1247, 
	1247, 1247, 1247, 1247, 1247, 1249, 1247, 1247, 
	1247, 1247, 1247, 1247, 1247, 1247, 1247, 1250, 
	1247, 1247, 1247, 1247, 1247, 1247, 1247, 1247, 
	1251, 1247, 1252, 1252, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1253, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1240, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1241, 1237, 1252, 1252, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1242, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1240, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1241, 1237, 1255, 1255, 1255, 1255, 1255, 1255, 
	1255, 1255, 1255, 1255, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1256, 1254, 1254, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1257, 1254, 1254, 1254, 1254, 
	1254, 1254, 1254, 1254, 1258, 1254, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1261, 1259, 1259, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1262, 
	1259, 1259, 1259, 1259, 1259, 1259, 1259, 1259, 
	1263, 1259, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1265, 1265, 1265, 1265, 1265, 
	1265, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 
	1264, 1266, 1264, 1265, 1265, 1265, 1265, 1265, 
	1265, 1264, 1264, 1267, 1264, 1264, 1264, 1264, 
	1264, 1264, 1264, 1264, 1268, 1264, 1269, 1269, 
	1269, 1269, 1269, 1269, 1269, 1269, 1269, 1269, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1269, 
	1269, 1269, 1269, 1269, 1269, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1270, 1237, 1269, 
	1269, 1269, 1269, 1269, 1269, 1237, 1237, 1240, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1241, 1237, 1269, 1269, 1269, 1269, 1269, 1269, 
	1269, 1269, 1269, 1269, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1269, 1269, 1269, 1269, 1269, 
	1269, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1242, 1237, 1269, 1269, 1269, 1269, 1269, 
	1269, 1237, 1237, 1240, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1241, 1237, 1272, 1271, 
	1273, 1273, 1273, 1273, 1273, 1273, 1273, 1273, 
	1273, 1273, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1274, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1275, 
	1271, 1271, 1271, 1271, 1271, 1274, 1271, 1271, 
	1271, 1276, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1277, 1271, 1278, 1278, 1278, 1278, 
	1278, 1278, 1278, 1278, 1278, 1278, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1279, 1271, 1271, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1276, 1271, 1271, 
	1271, 1271, 1271, 1271, 1271, 1271, 1277, 1271, 
	1280, 1237, 1281, 1281, 1281, 1281, 1281, 1281, 
	1281, 1281, 1281, 1281, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1282, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1283, 1237, 1237, 1237, 1237, 1237, 1282, 
	1237, 1237, 1237, 1240, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1241, 1237, 1281, 1281, 
	1281, 1281, 1281, 1281, 1281, 1281, 1281, 1281, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1242, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1240, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1237, 
	1241, 1237, 1202, 1208, 1142, 1284, 1191, 1192, 
	1191, 1285, 1192, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1208, 1208, 1208, 1208, 1208, 1208, 
	1208, 1208, 1192, 1208, 1192, 1191, 1192, 1142, 
	1191, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 
	1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 
	1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 
	1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 
	1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 
	1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 
	1197, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 1197, 1197, 1197, 1197, 1197, 
	1197, 1286, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 1197, 1197, 1197, 1197, 
	268, 1197, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 1197, 1197, 1197, 1197, 
	1197, 268, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 1185, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1287, 265, 265, 265, 
	265, 1185, 265, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 265, 265, 265, 
	265, 1159, 265, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 265, 265, 265, 
	265, 265, 1159, 1288, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1185, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1287, 1289, 
	1289, 1289, 1289, 1185, 1289, 1159, 1159, 1159, 
	1159, 1290, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1289, 
	1289, 1289, 1289, 1159, 1289, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1289, 
	1289, 1289, 1289, 1289, 1159, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1185, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1287, 
	1289, 1289, 1289, 1289, 1185, 1289, 1159, 1159, 
	1159, 1159, 1159, 1159, 1291, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1289, 1289, 1289, 1289, 1159, 1289, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1289, 1289, 1289, 1289, 1289, 1159, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1185, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1287, 1289, 1289, 1289, 1289, 1185, 1289, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1292, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1289, 1289, 1289, 1289, 1159, 1289, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1289, 1289, 1289, 1289, 1289, 1159, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1185, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1287, 1289, 1289, 1289, 1289, 1185, 1289, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1293, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1289, 1289, 1289, 1289, 1159, 1289, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1289, 1289, 1289, 1289, 1289, 1159, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1185, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1287, 1289, 1289, 1289, 1289, 1185, 
	1289, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1294, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1289, 1289, 1289, 1289, 1159, 
	1289, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1289, 1289, 1289, 1289, 1289, 
	1159, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1185, 1289, 1289, 1289, 1289, 1289, 
	1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 
	1289, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1287, 1289, 1289, 1289, 1289, 
	1185, 1289, 1159, 1159, 1159, 1293, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1289, 1289, 1289, 1289, 
	1159, 1289, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1159, 1159, 1159, 1159, 
	1159, 1159, 1159, 1159, 1289, 1289, 1289, 1289, 
	1289, 1159, 1295, 1297, 1296, 1298, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1300, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1301, 1302, 1133, 1133, 
	1133, 1133, 1133, 1303, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1304, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1305, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1306, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1307, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1308, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1309, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1310, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1311, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1312, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1313, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1314, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1315, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1316, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1317, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1318, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1314, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1319, 1133, 1320, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1321, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1322, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1323, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1133, 1133, 1133, 
	1324, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1133, 1325, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1326, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1327, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1328, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1324, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1329, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1330, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1331, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1332, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1333, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1334, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1133, 1324, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1335, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1336, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1337, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1338, 1338, 1338, 1338, 1338, 1338, 
	1338, 1338, 1338, 270, 271, 270, 270, 270, 
	1338, 1338, 1338, 1338, 1338, 1338, 1338, 1338, 
	1338, 1338, 1338, 1338, 1338, 1338, 1338, 1338, 
	1338, 1338, 270, 1185, 1338, 272, 1338, 1338, 
	1338, 1338, 1338, 1338, 1338, 1338, 1338, 1338, 
	1338, 1338, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1338, 1338, 273, 1338, 
	1338, 1185, 1338, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1338, 274, 1338, 
	1338, 1133, 1338, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1338, 1338, 1338, 
	1338, 1338, 1133, 287, 288, 287, 287, 287, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 287, 286, 286, 289, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 292, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 286, 286, 291, 286, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1340, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1341, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1133, 1342, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1185, 1343, 1343, 1343, 1343, 
	1343, 1343, 1343, 1343, 1343, 1343, 1343, 1343, 
	1343, 1343, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1343, 1343, 1343, 1343, 
	1343, 1185, 1343, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1343, 1343, 1343, 
	1343, 1133, 1343, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1344, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1343, 1343, 1343, 
	1343, 1343, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1345, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1133, 1133, 1133, 
	1133, 1346, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1347, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1348, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1349, 1133, 1350, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1351, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1324, 1133, 
	1133, 1133, 1352, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1133, 1133, 1133, 1133, 1133, 
	1324, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1317, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1353, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1354, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1334, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1355, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1175, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1356, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1357, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1317, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1324, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1133, 1358, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1324, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1359, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1360, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1361, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1334, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1362, 1133, 1133, 
	1133, 1363, 1133, 1133, 1133, 1133, 1133, 1364, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1365, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1331, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1317, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1366, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1133, 1367, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1368, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1369, 1370, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1317, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1371, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1372, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1133, 1133, 1133, 1133, 1358, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1373, 1133, 1133, 
	1374, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1317, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1375, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1331, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1376, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1377, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1378, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1133, 1317, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1379, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1380, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1366, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1381, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1382, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1133, 1328, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1357, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1383, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1384, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1385, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1386, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1133, 1133, 1133, 1133, 1387, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1133, 1323, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1133, 1133, 1133, 
	1133, 1388, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1389, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1358, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1390, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1358, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1133, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1391, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1133, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1133, 1299, 1133, 1133, 1133, 1133, 1328, 
	1133, 1133, 1133, 1392, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1133, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1299, 1299, 1299, 
	1299, 1299, 1185, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1133, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1393, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1133, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1299, 1299, 
	1299, 1299, 1299, 1185, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1133, 1299, 1133, 1133, 1133, 
	1133, 1358, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1133, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1299, 
	1299, 1299, 1299, 1299, 1185, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1133, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1394, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1133, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1299, 1299, 1299, 1299, 1299, 1185, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1133, 1299, 1133, 
	1133, 1133, 1133, 1395, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1133, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1185, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1299, 1299, 1299, 1299, 1299, 1185, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1133, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1396, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1133, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1185, 1299, 1299, 1299, 1299, 1299, 1299, 
	1299, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1299, 1299, 1299, 1299, 1299, 1185, 
	1299, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1133, 
	1299, 1133, 1133, 1133, 1366, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1133, 1133, 1133, 1133, 1133, 
	1133, 1133, 1133, 1299, 1299, 1299, 1299, 1299, 
	1133, 1397, 1201, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1191, 1191, 1191, 1191, 1191, 1191, 1191, 
	1191, 1142, 1191, 1398, 1400, 1399, 1400, 1400, 
	1400, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 
	1399, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 
	1399, 1399, 1399, 1400, 1399, 1399, 1399, 1399, 
	1399, 1401, 1399, 1399, 1399, 1399, 1399, 1399, 
	1399, 298, 1399, 296, 1402, 296, 296, 296, 
	1402, 1402, 1402, 1402, 1402, 1402, 1402, 1402, 
	1402, 1402, 1402, 1402, 1402, 1402, 1402, 1402, 
	1402, 1402, 296, 1402, 1402, 1402, 1402, 1402, 
	297, 1402, 1402, 1402, 1402, 1402, 1402, 1402, 
	298, 1402, 299, 1402, 1404, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1405, 
	1403, 1404, 1403, 1404, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1407, 1403, 
	1404, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1408, 1403, 1404, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1403, 1403, 1403, 1403, 1403, 1403, 1403, 1403, 
	1409, 1403, 1411, 1409, 0
]

class << self
	attr_accessor :_lex_trans_targs
	private :_lex_trans_targs, :_lex_trans_targs=
end
self._lex_trans_targs = [
	165, 2, 3, 4, 171, 6, 7, 8, 
	9, 10, 165, 165, 174, 177, 174, 12, 
	178, 14, 174, 185, 186, 189, 190, 196, 
	191, 192, 193, 19, 194, 195, 198, 200, 
	201, 202, 203, 204, 25, 18, 187, 188, 
	27, 236, 237, 239, 241, 239, 30, 242, 
	32, 239, 249, 250, 253, 254, 260, 255, 
	256, 257, 37, 258, 259, 262, 264, 265, 
	266, 267, 268, 43, 36, 251, 252, 45, 
	300, 301, 308, 310, 308, 48, 311, 50, 
	313, 316, 313, 52, 317, 54, 323, 322, 
	0, 56, 324, 325, 58, 326, 327, 327, 
	327, 327, 440, 61, 62, 63, 440, 468, 
	64, 65, 468, 468, 472, 472, 69, 64, 
	70, 470, 471, 473, 474, 472, 468, 475, 
	476, 478, 66, 67, 479, 480, 68, 472, 
	71, 72, 77, 84, 482, 483, 70, 470, 
	471, 473, 474, 472, 468, 475, 476, 478, 
	66, 67, 479, 480, 68, 71, 72, 77, 
	84, 482, 483, 481, 73, 74, 75, 76, 
	78, 79, 82, 80, 81, 83, 85, 86, 
	468, 88, 89, 90, 92, 95, 93, 94, 
	96, 98, 499, 499, 499, 500, 100, 502, 
	101, 503, 102, 500, 100, 502, 101, 503, 
	537, 537, 537, 105, 106, 107, 108, 548, 
	537, 537, 553, 537, 537, 574, 537, 112, 
	575, 581, 115, 118, 120, 122, 123, 124, 
	118, 119, 585, 119, 585, 121, 537, 599, 
	600, 603, 604, 610, 605, 606, 607, 129, 
	608, 609, 612, 614, 615, 616, 617, 618, 
	135, 128, 601, 602, 137, 654, 655, 139, 
	539, 103, 541, 141, 142, 657, 758, 144, 
	145, 146, 758, 766, 766, 766, 149, 787, 
	786, 766, 789, 791, 776, 823, 155, 156, 
	157, 161, 162, 155, 156, 157, 161, 162, 
	158, 158, 156, 157, 159, 160, 158, 158, 
	156, 157, 159, 160, 870, 156, 766, 939, 
	163, 164, 939, 939, 165, 165, 166, 167, 
	168, 170, 172, 173, 165, 165, 165, 169, 
	165, 169, 165, 1, 165, 165, 165, 5, 
	174, 174, 175, 174, 176, 179, 174, 174, 
	11, 13, 174, 174, 174, 180, 181, 182, 
	15, 21, 26, 205, 28, 174, 174, 174, 
	183, 184, 174, 16, 174, 174, 174, 17, 
	174, 174, 174, 20, 197, 199, 22, 174, 
	174, 23, 24, 174, 206, 210, 214, 207, 
	208, 209, 211, 212, 213, 174, 174, 215, 
	219, 225, 216, 223, 224, 217, 221, 222, 
	218, 220, 174, 226, 235, 234, 227, 228, 
	229, 230, 231, 232, 233, 174, 174, 174, 
	238, 239, 239, 239, 240, 243, 239, 29, 
	31, 239, 239, 239, 244, 245, 246, 33, 
	39, 44, 269, 46, 239, 239, 239, 247, 
	248, 239, 34, 239, 239, 239, 35, 239, 
	239, 239, 38, 261, 263, 40, 239, 239, 
	41, 42, 239, 270, 274, 278, 271, 272, 
	273, 275, 276, 277, 239, 239, 279, 283, 
	289, 280, 287, 288, 281, 285, 286, 282, 
	284, 239, 290, 299, 298, 291, 292, 293, 
	294, 295, 296, 297, 239, 239, 239, 302, 
	303, 303, 304, 303, 305, 303, 303, 303, 
	306, 306, 306, 307, 306, 306, 306, 308, 
	308, 308, 309, 308, 47, 49, 308, 308, 
	312, 312, 312, 313, 313, 314, 313, 315, 
	313, 313, 51, 53, 313, 313, 318, 318, 
	319, 318, 318, 320, 321, 320, 55, 57, 
	322, 322, 322, 328, 327, 327, 329, 330, 
	331, 332, 334, 337, 338, 339, 340, 327, 
	341, 342, 344, 346, 347, 348, 352, 354, 
	355, 356, 372, 377, 384, 389, 396, 403, 
	406, 407, 411, 405, 415, 423, 427, 429, 
	434, 436, 439, 327, 327, 327, 327, 327, 
	327, 333, 327, 333, 327, 335, 59, 336, 
	327, 60, 327, 327, 343, 345, 327, 349, 
	350, 351, 347, 353, 327, 357, 358, 367, 
	370, 359, 360, 361, 362, 363, 364, 365, 
	366, 328, 368, 369, 371, 373, 376, 374, 
	375, 378, 381, 379, 380, 382, 383, 385, 
	387, 386, 388, 390, 391, 327, 392, 393, 
	394, 395, 327, 397, 400, 398, 399, 401, 
	402, 404, 408, 409, 410, 412, 414, 413, 
	416, 417, 418, 420, 419, 421, 422, 424, 
	425, 426, 428, 430, 431, 432, 433, 435, 
	437, 438, 441, 440, 440, 442, 443, 445, 
	440, 440, 440, 444, 440, 444, 446, 440, 
	448, 447, 447, 451, 452, 453, 454, 447, 
	456, 457, 458, 459, 461, 463, 464, 465, 
	466, 467, 447, 449, 447, 450, 447, 447, 
	447, 447, 447, 455, 447, 455, 460, 447, 
	462, 447, 468, 468, 469, 484, 485, 471, 
	487, 488, 475, 489, 490, 491, 492, 493, 
	495, 496, 497, 498, 468, 468, 468, 468, 
	468, 468, 472, 477, 468, 468, 468, 468, 
	468, 468, 468, 468, 468, 486, 468, 486, 
	468, 468, 468, 468, 494, 468, 87, 91, 
	97, 499, 501, 504, 99, 499, 499, 500, 
	505, 505, 506, 507, 509, 511, 512, 505, 
	505, 508, 505, 508, 505, 510, 505, 505, 
	505, 514, 513, 513, 515, 516, 517, 519, 
	521, 522, 527, 534, 513, 513, 513, 513, 
	518, 513, 518, 513, 520, 513, 513, 514, 
	523, 524, 525, 526, 528, 529, 532, 530, 
	531, 533, 535, 536, 538, 537, 546, 547, 
	549, 550, 552, 554, 555, 556, 558, 559, 
	560, 562, 563, 584, 587, 588, 589, 657, 
	658, 659, 660, 661, 557, 663, 679, 684, 
	691, 696, 698, 704, 707, 708, 712, 706, 
	716, 727, 731, 734, 742, 746, 749, 750, 
	537, 103, 540, 537, 537, 542, 544, 545, 
	537, 543, 537, 537, 537, 537, 537, 104, 
	537, 537, 537, 537, 537, 551, 537, 551, 
	537, 537, 109, 537, 537, 110, 537, 537, 
	557, 537, 561, 537, 564, 573, 537, 111, 
	576, 577, 578, 537, 579, 113, 582, 114, 
	116, 583, 537, 565, 567, 537, 566, 537, 
	537, 568, 571, 572, 537, 569, 570, 537, 
	537, 537, 537, 580, 117, 586, 537, 537, 
	590, 537, 537, 537, 591, 593, 537, 592, 
	537, 592, 537, 594, 595, 596, 125, 131, 
	136, 619, 138, 537, 537, 537, 597, 598, 
	537, 126, 537, 537, 537, 127, 537, 537, 
	537, 130, 611, 613, 132, 537, 537, 133, 
	134, 537, 620, 624, 628, 621, 622, 623, 
	625, 626, 627, 537, 537, 629, 633, 639, 
	630, 637, 638, 631, 635, 636, 632, 634, 
	537, 640, 648, 653, 641, 642, 643, 644, 
	645, 646, 647, 649, 650, 651, 652, 537, 
	537, 537, 656, 140, 143, 537, 662, 537, 
	664, 665, 674, 677, 666, 667, 668, 669, 
	670, 671, 672, 673, 538, 675, 676, 678, 
	680, 683, 681, 682, 685, 688, 686, 687, 
	689, 690, 692, 694, 693, 695, 697, 699, 
	701, 700, 702, 703, 705, 538, 709, 710, 
	711, 713, 715, 714, 717, 718, 719, 724, 
	720, 721, 722, 537, 538, 539, 103, 723, 
	544, 725, 726, 728, 729, 730, 732, 733, 
	735, 736, 737, 740, 738, 739, 741, 743, 
	744, 745, 747, 748, 537, 751, 751, 752, 
	753, 754, 756, 751, 751, 751, 755, 751, 
	755, 751, 757, 751, 759, 758, 758, 760, 
	761, 758, 762, 764, 758, 758, 758, 758, 
	763, 758, 763, 765, 758, 767, 766, 766, 
	770, 771, 772, 766, 773, 775, 778, 779, 
	780, 781, 782, 766, 783, 784, 788, 811, 
	815, 766, 816, 818, 820, 766, 821, 822, 
	824, 828, 830, 831, 766, 833, 851, 856, 
	863, 871, 878, 885, 890, 891, 895, 889, 
	900, 910, 916, 919, 928, 932, 936, 937, 
	938, 768, 766, 769, 766, 766, 766, 766, 
	766, 766, 774, 766, 774, 766, 147, 777, 
	766, 766, 766, 766, 766, 766, 766, 785, 
	766, 766, 148, 150, 766, 151, 795, 803, 
	806, 790, 807, 808, 796, 800, 801, 766, 
	790, 151, 792, 793, 152, 766, 792, 766, 
	766, 794, 766, 797, 799, 766, 797, 798, 
	800, 801, 799, 766, 766, 802, 766, 766, 
	804, 799, 800, 801, 804, 805, 766, 797, 
	799, 800, 801, 766, 797, 799, 800, 801, 
	766, 809, 799, 800, 801, 809, 810, 766, 
	151, 811, 790, 812, 800, 801, 813, 799, 
	151, 813, 790, 814, 817, 819, 153, 154, 
	766, 766, 825, 826, 827, 822, 829, 766, 
	766, 832, 766, 766, 834, 835, 844, 849, 
	836, 837, 838, 839, 840, 841, 842, 843, 
	767, 845, 846, 847, 848, 767, 850, 852, 
	855, 853, 854, 767, 767, 857, 860, 858, 
	859, 861, 862, 767, 864, 866, 865, 867, 
	868, 869, 766, 766, 872, 767, 873, 766, 
	874, 875, 876, 877, 768, 879, 882, 880, 
	881, 883, 884, 886, 887, 888, 767, 892, 
	893, 894, 896, 898, 899, 897, 767, 901, 
	902, 903, 906, 904, 905, 907, 908, 909, 
	911, 913, 912, 914, 915, 917, 918, 920, 
	921, 923, 926, 922, 924, 925, 927, 929, 
	930, 931, 933, 934, 935, 766, 766, 939, 
	940, 941, 939, 943, 942, 944, 942, 945, 
	946, 947, 942, 942
]

class << self
	attr_accessor :_lex_trans_actions
	private :_lex_trans_actions, :_lex_trans_actions=
end
self._lex_trans_actions = [
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 3, 4, 0, 5, 0, 
	0, 0, 6, 0, 7, 0, 8, 0, 
	7, 0, 0, 0, 0, 8, 7, 0, 
	8, 0, 7, 7, 0, 0, 0, 0, 
	0, 0, 0, 9, 0, 10, 0, 0, 
	0, 11, 0, 7, 0, 8, 0, 7, 
	0, 0, 0, 0, 8, 7, 0, 8, 
	0, 7, 7, 0, 0, 0, 0, 0, 
	0, 0, 12, 0, 13, 0, 0, 0, 
	14, 0, 15, 0, 0, 0, 0, 16, 
	0, 0, 0, 0, 0, 0, 17, 18, 
	19, 20, 21, 0, 0, 0, 22, 23, 
	0, 0, 24, 25, 26, 27, 28, 29, 
	29, 30, 31, 29, 32, 31, 33, 31, 
	29, 29, 30, 29, 34, 29, 29, 35, 
	29, 29, 29, 29, 29, 29, 0, 36, 
	37, 0, 38, 37, 39, 37, 0, 0, 
	36, 0, 40, 0, 0, 0, 0, 0, 
	0, 0, 0, 27, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	41, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 42, 43, 44, 45, 0, 0, 
	0, 45, 28, 46, 29, 29, 29, 46, 
	47, 48, 49, 0, 0, 0, 0, 0, 
	50, 51, 0, 52, 53, 0, 54, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	55, 55, 56, 0, 28, 0, 57, 0, 
	7, 0, 8, 0, 7, 0, 0, 0, 
	0, 8, 7, 0, 8, 0, 7, 7, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	58, 0, 0, 0, 0, 58, 59, 0, 
	0, 0, 60, 61, 62, 63, 0, 7, 
	7, 64, 65, 65, 0, 0, 0, 28, 
	0, 0, 0, 29, 66, 29, 29, 29, 
	67, 68, 69, 68, 68, 68, 0, 70, 
	71, 70, 70, 70, 72, 73, 74, 75, 
	0, 76, 77, 78, 81, 82, 0, 28, 
	0, 7, 0, 7, 83, 84, 85, 67, 
	86, 0, 87, 0, 88, 89, 90, 0, 
	91, 92, 0, 93, 7, 7, 94, 95, 
	0, 0, 96, 97, 98, 99, 99, 99, 
	99, 99, 99, 99, 99, 100, 101, 102, 
	0, 0, 103, 0, 104, 105, 106, 0, 
	107, 108, 109, 0, 7, 0, 0, 110, 
	111, 0, 28, 112, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 113, 114, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 115, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 116, 117, 118, 
	0, 119, 120, 121, 7, 7, 122, 0, 
	0, 123, 124, 125, 99, 99, 99, 99, 
	99, 99, 99, 99, 126, 127, 128, 0, 
	0, 129, 0, 130, 131, 132, 0, 133, 
	134, 135, 0, 7, 0, 0, 136, 137, 
	0, 28, 138, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 139, 140, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 141, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 142, 143, 144, 0, 
	145, 146, 0, 147, 0, 148, 149, 150, 
	151, 152, 153, 0, 154, 155, 156, 157, 
	158, 159, 7, 160, 0, 0, 161, 162, 
	163, 164, 165, 166, 167, 0, 168, 7, 
	169, 170, 0, 0, 171, 172, 173, 174, 
	0, 175, 176, 177, 0, 178, 0, 0, 
	179, 180, 181, 182, 183, 184, 0, 28, 
	0, 0, 7, 7, 0, 0, 0, 185, 
	0, 0, 0, 0, 186, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 187, 188, 189, 190, 191, 
	192, 67, 193, 0, 194, 0, 0, 0, 
	195, 0, 196, 197, 0, 0, 198, 0, 
	0, 0, 199, 0, 200, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 199, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 201, 0, 0, 
	0, 0, 202, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 7, 203, 204, 0, 0, 0, 
	205, 206, 207, 67, 208, 0, 28, 209, 
	0, 210, 211, 0, 28, 0, 0, 212, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 213, 0, 214, 0, 215, 216, 
	217, 218, 219, 67, 220, 0, 0, 221, 
	0, 222, 223, 224, 225, 28, 0, 27, 
	0, 0, 27, 0, 0, 0, 0, 0, 
	0, 7, 7, 7, 226, 227, 228, 229, 
	230, 231, 232, 0, 233, 234, 235, 236, 
	237, 238, 239, 240, 241, 67, 242, 0, 
	243, 244, 245, 246, 247, 248, 0, 0, 
	0, 249, 7, 7, 0, 250, 251, 252, 
	253, 254, 0, 0, 0, 0, 0, 255, 
	256, 67, 257, 0, 258, 28, 259, 260, 
	261, 262, 263, 264, 0, 28, 0, 0, 
	0, 0, 0, 0, 265, 266, 267, 268, 
	67, 269, 0, 270, 28, 271, 272, 273, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 274, 275, 0, 8, 
	0, 0, 7, 276, 0, 0, 0, 0, 
	0, 0, 7, 7, 0, 277, 0, 277, 
	277, 277, 0, 0, 277, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 0, 277, 
	278, 279, 0, 280, 281, 0, 58, 0, 
	282, 0, 283, 284, 285, 286, 287, 29, 
	288, 289, 290, 291, 292, 67, 293, 0, 
	294, 295, 0, 296, 297, 0, 298, 299, 
	276, 300, 0, 301, 0, 0, 302, 0, 
	0, 0, 0, 303, 0, 0, 0, 0, 
	0, 0, 304, 0, 0, 305, 0, 306, 
	307, 0, 0, 0, 308, 0, 0, 309, 
	310, 311, 312, 0, 0, 0, 313, 314, 
	0, 315, 316, 317, 0, 7, 318, 319, 
	320, 0, 321, 99, 99, 99, 99, 99, 
	99, 99, 99, 322, 323, 324, 0, 0, 
	325, 0, 326, 327, 328, 0, 329, 330, 
	331, 0, 7, 0, 0, 332, 333, 0, 
	28, 334, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 335, 336, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	337, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 338, 
	339, 340, 0, 0, 0, 341, 28, 342, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 58, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 343, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 344, 345, 346, 347, 348, 348, 
	344, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 274, 274, 274, 274, 
	274, 274, 274, 274, 349, 350, 351, 0, 
	28, 0, 0, 352, 353, 354, 67, 355, 
	0, 356, 28, 357, 7, 358, 359, 0, 
	28, 360, 0, 0, 361, 362, 363, 364, 
	67, 365, 0, 28, 366, 367, 368, 369, 
	0, 28, 0, 370, 0, 7, 0, 0, 
	0, 0, 0, 371, 0, 0, 372, 372, 
	0, 373, 0, 0, 0, 374, 7, 375, 
	375, 375, 0, 0, 376, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 377, 378, 0, 379, 380, 381, 382, 
	383, 384, 67, 385, 0, 386, 0, 0, 
	387, 388, 389, 390, 391, 392, 393, 0, 
	394, 395, 0, 0, 396, 397, 398, 0, 
	0, 399, 0, 0, 398, 400, 400, 401, 
	402, 0, 403, 403, 0, 404, 405, 406, 
	407, 0, 408, 398, 398, 409, 0, 0, 
	410, 410, 0, 411, 412, 0, 413, 414, 
	415, 415, 416, 416, 0, 0, 417, 418, 
	418, 419, 419, 420, 421, 421, 422, 422, 
	423, 424, 424, 425, 425, 0, 0, 426, 
	427, 428, 429, 430, 431, 431, 428, 430, 
	432, 372, 433, 0, 0, 0, 0, 0, 
	434, 435, 375, 375, 375, 436, 375, 437, 
	438, 28, 439, 440, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	441, 0, 0, 0, 0, 436, 0, 0, 
	0, 0, 0, 442, 443, 0, 0, 0, 
	0, 0, 0, 444, 0, 0, 0, 0, 
	0, 443, 445, 446, 0, 447, 0, 448, 
	0, 0, 0, 0, 449, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 450, 0, 
	0, 0, 0, 0, 0, 0, 449, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 451, 452, 453, 
	7, 76, 454, 0, 455, 0, 456, 0, 
	0, 0, 457, 458
]

class << self
	attr_accessor :_lex_to_state_actions
	private :_lex_to_state_actions, :_lex_to_state_actions=
end
self._lex_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 79, 0, 0, 
	0, 0, 0, 0, 0, 0, 79, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 79, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 79, 
	0, 0, 79, 0, 79, 0, 0, 0, 
	79, 79, 0, 0, 0, 0, 79, 0, 
	79, 0, 79, 0, 0, 0, 0, 79, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	79, 0, 0, 0, 0, 0, 0, 79, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 79, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 79, 0, 0, 0, 0, 
	0, 79, 0, 0, 0, 0, 0, 0, 
	0, 79, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 79, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 79, 
	0, 0, 0, 0, 0, 0, 79, 0, 
	0, 0, 0, 0, 0, 0, 79, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 79, 0, 0, 79, 0, 
	0, 0, 0, 0
]

class << self
	attr_accessor :_lex_from_state_actions
	private :_lex_from_state_actions, :_lex_from_state_actions=
end
self._lex_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 80, 0, 0, 
	0, 0, 0, 0, 0, 0, 80, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 80, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 80, 
	0, 0, 80, 0, 80, 0, 0, 0, 
	80, 80, 0, 0, 0, 0, 80, 0, 
	80, 0, 80, 0, 0, 0, 0, 80, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	80, 0, 0, 0, 0, 0, 0, 80, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 80, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 80, 0, 0, 0, 0, 
	0, 80, 0, 0, 0, 0, 0, 0, 
	0, 80, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 80, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 80, 
	0, 0, 0, 0, 0, 0, 80, 0, 
	0, 0, 0, 0, 0, 0, 80, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 80, 0, 0, 80, 0, 
	0, 0, 0, 0
]

class << self
	attr_accessor :_lex_eof_trans
	private :_lex_eof_trans, :_lex_eof_trans=
end
self._lex_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 13, 13, 13, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 44, 44, 44, 
	44, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 75, 
	75, 75, 75, 81, 81, 81, 81, 0, 
	0, 0, 0, 95, 97, 99, 99, 99, 
	104, 104, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 169, 
	169, 169, 169, 169, 169, 169, 169, 169, 
	169, 169, 169, 179, 181, 181, 181, 193, 
	195, 195, 195, 195, 195, 201, 193, 205, 
	205, 205, 205, 205, 205, 205, 205, 205, 
	205, 205, 205, 205, 205, 223, 223, 223, 
	223, 223, 223, 223, 223, 223, 223, 223, 
	223, 223, 223, 193, 205, 205, 205, 205, 
	255, 255, 255, 260, 262, 262, 262, 266, 
	266, 260, 266, 266, 266, 266, 266, 266, 
	266, 266, 266, 296, 296, 0, 309, 310, 
	311, 313, 315, 317, 315, 315, 0, 327, 
	328, 332, 332, 333, 342, 343, 344, 344, 
	344, 347, 347, 349, 350, 351, 351, 351, 
	353, 354, 355, 355, 351, 347, 347, 360, 
	361, 361, 361, 361, 361, 364, 364, 364, 
	364, 364, 364, 364, 364, 374, 375, 375, 
	375, 375, 387, 387, 387, 375, 375, 375, 
	375, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 398, 387, 399, 400, 400, 0, 
	407, 411, 411, 412, 421, 422, 423, 423, 
	423, 426, 426, 428, 429, 430, 430, 430, 
	432, 433, 434, 434, 430, 426, 426, 439, 
	440, 440, 440, 440, 440, 443, 443, 443, 
	443, 443, 443, 443, 443, 453, 454, 454, 
	454, 454, 466, 466, 466, 454, 454, 454, 
	454, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 477, 466, 478, 479, 479, 0, 
	486, 487, 0, 493, 0, 500, 504, 504, 
	0, 0, 513, 514, 518, 518, 0, 523, 
	0, 526, 0, 529, 529, 530, 531, 0, 
	572, 574, 575, 576, 577, 579, 581, 585, 
	585, 576, 576, 576, 576, 587, 576, 576, 
	581, 576, 576, 572, 591, 591, 591, 591, 
	591, 591, 581, 581, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 630, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 576, 
	0, 673, 674, 675, 677, 673, 680, 0, 
	699, 701, 703, 704, 705, 706, 707, 709, 
	706, 706, 706, 706, 706, 712, 706, 706, 
	714, 712, 712, 706, 0, 733, 734, 104, 
	104, 737, 738, 104, 734, 734, 741, 743, 
	746, 734, 747, 734, 748, 749, 751, 753, 
	734, 741, 754, 754, 743, 754, 758, 754, 
	754, 754, 754, 0, 179, 766, 767, 766, 
	766, 0, 776, 777, 779, 781, 783, 781, 
	785, 0, 797, 798, 799, 800, 802, 804, 
	806, 807, 807, 807, 807, 807, 807, 807, 
	807, 807, 807, 807, 807, 807, 807, 807, 
	807, 0, 193, 865, 868, 869, 873, 875, 
	876, 877, 878, 879, 881, 884, 885, 887, 
	889, 892, 893, 895, 896, 193, 893, 893, 
	884, 884, 884, 884, 915, 918, 920, 921, 
	925, 928, 929, 930, 931, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	884, 935, 884, 884, 884, 936, 943, 943, 
	945, 947, 956, 957, 958, 958, 958, 961, 
	961, 963, 964, 965, 965, 965, 967, 968, 
	969, 969, 965, 961, 961, 974, 975, 975, 
	975, 975, 975, 978, 978, 978, 978, 978, 
	978, 978, 978, 988, 989, 989, 989, 989, 
	1001, 1001, 1001, 989, 989, 989, 989, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1016, 1017, 1018, 
	1018, 193, 884, 884, 1022, 884, 879, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1076, 869, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1101, 884, 0, 
	1108, 1109, 1110, 1112, 1114, 1116, 0, 1125, 
	1126, 1127, 1128, 1130, 1125, 1133, 0, 266, 
	1187, 1189, 1190, 1191, 1192, 1194, 1196, 1198, 
	1201, 1201, 1192, 1192, 1204, 1205, 1192, 1192, 
	1207, 1209, 1210, 1210, 1213, 1224, 266, 1230, 
	1232, 1233, 1235, 1213, 1213, 1238, 1238, 1238, 
	1244, 1245, 1247, 1248, 1238, 1238, 1255, 1260, 
	1265, 1238, 1238, 1272, 1272, 1238, 1238, 1209, 
	1192, 1192, 1209, 1192, 1192, 1198, 266, 1289, 
	1290, 1290, 1290, 1290, 1290, 1290, 1296, 1198, 
	1299, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1339, 1340, 1300, 
	1300, 1344, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1300, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 
	1398, 1192, 1399, 0, 1403, 1403, 0, 1407, 
	1407, 1407, 1407, 1411
]

class << self
	attr_accessor :lex_start
end
self.lex_start = 165;
class << self
	attr_accessor :lex_error
end
self.lex_error = 0;

class << self
	attr_accessor :lex_en_interp_words
end
self.lex_en_interp_words = 174;
class << self
	attr_accessor :lex_en_interp_string
end
self.lex_en_interp_string = 239;
class << self
	attr_accessor :lex_en_plain_words
end
self.lex_en_plain_words = 303;
class << self
	attr_accessor :lex_en_plain_string
end
self.lex_en_plain_string = 306;
class << self
	attr_accessor :lex_en_interp_backslash_delimited
end
self.lex_en_interp_backslash_delimited = 308;
class << self
	attr_accessor :lex_en_plain_backslash_delimited
end
self.lex_en_plain_backslash_delimited = 312;
class << self
	attr_accessor :lex_en_interp_backslash_delimited_words
end
self.lex_en_interp_backslash_delimited_words = 313;
class << self
	attr_accessor :lex_en_plain_backslash_delimited_words
end
self.lex_en_plain_backslash_delimited_words = 318;
class << self
	attr_accessor :lex_en_regexp_modifiers
end
self.lex_en_regexp_modifiers = 320;
class << self
	attr_accessor :lex_en_expr_variable
end
self.lex_en_expr_variable = 322;
class << self
	attr_accessor :lex_en_expr_fname
end
self.lex_en_expr_fname = 327;
class << self
	attr_accessor :lex_en_expr_endfn
end
self.lex_en_expr_endfn = 440;
class << self
	attr_accessor :lex_en_expr_dot
end
self.lex_en_expr_dot = 447;
class << self
	attr_accessor :lex_en_expr_arg
end
self.lex_en_expr_arg = 468;
class << self
	attr_accessor :lex_en_expr_cmdarg
end
self.lex_en_expr_cmdarg = 499;
class << self
	attr_accessor :lex_en_expr_endarg
end
self.lex_en_expr_endarg = 505;
class << self
	attr_accessor :lex_en_expr_mid
end
self.lex_en_expr_mid = 513;
class << self
	attr_accessor :lex_en_expr_beg
end
self.lex_en_expr_beg = 537;
class << self
	attr_accessor :lex_en_expr_labelarg
end
self.lex_en_expr_labelarg = 751;
class << self
	attr_accessor :lex_en_expr_value
end
self.lex_en_expr_value = 758;
class << self
	attr_accessor :lex_en_expr_end
end
self.lex_en_expr_end = 766;
class << self
	attr_accessor :lex_en_leading_dot
end
self.lex_en_leading_dot = 939;
class << self
	attr_accessor :lex_en_line_comment
end
self.lex_en_line_comment = 942;
class << self
	attr_accessor :lex_en_line_begin
end
self.lex_en_line_begin = 165;


# line 82 "lib/parser/lexer.rl"
  # %

  ESCAPES = {
    ?a.ord => "\a", ?b.ord  => "\b", ?e.ord => "\e", ?f.ord => "\f",
    ?n.ord => "\n", ?r.ord  => "\r", ?s.ord => "\s", ?t.ord => "\t",
    ?v.ord => "\v", ?\\.ord => "\\"
  }.freeze

  REGEXP_META_CHARACTERS = Regexp.union(*"\\$()*+.<>?[]^{|}".chars).freeze

  RBRACE_OR_RBRACK = %w"} ]".freeze

  attr_reader   :source_buffer

  attr_accessor :diagnostics
  attr_accessor :static_env
  attr_accessor :force_utf32

  attr_accessor :cond, :cmdarg, :in_kwarg

  attr_accessor :tokens, :comments

  def initialize(version)
    @version    = version
    @static_env = nil

    @tokens     = nil
    @comments   = nil

    reset
  end

  def reset(reset_state=true)
    # Ragel state:
    if reset_state
      # Unit tests set state prior to resetting lexer.
      @cs     = self.class.lex_en_line_begin

      @cond   = StackState.new('cond')
      @cmdarg = StackState.new('cmdarg')
      @cond_stack   = []
      @cmdarg_stack = []
    end

    @force_utf32   = false # Set to true by some tests

    @source_pts    = nil # @source as a codepoint array

    @p             = 0   # stream position (saved manually in #advance)
    @ts            = nil # token start
    @te            = nil # token end
    @act           = 0   # next action

    @stack         = []  # state stack
    @top           = 0   # state stack top pointer

    # Lexer state:
    @token_queue   = []
    @literal_stack = []

    @eq_begin_s    = nil # location of last encountered =begin
    @sharp_s       = nil # location of last encountered #

    @newline_s     = nil # location of last encountered newline

    @num_base      = nil # last numeric base
    @num_digits_s  = nil # starting position of numeric digits
    @num_suffix_s  = nil # starting position of numeric suffix
    @num_xfrm      = nil # numeric suffix-induced transformation

    @escape_s      = nil # starting position of current sequence
    @escape        = nil # last escaped sequence, as string

    @herebody_s    = nil # starting position of current heredoc line

    # Ruby 1.9 ->() lambdas emit a distinct token if do/{ is
    # encountered after a matching closing parenthesis.
    @paren_nest    = 0
    @lambda_stack  = []

    # After encountering the closing line of <<~SQUIGGLY_HEREDOC,
    # we store the indentation level and give it out to the parser
    # on request. It is not possible to infer indentation level just
    # from the AST because escape sequences such as `\ ` or `\t` are
    # expanded inside the lexer, but count as non-whitespace for
    # indentation purposes.
    @dedent_level  = nil

    # If the lexer is in `command state' (aka expr_value)
    # at the entry to #advance, it will transition to expr_cmdarg
    # instead of expr_arg at certain points.
    @command_state = false

    # True at the end of "def foo a:"
    @in_kwarg      = false
  end

  def source_buffer=(source_buffer)
    @source_buffer = source_buffer

    if @source_buffer
      source = @source_buffer.source

      if defined?(Encoding) && source.encoding == Encoding::UTF_8
        @source_pts = source.unpack('U*')
      else
        @source_pts = source.unpack('C*')
      end

      if @source_pts[0] == 0xfeff
        # Skip byte order mark.
        @p = 1
      end
    else
      @source_pts = nil
    end
  end

  def encoding
    @source_buffer.source.encoding
  end

  LEX_STATES = {
    :line_begin    => lex_en_line_begin,
    :expr_dot      => lex_en_expr_dot,
    :expr_fname    => lex_en_expr_fname,
    :expr_value    => lex_en_expr_value,
    :expr_beg      => lex_en_expr_beg,
    :expr_mid      => lex_en_expr_mid,
    :expr_arg      => lex_en_expr_arg,
    :expr_cmdarg   => lex_en_expr_cmdarg,
    :expr_end      => lex_en_expr_end,
    :expr_endarg   => lex_en_expr_endarg,
    :expr_endfn    => lex_en_expr_endfn,
    :expr_labelarg => lex_en_expr_labelarg,

    :interp_string => lex_en_interp_string,
    :interp_words  => lex_en_interp_words,
    :plain_string  => lex_en_plain_string,
    :plain_words   => lex_en_plain_string,
  }

  def state
    LEX_STATES.invert.fetch(@cs, @cs)
  end

  def state=(state)
    @cs = LEX_STATES.fetch(state)
  end

  def push_cmdarg
    @cmdarg_stack.push(@cmdarg)
    @cmdarg = StackState.new("cmdarg.#{@cmdarg_stack.count}")
  end

  def pop_cmdarg
    @cmdarg = @cmdarg_stack.pop
  end

  def push_cond
    @cond_stack.push(@cond)
    @cond = StackState.new("cond.#{@cond_stack.count}")
  end

  def pop_cond
    @cond = @cond_stack.pop
  end

  def dedent_level
    # We erase @dedent_level as a precaution to avoid accidentally
    # using a stale value.
    dedent_level, @dedent_level = @dedent_level, nil
    dedent_level
  end

  # Return next token: [type, value].
  def advance
    if @token_queue.any?
      return @token_queue.shift
    end

    # Ugly, but dependent on Ragel output. Consider refactoring it somehow.
    klass = self.class
    _lex_trans_keys         = klass.send :_lex_trans_keys
    _lex_key_spans          = klass.send :_lex_key_spans
    _lex_index_offsets      = klass.send :_lex_index_offsets
    _lex_indicies           = klass.send :_lex_indicies
    _lex_trans_targs        = klass.send :_lex_trans_targs
    _lex_trans_actions      = klass.send :_lex_trans_actions
    _lex_to_state_actions   = klass.send :_lex_to_state_actions
    _lex_from_state_actions = klass.send :_lex_from_state_actions
    _lex_eof_trans          = klass.send :_lex_eof_trans

    pe = @source_pts.size + 2
    p, eof = @p, pe

    @command_state = (@cs == klass.lex_en_expr_value ||
                      @cs == klass.lex_en_line_begin)

    
# line 10920 "lib/parser/lexer.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _lex_from_state_actions[ @cs] 
	when 80 then
# line 1 "NONE"
		begin
 @ts = p
		end
# line 10948 "lib/parser/lexer.rb"
	end
	_keys =  @cs << 1
	_inds = _lex_index_offsets[ @cs]
	_slen = _lex_key_spans[ @cs]
	_wide = ( (@source_pts[p] || 0))
	_trans = if (   _slen > 0 && 
			_lex_trans_keys[_keys] <= _wide && 
			_wide <= _lex_trans_keys[_keys + 1] 
		    ) then
			_lex_indicies[ _inds + _wide - _lex_trans_keys[_keys] ] 
		 else 
			_lex_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	 @cs = _lex_trans_targs[_trans]
	if _lex_trans_actions[_trans] != 0
	case _lex_trans_actions[_trans]
	when 28 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 99 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 29 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
	when 67 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
	when 70 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 279 then
# line 1172 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 36 then
# line 1441 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 38 then
# line 1457 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 40 then
# line 1485 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 55 then
# line 1678 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
	when 319 then
# line 1732 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
	when 348 then
# line 1805 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 424 then
# line 2023 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
	when 418 then
# line 2024 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
	when 421 then
# line 2025 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
	when 415 then
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
	when 430 then
# line 2027 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
	when 398 then
# line 2028 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
	when 410 then
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 405 then
# line 2086 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 403 then
# line 2087 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 76 then
# line 2222 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 7 then
# line 1 "NONE"
		begin
 @te = p+1
		end
	when 96 then
# line 1013 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 758
		_goto_level = _again
		next
	end

   end
		end
	when 5 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end

   end
		end
	when 92 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 91 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 97 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end

   end
		end
	when 94 then
# line 945 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 95 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 6 then
# line 845 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 4 then
# line 821 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 123 then
# line 1013 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 758
		_goto_level = _again
		next
	end

   end
		end
	when 10 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end

   end
		end
	when 120 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 119 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 124 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end

   end
		end
	when 122 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 11 then
# line 845 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 9 then
# line 821 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 146 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 145 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 148 then
# line 945 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 149 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 152 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 151 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 154 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 161 then
# line 1013 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 758
		_goto_level = _again
		next
	end

   end
		end
	when 13 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end

   end
		end
	when 158 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 157 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 162 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end

   end
		end
	when 160 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 12 then
# line 821 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 164 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 163 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 171 then
# line 1013 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 758
		_goto_level = _again
		next
	end

   end
		end
	when 15 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end

   end
		end
	when 167 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 166 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 172 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end

   end
		end
	when 169 then
# line 945 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 170 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 14 then
# line 821 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 174 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 173 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 751;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 176 then
# line 945 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 177 then
# line 1103 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tREGEXP_OPT, tok(@ts, @te - 1), @ts, @te - 1)
        p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end

       end
		end
	when 178 then
# line 1091 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        unknown_options = tok.scan(/[^imxouesn]/)
        if unknown_options.any?
          diagnostic :error, :regexp_options,
                     { :options => unknown_options.join }
        end

        emit(:tREGEXP_OPT)
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 16 then
# line 1231 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 179 then
# line 1231 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 181 then
# line 1244 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@@[0-9]/
          diagnostic :error, :cvar_name, { :name => tok }
        end

        emit(:tCVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 180 then
# line 1254 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@[0-9]/
          diagnostic :error, :ivar_name, { :name => tok }
        end

        emit(:tIVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 202 then
# line 1275 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(KEYWORDS_BEGIN);
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 188 then
# line 1283 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tIDENTIFIER)
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 18 then
# line 1287 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
            @cs = 766; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end
  end
		end
	when 185 then
# line 1296 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 197 then
# line 1300 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 20 then
# line 1306 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if version?(23)
          type, delimiter = tok[0..-2], tok[-1].chr
          	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

        else
          p = @ts - 1
          	begin
		 @cs = 766
		_goto_level = _again
		next
	end

        end
       end
		end
	when 184 then
# line 1319 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 183 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 201 then
# line 1275 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS_BEGIN);
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 198 then
# line 1279 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 200 then
# line 1283 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 195 then
# line 1287 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
            @cs = 766; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end
  end
		end
	when 191 then
# line 1296 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 196 then
# line 1303 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 189 then
# line 1316 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 194 then
# line 1319 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 19 then
# line 1296 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit_table(PUNCTUATION)
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 17 then
# line 1319 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 187 then
# line 1 "NONE"
		begin
	case  @act
	when 39 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN);
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 40 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 41 then
	begin begin p = (( @te))-1; end
 emit(:tIDENTIFIER)
            @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 22 then
# line 1331 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           p = p - 1;  @cs = 751; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 204 then
# line 1337 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 203 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 206 then
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 205 then
# line 1337 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 21 then
# line 1337 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 212 then
# line 1363 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 468; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 211 then
# line 1369 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 210 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 222 then
# line 1348 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 213 then
# line 1352 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 218 then
# line 1363 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 468; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 216 then
# line 1366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 221 then
# line 1369 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 245 then
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 766
		_goto_level = _again
		next
	end

       end
		end
	when 228 then
# line 1445 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 537
		_goto_level = _again
		next
	end

       end
		end
	when 234 then
# line 1469 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 24 then
# line 1477 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 236 then
# line 1486 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 39 then
# line 1495 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 766
		_goto_level = _again
		next
	end

       end
		end
	when 223 then
# line 1509 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 224 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 235 then
# line 1436 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 231 then
# line 1458 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 537
		_goto_level = _again
		next
	end

       end
		end
	when 233 then
# line 1474 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 227 then
# line 1495 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 766
		_goto_level = _again
		next
	end

       end
		end
	when 226 then
# line 1500 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 244 then
# line 1509 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 25 then
# line 1500 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 41 then
# line 1509 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 23 then
# line 1 "NONE"
		begin
	case  @act
	when 67 then
	begin begin p = (( @te))-1; end

        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 537
		_goto_level = _again
		next
	end

      end
	when 68 then
	begin begin p = (( @te))-1; end

        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 537
		_goto_level = _again
		next
	end

      end
	when 73 then
	begin begin p = (( @te))-1; end

        p = @ts - 1
        	begin
		 @cs = 766
		_goto_level = _again
		next
	end

      end
	else
	begin begin p = (( @te))-1; end
end
end 
			end
	when 43 then
# line 1545 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 468
		_goto_level = _again
		next
	end
  end
		end
	when 249 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 250 then
# line 1545 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 468
		_goto_level = _again
		next
	end
  end
		end
	when 44 then
# line 1545 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1
           	begin
		 @cs = 468
		_goto_level = _again
		next
	end
  end
		end
	when 42 then
# line 1 "NONE"
		begin
	case  @act
	when 80 then
	begin begin p = (( @te))-1; end

        if @cond.active?
          emit(:kDO_COND, 'do'.freeze, @te - 2, @te)
        else
          emit(:kDO, 'do'.freeze, @te - 2, @te)
        end
         @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 81 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 468
		_goto_level = _again
		next
	end
 end
end 
			end
	when 260 then
# line 1579 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_do(true)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 253 then
# line 1585 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 254 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 255 then
# line 1582 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 258 then
# line 1585 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 264 then
# line 1609 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 263 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 272 then
# line 1601 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 266 then
# line 1603 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 270 then
# line 1609 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 265 then
# line 1 "NONE"
		begin
	case  @act
	when 88 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 89 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
 end
end 
			end
	when 300 then
# line 1626 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;
        if tok.start_with? '-'.freeze
          emit(:tUMINUS_NUM, '-'.freeze, @ts, @ts + 1)
           @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 301 then
# line 1646 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type = delimiter = tok[0].chr
        p = p - 1; 	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 295 then
# line 1653 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = @source_buffer.slice(@ts).chr, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 51 then
# line 1660 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 302 then
# line 1706 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 54 then
# line 1720 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 316 then
# line 1751 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 766
		_goto_level = _again
		next
	end

       end
		end
	when 315 then
# line 1761 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 303 then
# line 1800 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 48 then
# line 1820 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;

        if version?(18)
          ident = tok(@ts, @te - 2)

          emit((@source_buffer.slice(@ts) =~ /[A-Z]/) ? :tCONSTANT : :tIDENTIFIER,
               ident, @ts, @te - 2)
          p = p - 1; # continue as a symbol

          if !@static_env.nil? && @static_env.declared?(ident)
             @cs = 766;
          else
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           @cs = 751;
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 289 then
# line 1866 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 165
		_goto_level = _again
		next
	end
  end
		end
	when 52 then
# line 1879 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 275 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 299 then
# line 1636 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tSTAR, '*'.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 296 then
# line 1660 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 294 then
# line 1666 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 304 then
# line 1720 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 314 then
# line 1761 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 320 then
# line 1767 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 766
		_goto_level = _again
		next
	end

       end
		end
	when 297 then
# line 1800 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 342 then
# line 1216 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 286 then
# line 1863 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 288 then
# line 1866 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 165
		_goto_level = _again
		next
	end
  end
		end
	when 291 then
# line 1879 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 50 then
# line 1666 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 57 then
# line 1734 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 49 then
# line 1863 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 53 then
# line 1879 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 47 then
# line 1 "NONE"
		begin
	case  @act
	when 111 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 112 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 513; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 113 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 115 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 766
		_goto_level = _again
		next
	end
 end
	when 116 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 119 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
 end
end 
			end
	when 350 then
# line 1899 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 351 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 352 then
# line 1887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 356 then
# line 1899 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 60 then
# line 1909 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 360 then
# line 1914 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        	begin
		 @cs = (push_literal(tok, tok, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 359 then
# line 1924 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 358 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 362 then
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 361 then
# line 1924 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 59 then
# line 1924 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 537
		_goto_level = _again
		next
	end
  end
		end
	when 392 then
# line 1935 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tLAMBDA, '->'.freeze, @ts, @ts + 2)

        @lambda_stack.push @paren_nest
         @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 74 then
# line 1972 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 370 then
# line 2107 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts, nil, false, false, true))
		_goto_level = _again
		next
	end

       end
		end
	when 62 then
# line 2125 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end
  end
		end
	when 389 then
# line 2132 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 447; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 383 then
# line 2159 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 376 then
# line 2163 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)
        @cond.lexpop; @cmdarg.lexpop

        if RBRACE_OR_RBRACK.include?(tok)
           @cs = 505;
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 388 then
# line 2177 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tOP_ASGN, tok(@ts, @te - 1))
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 374 then
# line 2181 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tEH, '?'.freeze)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 371 then
# line 2189 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 373 then
# line 2202 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tSEMI, ';'.freeze)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 438 then
# line 2205 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :error, :bare_backslash, nil, range(@ts, @ts + 1)
        p = p - 1;
       end
		end
	when 369 then
# line 2211 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 368 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 448 then
# line 1968 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 327; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 446 then
# line 1972 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 445 then
# line 1983 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 395 then
# line 2057 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 435 then
# line 2117 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 387 then
# line 2125 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 322
		_goto_level = _again
		next
	end
  end
		end
	when 393 then
# line 2132 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 447; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 440 then
# line 1216 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 382 then
# line 2159 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 394 then
# line 2189 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 380 then
# line 2196 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 386 then
# line 2211 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 63 then
# line 2057 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 61 then
# line 2211 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 64 then
# line 1 "NONE"
		begin
	case  @act
	when 132 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 133 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 327; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 134 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 135 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 136 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 137 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 513; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 138 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 468; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 139 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 140 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 141 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 143 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 144 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 145 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 147 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 151 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 152 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 468; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
end 
			end
	when 78 then
# line 2223 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 453 then
# line 2226 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 165; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 454 then
# line 2226 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 165; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 75 then
# line 2226 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 165; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 457 then
# line 2236 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = 165
		_goto_level = _again
		next
	end

       end
		end
	when 456 then
# line 2244 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :embedded_document, nil,
                   range(@eq_begin_s, @eq_begin_s + '=begin'.length)
       end
		end
	when 89 then
# line 2254 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 942
		_goto_level = _again
		next
	end
  end
		end
	when 2 then
# line 2258 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 81 then
# line 2261 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 758
		_goto_level = _again
		next
	end
  end
		end
	when 82 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 83 then
# line 2251 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 88 then
# line 2254 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  @eq_begin_s = @ts
           	begin
		 @cs = 942
		_goto_level = _again
		next
	end
  end
		end
	when 87 then
# line 2261 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 758
		_goto_level = _again
		next
	end
  end
		end
	when 1 then
# line 2261 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 758
		_goto_level = _again
		next
	end
  end
		end
	when 73 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 93 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 121 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 147 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 153 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 159 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 165 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 168 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 175 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 246 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 766
		_goto_level = _again
		next
	end

       end
		end
	when 237 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1486 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 229 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1495 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 766
		_goto_level = _again
		next
	end

       end
		end
	when 317 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1751 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 766
		_goto_level = _again
		next
	end

       end
		end
	when 290 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1866 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 165
		_goto_level = _again
		next
	end
  end
		end
	when 458 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2236 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = 165
		_goto_level = _again
		next
	end

       end
		end
	when 455 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2241 "lib/parser/lexer.rl"
		begin
 @te = p+1
		end
	when 90 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2254 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 942
		_goto_level = _again
		next
	end
  end
		end
	when 3 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2258 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 412 then
# line 626 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 411 then
# line 627 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, chars)) } 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 413 then
# line 628 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 406 then
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Float(chars))) } 		end
# line 2089 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 407 then
# line 636 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2089 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 408 then
# line 637 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2089 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 116 then
# line 652 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    codepoints.split(/[ \t]/).each do |codepoint_str|
      codepoint = codepoint_str.to_i(16)

      if codepoint >= 0x110000
        diagnostic :error, :unicode_point_too_large, nil,
                   range(codepoint_s, codepoint_s + codepoint_str.length)
        break
      end

      @escape     += codepoint.chr(Encoding::UTF_8)
      codepoint_s += codepoint_str.length + 1
    end
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 142 then
# line 652 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    codepoints.split(/[ \t]/).each do |codepoint_str|
      codepoint = codepoint_str.to_i(16)

      if codepoint >= 0x110000
        diagnostic :error, :unicode_point_too_large, nil,
                   range(codepoint_s, codepoint_s + codepoint_str.length)
        break
      end

      @escape     += codepoint.chr(Encoding::UTF_8)
      codepoint_s += codepoint_str.length + 1
    end
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 338 then
# line 652 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    codepoints.split(/[ \t]/).each do |codepoint_str|
      codepoint = codepoint_str.to_i(16)

      if codepoint >= 0x110000
        diagnostic :error, :unicode_point_too_large, nil,
                   range(codepoint_s, codepoint_s + codepoint_str.length)
        break
      end

      @escape     += codepoint.chr(Encoding::UTF_8)
      codepoint_s += codepoint_str.length + 1
    end
  		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 100 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 126 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 322 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 103 then
# line 679 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 129 then
# line 679 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 325 then
# line 679 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 105 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 131 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 327 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 102 then
# line 705 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 128 then
# line 705 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 324 then
# line 705 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 118 then
# line 709 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 144 then
# line 709 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 340 then
# line 709 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 113 then
# line 713 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 139 then
# line 713 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 335 then
# line 713 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 117 then
# line 717 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 143 then
# line 717 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 339 then
# line 717 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 112 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 138 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 334 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 115 then
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 141 then
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 337 then
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 101 then
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 127 then
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 323 then
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 150 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 155 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 66 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 30 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1441 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 32 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1457 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 34 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1485 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 190 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1316 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 209 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 217 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 33 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1495 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 766
		_goto_level = _again
		next
	end

       end
		end
	when 248 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1500 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 240 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1506 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 259 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1582 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 271 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1603 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 267 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1606 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 287 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1863 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 357 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 353 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1890 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
      if @in_kwarg
        p = p - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end

      else
        	begin
		 @cs = 165
		_goto_level = _again
		next
	end

      end
     end
		end
	when 366 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 363 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 165
		_goto_level = _again
		next
	end
  end
		end
	when 439 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2196 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 381 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2199 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 939
		_goto_level = _again
		next
	end
  end
		end
	when 84 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2251 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 239 then
# line 983 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1410 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          p = @ts - 1
          	begin
		 @cs = 766
		_goto_level = _again
		next
	end

        else
          emit(:tLCURLY, '{'.freeze, @te - 1, @te)
           @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 261 then
# line 983 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1568 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE_ARG, '{'.freeze)
        end
         @cs = 758;
       end
		end
	when 349 then
# line 983 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1778 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE, '{'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 451 then
# line 983 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1943 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 452 then
# line 992 "lib/parser/lexer.rl"
		begin

    current_literal = literal
    if current_literal
      if current_literal.end_interp_brace_and_try_closing
        if version?(18, 19)
          emit(:tRCURLY, '}'.freeze, p - 1, p)
        else
          emit(:tSTRING_DEND, '}'.freeze, p - 1, p)
        end

        if current_literal.saved_herebody_s
          @herebody_s = current_literal.saved_herebody_s
        end

        p = p - 1;
         @cs = (stack_pop);
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
    end
  		end
# line 2163 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
        @cond.lexpop; @cmdarg.lexpop

        if RBRACE_OR_RBRACK.include?(tok)
           @cs = 505;
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 68 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 71 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 193 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1316 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 208 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 220 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 242 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1503 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 257 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1582 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 269 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1603 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 293 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1863 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 355 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 365 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 385 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2196 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 86 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2251 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 214 then
# line 1172 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1356 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 305 then
# line 1172 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 278 then
# line 1172 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1851 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 378 then
# line 1172 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1 "NONE"
		begin
	case  @act
	when 132 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 133 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 327; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 134 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 135 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 136 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 137 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 513; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 138 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 468; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 139 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 140 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 141 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 143 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 144 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 145 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 147 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 151 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 152 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 468; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
end 
			end
	when 215 then
# line 1173 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1356 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 306 then
# line 1173 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 280 then
# line 1173 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1851 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 379 then
# line 1173 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2139 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 468; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 307 then
# line 1178 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 281 then
# line 1178 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1851 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 308 then
# line 1179 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 282 then
# line 1179 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1851 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 312 then
# line 1180 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 285 then
# line 1180 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1851 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 311 then
# line 1181 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 284 then
# line 1181 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1 "NONE"
		begin
	case  @act
	when 111 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 112 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 513; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 113 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
            @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 115 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 766
		_goto_level = _again
		next
	end
 end
	when 116 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 440; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 119 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
 end
end 
			end
	when 309 then
# line 1182 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 283 then
# line 1182 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1851 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 310 then
# line 1187 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 434 then
# line 1192 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2121 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT, tok(@ts, tm), @ts, tm)
           p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 238 then
# line 1198 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 1404 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze, @te - 1, @te)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 341 then
# line 1198 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 1790 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 437 then
# line 1198 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 2185 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK2, '['.freeze)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 230 then
# line 1205 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1385 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if version?(18)
          emit(:tLPAREN2, '('.freeze, @te - 1, @te)
           @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
           @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 243 then
# line 1205 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1398 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN2, '('.freeze)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 251 then
# line 1205 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1522 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
        if version?(18)
           @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 298 then
# line 1205 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1795 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN, '('.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 390 then
# line 1205 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 2159 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 391 then
# line 1211 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2163 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
        @cond.lexpop; @cmdarg.lexpop

        if RBRACE_OR_RBRACK.include?(tok)
           @cs = 505;
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 56 then
# line 1678 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 313 then
# line 1679 "lib/parser/lexer.rl"
		begin
 new_herebody_s = p 		end
# line 1680 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        tok(@ts, heredoc_e) =~ /^<<(-?)(~?)(["'`]?)(.*)\3$/

        indent      = !$1.empty? || !$2.empty?
        dedent_body = !$2.empty?
        type        =  $3.empty? ? '<<"'.freeze : ('<<'.freeze + $3)
        delimiter   =  $4

        if dedent_body && version?(18, 19, 20, 21, 22)
          emit(:tLSHFT, '<<'.freeze, @ts, @ts + 2)
          p = @ts + 1
           @cs = 537; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = (push_literal(type, delimiter, @ts, heredoc_e, indent, dedent_body));

          @herebody_s ||= new_herebody_s
          p = @herebody_s - 1
        end
       end
		end
	when 318 then
# line 1732 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 345 then
# line 1805 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1806 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 513; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 425 then
# line 2023 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 419 then
# line 2024 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 422 then
# line 2025 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 416 then
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 431 then
# line 2027 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 400 then
# line 2028 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 432 then
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 77 then
# line 2222 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2223 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 8 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 199 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1275 "lib/parser/lexer.rl"
		begin
 @act = 39;		end
	when 186 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1279 "lib/parser/lexer.rl"
		begin
 @act = 40;		end
	when 182 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1283 "lib/parser/lexer.rl"
		begin
 @act = 41;		end
	when 26 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1445 "lib/parser/lexer.rl"
		begin
 @act = 67;		end
	when 232 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1458 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 27 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1495 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 225 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1500 "lib/parser/lexer.rl"
		begin
 @act = 74;		end
	when 252 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1532 "lib/parser/lexer.rl"
		begin
 @act = 80;		end
	when 45 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1545 "lib/parser/lexer.rl"
		begin
 @act = 81;		end
	when 273 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1597 "lib/parser/lexer.rl"
		begin
 @act = 88;		end
	when 262 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1601 "lib/parser/lexer.rl"
		begin
 @act = 89;		end
	when 276 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1800 "lib/parser/lexer.rl"
		begin
 @act = 111;		end
	when 344 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1806 "lib/parser/lexer.rl"
		begin
 @act = 112;		end
	when 343 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1812 "lib/parser/lexer.rl"
		begin
 @act = 113;		end
	when 58 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1851 "lib/parser/lexer.rl"
		begin
 @act = 115;		end
	when 274 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1216 "lib/parser/lexer.rl"
		begin
 @act = 116;		end
	when 277 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1879 "lib/parser/lexer.rl"
		begin
 @act = 119;		end
	when 447 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1943 "lib/parser/lexer.rl"
		begin
 @act = 132;		end
	when 442 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1968 "lib/parser/lexer.rl"
		begin
 @act = 133;		end
	when 450 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1978 "lib/parser/lexer.rl"
		begin
 @act = 135;		end
	when 443 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1983 "lib/parser/lexer.rl"
		begin
 @act = 136;		end
	when 444 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1987 "lib/parser/lexer.rl"
		begin
 @act = 137;		end
	when 449 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1991 "lib/parser/lexer.rl"
		begin
 @act = 138;		end
	when 441 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2002 "lib/parser/lexer.rl"
		begin
 @act = 139;		end
	when 436 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2016 "lib/parser/lexer.rl"
		begin
 @act = 140;		end
	when 372 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @act = 141;		end
	when 402 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2074 "lib/parser/lexer.rl"
		begin
 @act = 144;		end
	when 65 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2089 "lib/parser/lexer.rl"
		begin
 @act = 145;		end
	when 375 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2117 "lib/parser/lexer.rl"
		begin
 @act = 147;		end
	when 367 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1216 "lib/parser/lexer.rl"
		begin
 @act = 151;		end
	when 377 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2139 "lib/parser/lexer.rl"
		begin
 @act = 152;		end
	when 156 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 106 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 132 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 328 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 111 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 137 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 333 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 110 then
# line 693 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 136 then
# line 693 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 332 then
# line 693 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 108 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 134 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 330 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 104 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 130 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 326 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 114 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 140 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 336 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 98 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 125 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 321 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 69 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 192 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1316 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 207 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 219 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 241 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1503 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 766
		_goto_level = _again
		next
	end
  end
		end
	when 256 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1582 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 268 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1603 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 292 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1863 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 354 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 364 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 384 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2196 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 85 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2251 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 427 then
# line 2027 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 397 then
# line 2028 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 409 then
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 404 then
# line 2086 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 631 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2089 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 401 then
# line 2087 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 631 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2089 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 247 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1500 "lib/parser/lexer.rl"
		begin
 @act = 74;		end
	when 35 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1495 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 46 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1545 "lib/parser/lexer.rl"
		begin
 @act = 81;		end
	when 72 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1972 "lib/parser/lexer.rl"
		begin
 @act = 134;		end
	when 37 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1457 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1458 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 347 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1805 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1851 "lib/parser/lexer.rl"
		begin
 @act = 115;		end
	when 346 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1805 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1216 "lib/parser/lexer.rl"
		begin
 @act = 116;		end
	when 428 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @act = 141;		end
	when 109 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 135 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 331 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 107 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 133 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 329 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1734 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 766; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 423 then
# line 2023 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 417 then
# line 2024 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 420 then
# line 2025 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 414 then
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 426 then
# line 2027 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 396 then
# line 2028 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2030 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 31 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1457 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1458 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 433 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2062 "lib/parser/lexer.rl"
		begin
 @act = 143;		end
	when 429 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2062 "lib/parser/lexer.rl"
		begin
 @act = 143;		end
	when 399 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2028 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2029 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2062 "lib/parser/lexer.rl"
		begin
 @act = 143;		end
# line 21474 "lib/parser/lexer.rb"
	end
	end
	end
	if _goto_level <= _again
	case _lex_to_state_actions[ @cs] 
	when 79 then
# line 1 "NONE"
		begin
 @ts = nil;		end
# line 21484 "lib/parser/lexer.rb"
	end

	if  @cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _lex_eof_trans[ @cs] > 0
		_trans = _lex_eof_trans[ @cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 282 "lib/parser/lexer.rl"
    # %

    @p = p

    if @token_queue.any?
      @token_queue.shift
    elsif @cs == klass.lex_error
      [ false, [ '$error'.freeze, range(p - 1, p) ] ]
    else
      eof = @source_pts.size
      [ false, [ '$eof'.freeze,   range(eof, eof) ] ]
    end
  end

  protected

  def eof_codepoint?(point)
    [0x04, 0x1a, 0x00].include? point
  end

  def version?(*versions)
    versions.include?(@version)
  end

  def stack_pop
    @top -= 1
    @stack[@top]
  end

  if defined?(Encoding)
    def encode_escape(ord)
      ord.chr.force_encoding(@source_buffer.source.encoding)
    end
  else
    def encode_escape(ord)
      ord.chr
    end
  end

  def tok(s = @ts, e = @te)
    @source_buffer.slice(s...e)
  end

  def range(s = @ts, e = @te)
    Parser::Source::Range.new(@source_buffer, s, e)
  end

  def emit(type, value = tok, s = @ts, e = @te)
    token = [ type, [ value, range(s, e) ] ]

    @token_queue.push(token)

    @tokens.push(token) if @tokens

    token
  end

  def emit_table(table, s = @ts, e = @te)
    value = tok(s, e)

    emit(table[value], value, s, e)
  end

  def emit_do(do_block=false)
    if @cond.active?
      emit(:kDO_COND, 'do'.freeze)
    elsif @cmdarg.active? || do_block
      emit(:kDO_BLOCK, 'do'.freeze)
    else
      emit(:kDO, 'do'.freeze)
    end
  end

  def arg_or_cmdarg
    if @command_state
      self.class.lex_en_expr_cmdarg
    else
      self.class.lex_en_expr_arg
    end
  end

  def emit_comment(s = @ts, e = @te)
    if @comments
      @comments.push(Parser::Source::Comment.new(range(s, e)))
    end

    if @tokens
      @tokens.push([ :tCOMMENT, [ tok(s, e), range(s, e) ] ])
    end

    nil
  end

  def diagnostic(type, reason, arguments=nil, location=range, highlights=[])
    @diagnostics.process(
        Parser::Diagnostic.new(type, reason, arguments, location, highlights))
  end

  #
  # === LITERAL STACK ===
  #

  def push_literal(*args)
    new_literal = Literal.new(self, *args)
    @literal_stack.push(new_literal)

    if new_literal.words? && new_literal.backslash_delimited?
      if new_literal.interpolate?
        self.class.lex_en_interp_backslash_delimited_words
      else
        self.class.lex_en_plain_backslash_delimited_words
      end
    elsif new_literal.words? && !new_literal.backslash_delimited?
      if new_literal.interpolate?
        self.class.lex_en_interp_words
      else
        self.class.lex_en_plain_words
      end
    elsif !new_literal.words? && new_literal.backslash_delimited?
      if new_literal.interpolate?
        self.class.lex_en_interp_backslash_delimited
      else
        self.class.lex_en_plain_backslash_delimited
      end
    else
      if new_literal.interpolate?
        self.class.lex_en_interp_string
      else
        self.class.lex_en_plain_string
      end
    end
  end

  def literal
    @literal_stack.last
  end

  def pop_literal
    old_literal = @literal_stack.pop

    @dedent_level = old_literal.dedent_level

    if old_literal.type == :tREGEXP_BEG
      # Fetch modifiers.
      self.class.lex_en_regexp_modifiers
    else
      self.class.lex_en_expr_end
    end
  end

  # Mapping of strings to parser tokens.

  PUNCTUATION = {
    '='   => :tEQL,     '&'   => :tAMPER2,  '|'   => :tPIPE,
    '!'   => :tBANG,    '^'   => :tCARET,   '+'   => :tPLUS,
    '-'   => :tMINUS,   '*'   => :tSTAR2,   '/'   => :tDIVIDE,
    '%'   => :tPERCENT, '~'   => :tTILDE,   ','   => :tCOMMA,
    ';'   => :tSEMI,    '.'   => :tDOT,     '..'  => :tDOT2,
    '...' => :tDOT3,    '['   => :tLBRACK2, ']'   => :tRBRACK,
    '('   => :tLPAREN2, ')'   => :tRPAREN,  '?'   => :tEH,
    ':'   => :tCOLON,   '&&'  => :tANDOP,   '||'  => :tOROP,
    '-@'  => :tUMINUS,  '+@'  => :tUPLUS,   '~@'  => :tTILDE,
    '**'  => :tPOW,     '->'  => :tLAMBDA,  '=~'  => :tMATCH,
    '!~'  => :tNMATCH,  '=='  => :tEQ,      '!='  => :tNEQ,
    '>'   => :tGT,      '>>'  => :tRSHFT,   '>='  => :tGEQ,
    '<'   => :tLT,      '<<'  => :tLSHFT,   '<='  => :tLEQ,
    '=>'  => :tASSOC,   '::'  => :tCOLON2,  '===' => :tEQQ,
    '<=>' => :tCMP,     '[]'  => :tAREF,    '[]=' => :tASET,
    '{'   => :tLCURLY,  '}'   => :tRCURLY,  '`'   => :tBACK_REF2,
    '!@'  => :tBANG,    '&.'  => :tANDDOT,
  }

  PUNCTUATION_BEGIN = {
    '&'   => :tAMPER,   '*'   => :tSTAR,    '**'  => :tDSTAR,
    '+'   => :tUPLUS,   '-'   => :tUMINUS,  '::'  => :tCOLON3,
    '('   => :tLPAREN,  '{'   => :tLBRACE,  '['   => :tLBRACK,
  }

  KEYWORDS = {
    'if'     => :kIF_MOD,      'unless'   => :kUNLESS_MOD,
    'while'  => :kWHILE_MOD,   'until'    => :kUNTIL_MOD,
    'rescue' => :kRESCUE_MOD,  'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  KEYWORDS_BEGIN = {
    'if'     => :kIF,          'unless'   => :kUNLESS,
    'while'  => :kWHILE,       'until'    => :kUNTIL,
    'rescue' => :kRESCUE,      'defined?' => :kDEFINED,
  }

  %w(class module def undef begin end then elsif else ensure case when
     for break next redo retry in do return yield super self nil true
     false and or not alias __FILE__ __LINE__ __ENCODING__).each do |keyword|
    KEYWORDS_BEGIN[keyword] = KEYWORDS[keyword] = :"k#{keyword.upcase}"
  end

  
# line 2266 "lib/parser/lexer.rl"

  # %
end
