
#line 1 "ragel/i18n/sr_latn.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/sr_latn.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_sr_latn/gherkin_lexer_sr_latn.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 20, 21, 22, 41, 42, 43, 
	45, 47, 52, 57, 62, 67, 71, 75, 
	77, 78, 79, 80, 81, 82, 83, 84, 
	85, 86, 87, 88, 89, 90, 91, 92, 
	93, 95, 97, 102, 109, 114, 115, 116, 
	117, 118, 119, 120, 121, 122, 123, 124, 
	125, 126, 127, 128, 129, 130, 131, 132, 
	145, 147, 149, 151, 153, 155, 157, 159, 
	161, 163, 165, 167, 169, 171, 173, 175, 
	177, 179, 181, 183, 185, 187, 189, 191, 
	193, 195, 197, 199, 201, 220, 222, 223, 
	225, 226, 228, 229, 230, 231, 232, 233, 
	234, 251, 253, 255, 257, 259, 261, 263, 
	265, 267, 269, 271, 273, 275, 277, 279, 
	281, 283, 285, 287, 289, 291, 293, 295, 
	297, 299, 301, 303, 305, 307, 309, 311, 
	313, 315, 317, 320, 322, 324, 326, 329, 
	331, 334, 336, 338, 340, 342, 344, 346, 
	348, 350, 352, 354, 356, 358, 360, 362, 
	364, 366, 368, 370, 372, 374, 377, 379, 
	381, 384, 386, 388, 389, 390, 391, 392, 
	393, 394, 395, 412, 414, 416, 418, 420, 
	422, 424, 426, 428, 430, 432, 434, 436, 
	438, 440, 442, 444, 446, 448, 450, 452, 
	454, 456, 458, 460, 462, 464, 466, 468, 
	470, 472, 474, 477, 479, 482, 484, 486, 
	488, 490, 492, 494, 496, 499, 501, 504, 
	506, 508, 510, 512, 514, 516, 518, 520, 
	522, 524, 526, 528, 532, 534, 536, 538, 
	540, 542, 544, 546, 548, 550, 552, 554, 
	556, 558, 560, 562, 564, 566, 568, 570, 
	572, 574, 576, 578, 580, 582, 585, 587, 
	589, 592, 594, 596, 597, 598, 599, 601, 
	602, 604, 605, 606, 608, 609, 610, 611, 
	612, 613, 614, 615, 617, 618, 619, 620, 
	621, 622, 623, 624, 625, 626, 628, 629, 
	630, 647, 649, 651, 653, 655, 657, 659, 
	661, 663, 665, 667, 669, 671, 673, 675, 
	677, 679, 681, 683, 685, 687, 689, 691, 
	693, 695, 697, 699, 701, 703, 705, 707, 
	709, 712, 714, 717, 719, 722, 724, 726, 
	728, 730, 732, 734, 736, 739, 741, 744, 
	746, 748, 751, 753, 755, 757, 759, 761, 
	763, 766, 768, 770, 772, 774, 776, 778, 
	780, 784, 786, 788, 790, 792, 794, 796, 
	798, 800, 802, 804, 806, 808, 810, 812, 
	814, 816, 818, 820, 822, 824, 826, 828, 
	830, 832, 834, 837, 839, 841, 844, 846, 
	848, 849, 850, 851, 860, 862, 864, 866, 
	868, 870, 872, 874, 876, 878, 880, 882, 
	884, 886, 888, 890, 892, 894, 897, 899, 
	901, 903, 905, 907, 909, 911, 914, 915, 
	916, 917, 918, 919, 921, 922, 923, 924, 
	925, 926, 927, 928, 929, 930, 931, 932, 
	933, 934, 935, 936, 937, 938, 939, 940, 
	941, 942, 943, 945, 946, 947, 949, 950, 
	951, 955, 961, 964, 966, 972, 991, 993, 
	995, 998, 1000, 1002, 1004, 1006, 1008, 1010, 
	1012, 1015, 1017, 1019, 1022, 1024, 1026, 1028, 
	1030, 1032, 1034, 1037, 1039, 1041, 1043, 1045, 
	1047, 1049, 1051, 1054, 1058, 1060, 1062, 1064, 
	1066, 1068, 1071, 1073, 1075, 1077, 1079, 1081, 
	1083, 1085, 1087, 1089, 1091, 1093, 1095, 1097, 
	1099, 1101, 1103, 1105, 1107, 1109
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	65, 70, 73, 75, 77, 79, 80, 83, 
	90, 124, 9, 13, -69, -65, 10, 32, 
	34, 35, 37, 42, 64, 65, 70, 73, 
	75, 77, 79, 80, 83, 90, 124, 9, 
	13, 34, 34, 10, 13, 10, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 9, 13, 10, 
	32, 9, 13, 10, 13, 10, 95, 70, 
	69, 65, 84, 85, 82, 69, 95, 69, 
	78, 68, 95, 37, 32, 10, 13, 10, 
	13, 13, 32, 64, 9, 10, 9, 10, 
	13, 32, 64, 11, 12, 10, 32, 64, 
	9, 13, 108, 105, 117, 110, 107, 99, 
	105, 111, 110, 97, 108, 110, 111, 115, 
	116, 58, 10, 10, 10, 32, 35, 37, 
	64, 70, 75, 77, 79, 80, 83, 9, 
	13, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, 10, 117, 10, 
	110, 10, 107, 10, 99, 10, 105, 10, 
	111, 10, 110, 10, 97, 10, 108, 10, 
	110, 10, 111, 10, 115, 10, 116, 10, 
	58, 10, 32, 34, 35, 37, 42, 64, 
	65, 70, 73, 75, 77, 79, 80, 83, 
	90, 124, 9, 13, 97, 111, 100, 32, 
	97, 110, 99, 116, 101, 112, 116, 58, 
	10, 10, 10, 32, 35, 37, 42, 64, 
	65, 70, 73, 75, 77, 79, 80, 83, 
	90, 9, 13, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	32, 10, 108, 10, 105, 10, 117, 10, 
	110, 10, 107, 10, 99, 10, 105, 10, 
	111, 10, 110, 10, 97, 10, 108, 10, 
	110, 10, 111, 10, 115, 10, 116, 10, 
	58, 10, 97, 10, 100, 10, 32, 97, 
	10, 111, 10, 103, 10, 117, -60, 10, 
	99, -121, 10, 10, 110, 115, 10, 100, 
	10, 97, 10, 111, 10, 98, 10, 105, 
	10, 110, 10, 97, 10, 114, 10, 105, 
	10, 109, 10, 101, 10, 114, 10, 99, 
	10, 101, 10, 110, 10, 97, 10, 114, 
	10, 105, 10, 111, 10, 97, 10, 100, 
	116, 10, 97, 10, 116, 10, 101, 111, 
	10, 97, 10, 116, 101, 107, 115, 116, 
	58, 10, 10, 10, 32, 35, 37, 42, 
	64, 65, 70, 73, 75, 77, 79, 80, 
	83, 90, 9, 13, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	10, 32, 10, 108, 10, 105, 10, 117, 
	10, 110, 10, 107, 10, 99, 10, 105, 
	10, 111, 10, 110, 10, 97, 10, 108, 
	10, 110, 10, 111, 10, 115, 10, 116, 
	10, 58, 10, 97, 111, 10, 100, 10, 
	32, 97, 10, 110, 10, 99, 10, 101, 
	10, 112, 10, 111, 10, 103, 10, 117, 
	-60, 10, 99, -121, 10, 10, 110, 115, 
	10, 100, 10, 97, 10, 111, 10, 98, 
	10, 105, 10, 110, 10, 97, 10, 114, 
	10, 105, 10, 109, 10, 101, 10, 114, 
	10, 99, 107, 116, 10, 101, 10, 110, 
	10, 97, 10, 114, 10, 105, 10, 111, 
	10, 105, 10, 99, 10, 114, 10, 117, 
	10, 107, 10, 116, 10, 117, 10, 114, 
	10, 97, 10, 32, 10, 115, 10, 99, 
	10, 101, 10, 110, 10, 97, 10, 114, 
	10, 105, 10, 106, 10, 97, 10, 100, 
	116, 10, 97, 10, 116, 10, 101, 111, 
	10, 97, 10, 116, 111, 103, 117, -60, 
	99, -121, 110, 115, 100, 97, 110, 111, 
	111, 118, 97, 98, 105, 110, 97, 111, 
	114, 122, 97, 100, 105, 110, 105, 109, 
	101, 114, 58, 105, 10, 10, 10, 32, 
	35, 37, 42, 64, 65, 70, 73, 75, 
	77, 79, 80, 83, 90, 9, 13, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, 10, 32, 10, 108, 10, 
	105, 10, 117, 10, 110, 10, 107, 10, 
	99, 10, 105, 10, 111, 10, 110, 10, 
	97, 10, 108, 10, 110, 10, 111, 10, 
	115, 10, 116, 10, 58, 10, 97, 111, 
	10, 100, 10, 32, 97, 10, 110, 10, 
	99, 116, 10, 101, 10, 112, 10, 101, 
	10, 107, 10, 111, 10, 103, 10, 117, 
	-60, 10, 99, -121, 10, 10, 110, 115, 
	10, 100, 10, 97, 10, 110, 111, 10, 
	111, 10, 118, 10, 97, 10, 98, 10, 
	105, 10, 110, 10, 111, 114, 10, 122, 
	10, 97, 10, 100, 10, 105, 10, 109, 
	10, 101, 10, 114, 10, 99, 107, 116, 
	10, 101, 10, 110, 10, 97, 10, 114, 
	10, 105, 10, 111, 10, 105, 10, 99, 
	10, 114, 10, 117, 10, 107, 10, 116, 
	10, 117, 10, 114, 10, 97, 10, 32, 
	10, 115, 10, 99, 10, 101, 10, 110, 
	10, 97, 10, 114, 10, 105, 10, 106, 
	10, 97, 10, 100, 116, 10, 97, 10, 
	116, 10, 101, 111, 10, 97, 10, 116, 
	58, 10, 10, 10, 32, 35, 70, 77, 
	79, 124, 9, 13, 10, 117, 10, 110, 
	10, 107, 10, 99, 10, 105, 10, 111, 
	10, 110, 10, 97, 10, 108, 10, 110, 
	10, 111, 10, 115, 10, 116, 10, 58, 
	10, 111, 10, 103, 10, 117, -60, 10, 
	99, -121, 10, 10, 115, 10, 111, 10, 
	98, 10, 105, 10, 110, 10, 97, 99, 
	107, 116, 101, 110, 97, 114, 105, 106, 
	111, 105, 58, 105, 99, 97, 114, 117, 
	107, 116, 117, 114, 97, 32, 115, 99, 
	101, 110, 97, 114, 105, 106, 97, 100, 
	116, 97, 116, 101, 111, 97, 116, 32, 
	124, 9, 13, 10, 32, 92, 124, 9, 
	13, 10, 92, 124, 10, 92, 10, 32, 
	92, 124, 9, 13, 10, 32, 34, 35, 
	37, 42, 64, 65, 70, 73, 75, 77, 
	79, 80, 83, 90, 124, 9, 13, 10, 
	111, 10, 110, 10, 99, 116, 10, 101, 
	10, 112, 10, 101, 10, 107, 10, 111, 
	10, 103, 10, 117, -60, 10, 99, -121, 
	10, 10, 115, 10, 110, 111, 10, 111, 
	10, 118, 10, 97, 10, 98, 10, 105, 
	10, 110, 10, 111, 114, 10, 122, 10, 
	97, 10, 100, 10, 105, 10, 109, 10, 
	101, 10, 114, 10, 58, 105, 10, 99, 
	107, 116, 10, 101, 10, 110, 10, 97, 
	10, 114, 10, 105, 10, 106, 111, 10, 
	105, 10, 105, 10, 99, 10, 114, 10, 
	117, 10, 107, 10, 116, 10, 117, 10, 
	114, 10, 97, 10, 32, 10, 115, 10, 
	99, 10, 101, 10, 110, 10, 97, 10, 
	114, 10, 105, 10, 106, 0
};

static const char _lexer_single_lengths[] = {
	0, 18, 1, 1, 17, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 5, 3, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 11, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 17, 2, 1, 2, 
	1, 2, 1, 1, 1, 1, 1, 1, 
	15, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 3, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	3, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 15, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 4, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	3, 2, 2, 1, 1, 1, 2, 1, 
	2, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 2, 1, 1, 
	15, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 3, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 3, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	4, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 3, 2, 2, 
	1, 1, 1, 7, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 3, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 2, 1, 1, 2, 1, 1, 
	2, 4, 3, 2, 4, 17, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 3, 4, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 0, 0, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 20, 22, 24, 43, 45, 47, 
	50, 53, 58, 63, 68, 73, 77, 81, 
	84, 86, 88, 90, 92, 94, 96, 98, 
	100, 102, 104, 106, 108, 110, 112, 114, 
	116, 119, 122, 127, 134, 139, 141, 143, 
	145, 147, 149, 151, 153, 155, 157, 159, 
	161, 163, 165, 167, 169, 171, 173, 175, 
	188, 191, 194, 197, 200, 203, 206, 209, 
	212, 215, 218, 221, 224, 227, 230, 233, 
	236, 239, 242, 245, 248, 251, 254, 257, 
	260, 263, 266, 269, 272, 291, 294, 296, 
	299, 301, 304, 306, 308, 310, 312, 314, 
	316, 333, 336, 339, 342, 345, 348, 351, 
	354, 357, 360, 363, 366, 369, 372, 375, 
	378, 381, 384, 387, 390, 393, 396, 399, 
	402, 405, 408, 411, 414, 417, 420, 423, 
	426, 429, 432, 436, 439, 442, 445, 449, 
	452, 456, 459, 462, 465, 468, 471, 474, 
	477, 480, 483, 486, 489, 492, 495, 498, 
	501, 504, 507, 510, 513, 516, 520, 523, 
	526, 530, 533, 536, 538, 540, 542, 544, 
	546, 548, 550, 567, 570, 573, 576, 579, 
	582, 585, 588, 591, 594, 597, 600, 603, 
	606, 609, 612, 615, 618, 621, 624, 627, 
	630, 633, 636, 639, 642, 645, 648, 651, 
	654, 657, 660, 664, 667, 671, 674, 677, 
	680, 683, 686, 689, 692, 696, 699, 703, 
	706, 709, 712, 715, 718, 721, 724, 727, 
	730, 733, 736, 739, 744, 747, 750, 753, 
	756, 759, 762, 765, 768, 771, 774, 777, 
	780, 783, 786, 789, 792, 795, 798, 801, 
	804, 807, 810, 813, 816, 819, 823, 826, 
	829, 833, 836, 839, 841, 843, 845, 848, 
	850, 853, 855, 857, 860, 862, 864, 866, 
	868, 870, 872, 874, 877, 879, 881, 883, 
	885, 887, 889, 891, 893, 895, 898, 900, 
	902, 919, 922, 925, 928, 931, 934, 937, 
	940, 943, 946, 949, 952, 955, 958, 961, 
	964, 967, 970, 973, 976, 979, 982, 985, 
	988, 991, 994, 997, 1000, 1003, 1006, 1009, 
	1012, 1016, 1019, 1023, 1026, 1030, 1033, 1036, 
	1039, 1042, 1045, 1048, 1051, 1055, 1058, 1062, 
	1065, 1068, 1072, 1075, 1078, 1081, 1084, 1087, 
	1090, 1094, 1097, 1100, 1103, 1106, 1109, 1112, 
	1115, 1120, 1123, 1126, 1129, 1132, 1135, 1138, 
	1141, 1144, 1147, 1150, 1153, 1156, 1159, 1162, 
	1165, 1168, 1171, 1174, 1177, 1180, 1183, 1186, 
	1189, 1192, 1195, 1199, 1202, 1205, 1209, 1212, 
	1215, 1217, 1219, 1221, 1230, 1233, 1236, 1239, 
	1242, 1245, 1248, 1251, 1254, 1257, 1260, 1263, 
	1266, 1269, 1272, 1275, 1278, 1281, 1285, 1288, 
	1291, 1294, 1297, 1300, 1303, 1306, 1310, 1312, 
	1314, 1316, 1318, 1320, 1323, 1325, 1327, 1329, 
	1331, 1333, 1335, 1337, 1339, 1341, 1343, 1345, 
	1347, 1349, 1351, 1353, 1355, 1357, 1359, 1361, 
	1363, 1365, 1367, 1370, 1372, 1374, 1377, 1379, 
	1381, 1385, 1391, 1395, 1398, 1404, 1423, 1426, 
	1429, 1433, 1436, 1439, 1442, 1445, 1448, 1451, 
	1454, 1458, 1461, 1464, 1468, 1471, 1474, 1477, 
	1480, 1483, 1486, 1490, 1493, 1496, 1499, 1502, 
	1505, 1508, 1511, 1515, 1520, 1523, 1526, 1529, 
	1532, 1535, 1539, 1542, 1545, 1548, 1551, 1554, 
	1557, 1560, 1563, 1566, 1569, 1572, 1575, 1578, 
	1581, 1584, 1587, 1590, 1593, 1596
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 15, 17, 31, 34, 
	37, 39, 31, 85, 259, 264, 275, 413, 
	441, 448, 4, 0, 3, 0, 4, 0, 
	4, 4, 5, 15, 17, 31, 34, 37, 
	39, 31, 85, 259, 264, 275, 413, 441, 
	448, 4, 0, 6, 0, 7, 0, 9, 
	8, 8, 9, 8, 8, 10, 10, 11, 
	10, 10, 10, 10, 11, 10, 10, 10, 
	10, 12, 10, 10, 10, 10, 13, 10, 
	10, 4, 14, 14, 0, 4, 14, 14, 
	0, 4, 16, 15, 4, 0, 18, 0, 
	19, 0, 20, 0, 21, 0, 22, 0, 
	23, 0, 24, 0, 25, 0, 26, 0, 
	27, 0, 28, 0, 29, 0, 30, 0, 
	509, 0, 32, 0, 4, 16, 33, 4, 
	16, 33, 0, 0, 0, 0, 35, 36, 
	4, 36, 36, 34, 35, 35, 4, 36, 
	34, 36, 0, 38, 0, 31, 0, 40, 
	0, 41, 0, 42, 0, 43, 0, 44, 
	0, 45, 0, 46, 0, 47, 0, 48, 
	0, 49, 0, 50, 0, 51, 0, 52, 
	0, 53, 0, 55, 54, 55, 54, 55, 
	55, 4, 56, 4, 70, 454, 461, 466, 
	474, 483, 55, 54, 55, 57, 54, 55, 
	58, 54, 55, 59, 54, 55, 60, 54, 
	55, 61, 54, 55, 62, 54, 55, 63, 
	54, 55, 64, 54, 55, 65, 54, 55, 
	66, 54, 55, 67, 54, 55, 68, 54, 
	55, 69, 54, 55, 4, 54, 55, 71, 
	54, 55, 72, 54, 55, 73, 54, 55, 
	74, 54, 55, 75, 54, 55, 76, 54, 
	55, 77, 54, 55, 78, 54, 55, 79, 
	54, 55, 80, 54, 55, 81, 54, 55, 
	82, 54, 55, 83, 54, 55, 84, 54, 
	4, 4, 5, 15, 17, 31, 34, 37, 
	39, 31, 85, 259, 264, 275, 413, 441, 
	448, 4, 0, 86, 88, 0, 87, 0, 
	32, 31, 0, 89, 0, 90, 163, 0, 
	91, 0, 92, 0, 93, 0, 94, 0, 
	96, 95, 96, 95, 96, 96, 4, 97, 
	111, 4, 112, 114, 111, 128, 131, 136, 
	144, 149, 156, 96, 95, 96, 98, 95, 
	96, 99, 95, 96, 100, 95, 96, 101, 
	95, 96, 102, 95, 96, 103, 95, 96, 
	104, 95, 96, 105, 95, 96, 106, 95, 
	96, 107, 95, 96, 108, 95, 96, 109, 
	95, 96, 110, 95, 96, 4, 95, 96, 
	84, 95, 96, 113, 95, 96, 111, 95, 
	96, 115, 95, 96, 116, 95, 96, 117, 
	95, 96, 118, 95, 96, 119, 95, 96, 
	120, 95, 96, 121, 95, 96, 122, 95, 
	96, 123, 95, 96, 124, 95, 96, 125, 
	95, 96, 126, 95, 96, 127, 95, 96, 
	84, 95, 96, 129, 95, 96, 130, 95, 
	96, 84, 111, 95, 96, 132, 95, 96, 
	133, 95, 96, 134, 95, 135, 96, 123, 
	95, 123, 96, 95, 96, 137, 139, 95, 
	96, 138, 95, 96, 111, 95, 96, 140, 
	95, 96, 141, 95, 96, 142, 95, 96, 
	143, 95, 96, 127, 95, 96, 145, 95, 
	96, 146, 95, 96, 147, 95, 96, 148, 
	95, 96, 127, 95, 96, 150, 95, 96, 
	151, 95, 96, 152, 95, 96, 153, 95, 
	96, 154, 95, 96, 155, 95, 96, 127, 
	95, 96, 157, 95, 96, 158, 161, 95, 
	96, 159, 95, 96, 160, 95, 96, 111, 
	111, 95, 96, 162, 95, 96, 113, 95, 
	164, 0, 165, 0, 166, 0, 167, 0, 
	168, 0, 170, 169, 170, 169, 170, 170, 
	4, 171, 185, 4, 186, 188, 185, 202, 
	209, 214, 222, 227, 252, 170, 169, 170, 
	172, 169, 170, 173, 169, 170, 174, 169, 
	170, 175, 169, 170, 176, 169, 170, 177, 
	169, 170, 178, 169, 170, 179, 169, 170, 
	180, 169, 170, 181, 169, 170, 182, 169, 
	170, 183, 169, 170, 184, 169, 170, 4, 
	169, 170, 84, 169, 170, 187, 169, 170, 
	185, 169, 170, 189, 169, 170, 190, 169, 
	170, 191, 169, 170, 192, 169, 170, 193, 
	169, 170, 194, 169, 170, 195, 169, 170, 
	196, 169, 170, 197, 169, 170, 198, 169, 
	170, 199, 169, 170, 200, 169, 170, 201, 
	169, 170, 84, 169, 170, 203, 205, 169, 
	170, 204, 169, 170, 84, 185, 169, 170, 
	206, 169, 170, 207, 169, 170, 208, 169, 
	170, 200, 169, 170, 210, 169, 170, 211, 
	169, 170, 212, 169, 213, 170, 197, 169, 
	197, 170, 169, 170, 215, 217, 169, 170, 
	216, 169, 170, 185, 169, 170, 218, 169, 
	170, 219, 169, 170, 220, 169, 170, 221, 
	169, 170, 201, 169, 170, 223, 169, 170, 
	224, 169, 170, 225, 169, 170, 226, 169, 
	170, 201, 169, 170, 228, 234, 236, 169, 
	170, 229, 169, 170, 230, 169, 170, 231, 
	169, 170, 232, 169, 170, 233, 169, 170, 
	201, 169, 170, 235, 169, 170, 221, 169, 
	170, 237, 169, 170, 238, 169, 170, 239, 
	169, 170, 240, 169, 170, 241, 169, 170, 
	242, 169, 170, 243, 169, 170, 244, 169, 
	170, 245, 169, 170, 246, 169, 170, 247, 
	169, 170, 248, 169, 170, 249, 169, 170, 
	250, 169, 170, 251, 169, 170, 221, 169, 
	170, 253, 169, 170, 254, 257, 169, 170, 
	255, 169, 170, 256, 169, 170, 185, 185, 
	169, 170, 258, 169, 170, 187, 169, 260, 
	0, 261, 0, 262, 0, 263, 48, 0, 
	48, 0, 265, 267, 0, 266, 0, 31, 
	0, 268, 271, 0, 269, 0, 270, 0, 
	167, 0, 272, 0, 273, 0, 274, 0, 
	52, 0, 276, 281, 0, 277, 0, 278, 
	0, 279, 0, 280, 0, 270, 0, 282, 
	0, 283, 0, 284, 0, 285, 0, 286, 
	384, 0, 288, 287, 288, 287, 288, 288, 
	4, 289, 303, 4, 304, 306, 303, 320, 
	329, 334, 344, 352, 377, 288, 287, 288, 
	290, 287, 288, 291, 287, 288, 292, 287, 
	288, 293, 287, 288, 294, 287, 288, 295, 
	287, 288, 296, 287, 288, 297, 287, 288, 
	298, 287, 288, 299, 287, 288, 300, 287, 
	288, 301, 287, 288, 302, 287, 288, 4, 
	287, 288, 84, 287, 288, 305, 287, 288, 
	303, 287, 288, 307, 287, 288, 308, 287, 
	288, 309, 287, 288, 310, 287, 288, 311, 
	287, 288, 312, 287, 288, 313, 287, 288, 
	314, 287, 288, 315, 287, 288, 316, 287, 
	288, 317, 287, 288, 318, 287, 288, 319, 
	287, 288, 84, 287, 288, 321, 323, 287, 
	288, 322, 287, 288, 84, 303, 287, 288, 
	324, 287, 288, 325, 327, 287, 288, 326, 
	287, 288, 318, 287, 288, 328, 287, 288, 
	317, 287, 288, 330, 287, 288, 331, 287, 
	288, 332, 287, 333, 288, 315, 287, 315, 
	288, 287, 288, 335, 337, 287, 288, 336, 
	287, 288, 303, 287, 288, 338, 341, 287, 
	288, 339, 287, 288, 340, 287, 288, 319, 
	287, 288, 342, 287, 288, 343, 287, 288, 
	340, 287, 288, 345, 348, 287, 288, 346, 
	287, 288, 347, 287, 288, 342, 287, 288, 
	349, 287, 288, 350, 287, 288, 351, 287, 
	288, 319, 287, 288, 353, 359, 361, 287, 
	288, 354, 287, 288, 355, 287, 288, 356, 
	287, 288, 357, 287, 288, 358, 287, 288, 
	319, 287, 288, 360, 287, 288, 340, 287, 
	288, 362, 287, 288, 363, 287, 288, 364, 
	287, 288, 365, 287, 288, 366, 287, 288, 
	367, 287, 288, 368, 287, 288, 369, 287, 
	288, 370, 287, 288, 371, 287, 288, 372, 
	287, 288, 373, 287, 288, 374, 287, 288, 
	375, 287, 288, 376, 287, 288, 340, 287, 
	288, 378, 287, 288, 379, 382, 287, 288, 
	380, 287, 288, 381, 287, 288, 303, 303, 
	287, 288, 383, 287, 288, 305, 287, 385, 
	0, 387, 386, 387, 386, 387, 387, 4, 
	388, 402, 407, 4, 387, 386, 387, 389, 
	386, 387, 390, 386, 387, 391, 386, 387, 
	392, 386, 387, 393, 386, 387, 394, 386, 
	387, 395, 386, 387, 396, 386, 387, 397, 
	386, 387, 398, 386, 387, 399, 386, 387, 
	400, 386, 387, 401, 386, 387, 84, 386, 
	387, 403, 386, 387, 404, 386, 387, 405, 
	386, 406, 387, 397, 386, 397, 387, 386, 
	387, 408, 386, 387, 409, 386, 387, 410, 
	386, 387, 411, 386, 387, 412, 386, 387, 
	401, 386, 414, 422, 425, 0, 415, 0, 
	416, 0, 417, 0, 418, 0, 419, 0, 
	420, 421, 0, 384, 0, 286, 0, 423, 
	0, 424, 0, 93, 0, 426, 0, 427, 
	0, 428, 0, 429, 0, 430, 0, 431, 
	0, 432, 0, 433, 0, 434, 0, 435, 
	0, 436, 0, 437, 0, 438, 0, 439, 
	0, 440, 0, 424, 0, 442, 0, 443, 
	446, 0, 444, 0, 445, 0, 31, 31, 
	0, 447, 0, 38, 0, 448, 449, 448, 
	0, 453, 452, 451, 449, 452, 450, 0, 
	451, 449, 450, 0, 451, 450, 453, 452, 
	451, 449, 452, 450, 453, 453, 5, 15, 
	17, 31, 34, 37, 39, 31, 85, 259, 
	264, 275, 413, 441, 448, 453, 0, 55, 
	455, 54, 55, 456, 54, 55, 457, 459, 
	54, 55, 458, 54, 55, 82, 54, 55, 
	460, 54, 55, 81, 54, 55, 462, 54, 
	55, 463, 54, 55, 464, 54, 465, 55, 
	79, 54, 79, 55, 54, 55, 467, 54, 
	55, 468, 471, 54, 55, 469, 54, 55, 
	470, 54, 55, 83, 54, 55, 472, 54, 
	55, 473, 54, 55, 470, 54, 55, 475, 
	478, 54, 55, 476, 54, 55, 477, 54, 
	55, 472, 54, 55, 479, 54, 55, 480, 
	54, 55, 481, 54, 55, 482, 54, 55, 
	84, 83, 54, 55, 484, 491, 493, 54, 
	55, 485, 54, 55, 486, 54, 55, 487, 
	54, 55, 488, 54, 55, 489, 54, 55, 
	490, 83, 54, 55, 83, 54, 55, 492, 
	54, 55, 470, 54, 55, 494, 54, 55, 
	495, 54, 55, 496, 54, 55, 497, 54, 
	55, 498, 54, 55, 499, 54, 55, 500, 
	54, 55, 501, 54, 55, 502, 54, 55, 
	503, 54, 55, 504, 54, 55, 505, 54, 
	55, 506, 54, 55, 507, 54, 55, 508, 
	54, 55, 470, 54, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	0, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 35, 0, 43, 0, 43, 0, 43, 
	54, 0, 5, 1, 0, 29, 1, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	35, 0, 43, 0, 43, 0, 43, 139, 
	48, 9, 106, 11, 0, 134, 45, 45, 
	45, 3, 122, 33, 33, 33, 0, 122, 
	33, 33, 33, 0, 122, 33, 0, 33, 
	0, 102, 7, 7, 43, 54, 0, 0, 
	43, 114, 25, 0, 54, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 149, 126, 57, 110, 
	23, 0, 43, 43, 43, 43, 0, 27, 
	118, 27, 27, 51, 27, 0, 54, 0, 
	1, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 54, 
	0, 69, 33, 69, 84, 84, 84, 84, 
	84, 84, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 13, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 13, 0, 
	130, 31, 60, 57, 31, 63, 57, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	66, 31, 43, 0, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 54, 0, 78, 33, 
	84, 78, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 19, 0, 54, 
	19, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	19, 0, 54, 0, 0, 54, 0, 0, 
	54, 19, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 54, 0, 
	72, 33, 84, 72, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 15, 
	0, 54, 15, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 15, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 15, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	0, 43, 144, 57, 54, 0, 54, 0, 
	75, 33, 84, 75, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 17, 
	0, 54, 17, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 17, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 17, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	43, 144, 57, 54, 0, 54, 0, 81, 
	84, 84, 84, 81, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 21, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	0, 43, 0, 43, 0, 43, 0, 0, 
	43, 0, 43, 0, 43, 0, 0, 0, 
	43, 54, 37, 37, 87, 37, 37, 43, 
	0, 39, 0, 43, 0, 0, 54, 0, 
	0, 39, 0, 0, 54, 0, 93, 90, 
	41, 96, 90, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 99, 0, 43, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	13, 0, 0, 54, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 509;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/sr_latn.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1171 "ext/gherkin_lexer_sr_latn/gherkin_lexer_sr_latn.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/sr_latn.c.rl"
    
#line 1178 "ext/gherkin_lexer_sr_latn/gherkin_lexer_sr_latn.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/sr_latn.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/sr_latn.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/sr_latn.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/sr_latn.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/sr_latn.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/sr_latn.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/sr_latn.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/sr_latn.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/sr_latn.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/sr_latn.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/sr_latn.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/sr_latn.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/sr_latn.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/sr_latn.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/sr_latn.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/sr_latn.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/sr_latn.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/sr_latn.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/sr_latn.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/sr_latn.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/sr_latn.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/sr_latn.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/sr_latn.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/sr_latn.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1468 "ext/gherkin_lexer_sr_latn/gherkin_lexer_sr_latn.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/sr_latn.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1531 "ext/gherkin_lexer_sr_latn/gherkin_lexer_sr_latn.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/sr_latn.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_sr_latn()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Sr_latn", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

