require "cairo/color"

module Cairo
  module Color
    # Absolute Zero: #0048BA: (0, 72, 186)
    ABSOLUTE_ZERO = RGB.new(0.0, 0.2823529411764706, 0.7294117647058823)
    # Acid green: #B0BF1A: (176, 191, 26)
    ACID_GREEN = RGB.new(0.6901960784313725, 0.7490196078431373, 0.10196078431372549)
    # Aero: #7CB9E8: (124, 185, 232)
    AERO = RGB.new(0.48627450980392156, 0.7254901960784313, 0.9098039215686274)
    # Aero blue: #C9FFE5: (201, 255, 229)
    AERO_BLUE = RGB.new(0.788235294117647, 1.0, 0.8980392156862745)
    # African violet: #B284BE: (178, 132, 190)
    AFRICAN_VIOLET = RGB.new(0.6980392156862745, 0.5176470588235295, 0.7450980392156863)
    # Alabama crimson: #AF002A: (175, 0, 42)
    ALABAMA_CRIMSON = RGB.new(0.6862745098039216, 0.0, 0.16470588235294117)
    # Alabaster: #F2F0E6: (242, 240, 230)
    ALABASTER = RGB.new(0.9490196078431372, 0.9411764705882353, 0.9019607843137255)
    # Alice blue: #F0F8FF: (240, 248, 255)
    ALICE_BLUE = RGB.new(0.9411764705882353, 0.9725490196078431, 1.0)
    # Alien Armpit: #84DE02: (132, 222, 2)
    ALIEN_ARMPIT = RGB.new(0.5176470588235295, 0.8705882352941177, 0.00784313725490196)
    # Alloy orange: #C46210: (196, 98, 16)
    ALLOY_ORANGE = RGB.new(0.7686274509803922, 0.3843137254901961, 0.06274509803921569)
    # Almond: #EFDECD: (239, 222, 205)
    ALMOND = RGB.new(0.9372549019607843, 0.8705882352941177, 0.803921568627451)
    # Amaranth: #E52B50: (229, 43, 80)
    AMARANTH = RGB.new(0.8980392156862745, 0.16862745098039217, 0.3137254901960784)
    # Amaranth deep purple: #9F2B68: (159, 43, 104)
    AMARANTH_DEEP_PURPLE = RGB.new(0.6235294117647059, 0.16862745098039217, 0.40784313725490196)
    # Amaranth pink: #F19CBB: (241, 156, 187)
    AMARANTH_PINK = RGB.new(0.9450980392156862, 0.611764705882353, 0.7333333333333333)
    # Amaranth purple: #AB274F: (171, 39, 79)
    AMARANTH_PURPLE = RGB.new(0.6705882352941176, 0.15294117647058825, 0.30980392156862746)
    # Amaranth red: #D3212D: (211, 33, 45)
    AMARANTH_RED = RGB.new(0.8274509803921568, 0.12941176470588237, 0.17647058823529413)
    # Amazon: #3B7A57: (59, 122, 87)
    AMAZON = RGB.new(0.23137254901960785, 0.47843137254901963, 0.3411764705882353)
    # Amber: #FFBF00: (255, 191, 0)
    AMBER = RGB.new(1.0, 0.7490196078431373, 0.0)
    # Amber (SAE/ECE): #FF7E00: (255, 126, 0)
    AMBER_SAE_ECE = RGB.new(1.0, 0.49411764705882355, 0.0)
    # Amethyst: #9966CC: (153, 102, 204)
    AMETHYST = RGB.new(0.6, 0.4, 0.8)
    # Android green: #A4C639: (164, 198, 57)
    ANDROID_GREEN = RGB.new(0.6431372549019608, 0.7764705882352941, 0.2235294117647059)
    # Anti-flash white: #F2F3F4: (242, 243, 244)
    ANTI_FLASH_WHITE = RGB.new(0.9490196078431372, 0.9529411764705882, 0.9568627450980393)
    # Antique brass: #CD9575: (205, 149, 117)
    ANTIQUE_BRASS = RGB.new(0.803921568627451, 0.5843137254901961, 0.4588235294117647)
    # Antique bronze: #665D1E: (102, 93, 30)
    ANTIQUE_BRONZE = RGB.new(0.4, 0.36470588235294116, 0.11764705882352941)
    # Antique fuchsia: #915C83: (145, 92, 131)
    ANTIQUE_FUCHSIA = RGB.new(0.5686274509803921, 0.3607843137254902, 0.5137254901960784)
    # Antique ruby: #841B2D: (132, 27, 45)
    ANTIQUE_RUBY = RGB.new(0.5176470588235295, 0.10588235294117647, 0.17647058823529413)
    # Antique white: #FAEBD7: (250, 235, 215)
    ANTIQUE_WHITE = RGB.new(0.9803921568627451, 0.9215686274509803, 0.8431372549019608)
    # Ao (English): #008000: (0, 128, 0)
    AO_ENGLISH = RGB.new(0.0, 0.5019607843137255, 0.0)
    # Apple: #66B447: (102, 180, 71)
    APPLE = RGB.new(0.4, 0.7058823529411765, 0.2784313725490196)
    # Apple green: #8DB600: (141, 182, 0)
    APPLE_GREEN = RGB.new(0.5529411764705883, 0.7137254901960784, 0.0)
    # Apricot: #FBCEB1: (251, 206, 177)
    APRICOT = RGB.new(0.984313725490196, 0.807843137254902, 0.6941176470588235)
    # Aqua: #00FFFF: (0, 255, 255)
    AQUA = RGB.new(0.0, 1.0, 1.0)
    # Aquamarine: #7FFFD4: (127, 255, 212)
    AQUAMARINE = RGB.new(0.4980392156862745, 1.0, 0.8313725490196079)
    # Arctic lime: #D0FF14: (208, 255, 20)
    ARCTIC_LIME = RGB.new(0.8156862745098039, 1.0, 0.0784313725490196)
    # Army green: #4B5320: (75, 83, 32)
    ARMY_GREEN = RGB.new(0.29411764705882354, 0.3254901960784314, 0.12549019607843137)
    # Artichoke: #8F9779: (143, 151, 121)
    ARTICHOKE = RGB.new(0.5607843137254902, 0.592156862745098, 0.4745098039215686)
    # Arylide yellow: #E9D66B: (233, 214, 107)
    ARYLIDE_YELLOW = RGB.new(0.9137254901960784, 0.8392156862745098, 0.4196078431372549)
    # Ash grey: #B2BEB5: (178, 190, 181)
    ASH_GREY = RGB.new(0.6980392156862745, 0.7450980392156863, 0.7098039215686275)
    # Asparagus: #87A96B: (135, 169, 107)
    ASPARAGUS = RGB.new(0.5294117647058824, 0.6627450980392157, 0.4196078431372549)
    # Atomic tangerine: #FF9966: (255, 153, 102)
    ATOMIC_TANGERINE = RGB.new(1.0, 0.6, 0.4)
    # Auburn: #A52A2A: (165, 42, 42)
    AUBURN = RGB.new(0.6470588235294118, 0.16470588235294117, 0.16470588235294117)
    # Aureolin: #FDEE00: (253, 238, 0)
    AUREOLIN = RGB.new(0.9921568627450981, 0.9333333333333333, 0.0)
    # AuroMetalSaurus: #6E7F80: (110, 127, 128)
    AUROMETALSAURUS = RGB.new(0.43137254901960786, 0.4980392156862745, 0.5019607843137255)
    # Avocado: #568203: (86, 130, 3)
    AVOCADO = RGB.new(0.33725490196078434, 0.5098039215686274, 0.011764705882352941)
    # Axolotl: #63775B: (99, 119, 91)
    AXOLOTL = RGB.new(0.38823529411764707, 0.4666666666666667, 0.3568627450980392)
    # Azure: #007FFF: (0, 127, 255)
    AZURE = RGB.new(0.0, 0.4980392156862745, 1.0)
    # Azure mist: #F0FFFF: (240, 255, 255)
    AZURE_MIST = RGB.new(0.9411764705882353, 1.0, 1.0)
    # B'dazzled blue: #2E5894: (46, 88, 149)
    BDAZZLED_BLUE = RGB.new(0.1803921568627451, 0.34509803921568627, 0.5843137254901961)
    # Baby blue: #89CFF0: (137, 207, 240)
    BABY_BLUE = RGB.new(0.5372549019607843, 0.8117647058823529, 0.9411764705882353)
    # Baby blue eyes: #A1CAF1: (161, 202, 241)
    BABY_BLUE_EYES = RGB.new(0.6313725490196078, 0.792156862745098, 0.9450980392156862)
    # Baby pink: #F4C2C2: (244, 194, 194)
    BABY_PINK = RGB.new(0.9568627450980393, 0.7607843137254902, 0.7607843137254902)
    # Baby powder: #FEFEFA: (254, 254, 250)
    BABY_POWDER = RGB.new(0.996078431372549, 0.996078431372549, 0.9803921568627451)
    # Baker-Miller pink: #FF91AF: (255, 145, 175)
    BAKER_MILLER_PINK = RGB.new(1.0, 0.5686274509803921, 0.6862745098039216)
    # Ball blue: #21ABCD: (33, 171, 205)
    BALL_BLUE = RGB.new(0.12941176470588237, 0.6705882352941176, 0.803921568627451)
    # Banana Mania: #FAE7B5: (250, 231, 181)
    BANANA_MANIA = RGB.new(0.9803921568627451, 0.9058823529411765, 0.7098039215686275)
    # Banana yellow: #FFE135: (255, 225, 53)
    BANANA_YELLOW = RGB.new(1.0, 0.8823529411764706, 0.20784313725490197)
    # Bangladesh green: #006A4E: (0, 106, 78)
    BANGLADESH_GREEN = RGB.new(0.0, 0.41568627450980394, 0.3058823529411765)
    # Barbie pink: #E0218A: (224, 33, 138)
    BARBIE_PINK = RGB.new(0.8784313725490196, 0.12941176470588237, 0.5411764705882353)
    # Barn red: #7C0A02: (124, 10, 2)
    BARN_RED = RGB.new(0.48627450980392156, 0.0392156862745098, 0.00784313725490196)
    # Battery charged blue: #1DACD6: (29, 172, 214)
    BATTERY_CHARGED_BLUE = RGB.new(0.11372549019607843, 0.6745098039215687, 0.8392156862745098)
    # Battleship grey: #848482: (132, 132, 130)
    BATTLESHIP_GREY = RGB.new(0.5176470588235295, 0.5176470588235295, 0.5098039215686274)
    # Bayside: #5FC9BF: (95, 201, 191)
    BAYSIDE = RGB.new(0.37254901960784315, 0.788235294117647, 0.7490196078431373)
    # Bazaar: #98777B: (152, 119, 123)
    BAZAAR = RGB.new(0.596078431372549, 0.4666666666666667, 0.4823529411764706)
    # Beau blue: #BCD4E6: (188, 212, 230)
    BEAU_BLUE = RGB.new(0.7372549019607844, 0.8313725490196079, 0.9019607843137255)
    # Begonia: #FA6E79: (250, 110, 121)
    BEGONIA = RGB.new(0.9803921568627451, 0.43137254901960786, 0.4745098039215686)
    # Beaver: #9F8170: (159, 129, 112)
    BEAVER = RGB.new(0.6235294117647059, 0.5058823529411764, 0.4392156862745098)
    # Beer: #F28E1C: (242, 142, 28)
    BEER = RGB.new(0.9490196078431372, 0.5568627450980392, 0.10980392156862745)
    # Beige: #F5F5DC: (245, 245, 220)
    BEIGE = RGB.new(0.9607843137254902, 0.9607843137254902, 0.8627450980392157)
    # Big dip o’ruby: #9C2542: (156, 37, 66)
    BIG_DIP_ORUBY = RGB.new(0.611764705882353, 0.1450980392156863, 0.25882352941176473)
    # Big Foot Feet: #E88E5A: (232, 142, 90)
    BIG_FOOT_FEET = RGB.new(0.9098039215686274, 0.5568627450980392, 0.35294117647058826)
    # Bisque: #FFE4C4: (255, 228, 196)
    BISQUE = RGB.new(1.0, 0.8941176470588236, 0.7686274509803922)
    # Bistre: #3D2B1F: (61, 43, 31)
    BISTRE = RGB.new(0.23921568627450981, 0.16862745098039217, 0.12156862745098039)
    # Bistre brown: #967117: (150, 113, 23)
    BISTRE_BROWN = RGB.new(0.5882352941176471, 0.44313725490196076, 0.09019607843137255)
    # Bitter lemon: #CAE00D: (202, 224, 13)
    BITTER_LEMON = RGB.new(0.792156862745098, 0.8784313725490196, 0.050980392156862744)
    # Bitter lime: #BFFF00: (191, 255, 0)
    BITTER_LIME = RGB.new(0.7490196078431373, 1.0, 0.0)
    # Bittersweet: #FE6F5E: (254, 111, 94)
    BITTERSWEET = RGB.new(0.996078431372549, 0.43529411764705883, 0.3686274509803922)
    # Bittersweet shimmer: #BF4F51: (191, 79, 81)
    BITTERSWEET_SHIMMER = RGB.new(0.7490196078431373, 0.30980392156862746, 0.3176470588235294)
    # Black: #000000: (0, 0, 0)
    BLACK = RGB.new(0.0, 0.0, 0.0)
    # Black bean: #3D0C02: (61, 12, 2)
    BLACK_BEAN = RGB.new(0.23921568627450981, 0.047058823529411764, 0.00784313725490196)
    # Black chocolate: #1B1811: (27, 24, 17)
    BLACK_CHOCOLATE = RGB.new(0.10588235294117647, 0.09411764705882353, 0.06666666666666667)
    # Black coffee: #3B2F2F: (59, 47, 47)
    BLACK_COFFEE = RGB.new(0.23137254901960785, 0.1843137254901961, 0.1843137254901961)
    # Black coral: #54626F: (84, 98, 111)
    BLACK_CORAL = RGB.new(0.32941176470588235, 0.3843137254901961, 0.43529411764705883)
    # Black leather jacket: #253529: (37, 53, 41)
    BLACK_LEATHER_JACKET = RGB.new(0.1450980392156863, 0.20784313725490197, 0.1607843137254902)
    # Black olive: #3B3C36: (59, 60, 54)
    BLACK_OLIVE = RGB.new(0.23137254901960785, 0.23529411764705882, 0.21176470588235294)
    # Blackberry: #8F5973: (143, 89, 115)
    BLACKBERRY = RGB.new(0.5607843137254902, 0.34901960784313724, 0.45098039215686275)
    # Black Shadows: #BFAFB2: (191, 175, 178)
    BLACK_SHADOWS = RGB.new(0.7490196078431373, 0.6862745098039216, 0.6980392156862745)
    # Blanched almond: #FFEBCD: (255, 235, 205)
    BLANCHED_ALMOND = RGB.new(1.0, 0.9215686274509803, 0.803921568627451)
    # Blast-off bronze: #A57164: (165, 113, 100)
    BLAST_OFF_BRONZE = RGB.new(0.6470588235294118, 0.44313725490196076, 0.39215686274509803)
    # Bleu de France: #318CE7: (49, 140, 231)
    BLEU_DE_FRANCE = RGB.new(0.19215686274509805, 0.5490196078431373, 0.9058823529411765)
    # Blizzard blue: #ACE5EE: (172, 229, 238)
    BLIZZARD_BLUE = RGB.new(0.6745098039215687, 0.8980392156862745, 0.9333333333333333)
    # Blond: #FAF0BE: (250, 240, 190)
    BLOND = RGB.new(0.9803921568627451, 0.9411764705882353, 0.7450980392156863)
    # Blood: #8A0303: (138, 3, 3)
    BLOOD = RGB.new(0.5411764705882353, 0.011764705882352941, 0.011764705882352941)
    # Blood orange: #D1001C: (210, 0, 27)
    BLOOD_ORANGE = RGB.new(0.8235294117647058, 0.0, 0.10588235294117647)
    # Blood red: #660000: (102, 0, 0)
    BLOOD_RED = RGB.new(0.4, 0.0, 0.0)
    # Blood (Animal): #A41313: (164, 19, 19)
    BLOOD_ANIMAL = RGB.new(0.6431372549019608, 0.07450980392156863, 0.07450980392156863)
    # Blood (organ): #630F0F: (99, 15, 15)
    BLOOD_ORGAN = RGB.new(0.38823529411764707, 0.058823529411764705, 0.058823529411764705)
    # Blue: #0000FF: (0, 0, 255)
    BLUE = RGB.new(0.0, 0.0, 1.0)
    # Blue (Crayola): #1F75FE: (31, 117, 254)
    BLUE_CRAYOLA = RGB.new(0.12156862745098039, 0.4588235294117647, 0.996078431372549)
    # Blue (Munsell): #0093AF: (0, 147, 175)
    BLUE_MUNSELL = RGB.new(0.0, 0.5764705882352941, 0.6862745098039216)
    # Blue (NCS): #0087BD: (0, 135, 189)
    BLUE_NCS = RGB.new(0.0, 0.5294117647058824, 0.7411764705882353)
    # Blue (Pantone): #0018A8: (0, 24, 168)
    BLUE_PANTONE = RGB.new(0.0, 0.09411764705882353, 0.6588235294117647)
    # Blue (pigment): #333399: (51, 51, 153)
    BLUE_PIGMENT = RGB.new(0.2, 0.2, 0.6)
    # Blue (RYB): #0247FE: (2, 71, 254)
    BLUE_RYB = RGB.new(0.00784313725490196, 0.2784313725490196, 0.996078431372549)
    # Blue bell: #A2A2D0: (162, 162, 208)
    BLUE_BELL = RGB.new(0.6352941176470588, 0.6352941176470588, 0.8156862745098039)
    # Blue bolt: #00B9FB: (0, 185, 251)
    BLUE_BOLT = RGB.new(0.0, 0.7254901960784313, 0.984313725490196)
    # Blue cola: #0088DC: (0, 136, 220)
    BLUE_COLA = RGB.new(0.0, 0.5333333333333333, 0.8627450980392157)
    # Blue-gray: #6699CC: (102, 153, 204)
    BLUE_GRAY = RGB.new(0.4, 0.6, 0.8)
    # Blue-green: #0D98BA: (13, 152, 186)
    BLUE_GREEN = RGB.new(0.050980392156862744, 0.596078431372549, 0.7294117647058823)
    # Blue-green (color wheel): #064E40: (6, 78, 64)
    BLUE_GREEN_COLOR_WHEEL = RGB.new(0.023529411764705882, 0.3058823529411765, 0.25098039215686274)
    # Blue jeans: #5DADEC: (93, 173, 236)
    BLUE_JEANS = RGB.new(0.36470588235294116, 0.6784313725490196, 0.9254901960784314)
    # Blue lagoon: #ACE5EE: (172, 229, 238)
    BLUE_LAGOON = RGB.new(0.6745098039215687, 0.8980392156862745, 0.9333333333333333)
    # Blue-magenta violet: #553592: (85, 53, 146)
    BLUE_MAGENTA_VIOLET = RGB.new(0.3333333333333333, 0.20784313725490197, 0.5725490196078431)
    # Blue raspberry: #0CBFE9: (12, 191, 233)
    BLUE_RASPBERRY = RGB.new(0.047058823529411764, 0.7490196078431373, 0.9137254901960784)
    # Blue sapphire: #126180: (18, 97, 128)
    BLUE_SAPPHIRE = RGB.new(0.07058823529411765, 0.3803921568627451, 0.5019607843137255)
    # Blue-violet: #8A2BE2: (138, 43, 226)
    BLUE_VIOLET = RGB.new(0.5411764705882353, 0.16862745098039217, 0.8862745098039215)
    # Blue-violet (Crayola): #7366BD: (115, 102, 189)
    BLUE_VIOLET_CRAYOLA = RGB.new(0.45098039215686275, 0.4, 0.7411764705882353)
    # Blue-violet (color wheel): #4D1A7F: (77, 26, 127)
    BLUE_VIOLET_COLOR_WHEEL = RGB.new(0.30196078431372547, 0.10196078431372549, 0.4980392156862745)
    # Blue yonder: #5072A7: (80, 114, 167)
    BLUE_YONDER = RGB.new(0.3137254901960784, 0.4470588235294118, 0.6549019607843137)
    # Blueberry: #4F86F7: (79, 134, 247)
    BLUEBERRY = RGB.new(0.30980392156862746, 0.5254901960784314, 0.9686274509803922)
    # Bluebonnet: #1C1CF0: (28, 28, 240)
    BLUEBONNET = RGB.new(0.10980392156862745, 0.10980392156862745, 0.9411764705882353)
    # Blush: #DE5D83: (222, 93, 131)
    BLUSH = RGB.new(0.8705882352941177, 0.36470588235294116, 0.5137254901960784)
    # Bole: #79443B: (121, 68, 59)
    BOLE = RGB.new(0.4745098039215686, 0.26666666666666666, 0.23137254901960785)
    # Bondi blue: #0095B6: (0, 149, 182)
    BONDI_BLUE = RGB.new(0.0, 0.5843137254901961, 0.7137254901960784)
    # Bone: #E3DAC9: (227, 218, 201)
    BONE = RGB.new(0.8901960784313725, 0.8549019607843137, 0.788235294117647)
    # Booger Buster: #DDE26A: (221, 226, 106)
    BOOGER_BUSTER = RGB.new(0.8666666666666667, 0.8862745098039215, 0.41568627450980394)
    # Boston University red: #CC0000: (204, 0, 0)
    BOSTON_UNIVERSITY_RED = RGB.new(0.8, 0.0, 0.0)
    # Bottle green: #006A4E: (0, 106, 78)
    BOTTLE_GREEN = RGB.new(0.0, 0.41568627450980394, 0.3058823529411765)
    # Boysenberry: #873260: (135, 50, 96)
    BOYSENBERRY = RGB.new(0.5294117647058824, 0.19607843137254902, 0.3764705882352941)
    # Brandeis blue: #0070FF: (0, 112, 255)
    BRANDEIS_BLUE = RGB.new(0.0, 0.4392156862745098, 1.0)
    # Brandy: #87413F: (135, 65, 63)
    BRANDY = RGB.new(0.5294117647058824, 0.2549019607843137, 0.24705882352941178)
    # Brave orange: #FF631C: (255, 99, 28)
    BRAVE_ORANGE = RGB.new(1.0, 0.38823529411764707, 0.10980392156862745)
    # Brick red: #CB4154: (203, 65, 84)
    BRICK_RED = RGB.new(0.796078431372549, 0.2549019607843137, 0.32941176470588235)
    # Bright cerulean: #1DACD6: (29, 172, 214)
    BRIGHT_CERULEAN = RGB.new(0.11372549019607843, 0.6745098039215687, 0.8392156862745098)
    # Bright gray: #EBECF0: (235, 236, 240)
    BRIGHT_GRAY = RGB.new(0.9215686274509803, 0.9254901960784314, 0.9411764705882353)
    # Bright green: #66FF00: (102, 255, 0)
    BRIGHT_GREEN = RGB.new(0.4, 1.0, 0.0)
    # Briquette: #E0475C: (224, 71, 92)
    BRIQUETTE = RGB.new(0.8784313725490196, 0.2784313725490196, 0.3607843137254902)
    # Bright lavender: #BF94E4: (191, 148, 228)
    BRIGHT_LAVENDER = RGB.new(0.7490196078431373, 0.5803921568627451, 0.8941176470588236)
    # Bright lilac: #D891EF: (216, 145, 239)
    BRIGHT_LILAC = RGB.new(0.8470588235294118, 0.5686274509803921, 0.9372549019607843)
    # Bright maroon: #C32148: (195, 33, 72)
    BRIGHT_MAROON = RGB.new(0.7647058823529411, 0.12941176470588237, 0.2823529411764706)
    # Bright navy blue: #1974D2: (25, 116, 210)
    BRIGHT_NAVY_BLUE = RGB.new(0.09803921568627451, 0.4549019607843137, 0.8235294117647058)
    # Bright pink: #FF007F: (255, 0, 127)
    BRIGHT_PINK = RGB.new(1.0, 0.0, 0.4980392156862745)
    # Bright turquoise: #08E8DE: (8, 232, 222)
    BRIGHT_TURQUOISE = RGB.new(0.03137254901960784, 0.9098039215686274, 0.8705882352941177)
    # Bright ube: #D19FE8: (209, 159, 232)
    BRIGHT_UBE = RGB.new(0.8196078431372549, 0.6235294117647059, 0.9098039215686274)
    # Bright yellow (Crayola): #FFAA1D: (255, 170, 29)
    BRIGHT_YELLOW_CRAYOLA = RGB.new(1.0, 0.6666666666666666, 0.11372549019607843)
    # Brilliant azure: #3399FF: (51, 153, 255)
    BRILLIANT_AZURE = RGB.new(0.2, 0.6, 1.0)
    # Brilliant lavender: #F4BBFF: (244, 187, 255)
    BRILLIANT_LAVENDER = RGB.new(0.9568627450980393, 0.7333333333333333, 1.0)
    # Brilliant rose: #FF55A3: (255, 85, 163)
    BRILLIANT_ROSE = RGB.new(1.0, 0.3333333333333333, 0.6392156862745098)
    # Brink pink: #FB607F: (251, 96, 127)
    BRINK_PINK = RGB.new(0.984313725490196, 0.3764705882352941, 0.4980392156862745)
    # British racing green: #004225: (0, 66, 37)
    BRITISH_RACING_GREEN = RGB.new(0.0, 0.25882352941176473, 0.1450980392156863)
    # Bronze: #88540B: (136, 84, 11)
    BRONZE = RGB.new(0.5333333333333333, 0.32941176470588235, 0.043137254901960784)
    # Bronze (metallic): #B08D57: (176, 140, 86)
    BRONZE_METALLIC = RGB.new(0.6901960784313725, 0.5490196078431373, 0.33725490196078434)
    # Bronze yellow: #737000: (115, 112, 0)
    BRONZE_YELLOW = RGB.new(0.45098039215686275, 0.4392156862745098, 0.0)
    # Brown: #993300: (153, 51, 0)
    BROWN = RGB.new(0.6, 0.2, 0.0)
    # Brown (Crayola): #AF593E: (175, 89, 62)
    BROWN_CRAYOLA = RGB.new(0.6862745098039216, 0.34901960784313724, 0.24313725490196078)
    # Brown (traditional): #964B00: (150, 75, 0)
    BROWN_TRADITIONAL = RGB.new(0.5882352941176471, 0.29411764705882354, 0.0)
    # Brown (web): #A52A2A: (165, 42, 42)
    BROWN_WEB = RGB.new(0.6470588235294118, 0.16470588235294117, 0.16470588235294117)
    # Brown-nose: #6B4423: (107, 68, 35)
    BROWN_NOSE = RGB.new(0.4196078431372549, 0.26666666666666666, 0.13725490196078433)
    # Brown sugar: #AF6E4D: (175, 110, 77)
    BROWN_SUGAR = RGB.new(0.6862745098039216, 0.43137254901960786, 0.30196078431372547)
    # Brunswick green: #1B4D3E: (27, 77, 62)
    BRUNSWICK_GREEN = RGB.new(0.10588235294117647, 0.30196078431372547, 0.24313725490196078)
    # Bubble gum: #FFC1CC: (255, 193, 204)
    BUBBLE_GUM = RGB.new(1.0, 0.7568627450980392, 0.8)
    # Bubbles: #E7FEFF: (231, 254, 255)
    BUBBLES = RGB.new(0.9058823529411765, 0.996078431372549, 1.0)
    # Bud green: #7BB661: (123, 182, 97)
    BUD_GREEN = RGB.new(0.4823529411764706, 0.7137254901960784, 0.3803921568627451)
    # Buff: #F0DC82: (240, 220, 130)
    BUFF = RGB.new(0.9411764705882353, 0.8627450980392157, 0.5098039215686274)
    # Bulgarian rose: #480607: (72, 6, 7)
    BULGARIAN_ROSE = RGB.new(0.2823529411764706, 0.023529411764705882, 0.027450980392156862)
    # Burgundy: #800020: (128, 0, 32)
    BURGUNDY = RGB.new(0.5019607843137255, 0.0, 0.12549019607843137)
    # Burlywood: #DEB887: (222, 184, 135)
    BURLYWOOD = RGB.new(0.8705882352941177, 0.7215686274509804, 0.5294117647058824)
    # Burnished brown: #A17A74: (161, 122, 116)
    BURNISHED_BROWN = RGB.new(0.6313725490196078, 0.47843137254901963, 0.4549019607843137)
    # Burnt orange: #CC5500: (204, 85, 0)
    BURNT_ORANGE = RGB.new(0.8, 0.3333333333333333, 0.0)
    # Burnt sienna: #E97451: (233, 116, 81)
    BURNT_SIENNA = RGB.new(0.9137254901960784, 0.4549019607843137, 0.3176470588235294)
    # Burnt umber: #8A3324: (138, 51, 36)
    BURNT_UMBER = RGB.new(0.5411764705882353, 0.2, 0.1411764705882353)
    # Button blue: #24A0ED: (36, 160, 237)
    BUTTON_BLUE = RGB.new(0.1411764705882353, 0.6274509803921569, 0.9294117647058824)
    # Byzantine: #BD33A4: (189, 51, 164)
    BYZANTINE = RGB.new(0.7411764705882353, 0.2, 0.6431372549019608)
    # Byzantium: #702963: (112, 41, 99)
    BYZANTIUM = RGB.new(0.4392156862745098, 0.1607843137254902, 0.38823529411764707)
    # Cadet: #536872: (83, 104, 114)
    CADET = RGB.new(0.3254901960784314, 0.40784313725490196, 0.4470588235294118)
    # Cadet blue: #5F9EA0: (95, 158, 160)
    CADET_BLUE = RGB.new(0.37254901960784315, 0.6196078431372549, 0.6274509803921569)
    # Cadet blue (Crayola): #A9B2C3: (169, 178, 195)
    CADET_BLUE_CRAYOLA = RGB.new(0.6627450980392157, 0.6980392156862745, 0.7647058823529411)
    # Cadet grey: #91A3B0: (145, 163, 176)
    CADET_GREY = RGB.new(0.5686274509803921, 0.6392156862745098, 0.6901960784313725)
    # Cadmium blue: #0A1195: (10, 17, 146)
    CADMIUM_BLUE = RGB.new(0.0392156862745098, 0.06666666666666667, 0.5725490196078431)
    # Cadmium green: #006B3C: (0, 107, 60)
    CADMIUM_GREEN = RGB.new(0.0, 0.4196078431372549, 0.23529411764705882)
    # Cadmium orange: #ED872D: (237, 135, 45)
    CADMIUM_ORANGE = RGB.new(0.9294117647058824, 0.5294117647058824, 0.17647058823529413)
    # Cadmium purple: #B60C26: (182, 12, 38)
    CADMIUM_PURPLE = RGB.new(0.7137254901960784, 0.047058823529411764, 0.14901960784313725)
    # Cadmium red: #E30022: (227, 0, 34)
    CADMIUM_RED = RGB.new(0.8901960784313725, 0.0, 0.13333333333333333)
    # Cadmium yellow: #FFF600: (255, 246, 0)
    CADMIUM_YELLOW = RGB.new(1.0, 0.9647058823529412, 0.0)
    # Cadmium violet: #7F3E98: (127, 62, 152)
    CADMIUM_VIOLET = RGB.new(0.4980392156862745, 0.24313725490196078, 0.596078431372549)
    # Café au lait: #A67B5B: (166, 123, 91)
    CAFE_AU_LAIT = RGB.new(0.6509803921568628, 0.4823529411764706, 0.3568627450980392)
    # Café noir: #4B3621: (75, 54, 33)
    CAFE_NOIR = RGB.new(0.29411764705882354, 0.21176470588235294, 0.12941176470588237)
    # Cal Poly Pomona green: #1E4D2B: (30, 77, 43)
    CAL_POLY_POMONA_GREEN = RGB.new(0.11764705882352941, 0.30196078431372547, 0.16862745098039217)
    # Calamansi: #FCFFA4: (252, 255, 164)
    CALAMANSI = RGB.new(0.9882352941176471, 1.0, 0.6431372549019608)
    # Cambridge blue: #A3C1AD: (163, 193, 173)
    CAMBRIDGE_BLUE = RGB.new(0.6392156862745098, 0.7568627450980392, 0.6784313725490196)
    # Camel: #C19A6B: (193, 154, 107)
    CAMEL = RGB.new(0.7568627450980392, 0.6039215686274509, 0.4196078431372549)
    # Cameo pink: #EFBBCC: (239, 187, 204)
    CAMEO_PINK = RGB.new(0.9372549019607843, 0.7333333333333333, 0.8)
    # Camouflage green: #78866B: (120, 134, 107)
    CAMOUFLAGE_GREEN = RGB.new(0.47058823529411764, 0.5254901960784314, 0.4196078431372549)
    # Canary: #FFFF99: (255, 255, 153)
    CANARY = RGB.new(1.0, 1.0, 0.6)
    # Canary yellow: #FFEF00: (255, 239, 0)
    CANARY_YELLOW = RGB.new(1.0, 0.9372549019607843, 0.0)
    # Candy apple red: #FF0800: (255, 8, 0)
    CANDY_APPLE_RED = RGB.new(1.0, 0.03137254901960784, 0.0)
    # Candy pink: #E4717A: (228, 113, 122)
    CANDY_PINK = RGB.new(0.8941176470588236, 0.44313725490196076, 0.47843137254901963)
    # Capri: #00BFFF: (0, 191, 255)
    CAPRI = RGB.new(0.0, 0.7490196078431373, 1.0)
    # Caput mortuum: #592720: (89, 39, 32)
    CAPUT_MORTUUM = RGB.new(0.34901960784313724, 0.15294117647058825, 0.12549019607843137)
    # Caramel: #FFD59A: (255, 213, 154)
    CARAMEL = RGB.new(1.0, 0.8352941176470589, 0.6039215686274509)
    # Cardinal: #C41E3A: (196, 30, 58)
    CARDINAL = RGB.new(0.7686274509803922, 0.11764705882352941, 0.22745098039215686)
    # Caribbean green: #00CC99: (0, 204, 153)
    CARIBBEAN_GREEN = RGB.new(0.0, 0.8, 0.6)
    # Carmine: #960018: (150, 0, 24)
    CARMINE = RGB.new(0.5882352941176471, 0.0, 0.09411764705882353)
    # Rich Carmine: #D70040: (215, 0, 64)
    RICH_CARMINE = RGB.new(0.8431372549019608, 0.0, 0.25098039215686274)
    # Carmine pink: #EB4C42: (235, 76, 66)
    CARMINE_PINK = RGB.new(0.9215686274509803, 0.2980392156862745, 0.25882352941176473)
    # Carmine red: #FF0038: (255, 0, 56)
    CARMINE_RED = RGB.new(1.0, 0.0, 0.2196078431372549)
    # Carnation pink: #FFA6C9: (255, 166, 201)
    CARNATION_PINK = RGB.new(1.0, 0.6509803921568628, 0.788235294117647)
    # Carnelian: #B31B1B: (179, 27, 27)
    CARNELIAN = RGB.new(0.7019607843137254, 0.10588235294117647, 0.10588235294117647)
    # Carolina blue: #56A0D3: (86, 160, 211)
    CAROLINA_BLUE = RGB.new(0.33725490196078434, 0.6274509803921569, 0.8274509803921568)
    # Carrot orange: #ED9121: (237, 145, 33)
    CARROT_ORANGE = RGB.new(0.9294117647058824, 0.5686274509803921, 0.12941176470588237)
    # Castleton green: #00563F: (0, 86, 63)
    CASTLETON_GREEN = RGB.new(0.0, 0.33725490196078434, 0.24705882352941178)
    # Catalina blue: #062A78: (6, 42, 120)
    CATALINA_BLUE = RGB.new(0.023529411764705882, 0.16470588235294117, 0.47058823529411764)
    # Catawba: #703642: (112, 54, 66)
    CATAWBA = RGB.new(0.4392156862745098, 0.21176470588235294, 0.25882352941176473)
    # Cedar Chest: #C95A49: (201, 90, 73)
    CEDAR_CHEST = RGB.new(0.788235294117647, 0.35294117647058826, 0.28627450980392155)
    # Ceil: #92A1CF: (146, 161, 207)
    CEIL = RGB.new(0.5725490196078431, 0.6313725490196078, 0.8117647058823529)
    # Celadon: #ACE1AF: (172, 225, 175)
    CELADON = RGB.new(0.6745098039215687, 0.8823529411764706, 0.6862745098039216)
    # Celadon blue: #007BA7: (0, 123, 167)
    CELADON_BLUE = RGB.new(0.0, 0.4823529411764706, 0.6549019607843137)
    # Celadon green: #2F847C: (47, 132, 124)
    CELADON_GREEN = RGB.new(0.1843137254901961, 0.5176470588235295, 0.48627450980392156)
    # Celeste: #B2FFFF: (178, 255, 255)
    CELESTE = RGB.new(0.6980392156862745, 1.0, 1.0)
    # Celestial blue: #4997D0: (73, 151, 208)
    CELESTIAL_BLUE = RGB.new(0.28627450980392155, 0.592156862745098, 0.8156862745098039)
    # Celtic blue: #246BCE: (36, 107, 206)
    CELTIC_BLUE = RGB.new(0.1411764705882353, 0.4196078431372549, 0.807843137254902)
    # Cerise: #DE3163: (222, 49, 99)
    CERISE = RGB.new(0.8705882352941177, 0.19215686274509805, 0.38823529411764707)
    # Cerise pink: #EC3B83: (236, 59, 131)
    CERISE_PINK = RGB.new(0.9254901960784314, 0.23137254901960785, 0.5137254901960784)
    # Cerulean: #007BA7: (0, 123, 167)
    CERULEAN = RGB.new(0.0, 0.4823529411764706, 0.6549019607843137)
    # Cerulean blue: #2A52BE: (42, 82, 190)
    CERULEAN_BLUE = RGB.new(0.16470588235294117, 0.3215686274509804, 0.7450980392156863)
    # Cetacean blue: #001440: (0, 20, 64)
    CETACEAN_BLUE = RGB.new(0.0, 0.0784313725490196, 0.25098039215686274)
    # Cerulean frost: #6D9BC3: (109, 155, 195)
    CERULEAN_FROST = RGB.new(0.42745098039215684, 0.6078431372549019, 0.7647058823529411)
    # Cerulean (Crayola): #1DACD6: (29, 172, 214)
    CERULEAN_CRAYOLA = RGB.new(0.11372549019607843, 0.6745098039215687, 0.8392156862745098)
    # CG blue: #007AA5: (0, 122, 165)
    CG_BLUE = RGB.new(0.0, 0.47843137254901963, 0.6470588235294118)
    # CG Red: #E03C31: (224, 60, 49)
    CG_RED = RGB.new(0.8784313725490196, 0.23529411764705882, 0.19215686274509805)
    # Chambray: #ADBFC8: (173, 191, 200)
    CHAMBRAY = RGB.new(0.6784313725490196, 0.7490196078431373, 0.7843137254901961)
    # Chamoisee: #A0785A: (160, 120, 90)
    CHAMOISEE = RGB.new(0.6274509803921569, 0.47058823529411764, 0.35294117647058826)
    # Champagne: #F7E7CE: (247, 231, 206)
    CHAMPAGNE = RGB.new(0.9686274509803922, 0.9058823529411765, 0.807843137254902)
    # Champagne pink: #F1DDCF: (241, 221, 207)
    CHAMPAGNE_PINK = RGB.new(0.9450980392156862, 0.8666666666666667, 0.8117647058823529)
    # Charcoal: #36454F: (54, 69, 79)
    CHARCOAL = RGB.new(0.21176470588235294, 0.27058823529411763, 0.30980392156862746)
    # Charleston green: #232B2B: (35, 43, 43)
    CHARLESTON_GREEN = RGB.new(0.13725490196078433, 0.16862745098039217, 0.16862745098039217)
    # Charm: #D0748B: (208, 116, 139)
    CHARM = RGB.new(0.8156862745098039, 0.4549019607843137, 0.5450980392156862)
    # Charm pink: #E68FAC: (230, 143, 172)
    CHARM_PINK = RGB.new(0.9019607843137255, 0.5607843137254902, 0.6745098039215687)
    # Chartreuse (traditional): #DFFF00: (223, 255, 0)
    CHARTREUSE_TRADITIONAL = RGB.new(0.8745098039215686, 1.0, 0.0)
    # Chartreuse (web): #7FFF00: (127, 255, 0)
    CHARTREUSE_WEB = RGB.new(0.4980392156862745, 1.0, 0.0)
    # Cheese: #FFA600: (255, 166, 0)
    CHEESE = RGB.new(1.0, 0.6509803921568628, 0.0)
    # Cherry: #DE3163: (222, 49, 99)
    CHERRY = RGB.new(0.8705882352941177, 0.19215686274509805, 0.38823529411764707)
    # Cherry blossom pink: #FFB7C5: (255, 183, 197)
    CHERRY_BLOSSOM_PINK = RGB.new(1.0, 0.7176470588235294, 0.7725490196078432)
    # Chestnut: #954535: (149, 69, 53)
    CHESTNUT = RGB.new(0.5843137254901961, 0.27058823529411763, 0.20784313725490197)
    # China pink: #DE6FA1: (222, 111, 161)
    CHINA_PINK = RGB.new(0.8705882352941177, 0.43529411764705883, 0.6313725490196078)
    # China rose: #A8516E: (168, 81, 110)
    CHINA_ROSE = RGB.new(0.6588235294117647, 0.3176470588235294, 0.43137254901960786)
    # Chinese black: #141414: (20, 20, 20)
    CHINESE_BLACK = RGB.new(0.0784313725490196, 0.0784313725490196, 0.0784313725490196)
    # Chinese blue: #365194: (54, 81, 148)
    CHINESE_BLUE = RGB.new(0.21176470588235294, 0.3176470588235294, 0.5803921568627451)
    # Chinese bronze: #CD8032: (205, 128, 50)
    CHINESE_BRONZE = RGB.new(0.803921568627451, 0.5019607843137255, 0.19607843137254902)
    # Chinese brown: #AB381F: (170, 56, 30)
    CHINESE_BROWN = RGB.new(0.6666666666666666, 0.2196078431372549, 0.11764705882352941)
    # Chinese green: #D0DB61: (208, 219, 97)
    CHINESE_GREEN = RGB.new(0.8156862745098039, 0.8588235294117647, 0.3803921568627451)
    # Chinese gold: #CC9900: (204, 153, 0)
    CHINESE_GOLD = RGB.new(0.8, 0.6, 0.0)
    # Chinese orange: #F37042: (243, 112, 66)
    CHINESE_ORANGE = RGB.new(0.9529411764705882, 0.4392156862745098, 0.25882352941176473)
    # Chinese pink: #DE70A1: (222, 112, 161)
    CHINESE_PINK = RGB.new(0.8705882352941177, 0.4392156862745098, 0.6313725490196078)
    # Chinese purple: #720B98: (114, 11, 152)
    CHINESE_PURPLE = RGB.new(0.4470588235294118, 0.043137254901960784, 0.596078431372549)
    # Chinese red: #CD071E: (205, 7, 30)
    CHINESE_RED = RGB.new(0.803921568627451, 0.027450980392156862, 0.11764705882352941)
    # Chinese silver: #CCCCCC: (204, 204, 204)
    CHINESE_SILVER = RGB.new(0.8, 0.8, 0.8)
    # Chinese violet: #856088: (133, 96, 136)
    CHINESE_VIOLET = RGB.new(0.5215686274509804, 0.3764705882352941, 0.5333333333333333)
    # Chinese white: #E2E5DE: (226, 229, 222)
    CHINESE_WHITE = RGB.new(0.8862745098039215, 0.8980392156862745, 0.8705882352941177)
    # Chinese yellow: #FFB200: (255, 178, 0)
    CHINESE_YELLOW = RGB.new(1.0, 0.6980392156862745, 0.0)
    # Chlorophyll green: #4AFF00: (74, 255, 0)
    CHLOROPHYLL_GREEN = RGB.new(0.2901960784313726, 1.0, 0.0)
    # Chocolate brown: #3F000F: (63, 0, 15)
    CHOCOLATE_BROWN = RGB.new(0.24705882352941178, 0.0, 0.058823529411764705)
    # Chocolate cosmos: #58111A: (88, 17, 26)
    CHOCOLATE_COSMOS = RGB.new(0.34509803921568627, 0.06666666666666667, 0.10196078431372549)
    # Chocolate Kisses: #3C1421: (60, 20, 33)
    CHOCOLATE_KISSES = RGB.new(0.23529411764705882, 0.0784313725490196, 0.12941176470588237)
    # Chocolate (traditional): #7B3F00: (123, 63, 0)
    CHOCOLATE_TRADITIONAL = RGB.new(0.4823529411764706, 0.24705882352941178, 0.0)
    # Chocolate (web): #D2691E: (210, 105, 30)
    CHOCOLATE_WEB = RGB.new(0.8235294117647058, 0.4117647058823529, 0.11764705882352941)
    # Christmas blue: #2A8FBD: (42, 143, 189)
    CHRISTMAS_BLUE = RGB.new(0.16470588235294117, 0.5607843137254902, 0.7411764705882353)
    # Christmas brown: #5D2B2C: (93, 43, 44)
    CHRISTMAS_BROWN = RGB.new(0.36470588235294116, 0.16862745098039217, 0.17254901960784313)
    # Christmas green: #3C8D0D: (60, 141, 13)
    CHRISTMAS_GREEN = RGB.new(0.23529411764705882, 0.5529411764705883, 0.050980392156862744)
    # Christmas gold: #CAA906: (202, 169, 6)
    CHRISTMAS_GOLD = RGB.new(0.792156862745098, 0.6627450980392157, 0.023529411764705882)
    # Christmas orange: #FF6600: (255, 102, 0)
    CHRISTMAS_ORANGE = RGB.new(1.0, 0.4, 0.0)
    # Christmas pink: #FFCCCB: (255, 204, 203)
    CHRISTMAS_PINK = RGB.new(1.0, 0.8, 0.796078431372549)
    # Christmas purple: #663398: (102, 51, 152)
    CHRISTMAS_PURPLE = RGB.new(0.4, 0.2, 0.596078431372549)
    # Christmas red: #AA0114: (170, 1, 20)
    CHRISTMAS_RED = RGB.new(0.6666666666666666, 0.00392156862745098, 0.0784313725490196)
    # Christmas silver: #E1DFE0: (225, 223, 224)
    CHRISTMAS_SILVER = RGB.new(0.8823529411764706, 0.8745098039215686, 0.8784313725490196)
    # Christmas yellow: #FFCC00: (255, 204, 0)
    CHRISTMAS_YELLOW = RGB.new(1.0, 0.8, 0.0)
    # Chrome yellow: #FFA700: (255, 167, 0)
    CHROME_YELLOW = RGB.new(1.0, 0.6549019607843137, 0.0)
    # Cinereous: #98817B: (152, 129, 123)
    CINEREOUS = RGB.new(0.596078431372549, 0.5058823529411764, 0.4823529411764706)
    # Cinnabar: #E34234: (227, 66, 52)
    CINNABAR = RGB.new(0.8901960784313725, 0.25882352941176473, 0.20392156862745098)
    # Cinnamon: #D2691E: (210, 105, 30)
    CINNAMON = RGB.new(0.8235294117647058, 0.4117647058823529, 0.11764705882352941)
    # Cinnamon Satin: #CD607E: (205, 96, 126)
    CINNAMON_SATIN = RGB.new(0.803921568627451, 0.3764705882352941, 0.49411764705882355)
    # Citrine: #E4D00A: (228, 208, 10)
    CITRINE = RGB.new(0.8941176470588236, 0.8156862745098039, 0.0392156862745098)
    # Citrine Brown: #933709: (147, 55, 9)
    CITRINE_BROWN = RGB.new(0.5764705882352941, 0.21568627450980393, 0.03529411764705882)
    # Citron: #9FA91F: (158, 169, 31)
    CITRON = RGB.new(0.6196078431372549, 0.6627450980392157, 0.12156862745098039)
    # Claret: #7F1734: (127, 23, 52)
    CLARET = RGB.new(0.4980392156862745, 0.09019607843137255, 0.20392156862745098)
    # Classic rose: #FBCCE7: (251, 204, 231)
    CLASSIC_ROSE = RGB.new(0.984313725490196, 0.8, 0.9058823529411765)
    # Cobalt blue: #0047AB: (0, 71, 171)
    COBALT_BLUE = RGB.new(0.0, 0.2784313725490196, 0.6705882352941176)
    # Cocoa brown: #D2691E: (210, 105, 30)
    COCOA_BROWN = RGB.new(0.8235294117647058, 0.4117647058823529, 0.11764705882352941)
    # Coconut: #965A3E: (150, 90, 62)
    COCONUT = RGB.new(0.5882352941176471, 0.35294117647058826, 0.24313725490196078)
    # Coffee: #6F4E37: (111, 78, 55)
    COFFEE = RGB.new(0.43529411764705883, 0.3058823529411765, 0.21568627450980393)
    # Cola: #3C3024: (60, 48, 36)
    COLA = RGB.new(0.23529411764705882, 0.18823529411764706, 0.1411764705882353)
    # Columbia Blue: #C4D8E2: (196, 216, 226)
    COLUMBIA_BLUE = RGB.new(0.7686274509803922, 0.8470588235294118, 0.8862745098039215)
    # Conditioner: #FFFFCC: (255, 255, 204)
    CONDITIONER = RGB.new(1.0, 1.0, 0.8)
    # Congo pink: #F88379: (248, 131, 121)
    CONGO_PINK = RGB.new(0.9725490196078431, 0.5137254901960784, 0.4745098039215686)
    # Cool black: #002E63: (0, 46, 99)
    COOL_BLACK = RGB.new(0.0, 0.1803921568627451, 0.38823529411764707)
    # Cool grey: #8C92AC: (140, 146, 172)
    COOL_GREY = RGB.new(0.5490196078431373, 0.5725490196078431, 0.6745098039215687)
    # Cookies and cream: #EEE0B1: (238, 224, 177)
    COOKIES_AND_CREAM = RGB.new(0.9333333333333333, 0.8784313725490196, 0.6941176470588235)
    # Copper: #B87333: (184, 115, 51)
    COPPER = RGB.new(0.7215686274509804, 0.45098039215686275, 0.2)
    # Copper (Crayola): #DA8A67: (218, 138, 103)
    COPPER_CRAYOLA = RGB.new(0.8549019607843137, 0.5411764705882353, 0.403921568627451)
    # Copper penny: #AD6F69: (173, 111, 105)
    COPPER_PENNY = RGB.new(0.6784313725490196, 0.43529411764705883, 0.4117647058823529)
    # Copper red: #CB6D51: (203, 109, 81)
    COPPER_RED = RGB.new(0.796078431372549, 0.42745098039215684, 0.3176470588235294)
    # Copper rose: #996666: (153, 102, 102)
    COPPER_ROSE = RGB.new(0.6, 0.4, 0.4)
    # Coquelicot: #FF3800: (255, 56, 0)
    COQUELICOT = RGB.new(1.0, 0.2196078431372549, 0.0)
    # Coral: #FF7F50: (255, 127, 80)
    CORAL = RGB.new(1.0, 0.4980392156862745, 0.3137254901960784)
    # Coral pink: #F88379: (248, 131, 121)
    CORAL_PINK = RGB.new(0.9725490196078431, 0.5137254901960784, 0.4745098039215686)
    # Coral red: #FF4040: (255, 64, 64)
    CORAL_RED = RGB.new(1.0, 0.25098039215686274, 0.25098039215686274)
    # Coral reef: #FD7C6E: (253, 124, 110)
    CORAL_REEF = RGB.new(0.9921568627450981, 0.48627450980392156, 0.43137254901960786)
    # Coral Reef (Valspar Paint Color): #F6A494: (246, 164, 148)
    CORAL_REEF_VALSPAR_PAINT_COLOR = RGB.new(0.9647058823529412, 0.6431372549019608, 0.5803921568627451)
    # Cordovan: #893F45: (137, 63, 69)
    CORDOVAN = RGB.new(0.5372549019607843, 0.24705882352941178, 0.27058823529411763)
    # Corn: #FBEC5D: (251, 236, 93)
    CORN = RGB.new(0.984313725490196, 0.9254901960784314, 0.36470588235294116)
    # Cornell red: #B31B1B: (179, 27, 27)
    CORNELL_RED = RGB.new(0.7019607843137254, 0.10588235294117647, 0.10588235294117647)
    # Cornflower blue: #6495ED: (100, 149, 237)
    CORNFLOWER_BLUE = RGB.new(0.39215686274509803, 0.5843137254901961, 0.9294117647058824)
    # Cornflower: #93CCEA: (1, 159, 222)
    CORNFLOWER = RGB.new(0.00392156862745098, 0.6235294117647059, 0.8705882352941177)
    # Cornsilk: #FFF8DC: (255, 248, 220)
    CORNSILK = RGB.new(1.0, 0.9725490196078431, 0.8627450980392157)
    # Cosmic cobalt: #2E2D88: (46, 45, 136)
    COSMIC_COBALT = RGB.new(0.1803921568627451, 0.17647058823529413, 0.5333333333333333)
    # Cosmic latte: #FFF8E7: (255, 248, 231)
    COSMIC_LATTE = RGB.new(1.0, 0.9725490196078431, 0.9058823529411765)
    # Coyote brown: #81613C: (129, 97, 60)
    COYOTE_BROWN = RGB.new(0.5058823529411764, 0.3803921568627451, 0.23529411764705882)
    # Cotton candy: #FFBCD9: (255, 188, 217)
    COTTON_CANDY = RGB.new(1.0, 0.7372549019607844, 0.8509803921568627)
    # Cream: #FFFDD0: (255, 253, 208)
    CREAM = RGB.new(1.0, 0.9921568627450981, 0.8156862745098039)
    # Crimson: #DC143C: (220, 20, 60)
    CRIMSON = RGB.new(0.8627450980392157, 0.0784313725490196, 0.23529411764705882)
    # Crimson glory: #BE0032: (190, 0, 50)
    CRIMSON_GLORY = RGB.new(0.7450980392156863, 0.0, 0.19607843137254902)
    # Crimson red: #990000: (153, 0, 0)
    CRIMSON_RED = RGB.new(0.6, 0.0, 0.0)
    # Cultured: #F5F5F5: (245, 245, 245)
    CULTURED = RGB.new(0.9607843137254902, 0.9607843137254902, 0.9607843137254902)
    # Cyan: #00FFFF: (0, 255, 255)
    CYAN = RGB.new(0.0, 1.0, 1.0)
    # Cyan azure: #4E82B4: (78, 130, 180)
    CYAN_AZURE = RGB.new(0.3058823529411765, 0.5098039215686274, 0.7058823529411765)
    # Cyan-blue azure: #4682BF: (70, 130, 191)
    CYAN_BLUE_AZURE = RGB.new(0.27450980392156865, 0.5098039215686274, 0.7490196078431373)
    # Cyan cobalt blue: #28589C: (40, 88, 156)
    CYAN_COBALT_BLUE = RGB.new(0.1568627450980392, 0.34509803921568627, 0.611764705882353)
    # Cyan cornflower blue: #188BC2: (24, 139, 194)
    CYAN_CORNFLOWER_BLUE = RGB.new(0.09411764705882353, 0.5450980392156862, 0.7607843137254902)
    # Cyan (process): #00B7EB: (0, 183, 235)
    CYAN_PROCESS = RGB.new(0.0, 0.7176470588235294, 0.9215686274509803)
    # Cyber grape: #58427C: (88, 66, 124)
    CYBER_GRAPE = RGB.new(0.34509803921568627, 0.25882352941176473, 0.48627450980392156)
    # Cyber yellow: #FFD300: (255, 211, 0)
    CYBER_YELLOW = RGB.new(1.0, 0.8274509803921568, 0.0)
    # Cyclamen: #F56FA1: (245, 111, 161)
    CYCLAMEN = RGB.new(0.9607843137254902, 0.43529411764705883, 0.6313725490196078)
    # Daffodil: #FFFF31: (255, 255, 49)
    DAFFODIL = RGB.new(1.0, 1.0, 0.19215686274509805)
    # Dandelion: #F0E130: (240, 225, 48)
    DANDELION = RGB.new(0.9411764705882353, 0.8823529411764706, 0.18823529411764706)
    # Dandelion (Crayola): #FDDB6D: (253, 219, 109)
    DANDELION_CRAYOLA = RGB.new(0.9921568627450981, 0.8588235294117647, 0.42745098039215684)
    # Dark blue: #00008B: (0, 0, 139)
    DARK_BLUE = RGB.new(0.0, 0.0, 0.5450980392156862)
    # Dark blue-gray: #666699: (102, 102, 153)
    DARK_BLUE_GRAY = RGB.new(0.4, 0.4, 0.6)
    # Dark bronze: #804A00: (128, 74, 45)
    DARK_BRONZE = RGB.new(0.5019607843137255, 0.2901960784313726, 0.17647058823529413)
    # Dark bronze (Coin): #514100: (81, 65, 0)
    DARK_BRONZE_COIN = RGB.new(0.3176470588235294, 0.2549019607843137, 0.0)
    # Dark brown: #654321: (101, 67, 33)
    DARK_BROWN = RGB.new(0.396078431372549, 0.2627450980392157, 0.12941176470588237)
    # Dark brown-tangelo: #88654E: (136, 101, 78)
    DARK_BROWN_TANGELO = RGB.new(0.5333333333333333, 0.396078431372549, 0.3058823529411765)
    # Dark byzantium: #5D3954: (93, 57, 84)
    DARK_BYZANTIUM = RGB.new(0.36470588235294116, 0.2235294117647059, 0.32941176470588235)
    # Dark candy apple red: #A40000: (164, 0, 0)
    DARK_CANDY_APPLE_RED = RGB.new(0.6431372549019608, 0.0, 0.0)
    # Dark cerulean: #08457E: (8, 69, 126)
    DARK_CERULEAN = RGB.new(0.03137254901960784, 0.27058823529411763, 0.49411764705882355)
    # Dark charcoal: #333333: (51, 51, 51)
    DARK_CHARCOAL = RGB.new(0.2, 0.2, 0.2)
    # Dark chestnut: #986960: (152, 105, 96)
    DARK_CHESTNUT = RGB.new(0.596078431372549, 0.4117647058823529, 0.3764705882352941)
    # Dark chocolate: #490206: (73, 2, 6)
    DARK_CHOCOLATE = RGB.new(0.28627450980392155, 0.00784313725490196, 0.023529411764705882)
    # Dark chocolate (Hershey's): #3C1321: (60, 19, 33)
    DARK_CHOCOLATE_HERSHEYS = RGB.new(0.23529411764705882, 0.07450980392156863, 0.12941176470588237)
    # Dark cornflower blue: #26428B: (38, 66, 139)
    DARK_CORNFLOWER_BLUE = RGB.new(0.14901960784313725, 0.25882352941176473, 0.5450980392156862)
    # Dark coral: #CD5B45: (205, 91, 69)
    DARK_CORAL = RGB.new(0.803921568627451, 0.3568627450980392, 0.27058823529411763)
    # Dark cyan: #008B8B: (0, 139, 139)
    DARK_CYAN = RGB.new(0.0, 0.5450980392156862, 0.5450980392156862)
    # Dark electric blue: #536878: (83, 104, 120)
    DARK_ELECTRIC_BLUE = RGB.new(0.3254901960784314, 0.40784313725490196, 0.47058823529411764)
    # Dark gold: #AA6C39: (170, 108, 57)
    DARK_GOLD = RGB.new(0.6666666666666666, 0.4235294117647059, 0.2235294117647059)
    # Dark goldenrod: #B8860B: (184, 134, 11)
    DARK_GOLDENROD = RGB.new(0.7215686274509804, 0.5254901960784314, 0.043137254901960784)
    # Dark gray (X11): #A9A9A9: (169, 169, 169)
    DARK_GRAY_X11 = RGB.new(0.6627450980392157, 0.6627450980392157, 0.6627450980392157)
    # Dark green: #013220: (1, 50, 32)
    DARK_GREEN = RGB.new(0.00392156862745098, 0.19607843137254902, 0.12549019607843137)
    # Dark green (X11): #006400: (0, 100, 0)
    DARK_GREEN_X11 = RGB.new(0.0, 0.39215686274509803, 0.0)
    # Dark gunmetal: #1F262A: (31, 38, 42)
    DARK_GUNMETAL = RGB.new(0.12156862745098039, 0.14901960784313725, 0.16470588235294117)
    # Dark imperial blue: #00416A: (0, 65, 106)
    DARK_IMPERIAL_BLUE = RGB.new(0.0, 0.2549019607843137, 0.41568627450980394)
    # Dark jungle green: #1A2421: (26, 36, 33)
    DARK_JUNGLE_GREEN = RGB.new(0.10196078431372549, 0.1411764705882353, 0.12941176470588237)
    # Dark khaki: #BDB76B: (189, 183, 107)
    DARK_KHAKI = RGB.new(0.7411764705882353, 0.7176470588235294, 0.4196078431372549)
    # Dark lava: #483C32: (72, 60, 50)
    DARK_LAVA = RGB.new(0.2823529411764706, 0.23529411764705882, 0.19607843137254902)
    # Dark lavender: #734F96: (115, 79, 150)
    DARK_LAVENDER = RGB.new(0.45098039215686275, 0.30980392156862746, 0.5882352941176471)
    # Dark lemon lime: #8BBE1B: (139, 190, 27)
    DARK_LEMON_LIME = RGB.new(0.5450980392156862, 0.7450980392156863, 0.10588235294117647)
    # Dark liver: #534B4F: (83, 75, 79)
    DARK_LIVER = RGB.new(0.3254901960784314, 0.29411764705882354, 0.30980392156862746)
    # Dark liver (horses): #543D37: (84, 61, 55)
    DARK_LIVER_HORSES = RGB.new(0.32941176470588235, 0.23921568627450981, 0.21568627450980393)
    # Dark magenta: #8B008B: (139, 0, 139)
    DARK_MAGENTA = RGB.new(0.5450980392156862, 0.0, 0.5450980392156862)
    # Dark medium gray: #A9A9A9: (169, 169, 169)
    DARK_MEDIUM_GRAY = RGB.new(0.6627450980392157, 0.6627450980392157, 0.6627450980392157)
    # Dark midnight blue: #003366: (0, 51, 102)
    DARK_MIDNIGHT_BLUE = RGB.new(0.0, 0.2, 0.4)
    # Dark moss green: #4A5D23: (74, 93, 35)
    DARK_MOSS_GREEN = RGB.new(0.2901960784313726, 0.36470588235294116, 0.13725490196078433)
    # Dark olive green: #556B2F: (85, 107, 47)
    DARK_OLIVE_GREEN = RGB.new(0.3333333333333333, 0.4196078431372549, 0.1843137254901961)
    # Dark orange: #FF8C00: (255, 140, 0)
    DARK_ORANGE = RGB.new(1.0, 0.5490196078431373, 0.0)
    # Dark orchid: #9932CC: (153, 50, 204)
    DARK_ORCHID = RGB.new(0.6, 0.19607843137254902, 0.8)
    # Dark pastel blue: #779ECB: (119, 158, 203)
    DARK_PASTEL_BLUE = RGB.new(0.4666666666666667, 0.6196078431372549, 0.796078431372549)
    # Dark pastel green: #03C03C: (3, 192, 60)
    DARK_PASTEL_GREEN = RGB.new(0.011764705882352941, 0.7529411764705882, 0.23529411764705882)
    # Dark pastel purple: #966FD6: (150, 111, 214)
    DARK_PASTEL_PURPLE = RGB.new(0.5882352941176471, 0.43529411764705883, 0.8392156862745098)
    # Dark pastel red: #C23B22: (194, 59, 34)
    DARK_PASTEL_RED = RGB.new(0.7607843137254902, 0.23137254901960785, 0.13333333333333333)
    # Dark pink: #E75480: (231, 84, 128)
    DARK_PINK = RGB.new(0.9058823529411765, 0.32941176470588235, 0.5019607843137255)
    # Dark powder blue: #003399: (0, 51, 153)
    DARK_POWDER_BLUE = RGB.new(0.0, 0.2, 0.6)
    # Dark puce: #4F3A3C: (79, 58, 60)
    DARK_PUCE = RGB.new(0.30980392156862746, 0.22745098039215686, 0.23529411764705882)
    # Dark purple: #301934: (48, 25, 52)
    DARK_PURPLE = RGB.new(0.18823529411764706, 0.09803921568627451, 0.20392156862745098)
    # Dark raspberry: #872657: (135, 38, 87)
    DARK_RASPBERRY = RGB.new(0.5294117647058824, 0.14901960784313725, 0.3411764705882353)
    # Dark red: #8B0000: (139, 0, 0)
    DARK_RED = RGB.new(0.5450980392156862, 0.0, 0.0)
    # Dark salmon: #E9967A: (233, 150, 122)
    DARK_SALMON = RGB.new(0.9137254901960784, 0.5882352941176471, 0.47843137254901963)
    # Dark scarlet: #560319: (86, 3, 25)
    DARK_SCARLET = RGB.new(0.33725490196078434, 0.011764705882352941, 0.09803921568627451)
    # Dark sea green: #8FBC8F: (143, 188, 143)
    DARK_SEA_GREEN = RGB.new(0.5607843137254902, 0.7372549019607844, 0.5607843137254902)
    # Dark sienna: #3C1414: (60, 20, 20)
    DARK_SIENNA = RGB.new(0.23529411764705882, 0.0784313725490196, 0.0784313725490196)
    # Dark silver: #71706E: (113, 112, 110)
    DARK_SILVER = RGB.new(0.44313725490196076, 0.4392156862745098, 0.43137254901960786)
    # Dark sky blue: #8CBED6: (140, 190, 214)
    DARK_SKY_BLUE = RGB.new(0.5490196078431373, 0.7450980392156863, 0.8392156862745098)
    # Dark slate blue: #483D8B: (72, 61, 139)
    DARK_SLATE_BLUE = RGB.new(0.2823529411764706, 0.23921568627450981, 0.5450980392156862)
    # Dark slate gray: #2F4F4F: (47, 79, 79)
    DARK_SLATE_GRAY = RGB.new(0.1843137254901961, 0.30980392156862746, 0.30980392156862746)
    # Dark spring green: #177245: (23, 114, 69)
    DARK_SPRING_GREEN = RGB.new(0.09019607843137255, 0.4470588235294118, 0.27058823529411763)
    # Dark tan: #918151: (145, 129, 81)
    DARK_TAN = RGB.new(0.5686274509803921, 0.5058823529411764, 0.3176470588235294)
    # Dark tangerine: #FFA812: (255, 168, 18)
    DARK_TANGERINE = RGB.new(1.0, 0.6588235294117647, 0.07058823529411765)
    # Dark taupe: #483C32: (72, 60, 50)
    DARK_TAUPE = RGB.new(0.2823529411764706, 0.23529411764705882, 0.19607843137254902)
    # Dark terra cotta: #CC4E5C: (204, 78, 92)
    DARK_TERRA_COTTA = RGB.new(0.8, 0.3058823529411765, 0.3607843137254902)
    # Dark turquoise: #00CED1: (0, 206, 209)
    DARK_TURQUOISE = RGB.new(0.0, 0.807843137254902, 0.8196078431372549)
    # Dark vanilla: #D1BEA8: (209, 190, 168)
    DARK_VANILLA = RGB.new(0.8196078431372549, 0.7450980392156863, 0.6588235294117647)
    # Dark violet: #9400D3: (148, 0, 211)
    DARK_VIOLET = RGB.new(0.5803921568627451, 0.0, 0.8274509803921568)
    # Dark yellow: #9B870C: (155, 135, 12)
    DARK_YELLOW = RGB.new(0.6078431372549019, 0.5294117647058824, 0.047058823529411764)
    # Dartmouth green: #00703C: (0, 112, 60)
    DARTMOUTH_GREEN = RGB.new(0.0, 0.4392156862745098, 0.23529411764705882)
    # Davy's grey: #555555: (85, 85, 85)
    DAVYS_GREY = RGB.new(0.3333333333333333, 0.3333333333333333, 0.3333333333333333)
    # Debian red: #D70A53: (215, 10, 83)
    DEBIAN_RED = RGB.new(0.8431372549019608, 0.0392156862745098, 0.3254901960784314)
    # Deep amethyst: #9C8AA4: (156, 138, 164)
    DEEP_AMETHYST = RGB.new(0.611764705882353, 0.5411764705882353, 0.6431372549019608)
    # Deep aquamarine: #40826D: (64, 130, 109)
    DEEP_AQUAMARINE = RGB.new(0.25098039215686274, 0.5098039215686274, 0.42745098039215684)
    # Deep carmine: #A9203E: (169, 32, 62)
    DEEP_CARMINE = RGB.new(0.6627450980392157, 0.12549019607843137, 0.24313725490196078)
    # Deep carmine pink: #EF3038: (239, 48, 56)
    DEEP_CARMINE_PINK = RGB.new(0.9372549019607843, 0.18823529411764706, 0.2196078431372549)
    # Deep carrot orange: #E9692C: (233, 105, 44)
    DEEP_CARROT_ORANGE = RGB.new(0.9137254901960784, 0.4117647058823529, 0.17254901960784313)
    # Deep cerise: #DA3287: (218, 50, 135)
    DEEP_CERISE = RGB.new(0.8549019607843137, 0.19607843137254902, 0.5294117647058824)
    # Deep champagne: #FAD6A5: (250, 214, 165)
    DEEP_CHAMPAGNE = RGB.new(0.9803921568627451, 0.8392156862745098, 0.6470588235294118)
    # Deep chestnut: #B94E48: (185, 78, 72)
    DEEP_CHESTNUT = RGB.new(0.7254901960784313, 0.3058823529411765, 0.2823529411764706)
    # Deep coffee: #704241: (112, 66, 65)
    DEEP_COFFEE = RGB.new(0.4392156862745098, 0.25882352941176473, 0.2549019607843137)
    # Deep fuchsia: #C154C1: (193, 84, 193)
    DEEP_FUCHSIA = RGB.new(0.7568627450980392, 0.32941176470588235, 0.7568627450980392)
    # Deep Green: #056608: (5, 102, 8)
    DEEP_GREEN = RGB.new(0.0196078431372549, 0.4, 0.03137254901960784)
    # Deep green-cyan turquoise: #0E7C61: (14, 124, 97)
    DEEP_GREEN_CYAN_TURQUOISE = RGB.new(0.054901960784313725, 0.48627450980392156, 0.3803921568627451)
    # Deep jungle green: #004B49: (0, 75, 73)
    DEEP_JUNGLE_GREEN = RGB.new(0.0, 0.29411764705882354, 0.28627450980392155)
    # Deep koamaru: #333366: (51, 51, 102)
    DEEP_KOAMARU = RGB.new(0.2, 0.2, 0.4)
    # Deep lemon: #F5C71A: (245, 199, 26)
    DEEP_LEMON = RGB.new(0.9607843137254902, 0.7803921568627451, 0.10196078431372549)
    # Deep lilac: #9955BB: (153, 85, 187)
    DEEP_LILAC = RGB.new(0.6, 0.3333333333333333, 0.7333333333333333)
    # Deep magenta: #CC00CC: (204, 0, 204)
    DEEP_MAGENTA = RGB.new(0.8, 0.0, 0.8)
    # Deep maroon: #820000: (130, 0, 0)
    DEEP_MAROON = RGB.new(0.5098039215686274, 0.0, 0.0)
    # Deep mauve: #D473D4: (212, 115, 212)
    DEEP_MAUVE = RGB.new(0.8313725490196079, 0.45098039215686275, 0.8313725490196079)
    # Deep moss green: #355E3B: (53, 94, 59)
    DEEP_MOSS_GREEN = RGB.new(0.20784313725490197, 0.3686274509803922, 0.23137254901960785)
    # Deep peach: #FFCBA4: (255, 203, 164)
    DEEP_PEACH = RGB.new(1.0, 0.796078431372549, 0.6431372549019608)
    # Deep pink: #FF1493: (255, 20, 147)
    DEEP_PINK = RGB.new(1.0, 0.0784313725490196, 0.5764705882352941)
    # Deep puce: #A95C68: (169, 92, 104)
    DEEP_PUCE = RGB.new(0.6627450980392157, 0.3607843137254902, 0.40784313725490196)
    # Deep Red: #850101: (133, 1, 1)
    DEEP_RED = RGB.new(0.5215686274509804, 0.00392156862745098, 0.00392156862745098)
    # Deep ruby: #843F5B: (132, 63, 91)
    DEEP_RUBY = RGB.new(0.5176470588235295, 0.24705882352941178, 0.3568627450980392)
    # Deep saffron: #FF9933: (255, 153, 51)
    DEEP_SAFFRON = RGB.new(1.0, 0.6, 0.2)
    # Deep sky blue: #00BFFF: (0, 191, 255)
    DEEP_SKY_BLUE = RGB.new(0.0, 0.7490196078431373, 1.0)
    # Deep Space Sparkle: #4A646C: (74, 100, 108)
    DEEP_SPACE_SPARKLE = RGB.new(0.2901960784313726, 0.39215686274509803, 0.4235294117647059)
    # Deep spring bud: #556B2F: (85, 107, 47)
    DEEP_SPRING_BUD = RGB.new(0.3333333333333333, 0.4196078431372549, 0.1843137254901961)
    # Deep Taupe: #7E5E60: (126, 94, 96)
    DEEP_TAUPE = RGB.new(0.49411764705882355, 0.3686274509803922, 0.3764705882352941)
    # Deep Tuscan red: #66424D: (102, 66, 77)
    DEEP_TUSCAN_RED = RGB.new(0.4, 0.25882352941176473, 0.30196078431372547)
    # Deep violet: #330066: (51, 0, 102)
    DEEP_VIOLET = RGB.new(0.2, 0.0, 0.4)
    # Deer: #BA8759: (186, 135, 89)
    DEER = RGB.new(0.7294117647058823, 0.5294117647058824, 0.34901960784313724)
    # Denim: #1560BD: (21, 96, 189)
    DENIM = RGB.new(0.08235294117647059, 0.3764705882352941, 0.7411764705882353)
    # Denim Blue: #2243B6: (34, 67, 182)
    DENIM_BLUE = RGB.new(0.13333333333333333, 0.2627450980392157, 0.7137254901960784)
    # Desaturated cyan: #669999: (102, 153, 153)
    DESATURATED_CYAN = RGB.new(0.4, 0.6, 0.6)
    # Desert: #C19A6B: (193, 154, 107)
    DESERT = RGB.new(0.7568627450980392, 0.6039215686274509, 0.4196078431372549)
    # Desert sand: #EDC9AF: (237, 201, 175)
    DESERT_SAND = RGB.new(0.9294117647058824, 0.788235294117647, 0.6862745098039216)
    # Desire: #EA3C53: (234, 60, 83)
    DESIRE = RGB.new(0.9176470588235294, 0.23529411764705882, 0.3254901960784314)
    # Diamond: #B9F2FF: (185, 242, 255)
    DIAMOND = RGB.new(0.7254901960784313, 0.9490196078431372, 1.0)
    # Dim gray: #696969: (105, 105, 105)
    DIM_GRAY = RGB.new(0.4117647058823529, 0.4117647058823529, 0.4117647058823529)
    # Dingy Dungeon: #C53151: (197, 49, 81)
    DINGY_DUNGEON = RGB.new(0.7725490196078432, 0.19215686274509805, 0.3176470588235294)
    # Dirt: #9B7653: (155, 118, 83)
    DIRT = RGB.new(0.6078431372549019, 0.4627450980392157, 0.3254901960784314)
    # Dirty brown: #B5651E: (181, 101, 30)
    DIRTY_BROWN = RGB.new(0.7098039215686275, 0.396078431372549, 0.11764705882352941)
    # Dirty white: #E8E4C9: (232, 228, 201)
    DIRTY_WHITE = RGB.new(0.9098039215686274, 0.8941176470588236, 0.788235294117647)
    # Dodger blue: #1E90FF: (30, 144, 255)
    DODGER_BLUE = RGB.new(0.11764705882352941, 0.5647058823529412, 1.0)
    # Dodie yellow: #FEF65B: (254, 246, 91)
    DODIE_YELLOW = RGB.new(0.996078431372549, 0.9647058823529412, 0.3568627450980392)
    # Dogwood rose: #D71868: (215, 24, 104)
    DOGWOOD_ROSE = RGB.new(0.8431372549019608, 0.09411764705882353, 0.40784313725490196)
    # Dollar bill: #85BB65: (133, 187, 101)
    DOLLAR_BILL = RGB.new(0.5215686274509804, 0.7333333333333333, 0.396078431372549)
    # Dolphin gray: #828E84: (130, 142, 132)
    DOLPHIN_GRAY = RGB.new(0.5098039215686274, 0.5568627450980392, 0.5176470588235295)
    # Donkey brown: #664C28: (102, 76, 40)
    DONKEY_BROWN = RGB.new(0.4, 0.2980392156862745, 0.1568627450980392)
    # Drab: #967117: (150, 113, 23)
    DRAB = RGB.new(0.5882352941176471, 0.44313725490196076, 0.09019607843137255)
    # Duke blue: #00009C: (0, 0, 156)
    DUKE_BLUE = RGB.new(0.0, 0.0, 0.611764705882353)
    # Dust storm: #E5CCC9: (229, 204, 201)
    DUST_STORM = RGB.new(0.8980392156862745, 0.8, 0.788235294117647)
    # Dutch white: #EFDFBB: (239, 223, 187)
    DUTCH_WHITE = RGB.new(0.9372549019607843, 0.8745098039215686, 0.7333333333333333)
    # Earthtone: #5D3A1A: (93, 58, 26)
    EARTHTONE = RGB.new(0.36470588235294116, 0.22745098039215686, 0.10196078431372549)
    # Earth yellow: #E1A95F: (225, 169, 95)
    EARTH_YELLOW = RGB.new(0.8823529411764706, 0.6627450980392157, 0.37254901960784315)
    # Ebony: #555D50: (85, 93, 80)
    EBONY = RGB.new(0.3333333333333333, 0.36470588235294116, 0.3137254901960784)
    # Ecru: #C2B280: (194, 178, 128)
    ECRU = RGB.new(0.7607843137254902, 0.6980392156862745, 0.5019607843137255)
    # Eerie black: #1B1B1B: (27, 27, 27)
    EERIE_BLACK = RGB.new(0.10588235294117647, 0.10588235294117647, 0.10588235294117647)
    # Eggplant: #614051: (97, 64, 81)
    EGGPLANT = RGB.new(0.3803921568627451, 0.25098039215686274, 0.3176470588235294)
    # Eggshell: #F0EAD6: (240, 234, 214)
    EGGSHELL = RGB.new(0.9411764705882353, 0.9176470588235294, 0.8392156862745098)
    # Egyptian blue: #1034A6: (16, 52, 166)
    EGYPTIAN_BLUE = RGB.new(0.06274509803921569, 0.20392156862745098, 0.6509803921568628)
    # Electric blue: #7DF9FF: (125, 249, 255)
    ELECTRIC_BLUE = RGB.new(0.49019607843137253, 0.9764705882352941, 1.0)
    # Electric brown: #B56257: (181, 98, 87)
    ELECTRIC_BROWN = RGB.new(0.7098039215686275, 0.3843137254901961, 0.3411764705882353)
    # Electric crimson: #FF003F: (255, 0, 63)
    ELECTRIC_CRIMSON = RGB.new(1.0, 0.0, 0.24705882352941178)
    # Electric cyan: #00FFFF: (0, 255, 255)
    ELECTRIC_CYAN = RGB.new(0.0, 1.0, 1.0)
    # Electric green: #00FF00: (0, 255, 0)
    ELECTRIC_GREEN = RGB.new(0.0, 1.0, 0.0)
    # Electric indigo: #6F00FF: (111, 0, 255)
    ELECTRIC_INDIGO = RGB.new(0.43529411764705883, 0.0, 1.0)
    # Electric lavender: #F4BBFF: (244, 187, 255)
    ELECTRIC_LAVENDER = RGB.new(0.9568627450980393, 0.7333333333333333, 1.0)
    # Electric lime: #CCFF00: (204, 255, 0)
    ELECTRIC_LIME = RGB.new(0.8, 1.0, 0.0)
    # Electric orange: #FF3503: (255, 53, 3)
    ELECTRIC_ORANGE = RGB.new(1.0, 0.20784313725490197, 0.011764705882352941)
    # Electric pink: #F62681: (246, 38, 129)
    ELECTRIC_PINK = RGB.new(0.9647058823529412, 0.14901960784313725, 0.5058823529411764)
    # Electric purple: #BF00FF: (191, 0, 255)
    ELECTRIC_PURPLE = RGB.new(0.7490196078431373, 0.0, 1.0)
    # Electric red: #E60000: (230, 0, 0)
    ELECTRIC_RED = RGB.new(0.9019607843137255, 0.0, 0.0)
    # Electric ultramarine: #3F00FF: (63, 0, 255)
    ELECTRIC_ULTRAMARINE = RGB.new(0.24705882352941178, 0.0, 1.0)
    # Electric violet: #8F00FF: (143, 0, 255)
    ELECTRIC_VIOLET = RGB.new(0.5607843137254902, 0.0, 1.0)
    # Electric yellow: #FFFF33: (255, 255, 51)
    ELECTRIC_YELLOW = RGB.new(1.0, 1.0, 0.2)
    # Emerald: #50C878: (80, 200, 120)
    EMERALD = RGB.new(0.3137254901960784, 0.7843137254901961, 0.47058823529411764)
    # Emerald green: #046307: (4, 99, 7)
    EMERALD_GREEN = RGB.new(0.01568627450980392, 0.38823529411764707, 0.027450980392156862)
    # Eminence: #6C3082: (108, 48, 130)
    EMINENCE = RGB.new(0.4235294117647059, 0.18823529411764706, 0.5098039215686274)
    # English green: #1B4D3E: (27, 77, 62)
    ENGLISH_GREEN = RGB.new(0.10588235294117647, 0.30196078431372547, 0.24313725490196078)
    # English lavender: #B48395: (180, 131, 149)
    ENGLISH_LAVENDER = RGB.new(0.7058823529411765, 0.5137254901960784, 0.5843137254901961)
    # English red: #AB4B52: (171, 75, 82)
    ENGLISH_RED = RGB.new(0.6705882352941176, 0.29411764705882354, 0.3215686274509804)
    # English vermillion: #CC474B: (204, 71, 75)
    ENGLISH_VERMILLION = RGB.new(0.8, 0.2784313725490196, 0.29411764705882354)
    # English violet: #563C5C: (86, 60, 92)
    ENGLISH_VIOLET = RGB.new(0.33725490196078434, 0.23529411764705882, 0.3607843137254902)
    # Eton blue: #96C8A2: (150, 200, 162)
    ETON_BLUE = RGB.new(0.5882352941176471, 0.7843137254901961, 0.6352941176470588)
    # Eucalyptus: #44D7A8: (68, 215, 168)
    EUCALYPTUS = RGB.new(0.26666666666666666, 0.8431372549019608, 0.6588235294117647)
    # Facebook Blue: #39569C: (57, 86, 156)
    FACEBOOK_BLUE = RGB.new(0.2235294117647059, 0.33725490196078434, 0.611764705882353)
    # Fallow: #C19A6B: (193, 154, 107)
    FALLOW = RGB.new(0.7568627450980392, 0.6039215686274509, 0.4196078431372549)
    # Falu red: #801818: (128, 24, 24)
    FALU_RED = RGB.new(0.5019607843137255, 0.09411764705882353, 0.09411764705882353)
    # Fandango: #B53389: (181, 51, 137)
    FANDANGO = RGB.new(0.7098039215686275, 0.2, 0.5372549019607843)
    # Fandango pink: #DE5285: (222, 82, 133)
    FANDANGO_PINK = RGB.new(0.8705882352941177, 0.3215686274509804, 0.5215686274509804)
    # Fashion fuchsia: #F400A1: (244, 0, 161)
    FASHION_FUCHSIA = RGB.new(0.9568627450980393, 0.0, 0.6313725490196078)
    # Fawn: #E5AA70: (229, 170, 112)
    FAWN = RGB.new(0.8980392156862745, 0.6666666666666666, 0.4392156862745098)
    # Feldgrau: #4D5D53: (77, 93, 83)
    FELDGRAU = RGB.new(0.30196078431372547, 0.36470588235294116, 0.3254901960784314)
    # Feldspar: #FDD5B1: (253, 213, 177)
    FELDSPAR = RGB.new(0.9921568627450981, 0.8352941176470589, 0.6941176470588235)
    # Fern green: #4F7942: (79, 121, 66)
    FERN_GREEN = RGB.new(0.30980392156862746, 0.4745098039215686, 0.25882352941176473)
    # Ferrari red: #FF2800: (255, 40, 0)
    FERRARI_RED = RGB.new(1.0, 0.1568627450980392, 0.0)
    # Field drab: #6C541E: (108, 84, 30)
    FIELD_DRAB = RGB.new(0.4235294117647059, 0.32941176470588235, 0.11764705882352941)
    # Fiery rose: #FF5470: (255, 84, 112)
    FIERY_ROSE = RGB.new(1.0, 0.32941176470588235, 0.4392156862745098)
    # Firebrick: #B22222: (178, 34, 34)
    FIREBRICK = RGB.new(0.6980392156862745, 0.13333333333333333, 0.13333333333333333)
    # Fire engine red: #CE2029: (206, 32, 41)
    FIRE_ENGINE_RED = RGB.new(0.807843137254902, 0.12549019607843137, 0.1607843137254902)
    # Fire opal: #E95C4B: (233, 92, 75)
    FIRE_OPAL = RGB.new(0.9137254901960784, 0.3607843137254902, 0.29411764705882354)
    # Flame: #E25822: (226, 88, 34)
    FLAME = RGB.new(0.8862745098039215, 0.34509803921568627, 0.13333333333333333)
    # Flamingo pink: #FC8EAC: (252, 142, 172)
    FLAMINGO_PINK = RGB.new(0.9882352941176471, 0.5568627450980392, 0.6745098039215687)
    # Flattery: #6B4423: (107, 68, 35)
    FLATTERY = RGB.new(0.4196078431372549, 0.26666666666666666, 0.13725490196078433)
    # Flavescent: #F7E98E: (247, 233, 142)
    FLAVESCENT = RGB.new(0.9686274509803922, 0.9137254901960784, 0.5568627450980392)
    # Flax: #EEDC82: (238, 220, 130)
    FLAX = RGB.new(0.9333333333333333, 0.8627450980392157, 0.5098039215686274)
    # Flickr Blue: #216BD6: (33, 107, 214)
    FLICKR_BLUE = RGB.new(0.12941176470588237, 0.4196078431372549, 0.8392156862745098)
    # Flickr Pink: #FB0081: (251, 0, 129)
    FLICKR_PINK = RGB.new(0.984313725490196, 0.0, 0.5058823529411764)
    # Flirt: #A2006D: (162, 0, 109)
    FLIRT = RGB.new(0.6352941176470588, 0.0, 0.42745098039215684)
    # Floral white: #FFFAF0: (255, 250, 240)
    FLORAL_WHITE = RGB.new(1.0, 0.9803921568627451, 0.9411764705882353)
    # Flower girl: #F498AD: (244, 152, 173)
    FLOWER_GIRL = RGB.new(0.9568627450980393, 0.596078431372549, 0.6784313725490196)
    # Fluorescent blue: #15F4EE: (21, 244, 238)
    FLUORESCENT_BLUE = RGB.new(0.08235294117647059, 0.9568627450980393, 0.9333333333333333)
    # Fluorescent orange: #FFBF00: (255, 191, 0)
    FLUORESCENT_ORANGE = RGB.new(1.0, 0.7490196078431373, 0.0)
    # Fluorescent pink: #FF1493: (255, 20, 147)
    FLUORESCENT_PINK = RGB.new(1.0, 0.0784313725490196, 0.5764705882352941)
    # Fluorescent yellow: #CCFF00: (204, 255, 0)
    FLUORESCENT_YELLOW = RGB.new(0.8, 1.0, 0.0)
    # Folly: #FF004F: (255, 0, 79)
    FOLLY = RGB.new(1.0, 0.0, 0.30980392156862746)
    # Forest green (Crayola): #5FA777: (95, 167, 119)
    FOREST_GREEN_CRAYOLA = RGB.new(0.37254901960784315, 0.6549019607843137, 0.4666666666666667)
    # Forest green (traditional): #014421: (1, 68, 33)
    FOREST_GREEN_TRADITIONAL = RGB.new(0.00392156862745098, 0.26666666666666666, 0.12941176470588237)
    # Forest green (web): #228B22: (34, 139, 34)
    FOREST_GREEN_WEB = RGB.new(0.13333333333333333, 0.5450980392156862, 0.13333333333333333)
    # French beige: #A67B5B: (166, 123, 91)
    FRENCH_BEIGE = RGB.new(0.6509803921568628, 0.4823529411764706, 0.3568627450980392)
    # French bistre: #856D4D: (133, 109, 77)
    FRENCH_BISTRE = RGB.new(0.5215686274509804, 0.42745098039215684, 0.30196078431372547)
    # French blue: #0072BB: (0, 114, 187)
    FRENCH_BLUE = RGB.new(0.0, 0.4470588235294118, 0.7333333333333333)
    # French fuchsia: #FD3F92: (253, 63, 146)
    FRENCH_FUCHSIA = RGB.new(0.9921568627450981, 0.24705882352941178, 0.5725490196078431)
    # French lilac: #86608E: (134, 96, 142)
    FRENCH_LILAC = RGB.new(0.5254901960784314, 0.3764705882352941, 0.5568627450980392)
    # French lime: #9EFD38: (158, 253, 56)
    FRENCH_LIME = RGB.new(0.6196078431372549, 0.9921568627450981, 0.2196078431372549)
    # French mauve: #D473D4: (212, 115, 212)
    FRENCH_MAUVE = RGB.new(0.8313725490196079, 0.45098039215686275, 0.8313725490196079)
    # French Middle Red Purple: #1C0218: (28, 2, 24)
    FRENCH_MIDDLE_RED_PURPLE = RGB.new(0.10980392156862745, 0.00784313725490196, 0.09411764705882353)
    # French pink: #FD6C9E: (253, 108, 158)
    FRENCH_PINK = RGB.new(0.9921568627450981, 0.4235294117647059, 0.6196078431372549)
    # French plum: #811453: (129, 20, 83)
    FRENCH_PLUM = RGB.new(0.5058823529411764, 0.0784313725490196, 0.3254901960784314)
    # French puce: #4E1609: (78, 22, 9)
    FRENCH_PUCE = RGB.new(0.3058823529411765, 0.08627450980392157, 0.03529411764705882)
    # French raspberry: #C72C48: (199, 44, 72)
    FRENCH_RASPBERRY = RGB.new(0.7803921568627451, 0.17254901960784313, 0.2823529411764706)
    # French rose: #F64A8A: (246, 74, 138)
    FRENCH_ROSE = RGB.new(0.9647058823529412, 0.2901960784313726, 0.5411764705882353)
    # French sky blue: #77B5FE: (119, 181, 254)
    FRENCH_SKY_BLUE = RGB.new(0.4666666666666667, 0.7098039215686275, 0.996078431372549)
    # French violet: #8806CE: (136, 6, 206)
    FRENCH_VIOLET = RGB.new(0.5333333333333333, 0.023529411764705882, 0.807843137254902)
    # French wine: #AC1E44: (172, 30, 68)
    FRENCH_WINE = RGB.new(0.6745098039215687, 0.11764705882352941, 0.26666666666666666)
    # Fresh Air: #A6E7FF: (166, 231, 255)
    FRESH_AIR = RGB.new(0.6509803921568628, 0.9058823529411765, 1.0)
    # Frostbite: #E936A7: (233, 54, 167)
    FROSTBITE = RGB.new(0.9137254901960784, 0.21176470588235294, 0.6549019607843137)
    # Fuchsia: #FF00FF: (255, 0, 255)
    FUCHSIA = RGB.new(1.0, 0.0, 1.0)
    # Fuchsia (Crayola): #C154C1: (193, 84, 193)
    FUCHSIA_CRAYOLA = RGB.new(0.7568627450980392, 0.32941176470588235, 0.7568627450980392)
    # Fuchsia pink: #FF77FF: (255, 119, 255)
    FUCHSIA_PINK = RGB.new(1.0, 0.4666666666666667, 1.0)
    # Fuchsia purple: #CC397B: (204, 57, 123)
    FUCHSIA_PURPLE = RGB.new(0.8, 0.2235294117647059, 0.4823529411764706)
    # Fuchsia rose: #C74375: (199, 67, 117)
    FUCHSIA_ROSE = RGB.new(0.7803921568627451, 0.2627450980392157, 0.4588235294117647)
    # Fulvous: #E48400: (228, 132, 0)
    FULVOUS = RGB.new(0.8941176470588236, 0.5176470588235295, 0.0)
    # Fuzzy Wuzzy: #CC6666: (204, 102, 102)
    FUZZY_WUZZY = RGB.new(0.8, 0.4, 0.4)
    # Gainsboro: #DCDCDC: (220, 220, 220)
    GAINSBORO = RGB.new(0.8627450980392157, 0.8627450980392157, 0.8627450980392157)
    # Gamboge: #E49B0F: (228, 155, 15)
    GAMBOGE = RGB.new(0.8941176470588236, 0.6078431372549019, 0.058823529411764705)
    # Gamboge orange (brown): #996600: (152, 102, 0)
    GAMBOGE_ORANGE_BROWN = RGB.new(0.596078431372549, 0.4, 0.0)
    # Garnet: #733635: (115, 54, 53)
    GARNET = RGB.new(0.45098039215686275, 0.21176470588235294, 0.20784313725490197)
    # Gargoyle Gas: #FFDF46: (255, 223, 70)
    GARGOYLE_GAS = RGB.new(1.0, 0.8745098039215686, 0.27450980392156865)
    # Generic viridian: #007F66: (0, 127, 102)
    GENERIC_VIRIDIAN = RGB.new(0.0, 0.4980392156862745, 0.4)
    # Ghost white: #F8F8FF: (248, 248, 255)
    GHOST_WHITE = RGB.new(0.9725490196078431, 0.9725490196078431, 1.0)
    # Giant's Club: #B05C52: (176, 92, 82)
    GIANTS_CLUB = RGB.new(0.6901960784313725, 0.3607843137254902, 0.3215686274509804)
    # Giants orange: #FE5A1D: (254, 90, 29)
    GIANTS_ORANGE = RGB.new(0.996078431372549, 0.35294117647058826, 0.11372549019607843)
    # Gin: #D8E4BC: (216, 228, 188)
    GIN = RGB.new(0.8470588235294118, 0.8941176470588236, 0.7372549019607844)
    # Glaucous: #6082B6: (96, 130, 182)
    GLAUCOUS = RGB.new(0.3764705882352941, 0.5098039215686274, 0.7137254901960784)
    # Glossy grape: #AB92B3: (171, 146, 179)
    GLOSSY_GRAPE = RGB.new(0.6705882352941176, 0.5725490196078431, 0.7019607843137254)
    # GO green: #00AB66: (0, 171, 102)
    GO_GREEN = RGB.new(0.0, 0.6705882352941176, 0.4)
    # Gold: #A57C00: (165, 124, 0)
    GOLD = RGB.new(0.6470588235294118, 0.48627450980392156, 0.0)
    # Gold (metallic): #D4AF37: (212, 175, 55)
    GOLD_METALLIC = RGB.new(0.8313725490196079, 0.6862745098039216, 0.21568627450980393)
    # Gold (web) (Golden): #FFD700: (255, 215, 0)
    GOLD_WEB_GOLDEN = RGB.new(1.0, 0.8431372549019608, 0.0)
    # Gold (Crayola): #E6BE8A: (230, 190, 138)
    GOLD_CRAYOLA = RGB.new(0.9019607843137255, 0.7450980392156863, 0.5411764705882353)
    # Gold Fusion: #85754E: (133, 117, 78)
    GOLD_FUSION = RGB.new(0.5215686274509804, 0.4588235294117647, 0.3058823529411765)
    # Gold foil: #BD9B16: (189, 155, 22)
    GOLD_FOIL = RGB.new(0.7411764705882353, 0.6078431372549019, 0.08627450980392157)
    # Golden brown: #996515: (153, 101, 21)
    GOLDEN_BROWN = RGB.new(0.6, 0.396078431372549, 0.08235294117647059)
    # Golden poppy: #FCC200: (252, 194, 0)
    GOLDEN_POPPY = RGB.new(0.9882352941176471, 0.7607843137254902, 0.0)
    # Golden yellow: #FFDF00: (255, 223, 0)
    GOLDEN_YELLOW = RGB.new(1.0, 0.8745098039215686, 0.0)
    # Goldenrod: #DAA520: (218, 165, 32)
    GOLDENROD = RGB.new(0.8549019607843137, 0.6470588235294118, 0.12549019607843137)
    # Google Chrome red: #DE5246: (222, 82, 70)
    GOOGLE_CHROME_RED = RGB.new(0.8705882352941177, 0.3215686274509804, 0.27450980392156865)
    # Google Chrome blue: #4C8BF5: (76, 139, 245)
    GOOGLE_CHROME_BLUE = RGB.new(0.2980392156862745, 0.5450980392156862, 0.9607843137254902)
    # Google Chrome green: #1AA260: (26, 162, 96)
    GOOGLE_CHROME_GREEN = RGB.new(0.10196078431372549, 0.6352941176470588, 0.3764705882352941)
    # Google Chrome yellow: #FFCE44: (255, 206, 68)
    GOOGLE_CHROME_YELLOW = RGB.new(1.0, 0.807843137254902, 0.26666666666666666)
    # Granite gray: #676767: (103, 103, 103)
    GRANITE_GRAY = RGB.new(0.403921568627451, 0.403921568627451, 0.403921568627451)
    # Granny Smith apple: #A8E4A0: (168, 228, 160)
    GRANNY_SMITH_APPLE = RGB.new(0.6588235294117647, 0.8941176470588236, 0.6274509803921569)
    # Grape: #6F2DA8: (111, 45, 168)
    GRAPE = RGB.new(0.43529411764705883, 0.17647058823529413, 0.6588235294117647)
    # Gray (HTML/CSS gray): #808080: (128, 128, 128)
    GRAY_HTML_CSS_GRAY = RGB.new(0.5019607843137255, 0.5019607843137255, 0.5019607843137255)
    # Gray (X11 gray): #BEBEBE: (190, 190, 190)
    GRAY_X11_GRAY = RGB.new(0.7450980392156863, 0.7450980392156863, 0.7450980392156863)
    # Gray-asparagus: #465945: (70, 89, 69)
    GRAY_ASPARAGUS = RGB.new(0.27450980392156865, 0.34901960784313724, 0.27058823529411763)
    # Gray-blue: #8C92AC: (140, 146, 172)
    GRAY_BLUE = RGB.new(0.5490196078431373, 0.5725490196078431, 0.6745098039215687)
    # Green: #008001: (0, 128, 1)
    GREEN = RGB.new(0.0, 0.5019607843137255, 0.00392156862745098)
    # Green (Color Wheel) (X11 green): #00FF00: (0, 255, 0)
    GREEN_COLOR_WHEEL_X11_GREEN = RGB.new(0.0, 1.0, 0.0)
    # Green (Crayola): #1CAC78: (28, 172, 120)
    GREEN_CRAYOLA = RGB.new(0.10980392156862745, 0.6745098039215687, 0.47058823529411764)
    # Green (HTML/CSS color): #008000: (0, 128, 0)
    GREEN_HTML_CSS_COLOR = RGB.new(0.0, 0.5019607843137255, 0.0)
    # Green (Munsell): #00A877: (0, 168, 119)
    GREEN_MUNSELL = RGB.new(0.0, 0.6588235294117647, 0.4666666666666667)
    # Green (NCS): #009F6B: (0, 159, 107)
    GREEN_NCS = RGB.new(0.0, 0.6235294117647059, 0.4196078431372549)
    # Green (Pantone): #00AD43: (0, 173, 67)
    GREEN_PANTONE = RGB.new(0.0, 0.6784313725490196, 0.2627450980392157)
    # Green (pigment): #00A550: (0, 165, 80)
    GREEN_PIGMENT = RGB.new(0.0, 0.6470588235294118, 0.3137254901960784)
    # Green (RYB): #66B032: (102, 176, 50)
    GREEN_RYB = RGB.new(0.4, 0.6901960784313725, 0.19607843137254902)
    # Green-blue: #1164B4: (17, 100, 180)
    GREEN_BLUE = RGB.new(0.06666666666666667, 0.39215686274509803, 0.7058823529411765)
    # Green-blue (Crayola): #2887C8: (40, 135, 200)
    GREEN_BLUE_CRAYOLA = RGB.new(0.1568627450980392, 0.5294117647058824, 0.7843137254901961)
    # Green Cola: #4C721D: (76, 114, 29)
    GREEN_COLA = RGB.new(0.2980392156862745, 0.4470588235294118, 0.11372549019607843)
    # Green-cyan: #009966: (0, 153, 102)
    GREEN_CYAN = RGB.new(0.0, 0.6, 0.4)
    # Green Lizard: #A7F432: (167, 244, 50)
    GREEN_LIZARD = RGB.new(0.6549019607843137, 0.9568627450980393, 0.19607843137254902)
    # Green Sheen: #6EAEA1: (110, 174, 161)
    GREEN_SHEEN = RGB.new(0.43137254901960786, 0.6823529411764706, 0.6313725490196078)
    # Green slime: #65FF00: (101, 255, 0)
    GREEN_SLIME = RGB.new(0.396078431372549, 1.0, 0.0)
    # Green-yellow: #ADFF2F: (173, 255, 47)
    GREEN_YELLOW = RGB.new(0.6784313725490196, 1.0, 0.1843137254901961)
    # Green-yellow (Crayola): #F0E891: (240, 232, 145)
    GREEN_YELLOW_CRAYOLA = RGB.new(0.9411764705882353, 0.9098039215686274, 0.5686274509803921)
    # Grullo: #A99A86: (169, 154, 134)
    GRULLO = RGB.new(0.6627450980392157, 0.6039215686274509, 0.5254901960784314)
    # Guppie green: #00FF7F: (0, 255, 127)
    GUPPIE_GREEN = RGB.new(0.0, 1.0, 0.4980392156862745)
    # Gunmetal: #2a3439: (42, 52, 57)
    GUNMETAL = RGB.new(0.16470588235294117, 0.20392156862745098, 0.2235294117647059)
    # Guyabano: #F8F8F8: (248, 248, 248)
    GUYABANO = RGB.new(0.9725490196078431, 0.9725490196078431, 0.9725490196078431)
    # Halayà úbe: #663854: (102, 55, 84)
    HALAYA_UBE = RGB.new(0.4, 0.21568627450980393, 0.32941176470588235)
    # Halloween orange: #EB6123: (235, 97, 35)
    HALLOWEEN_ORANGE = RGB.new(0.9215686274509803, 0.3803921568627451, 0.13725490196078433)
    # Han blue: #446CCF: (68, 108, 207)
    HAN_BLUE = RGB.new(0.26666666666666666, 0.4235294117647059, 0.8117647058823529)
    # Han purple: #5218FA: (82, 24, 250)
    HAN_PURPLE = RGB.new(0.3215686274509804, 0.09411764705882353, 0.9803921568627451)
    # Hansa yellow: #E9D66B: (233, 214, 107)
    HANSA_YELLOW = RGB.new(0.9137254901960784, 0.8392156862745098, 0.4196078431372549)
    # Harlequin: #3FFF00: (63, 255, 0)
    HARLEQUIN = RGB.new(0.24705882352941178, 1.0, 0.0)
    # Harlequin green: #46CB18: (70, 203, 24)
    HARLEQUIN_GREEN = RGB.new(0.27450980392156865, 0.796078431372549, 0.09411764705882353)
    # Harmonious rose: #F29CB7: (242, 156, 183)
    HARMONIOUS_ROSE = RGB.new(0.9490196078431372, 0.611764705882353, 0.7176470588235294)
    # Harvard crimson: #C90016: (201, 0, 22)
    HARVARD_CRIMSON = RGB.new(0.788235294117647, 0.0, 0.08627450980392157)
    # Harvest gold: #DA9100: (218, 145, 0)
    HARVEST_GOLD = RGB.new(0.8549019607843137, 0.5686274509803921, 0.0)
    # Heart gold: #808000: (128, 128, 0)
    HEART_GOLD = RGB.new(0.5019607843137255, 0.5019607843137255, 0.0)
    # Heat Wave: #FF7A00: (255, 122, 0)
    HEAT_WAVE = RGB.new(1.0, 0.47843137254901963, 0.0)
    # Heidelberg red: #960018: (150, 0, 24)
    HEIDELBERG_RED = RGB.new(0.5882352941176471, 0.0, 0.09411764705882353)
    # Heliotrope: #DF73FF: (223, 115, 255)
    HELIOTROPE = RGB.new(0.8745098039215686, 0.45098039215686275, 1.0)
    # Heliotrope gray: #AA98A9: (170, 152, 168)
    HELIOTROPE_GRAY = RGB.new(0.6666666666666666, 0.596078431372549, 0.6588235294117647)
    # Heliotrope magenta: #AA00BB: (170, 0, 187)
    HELIOTROPE_MAGENTA = RGB.new(0.6666666666666666, 0.0, 0.7333333333333333)
    # Hollywood cerise: #F400A1: (244, 0, 161)
    HOLLYWOOD_CERISE = RGB.new(0.9568627450980393, 0.0, 0.6313725490196078)
    # Honeydew: #F0FFF0: (240, 255, 240)
    HONEYDEW = RGB.new(0.9411764705882353, 1.0, 0.9411764705882353)
    # Honolulu blue: #006DB0: (0, 109, 176)
    HONOLULU_BLUE = RGB.new(0.0, 0.42745098039215684, 0.6901960784313725)
    # Hooker's green: #49796B: (73, 121, 107)
    HOOKERS_GREEN = RGB.new(0.28627450980392155, 0.4745098039215686, 0.4196078431372549)
    # Hot magenta: #FF1DCE: (255, 29, 206)
    HOT_MAGENTA = RGB.new(1.0, 0.11372549019607843, 0.807843137254902)
    # Hot pink: #FF69B4: (255, 105, 180)
    HOT_PINK = RGB.new(1.0, 0.4117647058823529, 0.7058823529411765)
    # Hunter green: #355E3B: (53, 94, 59)
    HUNTER_GREEN = RGB.new(0.20784313725490197, 0.3686274509803922, 0.23137254901960785)
    # Iceberg: #71A6D2: (113, 166, 210)
    ICEBERG = RGB.new(0.44313725490196076, 0.6509803921568628, 0.8235294117647058)
    # Iced tea: #923C01: (146, 60, 1)
    ICED_TEA = RGB.new(0.5725490196078431, 0.23529411764705882, 0.00392156862745098)
    # Icterine: #FCF75E: (252, 247, 94)
    ICTERINE = RGB.new(0.9882352941176471, 0.9686274509803922, 0.3686274509803922)
    # Iguana green: #71BC78: (113, 188, 120)
    IGUANA_GREEN = RGB.new(0.44313725490196076, 0.7372549019607844, 0.47058823529411764)
    # Illuminating emerald: #319177: (49, 145, 119)
    ILLUMINATING_EMERALD = RGB.new(0.19215686274509805, 0.5686274509803921, 0.4666666666666667)
    # Imperial: #602F6B: (96, 47, 107)
    IMPERIAL = RGB.new(0.3764705882352941, 0.1843137254901961, 0.4196078431372549)
    # Imperial blue: #002395: (0, 35, 149)
    IMPERIAL_BLUE = RGB.new(0.0, 0.13725490196078433, 0.5843137254901961)
    # Imperial purple: #66023C: (102, 2, 60)
    IMPERIAL_PURPLE = RGB.new(0.4, 0.00784313725490196, 0.23529411764705882)
    # Imperial red: #ED2939: (237, 41, 57)
    IMPERIAL_RED = RGB.new(0.9294117647058824, 0.1607843137254902, 0.2235294117647059)
    # Inchworm: #B2EC5D: (178, 236, 93)
    INCHWORM = RGB.new(0.6980392156862745, 0.9254901960784314, 0.36470588235294116)
    # Independence: #4C516D: (76, 81, 109)
    INDEPENDENCE = RGB.new(0.2980392156862745, 0.3176470588235294, 0.42745098039215684)
    # India green: #138808: (19, 136, 8)
    INDIA_GREEN = RGB.new(0.07450980392156863, 0.5333333333333333, 0.03137254901960784)
    # Indian red: #CD5C5C: (205, 92, 92)
    INDIAN_RED = RGB.new(0.803921568627451, 0.3607843137254902, 0.3607843137254902)
    # Indian yellow: #E3A857: (227, 168, 87)
    INDIAN_YELLOW = RGB.new(0.8901960784313725, 0.6588235294117647, 0.3411764705882353)
    # Indigo: #4B0082: (75, 0, 130)
    INDIGO = RGB.new(0.29411764705882354, 0.0, 0.5098039215686274)
    # Indigo dye: #091F92: (9, 31, 146)
    INDIGO_DYE = RGB.new(0.03529411764705882, 0.12156862745098039, 0.5725490196078431)
    # Indigo (Crayola): #4F69C6: (79, 105, 198)
    INDIGO_CRAYOLA = RGB.new(0.30980392156862746, 0.4117647058823529, 0.7764705882352941)
    # Indigo (Rainbow): #233067: (35, 48, 103)
    INDIGO_RAINBOW = RGB.new(0.13725490196078433, 0.18823529411764706, 0.403921568627451)
    # Indigo (web): #4B0082: (75, 0, 130)
    INDIGO_WEB = RGB.new(0.29411764705882354, 0.0, 0.5098039215686274)
    # Infra red: #FF496C: (255, 73, 108)
    INFRA_RED = RGB.new(1.0, 0.28627450980392155, 0.4235294117647059)
    # Interdimensional blue: #360CCC: (54, 12, 204)
    INTERDIMENSIONAL_BLUE = RGB.new(0.21176470588235294, 0.047058823529411764, 0.8)
    # International Klein Blue: #002FA7: (0, 47, 167)
    INTERNATIONAL_KLEIN_BLUE = RGB.new(0.0, 0.1843137254901961, 0.6549019607843137)
    # International orange (aerospace): #FF4F00: (255, 79, 0)
    INTERNATIONAL_ORANGE_AEROSPACE = RGB.new(1.0, 0.30980392156862746, 0.0)
    # International orange (engineering): #BA160C: (186, 22, 12)
    INTERNATIONAL_ORANGE_ENGINEERING = RGB.new(0.7294117647058823, 0.08627450980392157, 0.047058823529411764)
    # International orange (Golden Gate Bridge): #C0362C: (192, 54, 44)
    INTERNATIONAL_ORANGE_GOLDEN_GATE_BRIDGE = RGB.new(0.7529411764705882, 0.21176470588235294, 0.17254901960784313)
    # Iris: #5A4FCF: (90, 79, 207)
    IRIS = RGB.new(0.35294117647058826, 0.30980392156862746, 0.8117647058823529)
    # Iron: #A19D94: (161, 157, 148)
    IRON = RGB.new(0.6313725490196078, 0.615686274509804, 0.5803921568627451)
    # Irresistible: #B3446C: (179, 68, 108)
    IRRESISTIBLE = RGB.new(0.7019607843137254, 0.26666666666666666, 0.4235294117647059)
    # Isabelline: #F4F0EC: (244, 240, 236)
    ISABELLINE = RGB.new(0.9568627450980393, 0.9411764705882353, 0.9254901960784314)
    # Islamic green: #009000: (0, 144, 0)
    ISLAMIC_GREEN = RGB.new(0.0, 0.5647058823529412, 0.0)
    # Italian sky blue: #B2FFFF: (178, 255, 255)
    ITALIAN_SKY_BLUE = RGB.new(0.6980392156862745, 1.0, 1.0)
    # Ivory: #FFFFF0: (255, 255, 240)
    IVORY = RGB.new(1.0, 1.0, 0.9411764705882353)
    # Jacarta: #3D325D: (61, 50, 93)
    JACARTA = RGB.new(0.23921568627450981, 0.19607843137254902, 0.36470588235294116)
    # Jacko bean: #413628: (65, 54, 40)
    JACKO_BEAN = RGB.new(0.2549019607843137, 0.21176470588235294, 0.1568627450980392)
    # Jade: #00A86B: (0, 168, 107)
    JADE = RGB.new(0.0, 0.6588235294117647, 0.4196078431372549)
    # Japanese carmine: #9D2933: (157, 41, 51)
    JAPANESE_CARMINE = RGB.new(0.615686274509804, 0.1607843137254902, 0.2)
    # Japanese indigo: #264348: (38, 67, 72)
    JAPANESE_INDIGO = RGB.new(0.14901960784313725, 0.2627450980392157, 0.2823529411764706)
    # Japanese laurel: #2F7532: (47, 117, 50)
    JAPANESE_LAUREL = RGB.new(0.1843137254901961, 0.4588235294117647, 0.19607843137254902)
    # Japanese violet: #5B3256: (91, 50, 86)
    JAPANESE_VIOLET = RGB.new(0.3568627450980392, 0.19607843137254902, 0.33725490196078434)
    # Jasmine: #F8DE7E: (248, 222, 126)
    JASMINE = RGB.new(0.9725490196078431, 0.8705882352941177, 0.49411764705882355)
    # Jasper: #D73B3E: (215, 59, 62)
    JASPER = RGB.new(0.8431372549019608, 0.23137254901960785, 0.24313725490196078)
    # Jasper orange: #DE8F4E: (223, 145, 79)
    JASPER_ORANGE = RGB.new(0.8745098039215686, 0.5686274509803921, 0.30980392156862746)
    # Jazzberry jam: #A50B5E: (165, 11, 94)
    JAZZBERRY_JAM = RGB.new(0.6470588235294118, 0.043137254901960784, 0.3686274509803922)
    # Jelly bean: #DA614E: (218, 97, 78)
    JELLY_BEAN = RGB.new(0.8549019607843137, 0.3803921568627451, 0.3058823529411765)
    # Jelly bean blue: #44798E: (68, 121, 142)
    JELLY_BEAN_BLUE = RGB.new(0.26666666666666666, 0.4745098039215686, 0.5568627450980392)
    # Jet: #343434: (52, 52, 52)
    JET = RGB.new(0.20392156862745098, 0.20392156862745098, 0.20392156862745098)
    # Jet stream: #BBD0C9: (187, 208, 201)
    JET_STREAM = RGB.new(0.7333333333333333, 0.8156862745098039, 0.788235294117647)
    # Jonquil: #F4CA16: (244, 202, 22)
    JONQUIL = RGB.new(0.9568627450980393, 0.792156862745098, 0.08627450980392157)
    # Jordy blue: #8AB9F1: (138, 185, 241)
    JORDY_BLUE = RGB.new(0.5411764705882353, 0.7254901960784313, 0.9450980392156862)
    # June bud: #BDDA57: (189, 218, 87)
    JUNE_BUD = RGB.new(0.7411764705882353, 0.8549019607843137, 0.3411764705882353)
    # Jungle green: #29AB87: (41, 171, 135)
    JUNGLE_GREEN = RGB.new(0.1607843137254902, 0.6705882352941176, 0.5294117647058824)
    # Kelly green: #4CBB17: (76, 187, 23)
    KELLY_GREEN = RGB.new(0.2980392156862745, 0.7333333333333333, 0.09019607843137255)
    # Kenyan copper: #7C1C05: (124, 28, 5)
    KENYAN_COPPER = RGB.new(0.48627450980392156, 0.10980392156862745, 0.0196078431372549)
    # Keppel: #3AB09E: (58, 176, 158)
    KEPPEL = RGB.new(0.22745098039215686, 0.6901960784313725, 0.6196078431372549)
    # Key lime: #E8F48C: (232, 244, 140)
    KEY_LIME = RGB.new(0.9098039215686274, 0.9568627450980393, 0.5490196078431373)
    # Khaki: #C3B091: (195, 176, 145)
    KHAKI = RGB.new(0.7647058823529411, 0.6901960784313725, 0.5686274509803921)
    # Khaki (X11): #F0E68C: (240, 230, 140)
    KHAKI_X11 = RGB.new(0.9411764705882353, 0.9019607843137255, 0.5490196078431373)
    # Kiwi: #8EE53F: (142, 229, 63)
    KIWI = RGB.new(0.5568627450980392, 0.8980392156862745, 0.24705882352941178)
    # Kobe: #882D17: (136, 45, 23)
    KOBE = RGB.new(0.5333333333333333, 0.17647058823529413, 0.09019607843137255)
    # Kobi: #E79FC4: (231, 159, 196)
    KOBI = RGB.new(0.9058823529411765, 0.6235294117647059, 0.7686274509803922)
    # Kobicha: #6B4423: (107, 68, 35)
    KOBICHA = RGB.new(0.4196078431372549, 0.26666666666666666, 0.13725490196078433)
    # Kombu green: #354230: (53, 66, 48)
    KOMBU_GREEN = RGB.new(0.20784313725490197, 0.25882352941176473, 0.18823529411764706)
    # KSU Purple: #512888: (79, 38, 131)
    KSU_PURPLE = RGB.new(0.30980392156862746, 0.14901960784313725, 0.5137254901960784)
    # KU Crimson: #E8000D: (232, 0, 13)
    KU_CRIMSON = RGB.new(0.9098039215686274, 0.0, 0.050980392156862744)
    # La Salle green: #087830: (8, 120, 48)
    LA_SALLE_GREEN = RGB.new(0.03137254901960784, 0.47058823529411764, 0.18823529411764706)
    # Languid lavender: #D6CADD: (214, 202, 221)
    LANGUID_LAVENDER = RGB.new(0.8392156862745098, 0.792156862745098, 0.8666666666666667)
    # Lanzones: #E0BC5B: (224, 188, 91)
    LANZONES = RGB.new(0.8784313725490196, 0.7372549019607844, 0.3568627450980392)
    # Lapis lazuli: #26619C: (38, 97, 156)
    LAPIS_LAZULI = RGB.new(0.14901960784313725, 0.3803921568627451, 0.611764705882353)
    # Laser Lemon: #FFFF66: (255, 255, 102)
    LASER_LEMON = RGB.new(1.0, 1.0, 0.4)
    # Laurel green: #A9BA9D: (169, 186, 157)
    LAUREL_GREEN = RGB.new(0.6627450980392157, 0.7294117647058823, 0.615686274509804)
    # Lava: #CF1020: (207, 16, 32)
    LAVA = RGB.new(0.8117647058823529, 0.06274509803921569, 0.12549019607843137)
    # Lavender: #B57EDC: (181, 126, 220)
    LAVENDER = RGB.new(0.7098039215686275, 0.49411764705882355, 0.8627450980392157)
    # Lavender (web): #E6E6FA: (230, 230, 250)
    LAVENDER_WEB = RGB.new(0.9019607843137255, 0.9019607843137255, 0.9803921568627451)
    # Lavender blue: #CCCCFF: (204, 204, 255)
    LAVENDER_BLUE = RGB.new(0.8, 0.8, 1.0)
    # Lavender blush: #FFF0F5: (255, 240, 245)
    LAVENDER_BLUSH = RGB.new(1.0, 0.9411764705882353, 0.9607843137254902)
    # Lavender gray: #C4C3D0: (196, 195, 208)
    LAVENDER_GRAY = RGB.new(0.7686274509803922, 0.7647058823529411, 0.8156862745098039)
    # Lavender indigo: #9457EB: (148, 87, 235)
    LAVENDER_INDIGO = RGB.new(0.5803921568627451, 0.3411764705882353, 0.9215686274509803)
    # Lavender magenta: #EE82EE: (238, 130, 238)
    LAVENDER_MAGENTA = RGB.new(0.9333333333333333, 0.5098039215686274, 0.9333333333333333)
    # Lavender mist: #E6E6FA: (230, 230, 250)
    LAVENDER_MIST = RGB.new(0.9019607843137255, 0.9019607843137255, 0.9803921568627451)
    # Lavender pink: #FBAED2: (251, 174, 210)
    LAVENDER_PINK = RGB.new(0.984313725490196, 0.6823529411764706, 0.8235294117647058)
    # Lavender purple: #967BB6: (150, 123, 182)
    LAVENDER_PURPLE = RGB.new(0.5882352941176471, 0.4823529411764706, 0.7137254901960784)
    # Lavender rose: #FBA0E3: (251, 160, 227)
    LAVENDER_ROSE = RGB.new(0.984313725490196, 0.6274509803921569, 0.8901960784313725)
    # Lawn green: #7CFC00: (124, 252, 0)
    LAWN_GREEN = RGB.new(0.48627450980392156, 0.9882352941176471, 0.0)
    # Lemon: #FFF700: (255, 247, 0)
    LEMON = RGB.new(1.0, 0.9686274509803922, 0.0)
    # Lemon chiffon: #FFFACD: (255, 250, 205)
    LEMON_CHIFFON = RGB.new(1.0, 0.9803921568627451, 0.803921568627451)
    # Lemon curry: #CCA01D: (204, 160, 29)
    LEMON_CURRY = RGB.new(0.8, 0.6274509803921569, 0.11372549019607843)
    # Lemon glacier: #FDFF00: (253, 255, 0)
    LEMON_GLACIER = RGB.new(0.9921568627450981, 1.0, 0.0)
    # Lemon iced tea: #BD3000: (189, 48, 0)
    LEMON_ICED_TEA = RGB.new(0.7411764705882353, 0.18823529411764706, 0.0)
    # Lemon lime: #E3FF00: (227, 255, 0)
    LEMON_LIME = RGB.new(0.8901960784313725, 1.0, 0.0)
    # Lemon meringue: #F6EABE: (246, 234, 190)
    LEMON_MERINGUE = RGB.new(0.9647058823529412, 0.9176470588235294, 0.7450980392156863)
    # Lemon yellow: #FFF44F: (255, 244, 79)
    LEMON_YELLOW = RGB.new(1.0, 0.9568627450980393, 0.30980392156862746)
    # Lemon yellow (Crayola): #FFFF9F: (255, 255, 159)
    LEMON_YELLOW_CRAYOLA = RGB.new(1.0, 1.0, 0.6235294117647059)
    # Lenurple: #BA93D8: (186, 147, 216)
    LENURPLE = RGB.new(0.7294117647058823, 0.5764705882352941, 0.8470588235294118)
    # Liberty: #545AA7: (84, 90, 167)
    LIBERTY = RGB.new(0.32941176470588235, 0.35294117647058826, 0.6549019607843137)
    # Licorice: #1A1110: (26, 17, 16)
    LICORICE = RGB.new(0.10196078431372549, 0.06666666666666667, 0.06274509803921569)
    # Light apricot: #FDD5B1: (253, 213, 177)
    LIGHT_APRICOT = RGB.new(0.9921568627450981, 0.8352941176470589, 0.6941176470588235)
    # Light blue: #ADD8E6: (173, 216, 230)
    LIGHT_BLUE = RGB.new(0.6784313725490196, 0.8470588235294118, 0.9019607843137255)
    # Light brown: #B5651D: (181, 101, 29)
    LIGHT_BROWN = RGB.new(0.7098039215686275, 0.396078431372549, 0.11372549019607843)
    # Light carmine pink: #E66771: (230, 103, 113)
    LIGHT_CARMINE_PINK = RGB.new(0.9019607843137255, 0.403921568627451, 0.44313725490196076)
    # Light chocolate cosmos: #551F2F: (85, 31, 47)
    LIGHT_CHOCOLATE_COSMOS = RGB.new(0.3333333333333333, 0.12156862745098039, 0.1843137254901961)
    # Light cobalt blue: #88ACE0: (136, 172, 224)
    LIGHT_COBALT_BLUE = RGB.new(0.5333333333333333, 0.6745098039215687, 0.8784313725490196)
    # Light coral: #F08080: (240, 128, 128)
    LIGHT_CORAL = RGB.new(0.9411764705882353, 0.5019607843137255, 0.5019607843137255)
    # Light cornflower blue: #93CCEA: (147, 204, 234)
    LIGHT_CORNFLOWER_BLUE = RGB.new(0.5764705882352941, 0.8, 0.9176470588235294)
    # Light crimson: #F56991: (245, 105, 145)
    LIGHT_CRIMSON = RGB.new(0.9607843137254902, 0.4117647058823529, 0.5686274509803921)
    # Light cyan: #E0FFFF: (224, 255, 255)
    LIGHT_CYAN = RGB.new(0.8784313725490196, 1.0, 1.0)
    # Light deep pink: #FF5CCD: (255, 92, 205)
    LIGHT_DEEP_PINK = RGB.new(1.0, 0.3607843137254902, 0.803921568627451)
    # Light French beige: #C8AD7F: (200, 173, 127)
    LIGHT_FRENCH_BEIGE = RGB.new(0.7843137254901961, 0.6784313725490196, 0.4980392156862745)
    # Light fuchsia pink: #F984EF: (249, 132, 239)
    LIGHT_FUCHSIA_PINK = RGB.new(0.9764705882352941, 0.5176470588235295, 0.9372549019607843)
    # Light gold: #B29700: (178, 151, 0)
    LIGHT_GOLD = RGB.new(0.6980392156862745, 0.592156862745098, 0.0)
    # Light goldenrod: #FFEC8B: (255, 236, 139)
    LIGHT_GOLDENROD = RGB.new(1.0, 0.9254901960784314, 0.5450980392156862)
    # Light goldenrod yellow: #FAFAD2: (250, 250, 210)
    LIGHT_GOLDENROD_YELLOW = RGB.new(0.9803921568627451, 0.9803921568627451, 0.8235294117647058)
    # Light gray: #D3D3D3: (211, 211, 211)
    LIGHT_GRAY = RGB.new(0.8274509803921568, 0.8274509803921568, 0.8274509803921568)
    # Light grayish magenta: #CC99CC: (204, 153, 204)
    LIGHT_GRAYISH_MAGENTA = RGB.new(0.8, 0.6, 0.8)
    # Light green: #90EE90: (144, 238, 144)
    LIGHT_GREEN = RGB.new(0.5647058823529412, 0.9333333333333333, 0.5647058823529412)
    # Light hot pink: #FFB3DE: (255, 179, 222)
    LIGHT_HOT_PINK = RGB.new(1.0, 0.7019607843137254, 0.8705882352941177)
    # Light khaki: #F0E68C: (240, 230, 140)
    LIGHT_KHAKI = RGB.new(0.9411764705882353, 0.9019607843137255, 0.5490196078431373)
    # Light medium orchid: #D39BCB: (211, 155, 203)
    LIGHT_MEDIUM_ORCHID = RGB.new(0.8274509803921568, 0.6078431372549019, 0.796078431372549)
    # Light moss green: #ADDFAD: (173, 223, 173)
    LIGHT_MOSS_GREEN = RGB.new(0.6784313725490196, 0.8745098039215686, 0.6784313725490196)
    # Light mustard: #FF3333: (238, 221, 98)
    LIGHT_MUSTARD = RGB.new(0.9333333333333333, 0.8666666666666667, 0.3843137254901961)
    # Light orange: #FED8B1: (254, 216, 177)
    LIGHT_ORANGE = RGB.new(0.996078431372549, 0.8470588235294118, 0.6941176470588235)
    # Light orchid: #E6A8D7: (230, 168, 215)
    LIGHT_ORCHID = RGB.new(0.9019607843137255, 0.6588235294117647, 0.8431372549019608)
    # Light pastel purple: #B19CD9: (177, 156, 217)
    LIGHT_PASTEL_PURPLE = RGB.new(0.6941176470588235, 0.611764705882353, 0.8509803921568627)
    # Light periwinkle: #C5CBE1: (197, 203, 225)
    LIGHT_PERIWINKLE = RGB.new(0.7725490196078432, 0.796078431372549, 0.8823529411764706)
    # Light pink: #FFB6C1: (255, 182, 193)
    LIGHT_PINK = RGB.new(1.0, 0.7137254901960784, 0.7568627450980392)
    # Light red: #FF3333: (255, 51, 51)
    LIGHT_RED = RGB.new(1.0, 0.2, 0.2)
    # Light red ochre: #E97451: (233, 116, 81)
    LIGHT_RED_OCHRE = RGB.new(0.9137254901960784, 0.4549019607843137, 0.3176470588235294)
    # Light salmon: #FFA07A: (255, 160, 122)
    LIGHT_SALMON = RGB.new(1.0, 0.6274509803921569, 0.47843137254901963)
    # Light salmon pink: #FF9999: (255, 153, 153)
    LIGHT_SALMON_PINK = RGB.new(1.0, 0.6, 0.6)
    # Light sea green: #20B2AA: (32, 178, 170)
    LIGHT_SEA_GREEN = RGB.new(0.12549019607843137, 0.6980392156862745, 0.6666666666666666)
    # Light silver: #D8D8D8: (216, 216, 216)
    LIGHT_SILVER = RGB.new(0.8470588235294118, 0.8470588235294118, 0.8470588235294118)
    # Light sky blue: #87CEFA: (135, 206, 250)
    LIGHT_SKY_BLUE = RGB.new(0.5294117647058824, 0.807843137254902, 0.9803921568627451)
    # Light slate gray: #778899: (119, 136, 153)
    LIGHT_SLATE_GRAY = RGB.new(0.4666666666666667, 0.5333333333333333, 0.6)
    # Light steel blue: #B0C4DE: (176, 196, 222)
    LIGHT_STEEL_BLUE = RGB.new(0.6901960784313725, 0.7686274509803922, 0.8705882352941177)
    # Light taupe: #B38B6D: (179, 139, 109)
    LIGHT_TAUPE = RGB.new(0.7019607843137254, 0.5450980392156862, 0.42745098039215684)
    # Light Thulian pink: #E68FAC: (230, 143, 172)
    LIGHT_THULIAN_PINK = RGB.new(0.9019607843137255, 0.5607843137254902, 0.6745098039215687)
    # Light turquoise: #AFE4DE: (175, 228, 222)
    LIGHT_TURQUOISE = RGB.new(0.6862745098039216, 0.8941176470588236, 0.8705882352941177)
    # Light violet: #7A5299: (122, 82, 153)
    LIGHT_VIOLET = RGB.new(0.47843137254901963, 0.3215686274509804, 0.6)
    # Light yellow: #FFFFE0: (255, 255, 224)
    LIGHT_YELLOW = RGB.new(1.0, 1.0, 0.8784313725490196)
    # Lilac: #C8A2C8: (200, 162, 200)
    LILAC = RGB.new(0.7843137254901961, 0.6352941176470588, 0.7843137254901961)
    # Lilac Luster: #AE98AA: (174, 152, 170)
    LILAC_LUSTER = RGB.new(0.6823529411764706, 0.596078431372549, 0.6666666666666666)
    # Lime (color wheel): #BFFF00: (191, 255, 0)
    LIME_COLOR_WHEEL = RGB.new(0.7490196078431373, 1.0, 0.0)
    # Lime (web) (X11 green): #00FF00: (0, 255, 0)
    LIME_WEB_X11_GREEN = RGB.new(0.0, 1.0, 0.0)
    # Lime green: #32CD32: (50, 205, 50)
    LIME_GREEN = RGB.new(0.19607843137254902, 0.803921568627451, 0.19607843137254902)
    # Limerick: #9DC209: (157, 194, 9)
    LIMERICK = RGB.new(0.615686274509804, 0.7607843137254902, 0.03529411764705882)
    # Lincoln green: #195905: (25, 89, 5)
    LINCOLN_GREEN = RGB.new(0.09803921568627451, 0.34901960784313724, 0.0196078431372549)
    # Linen: #FAF0E6: (250, 240, 230)
    LINEN = RGB.new(0.9803921568627451, 0.9411764705882353, 0.9019607843137255)
    # Lion: #C19A6B: (193, 154, 107)
    LION = RGB.new(0.7568627450980392, 0.6039215686274509, 0.4196078431372549)
    # Liseran purple: #DE6FA1: (222, 111, 161)
    LISERAN_PURPLE = RGB.new(0.8705882352941177, 0.43529411764705883, 0.6313725490196078)
    # Little boy blue: #6CA0DC: (108, 160, 220)
    LITTLE_BOY_BLUE = RGB.new(0.4235294117647059, 0.6274509803921569, 0.8627450980392157)
    # Little girl pink: #F8B9D4: (248, 185, 212)
    LITTLE_GIRL_PINK = RGB.new(0.9725490196078431, 0.7254901960784313, 0.8313725490196079)
    # Liver: #674C47: (103, 76, 71)
    LIVER = RGB.new(0.403921568627451, 0.2980392156862745, 0.2784313725490196)
    # Liver (dogs): #B86D29: (184, 109, 41)
    LIVER_DOGS = RGB.new(0.7215686274509804, 0.42745098039215684, 0.1607843137254902)
    # Liver (organ): #6C2E1F: (108, 46, 31)
    LIVER_ORGAN = RGB.new(0.4235294117647059, 0.1803921568627451, 0.12156862745098039)
    # Liver chestnut: #987456: (152, 116, 86)
    LIVER_CHESTNUT = RGB.new(0.596078431372549, 0.4549019607843137, 0.33725490196078434)
    # Livid: #6699CC: (102, 153, 204)
    LIVID = RGB.new(0.4, 0.6, 0.8)
    # Lotion: #FEFDFA: (255, 254, 250)
    LOTION = RGB.new(1.0, 0.996078431372549, 0.9803921568627451)
    # Lotion blue: #15F2FD: (123, 154, 200)
    LOTION_BLUE = RGB.new(0.4823529411764706, 0.6039215686274509, 0.7843137254901961)
    # Lotion pink: #ECCFCF: (236, 207, 207)
    LOTION_PINK = RGB.new(0.9254901960784314, 0.8117647058823529, 0.8117647058823529)
    # Lumber: #FFE4CD: (255, 228, 205)
    LUMBER = RGB.new(1.0, 0.8941176470588236, 0.803921568627451)
    # Lust: #E62020: (230, 32, 32)
    LUST = RGB.new(0.9019607843137255, 0.12549019607843137, 0.12549019607843137)
    # Maastricht Blue: #001C3D: (0, 28, 61)
    MAASTRICHT_BLUE = RGB.new(0.0, 0.10980392156862745, 0.23921568627450981)
    # Macaroni and Cheese: #FFBD88: (255, 189, 136)
    MACARONI_AND_CHEESE = RGB.new(1.0, 0.7411764705882353, 0.5333333333333333)
    # Madder Lake: #CC3336: (204, 51, 54)
    MADDER_LAKE = RGB.new(0.8, 0.2, 0.21176470588235294)
    # Magenta: #FF00FF: (255, 0, 255)
    MAGENTA = RGB.new(1.0, 0.0, 1.0)
    # Mahogany: #C04000: (192, 64, 0)
    MAHOGANY = RGB.new(0.7529411764705882, 0.25098039215686274, 0.0)
    # Maize: #FBEC5D: (251, 236, 93)
    MAIZE = RGB.new(0.984313725490196, 0.9254901960784314, 0.36470588235294116)
    # Maize (Crayola): #F2C649: (242, 198, 73)
    MAIZE_CRAYOLA = RGB.new(0.9490196078431372, 0.7764705882352941, 0.28627450980392155)
    # Majorelle Blue: #6050DC: (96, 80, 220)
    MAJORELLE_BLUE = RGB.new(0.3764705882352941, 0.3137254901960784, 0.8627450980392157)
    # Malachite: #0BDA51: (11, 218, 81)
    MALACHITE = RGB.new(0.043137254901960784, 0.8549019607843137, 0.3176470588235294)
    # Manatee: #979AAA: (151, 154, 170)
    MANATEE = RGB.new(0.592156862745098, 0.6039215686274509, 0.6666666666666666)
    # Mandarin: #F37A48: (243, 122, 72)
    MANDARIN = RGB.new(0.9529411764705882, 0.47843137254901963, 0.2823529411764706)
    # Mango: #FDBE02: (253, 190, 2)
    MANGO = RGB.new(0.9921568627450981, 0.7450980392156863, 0.00784313725490196)
    # Mango green: #96FF00: (150, 255, 0)
    MANGO_GREEN = RGB.new(0.5882352941176471, 1.0, 0.0)
    # Mango Tango: #FF8243: (255, 130, 67)
    MANGO_TANGO = RGB.new(1.0, 0.5098039215686274, 0.2627450980392157)
    # Mantis: #74C365: (116, 195, 101)
    MANTIS = RGB.new(0.4549019607843137, 0.7647058823529411, 0.396078431372549)
    # Mardi Gras: #880085: (136, 0, 133)
    MARDI_GRAS = RGB.new(0.5333333333333333, 0.0, 0.5215686274509804)
    # Marigold: #EAA221: (234, 162, 33)
    MARIGOLD = RGB.new(0.9176470588235294, 0.6352941176470588, 0.12941176470588237)
    # Maroon (Crayola): #C32148: (195, 33, 72)
    MAROON_CRAYOLA = RGB.new(0.7647058823529411, 0.12941176470588237, 0.2823529411764706)
    # Maroon (HTML/CSS): #800000: (128, 0, 0)
    MAROON_HTML_CSS = RGB.new(0.5019607843137255, 0.0, 0.0)
    # Maroon (X11): #B03060: (176, 48, 96)
    MAROON_X11 = RGB.new(0.6901960784313725, 0.18823529411764706, 0.3764705882352941)
    # Mauve: #E0B0FF: (224, 176, 255)
    MAUVE = RGB.new(0.8784313725490196, 0.6901960784313725, 1.0)
    # Mauve taupe: #915F6D: (145, 95, 109)
    MAUVE_TAUPE = RGB.new(0.5686274509803921, 0.37254901960784315, 0.42745098039215684)
    # Mauvelous: #EF98AA: (239, 152, 170)
    MAUVELOUS = RGB.new(0.9372549019607843, 0.596078431372549, 0.6666666666666666)
    # Maximum Blue: #47ABCC: (71, 171, 204)
    MAXIMUM_BLUE = RGB.new(0.2784313725490196, 0.6705882352941176, 0.8)
    # Maximum Blue Green: #30BFBF: (48, 191, 191)
    MAXIMUM_BLUE_GREEN = RGB.new(0.18823529411764706, 0.7490196078431373, 0.7490196078431373)
    # Maximum Blue Purple: #ACACE6: (172, 172, 230)
    MAXIMUM_BLUE_PURPLE = RGB.new(0.6745098039215687, 0.6745098039215687, 0.9019607843137255)
    # Maximum Green: #5E8C31: (94, 140, 49)
    MAXIMUM_GREEN = RGB.new(0.3686274509803922, 0.5490196078431373, 0.19215686274509805)
    # Maximum Green Yellow: #D9E650: (217, 230, 80)
    MAXIMUM_GREEN_YELLOW = RGB.new(0.8509803921568627, 0.9019607843137255, 0.3137254901960784)
    # Maximum orange: #FF5B00: (255, 91, 0)
    MAXIMUM_ORANGE = RGB.new(1.0, 0.3568627450980392, 0.0)
    # Maximum Purple: #733380: (115, 51, 128)
    MAXIMUM_PURPLE = RGB.new(0.45098039215686275, 0.2, 0.5019607843137255)
    # Maximum pink: #F6A5F2: (246, 165, 242)
    MAXIMUM_PINK = RGB.new(0.9647058823529412, 0.6470588235294118, 0.9490196078431372)
    # Maximum red: #D92121: (217, 33, 33)
    MAXIMUM_RED = RGB.new(0.8509803921568627, 0.12941176470588237, 0.12941176470588237)
    # Maximum Red Purple: #A63A79: (166, 58, 121)
    MAXIMUM_RED_PURPLE = RGB.new(0.6509803921568628, 0.22745098039215686, 0.4745098039215686)
    # Maximum violet: #892F77: (137, 47, 119)
    MAXIMUM_VIOLET = RGB.new(0.5372549019607843, 0.1843137254901961, 0.4666666666666667)
    # Maximum yellow: #FAFA37: (250, 250, 55)
    MAXIMUM_YELLOW = RGB.new(0.9803921568627451, 0.9803921568627451, 0.21568627450980393)
    # Maximum yellow red: #F2BA49: (242, 186, 73)
    MAXIMUM_YELLOW_RED = RGB.new(0.9490196078431372, 0.7294117647058823, 0.28627450980392155)
    # May green: #4C9141: (76, 145, 65)
    MAY_GREEN = RGB.new(0.2980392156862745, 0.5686274509803921, 0.2549019607843137)
    # Maya blue: #73C2FB: (115, 194, 251)
    MAYA_BLUE = RGB.new(0.45098039215686275, 0.7607843137254902, 0.984313725490196)
    # Meat brown: #E5B73B: (229, 183, 59)
    MEAT_BROWN = RGB.new(0.8980392156862745, 0.7176470588235294, 0.23137254901960785)
    # Medium aquamarine: #66DDAA: (102, 221, 170)
    MEDIUM_AQUAMARINE = RGB.new(0.4, 0.8666666666666667, 0.6666666666666666)
    # Medium blue: #0000CD: (0, 0, 205)
    MEDIUM_BLUE = RGB.new(0.0, 0.0, 0.803921568627451)
    # Medium candy apple red: #E2062C: (226, 6, 44)
    MEDIUM_CANDY_APPLE_RED = RGB.new(0.8862745098039215, 0.023529411764705882, 0.17254901960784313)
    # Medium carmine: #AF4035: (175, 64, 53)
    MEDIUM_CARMINE = RGB.new(0.6862745098039216, 0.25098039215686274, 0.20784313725490197)
    # Medium champagne: #F3E5AB: (243, 229, 171)
    MEDIUM_CHAMPAGNE = RGB.new(0.9529411764705882, 0.8980392156862745, 0.6705882352941176)
    # Medium electric blue: #035096: (3, 80, 150)
    MEDIUM_ELECTRIC_BLUE = RGB.new(0.011764705882352941, 0.3137254901960784, 0.5882352941176471)
    # Medium green: #037949: (3, 121, 73)
    MEDIUM_GREEN = RGB.new(0.011764705882352941, 0.4745098039215686, 0.28627450980392155)
    # Medium jungle green: #1C352D: (28, 53, 45)
    MEDIUM_JUNGLE_GREEN = RGB.new(0.10980392156862745, 0.20784313725490197, 0.17647058823529413)
    # Medium lavender magenta: #DDA0DD: (221, 160, 221)
    MEDIUM_LAVENDER_MAGENTA = RGB.new(0.8666666666666667, 0.6274509803921569, 0.8666666666666667)
    # Medium orange: #FF7802: (255, 120, 2)
    MEDIUM_ORANGE = RGB.new(1.0, 0.47058823529411764, 0.00784313725490196)
    # Medium orchid: #BA55D3: (186, 85, 211)
    MEDIUM_ORCHID = RGB.new(0.7294117647058823, 0.3333333333333333, 0.8274509803921568)
    # Medium Persian blue: #0067A5: (0, 103, 165)
    MEDIUM_PERSIAN_BLUE = RGB.new(0.0, 0.403921568627451, 0.6470588235294118)
    # Medium pink: #FE6E9F: (254, 110, 159)
    MEDIUM_PINK = RGB.new(0.996078431372549, 0.43137254901960786, 0.6235294117647059)
    # Medium purple: #9370DB: (147, 112, 219)
    MEDIUM_PURPLE = RGB.new(0.5764705882352941, 0.4392156862745098, 0.8588235294117647)
    # Medium red: #B10304: (177, 3, 4)
    MEDIUM_RED = RGB.new(0.6941176470588235, 0.011764705882352941, 0.01568627450980392)
    # Medium red-violet: #BB3385: (187, 51, 133)
    MEDIUM_RED_VIOLET = RGB.new(0.7333333333333333, 0.2, 0.5215686274509804)
    # Medium ruby: #AA4069: (170, 64, 105)
    MEDIUM_RUBY = RGB.new(0.6666666666666666, 0.25098039215686274, 0.4117647058823529)
    # Medium sea green: #3CB371: (60, 179, 113)
    MEDIUM_SEA_GREEN = RGB.new(0.23529411764705882, 0.7019607843137254, 0.44313725490196076)
    # Medium sky blue: #80DAEB: (128, 218, 235)
    MEDIUM_SKY_BLUE = RGB.new(0.5019607843137255, 0.8549019607843137, 0.9215686274509803)
    # Medium slate blue: #7B68EE: (123, 104, 238)
    MEDIUM_SLATE_BLUE = RGB.new(0.4823529411764706, 0.40784313725490196, 0.9333333333333333)
    # Medium spring bud: #C9DC87: (201, 220, 135)
    MEDIUM_SPRING_BUD = RGB.new(0.788235294117647, 0.8627450980392157, 0.5294117647058824)
    # Medium spring green: #00FA9A: (0, 250, 154)
    MEDIUM_SPRING_GREEN = RGB.new(0.0, 0.9803921568627451, 0.6039215686274509)
    # Medium taupe: #674C47: (103, 76, 71)
    MEDIUM_TAUPE = RGB.new(0.403921568627451, 0.2980392156862745, 0.2784313725490196)
    # Medium turquoise: #48D1CC: (72, 209, 204)
    MEDIUM_TURQUOISE = RGB.new(0.2823529411764706, 0.8196078431372549, 0.8)
    # Medium Tuscan red: #79443B: (121, 68, 59)
    MEDIUM_TUSCAN_RED = RGB.new(0.4745098039215686, 0.26666666666666666, 0.23137254901960785)
    # Medium vermilion: #D9603B: (217, 96, 59)
    MEDIUM_VERMILION = RGB.new(0.8509803921568627, 0.3764705882352941, 0.23137254901960785)
    # Medium violet: #65315F: (101, 49, 95)
    MEDIUM_VIOLET = RGB.new(0.396078431372549, 0.19215686274509805, 0.37254901960784315)
    # Medium violet-red: #C71585: (199, 21, 133)
    MEDIUM_VIOLET_RED = RGB.new(0.7803921568627451, 0.08235294117647059, 0.5215686274509804)
    # Medium yellow: #FFE302: (255, 227, 2)
    MEDIUM_YELLOW = RGB.new(1.0, 0.8901960784313725, 0.00784313725490196)
    # Mellow apricot: #F8B878: (248, 184, 120)
    MELLOW_APRICOT = RGB.new(0.9725490196078431, 0.7215686274509804, 0.47058823529411764)
    # Mellow yellow: #F8DE7E: (248, 222, 126)
    MELLOW_YELLOW = RGB.new(0.9725490196078431, 0.8705882352941177, 0.49411764705882355)
    # Melon: #FDBCB4: (253, 188, 180)
    MELON = RGB.new(0.9921568627450981, 0.7372549019607844, 0.7058823529411765)
    # Melon (Crayola): #FEBAAD: (254, 186, 173)
    MELON_CRAYOLA = RGB.new(0.996078431372549, 0.7294117647058823, 0.6784313725490196)
    # Menthol: #C1F9A2: (193, 249, 162)
    MENTHOL = RGB.new(0.7568627450980392, 0.9764705882352941, 0.6352941176470588)
    # Metallic blue: #32527B: (50, 82, 123)
    METALLIC_BLUE = RGB.new(0.19607843137254902, 0.3215686274509804, 0.4823529411764706)
    # Metallic bronze: #A97142: (169, 113, 66)
    METALLIC_BRONZE = RGB.new(0.6627450980392157, 0.44313725490196076, 0.25882352941176473)
    # Metallic brown: #AC4313: (172, 67, 19)
    METALLIC_BROWN = RGB.new(0.6745098039215687, 0.2627450980392157, 0.07450980392156863)
    # Metallic gold: #D3AF37: (211, 175, 55)
    METALLIC_GOLD = RGB.new(0.8274509803921568, 0.6862745098039216, 0.21568627450980393)
    # Metallic green: #296E01: (41, 110, 1)
    METALLIC_GREEN = RGB.new(0.1607843137254902, 0.43137254901960786, 0.00392156862745098)
    # Metallic orange: #DA680F: (218, 104, 15)
    METALLIC_ORANGE = RGB.new(0.8549019607843137, 0.40784313725490196, 0.058823529411764705)
    # Metallic pink: #EDA6C4: (237, 166, 196)
    METALLIC_PINK = RGB.new(0.9294117647058824, 0.6509803921568628, 0.7686274509803922)
    # Metallic red: #A62C2B: (166, 44, 43)
    METALLIC_RED = RGB.new(0.6509803921568628, 0.17254901960784313, 0.16862745098039217)
    # Metallic Seaweed: #0A7E8C: (10, 126, 140)
    METALLIC_SEAWEED = RGB.new(0.0392156862745098, 0.49411764705882355, 0.5490196078431373)
    # Metallic silver: #A8A9AD: (168, 169, 173)
    METALLIC_SILVER = RGB.new(0.6588235294117647, 0.6627450980392157, 0.6784313725490196)
    # Metallic Sunburst: #9C7C38: (156, 124, 56)
    METALLIC_SUNBURST = RGB.new(0.611764705882353, 0.48627450980392156, 0.2196078431372549)
    # Metallic violet: #5B0A91: (90, 10, 145)
    METALLIC_VIOLET = RGB.new(0.35294117647058826, 0.0392156862745098, 0.5686274509803921)
    # Metallic yellow: #FDCC0D: (253, 204, 13)
    METALLIC_YELLOW = RGB.new(0.9921568627450981, 0.8, 0.050980392156862744)
    # Mexican pink: #E4007C: (228, 0, 124)
    MEXICAN_PINK = RGB.new(0.8941176470588236, 0.0, 0.48627450980392156)
    # Microsoft blue: #00A2ED: (0, 162, 237)
    MICROSOFT_BLUE = RGB.new(0.0, 0.6352941176470588, 0.9294117647058824)
    # Microsoft Edge blue: #0078D7: (0, 120, 215)
    MICROSOFT_EDGE_BLUE = RGB.new(0.0, 0.47058823529411764, 0.8431372549019608)
    # Microsoft green: #7DB700: (125, 183, 0)
    MICROSOFT_GREEN = RGB.new(0.49019607843137253, 0.7176470588235294, 0.0)
    # Microsoft red: #F04E1F: (240, 78, 31)
    MICROSOFT_RED = RGB.new(0.9411764705882353, 0.3058823529411765, 0.12156862745098039)
    # Microsoft yellow: #FDB900: (253, 185, 0)
    MICROSOFT_YELLOW = RGB.new(0.9921568627450981, 0.7254901960784313, 0.0)
    # Middle blue: #7ED4E6: (126, 212, 230)
    MIDDLE_BLUE = RGB.new(0.49411764705882355, 0.8313725490196079, 0.9019607843137255)
    # Middle blue green: #8DD9CC: (141, 217, 204)
    MIDDLE_BLUE_GREEN = RGB.new(0.5529411764705883, 0.8509803921568627, 0.8)
    # Middle blue purple: #8B72BE: (139, 114, 190)
    MIDDLE_BLUE_PURPLE = RGB.new(0.5450980392156862, 0.4470588235294118, 0.7450980392156863)
    # Middle grey: #8B8680: (139, 134, 128)
    MIDDLE_GREY = RGB.new(0.5450980392156862, 0.5254901960784314, 0.5019607843137255)
    # Middle green: #4D8C57: (77, 140, 87)
    MIDDLE_GREEN = RGB.new(0.30196078431372547, 0.5490196078431373, 0.3411764705882353)
    # Middle green yellow: #ACBF60: (172, 191, 96)
    MIDDLE_GREEN_YELLOW = RGB.new(0.6745098039215687, 0.7490196078431373, 0.3764705882352941)
    # Middle purple: #D982B5: (217, 130, 181)
    MIDDLE_PURPLE = RGB.new(0.8509803921568627, 0.5098039215686274, 0.7098039215686275)
    # Middle red: #E58E73: (229, 144, 115)
    MIDDLE_RED = RGB.new(0.8980392156862745, 0.5647058823529412, 0.45098039215686275)
    # Middle red purple: #A55353: (165, 83, 83)
    MIDDLE_RED_PURPLE = RGB.new(0.6470588235294118, 0.3254901960784314, 0.3254901960784314)
    # Middle yellow: #FFEB00: (255, 235, 0)
    MIDDLE_YELLOW = RGB.new(1.0, 0.9215686274509803, 0.0)
    # Middle yellow red: #ECB176: (236, 177, 118)
    MIDDLE_YELLOW_RED = RGB.new(0.9254901960784314, 0.6941176470588235, 0.4627450980392157)
    # Midnight: #702670: (112, 38, 112)
    MIDNIGHT = RGB.new(0.4392156862745098, 0.14901960784313725, 0.4392156862745098)
    # Midnight blue: #191970: (25, 25, 112)
    MIDNIGHT_BLUE = RGB.new(0.09803921568627451, 0.09803921568627451, 0.4392156862745098)
    # Midnight green (eagle green): #004953: (0, 73, 83)
    MIDNIGHT_GREEN_EAGLE_GREEN = RGB.new(0.0, 0.28627450980392155, 0.3254901960784314)
    # Mikado yellow: #FFC40C: (255, 196, 12)
    MIKADO_YELLOW = RGB.new(1.0, 0.7686274509803922, 0.047058823529411764)
    # Milk: #FDFFF5: (253, 255, 245)
    MILK = RGB.new(0.9921568627450981, 1.0, 0.9607843137254902)
    # Milk chocolate: #84563C: (132, 86, 60)
    MILK_CHOCOLATE = RGB.new(0.5176470588235295, 0.33725490196078434, 0.23529411764705882)
    # Mimi pink: #FFDAE9: (255, 218, 233)
    MIMI_PINK = RGB.new(1.0, 0.8549019607843137, 0.9137254901960784)
    # Mindaro: #E3F988: (227, 249, 136)
    MINDARO = RGB.new(0.8901960784313725, 0.9764705882352941, 0.5333333333333333)
    # Ming: #36747D: (54, 116, 125)
    MING = RGB.new(0.21176470588235294, 0.4549019607843137, 0.49019607843137253)
    # Minion yellow: #F5E050: (245, 220, 80)
    MINION_YELLOW = RGB.new(0.9607843137254902, 0.8627450980392157, 0.3137254901960784)
    # Mint: #3EB489: (62, 180, 137)
    MINT = RGB.new(0.24313725490196078, 0.7058823529411765, 0.5372549019607843)
    # Mint cream: #F5FFFA: (245, 255, 250)
    MINT_CREAM = RGB.new(0.9607843137254902, 1.0, 0.9803921568627451)
    # Mint green: #98FF98: (152, 255, 152)
    MINT_GREEN = RGB.new(0.596078431372549, 1.0, 0.596078431372549)
    # Misty Moss: #BBB477: (187, 180, 119)
    MISTY_MOSS = RGB.new(0.7333333333333333, 0.7058823529411765, 0.4666666666666667)
    # Misty rose: #FFE4E1: (255, 228, 225)
    MISTY_ROSE = RGB.new(1.0, 0.8941176470588236, 0.8823529411764706)
    # Moccasin: #FAEBD7: (250, 235, 215)
    MOCCASIN = RGB.new(0.9803921568627451, 0.9215686274509803, 0.8431372549019608)
    # Mocha: #BEA493: (190, 164, 147)
    MOCHA = RGB.new(0.7450980392156863, 0.6431372549019608, 0.5764705882352941)
    # Mode beige: #967117: (150, 113, 23)
    MODE_BEIGE = RGB.new(0.5882352941176471, 0.44313725490196076, 0.09019607843137255)
    # Moonstone: #3AA8C1: (58, 168, 193)
    MOONSTONE = RGB.new(0.22745098039215686, 0.6588235294117647, 0.7568627450980392)
    # Moonstone blue: #73A9C2: (115, 169, 194)
    MOONSTONE_BLUE = RGB.new(0.45098039215686275, 0.6627450980392157, 0.7607843137254902)
    # Mordant red 19: #AE0C00: (174, 12, 0)
    MORDANT_RED_19 = RGB.new(0.6823529411764706, 0.047058823529411764, 0.0)
    # Morning blue: #8DA399: (141, 163, 153)
    MORNING_BLUE = RGB.new(0.5529411764705883, 0.6392156862745098, 0.6)
    # Moss green: #8A9A5B: (138, 154, 91)
    MOSS_GREEN = RGB.new(0.5411764705882353, 0.6039215686274509, 0.3568627450980392)
    # Mountain Meadow: #30BA8F: (48, 186, 143)
    MOUNTAIN_MEADOW = RGB.new(0.18823529411764706, 0.7294117647058823, 0.5607843137254902)
    # Mountbatten pink: #997A8D: (153, 122, 141)
    MOUNTBATTEN_PINK = RGB.new(0.6, 0.47843137254901963, 0.5529411764705883)
    # MSU green: #18453B: (24, 69, 59)
    MSU_GREEN = RGB.new(0.09411764705882353, 0.27058823529411763, 0.23137254901960785)
    # Mud: #70543E: (111, 83, 61)
    MUD = RGB.new(0.43529411764705883, 0.3254901960784314, 0.23921568627450981)
    # Mughal green: #306030: (48, 96, 48)
    MUGHAL_GREEN = RGB.new(0.18823529411764706, 0.3764705882352941, 0.18823529411764706)
    # Mulberry: #C54B8C: (197, 75, 140)
    MULBERRY = RGB.new(0.7725490196078432, 0.29411764705882354, 0.5490196078431373)
    # Mulberry (Crayola): #C8509B: (200, 80, 155)
    MULBERRY_CRAYOLA = RGB.new(0.7843137254901961, 0.3137254901960784, 0.6078431372549019)
    # Mummy's Tomb: #828E84: (130, 142, 132)
    MUMMYS_TOMB = RGB.new(0.5098039215686274, 0.5568627450980392, 0.5176470588235295)
    # Mustard: #FFDB58: (255, 219, 88)
    MUSTARD = RGB.new(1.0, 0.8588235294117647, 0.34509803921568627)
    # Mustard brown: #CD7A00: (205, 122, 0)
    MUSTARD_BROWN = RGB.new(0.803921568627451, 0.47843137254901963, 0.0)
    # Mustard green: #6E6E30: (110, 110, 48)
    MUSTARD_GREEN = RGB.new(0.43137254901960786, 0.43137254901960786, 0.18823529411764706)
    # Mustard yellow: #E1AD01: (255, 173, 1)
    MUSTARD_YELLOW = RGB.new(1.0, 0.6784313725490196, 0.00392156862745098)
    # Myrtle green: #317873: (49, 120, 115)
    MYRTLE_GREEN = RGB.new(0.19215686274509805, 0.47058823529411764, 0.45098039215686275)
    # Mystic: #D65282: (214, 82, 130)
    MYSTIC = RGB.new(0.8392156862745098, 0.3215686274509804, 0.5098039215686274)
    # Mystic maroon: #AD4379: (173, 67, 121)
    MYSTIC_MAROON = RGB.new(0.6784313725490196, 0.2627450980392157, 0.4745098039215686)
    # Mystic red: #FF5500: (255, 34, 0)
    MYSTIC_RED = RGB.new(1.0, 0.13333333333333333, 0.0)
    # Nadeshiko pink: #F6ADC6: (246, 173, 198)
    NADESHIKO_PINK = RGB.new(0.9647058823529412, 0.6784313725490196, 0.7764705882352941)
    # Napier green: #2A8000: (42, 128, 0)
    NAPIER_GREEN = RGB.new(0.16470588235294117, 0.5019607843137255, 0.0)
    # Naples yellow: #FADA5E: (250, 218, 94)
    NAPLES_YELLOW = RGB.new(0.9803921568627451, 0.8549019607843137, 0.3686274509803922)
    # Navajo white: #FFDEAD: (255, 222, 173)
    NAVAJO_WHITE = RGB.new(1.0, 0.8705882352941177, 0.6784313725490196)
    # Navy blue: #000080: (0, 0, 128)
    NAVY_BLUE = RGB.new(0.0, 0.0, 0.5019607843137255)
    # Navy blue (Crayola): #1974D2: (25, 116, 210)
    NAVY_BLUE_CRAYOLA = RGB.new(0.09803921568627451, 0.4549019607843137, 0.8235294117647058)
    # Navy purple: #9457EB: (148, 87, 235)
    NAVY_PURPLE = RGB.new(0.5803921568627451, 0.3411764705882353, 0.9215686274509803)
    # Neon blue: #1B03A3: (27, 3, 163)
    NEON_BLUE = RGB.new(0.10588235294117647, 0.011764705882352941, 0.6392156862745098)
    # Neon brown: #C3732A: (195, 115, 42)
    NEON_BROWN = RGB.new(0.7647058823529411, 0.45098039215686275, 0.16470588235294117)
    # Neon Carrot: #FFA343: (255, 163, 67)
    NEON_CARROT = RGB.new(1.0, 0.6392156862745098, 0.2627450980392157)
    # Neon cyan: #00FEFC: (0, 254, 252)
    NEON_CYAN = RGB.new(0.0, 0.996078431372549, 0.9882352941176471)
    # Neon fuchsia: #FE4164: (254, 65, 100)
    NEON_FUCHSIA = RGB.new(0.996078431372549, 0.2549019607843137, 0.39215686274509803)
    # Neon gold: #CFAA01: (207, 170, 1)
    NEON_GOLD = RGB.new(0.8117647058823529, 0.6666666666666666, 0.00392156862745098)
    # Neon gray: #808080: (128, 128, 128)
    NEON_GRAY = RGB.new(0.5019607843137255, 0.5019607843137255, 0.5019607843137255)
    # Neon dark green: #008443: (0, 132, 67)
    NEON_DARK_GREEN = RGB.new(0.0, 0.5176470588235295, 0.2627450980392157)
    # Neon green: #139B42: (19, 155, 66)
    NEON_GREEN = RGB.new(0.07450980392156863, 0.6078431372549019, 0.25882352941176473)
    # Neon pink: #FE347E: (254, 52, 126)
    NEON_PINK = RGB.new(0.996078431372549, 0.20392156862745098, 0.49411764705882355)
    # Neon purple: #9457EB: (148, 87, 235)
    NEON_PURPLE = RGB.new(0.5803921568627451, 0.3411764705882353, 0.9215686274509803)
    # Neon red: #FF1818: (255, 24, 24)
    NEON_RED = RGB.new(1.0, 0.09411764705882353, 0.09411764705882353)
    # Neon scarlet: #FF2603: (255, 38, 3)
    NEON_SCARLET = RGB.new(1.0, 0.14901960784313725, 0.011764705882352941)
    # Neon silver: #CCCCCC: (204, 204, 204)
    NEON_SILVER = RGB.new(0.8, 0.8, 0.8)
    # Neon tangerine: #F6890A: (246, 137, 10)
    NEON_TANGERINE = RGB.new(0.9647058823529412, 0.5372549019607843, 0.0392156862745098)
    # Neon yellow: #FFF700: (255, 247, 0)
    NEON_YELLOW = RGB.new(1.0, 0.9686274509803922, 0.0)
    # New Car: #214FC6: (33, 79, 198)
    NEW_CAR = RGB.new(0.12941176470588237, 0.30980392156862746, 0.7764705882352941)
    # New York pink: #D7837F: (215, 131, 127)
    NEW_YORK_PINK = RGB.new(0.8431372549019608, 0.5137254901960784, 0.4980392156862745)
    # Nickel: #727472: (114, 116, 114)
    NICKEL = RGB.new(0.4470588235294118, 0.4549019607843137, 0.4470588235294118)
    # Nintendo red: #E4000F: (228, 0, 15)
    NINTENDO_RED = RGB.new(0.8941176470588236, 0.0, 0.058823529411764705)
    # Non-photo blue: #A4DDED: (164, 221, 237)
    NON_PHOTO_BLUE = RGB.new(0.6431372549019608, 0.8666666666666667, 0.9294117647058824)
    # Nyanza: #E9FFDB: (233, 255, 219)
    NYANZA = RGB.new(0.9137254901960784, 1.0, 0.8588235294117647)
    # Ocean blue: #4F42B5: (79, 66, 181)
    OCEAN_BLUE = RGB.new(0.30980392156862746, 0.25882352941176473, 0.7098039215686275)
    # Ocean boat blue: #0077BE: (0, 119, 190)
    OCEAN_BOAT_BLUE = RGB.new(0.0, 0.4666666666666667, 0.7450980392156863)
    # Ocean green: #48BF91: (72, 191, 145)
    OCEAN_GREEN = RGB.new(0.2823529411764706, 0.7490196078431373, 0.5686274509803921)
    # Ochre: #CC7722: (204, 119, 34)
    OCHRE = RGB.new(0.8, 0.4666666666666667, 0.13333333333333333)
    # Office green: #008000: (0, 128, 0)
    OFFICE_GREEN = RGB.new(0.0, 0.5019607843137255, 0.0)
    # Ogre Odor: #FD5240: (253, 82, 64)
    OGRE_ODOR = RGB.new(0.9921568627450981, 0.3215686274509804, 0.25098039215686274)
    # Old burgundy: #43302E: (67, 48, 46)
    OLD_BURGUNDY = RGB.new(0.2627450980392157, 0.18823529411764706, 0.1803921568627451)
    # Old gold: #CFB53B: (207, 181, 59)
    OLD_GOLD = RGB.new(0.8117647058823529, 0.7098039215686275, 0.23137254901960785)
    # Old heliotrope: #563C5C: (86, 60, 92)
    OLD_HELIOTROPE = RGB.new(0.33725490196078434, 0.23529411764705882, 0.3607843137254902)
    # Old lace: #FDF5E6: (253, 245, 230)
    OLD_LACE = RGB.new(0.9921568627450981, 0.9607843137254902, 0.9019607843137255)
    # Old lavender: #796878: (121, 104, 120)
    OLD_LAVENDER = RGB.new(0.4745098039215686, 0.40784313725490196, 0.47058823529411764)
    # Old mauve: #673147: (103, 49, 71)
    OLD_MAUVE = RGB.new(0.403921568627451, 0.19215686274509805, 0.2784313725490196)
    # Old moss green: #867E36: (134, 126, 54)
    OLD_MOSS_GREEN = RGB.new(0.5254901960784314, 0.49411764705882355, 0.21176470588235294)
    # Old rose: #C08081: (192, 128, 129)
    OLD_ROSE = RGB.new(0.7529411764705882, 0.5019607843137255, 0.5058823529411764)
    # Old silver: #848482: (132, 132, 130)
    OLD_SILVER = RGB.new(0.5176470588235295, 0.5176470588235295, 0.5098039215686274)
    # Olive: #808000: (128, 128, 0)
    OLIVE = RGB.new(0.5019607843137255, 0.5019607843137255, 0.0)
    # Olive drab (#3): #6B8E23: (107, 142, 35)
    OLIVE_DRAB3 = RGB.new(0.4196078431372549, 0.5568627450980392, 0.13725490196078433)
    # Olive drab #7: #3C341F: (60, 52, 31)
    OLIVE_DRAB7 = RGB.new(0.23529411764705882, 0.20392156862745098, 0.12156862745098039)
    # Olive green: #B5B35C: (181, 179, 92)
    OLIVE_GREEN = RGB.new(0.7098039215686275, 0.7019607843137254, 0.3607843137254902)
    # Olivine: #9AB973: (154, 185, 115)
    OLIVINE = RGB.new(0.6039215686274509, 0.7254901960784313, 0.45098039215686275)
    # Onyx: #353839: (53, 56, 57)
    ONYX = RGB.new(0.20784313725490197, 0.2196078431372549, 0.2235294117647059)
    # Opal: #A8C3BC: (168, 195, 188)
    OPAL = RGB.new(0.6588235294117647, 0.7647058823529411, 0.7372549019607844)
    # Opera mauve: #B784A7: (183, 132, 167)
    OPERA_MAUVE = RGB.new(0.7176470588235294, 0.5176470588235295, 0.6549019607843137)
    # Orange: #FF6600: (255, 102, 0)
    ORANGE = RGB.new(1.0, 0.4, 0.0)
    # Orange (color wheel): #FF7F00: (255, 127, 0)
    ORANGE_COLOR_WHEEL = RGB.new(1.0, 0.4980392156862745, 0.0)
    # Orange (Crayola): #FF7538: (255, 117, 56)
    ORANGE_CRAYOLA = RGB.new(1.0, 0.4588235294117647, 0.2196078431372549)
    # Orange (Pantone): #FF5800: (255, 88, 0)
    ORANGE_PANTONE = RGB.new(1.0, 0.34509803921568627, 0.0)
    # Orange (RYB): #FB9902: (251, 153, 2)
    ORANGE_RYB = RGB.new(0.984313725490196, 0.6, 0.00784313725490196)
    # Orange (web): #FFA500: (255, 165, 0)
    ORANGE_WEB = RGB.new(1.0, 0.6470588235294118, 0.0)
    # Orange iced tea: #FF6700: (255, 103, 0)
    ORANGE_ICED_TEA = RGB.new(1.0, 0.403921568627451, 0.0)
    # Orange peel: #FF9F00: (255, 159, 0)
    ORANGE_PEEL = RGB.new(1.0, 0.6235294117647059, 0.0)
    # Orange-red: #FF681F: (255, 104, 31)
    ORANGE_RED = RGB.new(1.0, 0.40784313725490196, 0.12156862745098039)
    # Orange-red (Crayola): #FF5349: (255, 83, 73)
    ORANGE_RED_CRAYOLA = RGB.new(1.0, 0.3254901960784314, 0.28627450980392155)
    # Orange soda: #E74E14: (231, 78, 20)
    ORANGE_SODA = RGB.new(0.9058823529411765, 0.3058823529411765, 0.0784313725490196)
    # Orange-yellow: #F5BD1F: (245, 189, 31)
    ORANGE_YELLOW = RGB.new(0.9607843137254902, 0.7411764705882353, 0.12156862745098039)
    # Orange-yellow (Crayola): #F8D568: (248, 213, 104)
    ORANGE_YELLOW_CRAYOLA = RGB.new(0.9725490196078431, 0.8352941176470589, 0.40784313725490196)
    # Orchid: #DA70D6: (218, 112, 214)
    ORCHID = RGB.new(0.8549019607843137, 0.4392156862745098, 0.8392156862745098)
    # Orchid pink: #F2BDCD: (242, 189, 205)
    ORCHID_PINK = RGB.new(0.9490196078431372, 0.7411764705882353, 0.803921568627451)
    # Orchid (Crayola): #E29CD2: (226, 156, 210)
    ORCHID_CRAYOLA = RGB.new(0.8862745098039215, 0.611764705882353, 0.8235294117647058)
    # Orioles orange: #FB4F14: (251, 79, 20)
    ORIOLES_ORANGE = RGB.new(0.984313725490196, 0.30980392156862746, 0.0784313725490196)
    # Otter brown: #654321: (101, 67, 33)
    OTTER_BROWN = RGB.new(0.396078431372549, 0.2627450980392157, 0.12941176470588237)
    # Outer Space: #414A4C: (65, 74, 76)
    OUTER_SPACE = RGB.new(0.2549019607843137, 0.2901960784313726, 0.2980392156862745)
    # Outer space (Crayola): #2D383A: (45, 56, 58)
    OUTER_SPACE_CRAYOLA = RGB.new(0.17647058823529413, 0.2196078431372549, 0.22745098039215686)
    # Outrageous Orange: #FF6E4A: (255, 110, 74)
    OUTRAGEOUS_ORANGE = RGB.new(1.0, 0.43137254901960786, 0.2901960784313726)
    # Oxblood: #800020: (128, 0, 32)
    OXBLOOD = RGB.new(0.5019607843137255, 0.0, 0.12549019607843137)
    # Oxford blue: #002147: (0, 33, 71)
    OXFORD_BLUE = RGB.new(0.0, 0.12941176470588237, 0.2784313725490196)
    # Oxley: #6D9A79: (109, 154, 121)
    OXLEY = RGB.new(0.42745098039215684, 0.6039215686274509, 0.4745098039215686)
    # OU Crimson red: #990000: (153, 0, 0)
    OU_CRIMSON_RED = RGB.new(0.6, 0.0, 0.0)
    # Pacific Blue: #1CA9C9: (28, 169, 201)
    PACIFIC_BLUE = RGB.new(0.10980392156862745, 0.6627450980392157, 0.788235294117647)
    # Pakistan green: #006600: (0, 102, 0)
    PAKISTAN_GREEN = RGB.new(0.0, 0.4, 0.0)
    # Palatinate blue: #273BE2: (39, 59, 226)
    PALATINATE_BLUE = RGB.new(0.15294117647058825, 0.23137254901960785, 0.8862745098039215)
    # Palatinate purple: #682860: (104, 40, 96)
    PALATINATE_PURPLE = RGB.new(0.40784313725490196, 0.1568627450980392, 0.3764705882352941)
    # Pale aqua: #BCD4E6: (188, 212, 230)
    PALE_AQUA = RGB.new(0.7372549019607844, 0.8313725490196079, 0.9019607843137255)
    # Pale blue: #AFEEEE: (175, 238, 238)
    PALE_BLUE = RGB.new(0.6862745098039216, 0.9333333333333333, 0.9333333333333333)
    # Pale brown: #987654: (152, 118, 84)
    PALE_BROWN = RGB.new(0.596078431372549, 0.4627450980392157, 0.32941176470588235)
    # Pale carmine: #AF4035: (175, 64, 53)
    PALE_CARMINE = RGB.new(0.6862745098039216, 0.25098039215686274, 0.20784313725490197)
    # Pale cerulean: #9BC4E2: (155, 196, 226)
    PALE_CERULEAN = RGB.new(0.6078431372549019, 0.7686274509803922, 0.8862745098039215)
    # Pale chestnut: #DDADAF: (221, 173, 175)
    PALE_CHESTNUT = RGB.new(0.8666666666666667, 0.6784313725490196, 0.6862745098039216)
    # Pale copper: #DA8A67: (218, 138, 103)
    PALE_COPPER = RGB.new(0.8549019607843137, 0.5411764705882353, 0.403921568627451)
    # Pale cornflower blue: #ABCDEF: (171, 205, 239)
    PALE_CORNFLOWER_BLUE = RGB.new(0.6705882352941176, 0.803921568627451, 0.9372549019607843)
    # Pale cyan: #87D3F8: (135, 211, 248)
    PALE_CYAN = RGB.new(0.5294117647058824, 0.8274509803921568, 0.9725490196078431)
    # Pale gold: #E6BE8A: (230, 190, 138)
    PALE_GOLD = RGB.new(0.9019607843137255, 0.7450980392156863, 0.5411764705882353)
    # Pale goldenrod: #EEE8AA: (238, 232, 170)
    PALE_GOLDENROD = RGB.new(0.9333333333333333, 0.9098039215686274, 0.6666666666666666)
    # Pale green: #98FB98: (152, 251, 152)
    PALE_GREEN = RGB.new(0.596078431372549, 0.984313725490196, 0.596078431372549)
    # Pale lavender: #DCD0FF: (220, 208, 255)
    PALE_LAVENDER = RGB.new(0.8627450980392157, 0.8156862745098039, 1.0)
    # Pale magenta: #F984E5: (249, 132, 229)
    PALE_MAGENTA = RGB.new(0.9764705882352941, 0.5176470588235295, 0.8980392156862745)
    # Pale magenta-pink: #FF99CC: (255, 153, 204)
    PALE_MAGENTA_PINK = RGB.new(1.0, 0.6, 0.8)
    # Pale pink: #FADADD: (250, 218, 221)
    PALE_PINK = RGB.new(0.9803921568627451, 0.8549019607843137, 0.8666666666666667)
    # Pale plum: #DDA0DD: (221, 160, 221)
    PALE_PLUM = RGB.new(0.8666666666666667, 0.6274509803921569, 0.8666666666666667)
    # Pale red-violet: #DB7093: (219, 112, 147)
    PALE_RED_VIOLET = RGB.new(0.8588235294117647, 0.4392156862745098, 0.5764705882352941)
    # Pale robin egg blue: #96DED1: (150, 222, 209)
    PALE_ROBIN_EGG_BLUE = RGB.new(0.5882352941176471, 0.8705882352941177, 0.8196078431372549)
    # Pale silver: #C9C0BB: (201, 192, 187)
    PALE_SILVER = RGB.new(0.788235294117647, 0.7529411764705882, 0.7333333333333333)
    # Pale spring bud: #ECEBBD: (236, 235, 189)
    PALE_SPRING_BUD = RGB.new(0.9254901960784314, 0.9215686274509803, 0.7411764705882353)
    # Pale taupe: #BC987E: (188, 152, 126)
    PALE_TAUPE = RGB.new(0.7372549019607844, 0.596078431372549, 0.49411764705882355)
    # Pale turquoise: #AFEEEE: (175, 238, 238)
    PALE_TURQUOISE = RGB.new(0.6862745098039216, 0.9333333333333333, 0.9333333333333333)
    # Pale violet: #CC99FF: (204, 153, 255)
    PALE_VIOLET = RGB.new(0.8, 0.6, 1.0)
    # Pale violet-red: #DB7093: (219, 112, 147)
    PALE_VIOLET_RED = RGB.new(0.8588235294117647, 0.4392156862745098, 0.5764705882352941)
    # Palm Leaf: #6F9940: (111, 153, 64)
    PALM_LEAF = RGB.new(0.43529411764705883, 0.6, 0.25098039215686274)
    # Pansy purple: #78184A: (120, 24, 74)
    PANSY_PURPLE = RGB.new(0.47058823529411764, 0.09411764705882353, 0.2901960784313726)
    # Paolo Veronese green: #009B7D: (0, 155, 125)
    PAOLO_VERONESE_GREEN = RGB.new(0.0, 0.6078431372549019, 0.49019607843137253)
    # Papaya whip: #FFEFD5: (255, 239, 213)
    PAPAYA_WHIP = RGB.new(1.0, 0.9372549019607843, 0.8352941176470589)
    # Paradise pink: #E63E62: (230, 62, 98)
    PARADISE_PINK = RGB.new(0.9019607843137255, 0.24313725490196078, 0.3843137254901961)
    # Paris Green: #50C878: (80, 200, 120)
    PARIS_GREEN = RGB.new(0.3137254901960784, 0.7843137254901961, 0.47058823529411764)
    # Parrot Pink: #D998A0: (217, 152, 160)
    PARROT_PINK = RGB.new(0.8509803921568627, 0.596078431372549, 0.6274509803921569)
    # Pastel blue: #AEC6CF: (174, 198, 207)
    PASTEL_BLUE = RGB.new(0.6823529411764706, 0.7764705882352941, 0.8117647058823529)
    # Pastel brown: #836953: (130, 105, 83)
    PASTEL_BROWN = RGB.new(0.5098039215686274, 0.4117647058823529, 0.3254901960784314)
    # Pastel gray: #CFCFC4: (207, 207, 196)
    PASTEL_GRAY = RGB.new(0.8117647058823529, 0.8117647058823529, 0.7686274509803922)
    # Pastel green: #77DD77: (119, 221, 119)
    PASTEL_GREEN = RGB.new(0.4666666666666667, 0.8666666666666667, 0.4666666666666667)
    # Pastel magenta: #F49AC2: (244, 154, 194)
    PASTEL_MAGENTA = RGB.new(0.9568627450980393, 0.6039215686274509, 0.7607843137254902)
    # Pastel orange: #FFB347: (255, 179, 71)
    PASTEL_ORANGE = RGB.new(1.0, 0.7019607843137254, 0.2784313725490196)
    # Pastel pink: #DEA5A4: (222, 165, 164)
    PASTEL_PINK = RGB.new(0.8705882352941177, 0.6470588235294118, 0.6431372549019608)
    # Pastel purple: #B39EB5: (179, 158, 181)
    PASTEL_PURPLE = RGB.new(0.7019607843137254, 0.6196078431372549, 0.7098039215686275)
    # Pastel red: #FF6961: (255, 105, 97)
    PASTEL_RED = RGB.new(1.0, 0.4117647058823529, 0.3803921568627451)
    # Pastel violet: #CB99C9: (203, 153, 201)
    PASTEL_VIOLET = RGB.new(0.796078431372549, 0.6, 0.788235294117647)
    # Pastel yellow: #FDFD96: (253, 253, 150)
    PASTEL_YELLOW = RGB.new(0.9921568627450981, 0.9921568627450981, 0.5882352941176471)
    # Patriarch: #800080: (128, 0, 128)
    PATRIARCH = RGB.new(0.5019607843137255, 0.0, 0.5019607843137255)
    # Payne's grey: #536878: (83, 104, 120)
    PAYNES_GREY = RGB.new(0.3254901960784314, 0.40784313725490196, 0.47058823529411764)
    # Peach: #FFE5B4: (255, 229, 180)
    PEACH = RGB.new(1.0, 0.8980392156862745, 0.7058823529411765)
    # Peach (Crayola): #FFCBA4: (255, 203, 164)
    PEACH_CRAYOLA = RGB.new(1.0, 0.796078431372549, 0.6431372549019608)
    # Peach-orange: #FFCC99: (255, 204, 153)
    PEACH_ORANGE = RGB.new(1.0, 0.8, 0.6)
    # Peach puff: #FFDAB9: (255, 218, 185)
    PEACH_PUFF = RGB.new(1.0, 0.8549019607843137, 0.7254901960784313)
    # Peach-yellow: #FADFAD: (250, 223, 173)
    PEACH_YELLOW = RGB.new(0.9803921568627451, 0.8745098039215686, 0.6784313725490196)
    # Pear: #D1E231: (209, 226, 49)
    PEAR = RGB.new(0.8196078431372549, 0.8862745098039215, 0.19215686274509805)
    # Pearl: #EAE0C8: (234, 224, 200)
    PEARL = RGB.new(0.9176470588235294, 0.8784313725490196, 0.7843137254901961)
    # Pearl Aqua: #88D8C0: (136, 216, 192)
    PEARL_AQUA = RGB.new(0.5333333333333333, 0.8470588235294118, 0.7529411764705882)
    # Pearly purple: #B768A2: (183, 104, 162)
    PEARLY_PURPLE = RGB.new(0.7176470588235294, 0.40784313725490196, 0.6352941176470588)
    # Peridot: #E6E200: (230, 226, 0)
    PERIDOT = RGB.new(0.9019607843137255, 0.8862745098039215, 0.0)
    # Periwinkle: #CCCCFF: (204, 204, 255)
    PERIWINKLE = RGB.new(0.8, 0.8, 1.0)
    # Periwinkle (Crayola): #C3CDE6: (195, 205, 230)
    PERIWINKLE_CRAYOLA = RGB.new(0.7647058823529411, 0.803921568627451, 0.9019607843137255)
    # Permanent Geranium Lake: #E12C2C: (225, 44, 44)
    PERMANENT_GERANIUM_LAKE = RGB.new(0.8823529411764706, 0.17254901960784313, 0.17254901960784313)
    # Persian blue: #1C39BB: (28, 57, 187)
    PERSIAN_BLUE = RGB.new(0.10980392156862745, 0.2235294117647059, 0.7333333333333333)
    # Persian green: #00A693: (0, 166, 147)
    PERSIAN_GREEN = RGB.new(0.0, 0.6509803921568628, 0.5764705882352941)
    # Persian indigo: #32127A: (50, 18, 122)
    PERSIAN_INDIGO = RGB.new(0.19607843137254902, 0.07058823529411765, 0.47843137254901963)
    # Persian orange: #D99058: (217, 144, 88)
    PERSIAN_ORANGE = RGB.new(0.8509803921568627, 0.5647058823529412, 0.34509803921568627)
    # Persian pink: #F77FBE: (247, 127, 190)
    PERSIAN_PINK = RGB.new(0.9686274509803922, 0.4980392156862745, 0.7450980392156863)
    # Persian plum: #701C1C: (112, 28, 28)
    PERSIAN_PLUM = RGB.new(0.4392156862745098, 0.10980392156862745, 0.10980392156862745)
    # Persian red: #CC3333: (204, 51, 51)
    PERSIAN_RED = RGB.new(0.8, 0.2, 0.2)
    # Persian rose: #FE28A2: (254, 40, 162)
    PERSIAN_ROSE = RGB.new(0.996078431372549, 0.1568627450980392, 0.6352941176470588)
    # Persimmon: #EC5800: (236, 88, 0)
    PERSIMMON = RGB.new(0.9254901960784314, 0.34509803921568627, 0.0)
    # Peru: #CD853F: (205, 133, 63)
    PERU = RGB.new(0.803921568627451, 0.5215686274509804, 0.24705882352941178)
    # Pewter Blue: #8BA8B7: (139, 168, 183)
    PEWTER_BLUE = RGB.new(0.5450980392156862, 0.6588235294117647, 0.7176470588235294)
    # Philippine blue: #0038A7: (0, 56, 167)
    PHILIPPINE_BLUE = RGB.new(0.0, 0.2196078431372549, 0.6549019607843137)
    # Philippine bronze: #6E3A07: (110, 58, 7)
    PHILIPPINE_BRONZE = RGB.new(0.43137254901960786, 0.22745098039215686, 0.027450980392156862)
    # Philippine brown: #5D1916: (93, 25, 22)
    PHILIPPINE_BROWN = RGB.new(0.36470588235294116, 0.09803921568627451, 0.08627450980392157)
    # Philippine gold: #B17304: (177, 115, 4)
    PHILIPPINE_GOLD = RGB.new(0.6941176470588235, 0.45098039215686275, 0.01568627450980392)
    # Philippine golden yellow: #FFDF00: (253, 223, 22)
    PHILIPPINE_GOLDEN_YELLOW = RGB.new(0.9921568627450981, 0.8745098039215686, 0.08627450980392157)
    # Philippine gray: #8C8C8C: (140, 140, 140)
    PHILIPPINE_GRAY = RGB.new(0.5490196078431373, 0.5490196078431373, 0.5490196078431373)
    # Philippine green: #008543: (0, 133, 67)
    PHILIPPINE_GREEN = RGB.new(0.0, 0.5215686274509804, 0.2627450980392157)
    # Philippine indigo: #00416A: (0, 65, 106)
    PHILIPPINE_INDIGO = RGB.new(0.0, 0.2549019607843137, 0.41568627450980394)
    # Philippine orange: #FF7300: (255, 115, 0)
    PHILIPPINE_ORANGE = RGB.new(1.0, 0.45098039215686275, 0.0)
    # Philippine pink: #FA1A8E: (255, 26, 142)
    PHILIPPINE_PINK = RGB.new(1.0, 0.10196078431372549, 0.5568627450980392)
    # Philippine red: #CE1127: (206, 17, 39)
    PHILIPPINE_RED = RGB.new(0.807843137254902, 0.06666666666666667, 0.15294117647058825)
    # Philippine silver: #B3B3B3: (179, 179, 179)
    PHILIPPINE_SILVER = RGB.new(0.7019607843137254, 0.7019607843137254, 0.7019607843137254)
    # Philippine sky blue: #0066FF: (0, 102, 255)
    PHILIPPINE_SKY_BLUE = RGB.new(0.0, 0.4, 1.0)
    # Philippine violet: #81007F: (129, 0, 127)
    PHILIPPINE_VIOLET = RGB.new(0.5058823529411764, 0.0, 0.4980392156862745)
    # Philippine yellow: #FECB00: (254, 203, 0)
    PHILIPPINE_YELLOW = RGB.new(0.996078431372549, 0.796078431372549, 0.0)
    # Phlox: #DF00FF: (223, 0, 255)
    PHLOX = RGB.new(0.8745098039215686, 0.0, 1.0)
    # Phthalo blue: #000F89: (0, 15, 137)
    PHTHALO_BLUE = RGB.new(0.0, 0.058823529411764705, 0.5372549019607843)
    # Phthalo green: #123524: (18, 53, 36)
    PHTHALO_GREEN = RGB.new(0.07058823529411765, 0.20784313725490197, 0.1411764705882353)
    # Picton blue: #45B1E8: (69, 177, 232)
    PICTON_BLUE = RGB.new(0.27058823529411763, 0.6941176470588235, 0.9098039215686274)
    # Pictorial carmine: #C30B4E: (195, 11, 78)
    PICTORIAL_CARMINE = RGB.new(0.7647058823529411, 0.043137254901960784, 0.3058823529411765)
    # Piggy pink: #FDDDE6: (253, 221, 230)
    PIGGY_PINK = RGB.new(0.9921568627450981, 0.8666666666666667, 0.9019607843137255)
    # Pine green: #01796F: (1, 121, 111)
    PINE_GREEN = RGB.new(0.00392156862745098, 0.4745098039215686, 0.43529411764705883)
    # Pine tree: #2A2F23: (42, 47, 35)
    PINE_TREE = RGB.new(0.16470588235294117, 0.1843137254901961, 0.13725490196078433)
    # Pineapple: #563C0D: (86, 60, 13)
    PINEAPPLE = RGB.new(0.33725490196078434, 0.23529411764705882, 0.050980392156862744)
    # Pink: #FFC0CB: (255, 192, 203)
    PINK = RGB.new(1.0, 0.7529411764705882, 0.796078431372549)
    # Pink (Pantone): #D74894: (215, 72, 148)
    PINK_PANTONE = RGB.new(0.8431372549019608, 0.2823529411764706, 0.5803921568627451)
    # Pink Diamond (Ace Hardware Color): #F6D6DE: (246, 214, 222)
    PINK_DIAMOND_ACE_HARDWARE_COLOR = RGB.new(0.9647058823529412, 0.8392156862745098, 0.8705882352941177)
    # Pink Diamond (Independent Retailers Colors): #F0D3DC: (240, 211, 220)
    PINK_DIAMOND_INDEPENDENT_RETAILERS_COLORS = RGB.new(0.9411764705882353, 0.8274509803921568, 0.8627450980392157)
    # Pink flamingo: #FC74FD: (252, 116, 253)
    PINK_FLAMINGO = RGB.new(0.9882352941176471, 0.4549019607843137, 0.9921568627450981)
    # Pink lace: #FFDDF4: (255, 221, 244)
    PINK_LACE = RGB.new(1.0, 0.8666666666666667, 0.9568627450980393)
    # Pink lavender: #D8B2D1: (216, 178, 209)
    PINK_LAVENDER = RGB.new(0.8470588235294118, 0.6980392156862745, 0.8196078431372549)
    # Pink-orange: #FF9966: (255, 153, 102)
    PINK_ORANGE = RGB.new(1.0, 0.6, 0.4)
    # Pink pearl: #E7ACCF: (231, 172, 207)
    PINK_PEARL = RGB.new(0.9058823529411765, 0.6745098039215687, 0.8117647058823529)
    # Pink raspberry: #980036: (152, 0, 54)
    PINK_RASPBERRY = RGB.new(0.596078431372549, 0.0, 0.21176470588235294)
    # Pink Sherbet: #F78FA7: (247, 143, 167)
    PINK_SHERBET = RGB.new(0.9686274509803922, 0.5607843137254902, 0.6549019607843137)
    # Pistachio: #93C572: (147, 197, 114)
    PISTACHIO = RGB.new(0.5764705882352941, 0.7725490196078432, 0.4470588235294118)
    # Pixie Powder: #391285: (57, 18, 133)
    PIXIE_POWDER = RGB.new(0.2235294117647059, 0.07058823529411765, 0.5215686274509804)
    # Platinum: #E5E4E2: (229, 228, 226)
    PLATINUM = RGB.new(0.8980392156862745, 0.8941176470588236, 0.8862745098039215)
    # Plum: #8E4585: (142, 69, 133)
    PLUM = RGB.new(0.5568627450980392, 0.27058823529411763, 0.5215686274509804)
    # Plum (web): #DDA0DD: (221, 160, 221)
    PLUM_WEB = RGB.new(0.8666666666666667, 0.6274509803921569, 0.8666666666666667)
    # Plump Purple: #5946B2: (89, 70, 178)
    PLUMP_PURPLE = RGB.new(0.34901960784313724, 0.27450980392156865, 0.6980392156862745)
    # Police blue: #374F6B: (55, 79, 107)
    POLICE_BLUE = RGB.new(0.21568627450980393, 0.30980392156862746, 0.4196078431372549)
    # Polished Pine: #5DA493: (93, 164, 147)
    POLISHED_PINE = RGB.new(0.36470588235294116, 0.6431372549019608, 0.5764705882352941)
    # Pomp and Power: #86608E: (134, 96, 142)
    POMP_AND_POWER = RGB.new(0.5254901960784314, 0.3764705882352941, 0.5568627450980392)
    # Popstar: #BE4F62: (190, 79, 98)
    POPSTAR = RGB.new(0.7450980392156863, 0.30980392156862746, 0.3843137254901961)
    # Portland Orange: #FF5A36: (255, 90, 54)
    PORTLAND_ORANGE = RGB.new(1.0, 0.35294117647058826, 0.21176470588235294)
    # Powder blue: #B0E0E6: (176, 224, 230)
    POWDER_BLUE = RGB.new(0.6901960784313725, 0.8784313725490196, 0.9019607843137255)
    # Prilly blue: #329CC3: (50, 156, 195)
    PRILLY_BLUE = RGB.new(0.19607843137254902, 0.611764705882353, 0.7647058823529411)
    # Prilly pink: #FF40A0: (255, 64, 160)
    PRILLY_PINK = RGB.new(1.0, 0.25098039215686274, 0.6274509803921569)
    # Prilly red: #FF0040: (255, 0, 64)
    PRILLY_RED = RGB.new(1.0, 0.0, 0.25098039215686274)
    # Princess Perfume: #FF85CF: (255, 133, 207)
    PRINCESS_PERFUME = RGB.new(1.0, 0.5215686274509804, 0.8117647058823529)
    # Princeton orange: #F58025: (245, 128, 37)
    PRINCETON_ORANGE = RGB.new(0.9607843137254902, 0.5019607843137255, 0.1450980392156863)
    # Prune: #701C1C: (112, 28, 28)
    PRUNE = RGB.new(0.4392156862745098, 0.10980392156862745, 0.10980392156862745)
    # Prussian blue: #003153: (0, 49, 83)
    PRUSSIAN_BLUE = RGB.new(0.0, 0.19215686274509805, 0.3254901960784314)
    # Psychedelic purple: #DF00FF: (223, 0, 255)
    PSYCHEDELIC_PURPLE = RGB.new(0.8745098039215686, 0.0, 1.0)
    # Puce: #CC8899: (204, 136, 153)
    PUCE = RGB.new(0.8, 0.5333333333333333, 0.6)
    # Puce red: #722F37: (114, 47, 55)
    PUCE_RED = RGB.new(0.4470588235294118, 0.1843137254901961, 0.21568627450980393)
    # Pullman Brown (UPS Brown): #644117: (100, 65, 23)
    PULLMAN_BROWN_UPS_BROWN = RGB.new(0.39215686274509803, 0.2549019607843137, 0.09019607843137255)
    # Pullman Green: #3B331C: (59, 51, 28)
    PULLMAN_GREEN = RGB.new(0.23137254901960785, 0.2, 0.10980392156862745)
    # Pumpkin: #FF7518: (255, 117, 24)
    PUMPKIN = RGB.new(1.0, 0.4588235294117647, 0.09411764705882353)
    # Purple (HTML): #800080: (128, 0, 128)
    PURPLE_HTML = RGB.new(0.5019607843137255, 0.0, 0.5019607843137255)
    # Purple (Munsell): #9F00C5: (159, 0, 197)
    PURPLE_MUNSELL = RGB.new(0.6235294117647059, 0.0, 0.7725490196078432)
    # Purple (X11): #A020F0: (160, 32, 240)
    PURPLE_X11 = RGB.new(0.6274509803921569, 0.12549019607843137, 0.9411764705882353)
    # Purple Heart: #69359C: (105, 53, 156)
    PURPLE_HEART = RGB.new(0.4117647058823529, 0.20784313725490197, 0.611764705882353)
    # Purple mountain majesty: #9678B6: (150, 120, 182)
    PURPLE_MOUNTAIN_MAJESTY = RGB.new(0.5882352941176471, 0.47058823529411764, 0.7137254901960784)
    # Purple navy: #4E5180: (78, 81, 128)
    PURPLE_NAVY = RGB.new(0.3058823529411765, 0.3176470588235294, 0.5019607843137255)
    # Purple pizzazz: #FE4EDA: (254, 78, 218)
    PURPLE_PIZZAZZ = RGB.new(0.996078431372549, 0.3058823529411765, 0.8549019607843137)
    # Purple Plum: #9C51B6: (156, 81, 182)
    PURPLE_PLUM = RGB.new(0.611764705882353, 0.3176470588235294, 0.7137254901960784)
    # Purple taupe: #50404D: (80, 64, 77)
    PURPLE_TAUPE = RGB.new(0.3137254901960784, 0.25098039215686274, 0.30196078431372547)
    # Purpureus: #9A4EAE: (154, 78, 174)
    PURPUREUS = RGB.new(0.6039215686274509, 0.3058823529411765, 0.6823529411764706)
    # Quartz: #51484F: (81, 72, 79)
    QUARTZ = RGB.new(0.3176470588235294, 0.2823529411764706, 0.30980392156862746)
    # Queen blue: #436B95: (67, 107, 149)
    QUEEN_BLUE = RGB.new(0.2627450980392157, 0.4196078431372549, 0.5843137254901961)
    # Queen pink: #E8CCD7: (232, 204, 215)
    QUEEN_PINK = RGB.new(0.9098039215686274, 0.8, 0.8431372549019608)
    # Quick Silver: #A6A6A6: (166, 166, 166)
    QUICK_SILVER = RGB.new(0.6509803921568628, 0.6509803921568628, 0.6509803921568628)
    # Quinacridone magenta: #8E3A59: (142, 58, 89)
    QUINACRIDONE_MAGENTA = RGB.new(0.5568627450980392, 0.22745098039215686, 0.34901960784313724)
    # Quincy: #6A5445: (106, 84, 69)
    QUINCY = RGB.new(0.41568627450980394, 0.32941176470588235, 0.27058823529411763)
    # Rackley: #5D8AA8: (93, 138, 168)
    RACKLEY = RGB.new(0.36470588235294116, 0.5411764705882353, 0.6588235294117647)
    # Radical Red: #FF355E: (255, 53, 94)
    RADICAL_RED = RGB.new(1.0, 0.20784313725490197, 0.3686274509803922)
    # Raisin black: #242124: (36, 33, 36)
    RAISIN_BLACK = RGB.new(0.1411764705882353, 0.12941176470588237, 0.1411764705882353)
    # Rajah: #FBAB60: (251, 171, 96)
    RAJAH = RGB.new(0.984313725490196, 0.6705882352941176, 0.3764705882352941)
    # Raspberry: #E30B5D: (227, 11, 92)
    RASPBERRY = RGB.new(0.8901960784313725, 0.043137254901960784, 0.3607843137254902)
    # Raspberry glace: #915F6D: (145, 95, 109)
    RASPBERRY_GLACE = RGB.new(0.5686274509803921, 0.37254901960784315, 0.42745098039215684)
    # Raspberry pink: #E25098: (226, 80, 152)
    RASPBERRY_PINK = RGB.new(0.8862745098039215, 0.3137254901960784, 0.596078431372549)
    # Raspberry rose: #B3446C: (179, 68, 108)
    RASPBERRY_ROSE = RGB.new(0.7019607843137254, 0.26666666666666666, 0.4235294117647059)
    # Raw Sienna: #D68A59: (214, 138, 89)
    RAW_SIENNA = RGB.new(0.8392156862745098, 0.5411764705882353, 0.34901960784313724)
    # Raw umber: #826644: (130, 102, 68)
    RAW_UMBER = RGB.new(0.5098039215686274, 0.4, 0.26666666666666666)
    # Razzle dazzle rose: #FF33CC: (255, 51, 204)
    RAZZLE_DAZZLE_ROSE = RGB.new(1.0, 0.2, 0.8)
    # Razzmatazz: #E3256B: (227, 37, 107)
    RAZZMATAZZ = RGB.new(0.8901960784313725, 0.1450980392156863, 0.4196078431372549)
    # Razzmic Berry: #8D4E85: (141, 78, 133)
    RAZZMIC_BERRY = RGB.new(0.5529411764705883, 0.3058823529411765, 0.5215686274509804)
    # Rebecca Purple: #663399: (102, 52, 153)
    REBECCA_PURPLE = RGB.new(0.4, 0.20392156862745098, 0.6)
    # Red: #FF0000: (255, 0, 0)
    RED = RGB.new(1.0, 0.0, 0.0)
    # Red (Crayola): #EE204D: (238, 32, 77)
    RED_CRAYOLA = RGB.new(0.9333333333333333, 0.12549019607843137, 0.30196078431372547)
    # Red (Munsell): #F2003C: (242, 0, 60)
    RED_MUNSELL = RGB.new(0.9490196078431372, 0.0, 0.23529411764705882)
    # Red (NCS): #C40233: (196, 2, 51)
    RED_NCS = RGB.new(0.7686274509803922, 0.00784313725490196, 0.2)
    # Red (Pantone): #ED2939: (237, 41, 57)
    RED_PANTONE = RGB.new(0.9294117647058824, 0.1607843137254902, 0.2235294117647059)
    # Red (pigment): #ED1C24: (237, 28, 36)
    RED_PIGMENT = RGB.new(0.9294117647058824, 0.10980392156862745, 0.1411764705882353)
    # Red (RYB): #FE2712: (254, 39, 18)
    RED_RYB = RGB.new(0.996078431372549, 0.15294117647058825, 0.07058823529411765)
    # Red-brown: #A52A2A: (165, 42, 42)
    RED_BROWN = RGB.new(0.6470588235294118, 0.16470588235294117, 0.16470588235294117)
    # Red cola: #DF0118: (223, 1, 24)
    RED_COLA = RGB.new(0.8745098039215686, 0.00392156862745098, 0.09411764705882353)
    # Red devil: #860111: (134, 1, 17)
    RED_DEVIL = RGB.new(0.5254901960784314, 0.00392156862745098, 0.06666666666666667)
    # Red-orange: #FF5349: (255, 83, 73)
    RED_ORANGE = RGB.new(1.0, 0.3254901960784314, 0.28627450980392155)
    # Red-orange (Crayola): #FF681F: (255, 104, 31)
    RED_ORANGE_CRAYOLA = RGB.new(1.0, 0.40784313725490196, 0.12156862745098039)
    # Red-orange (Color wheel): #FF4500: (255, 69, 0)
    RED_ORANGE_COLOR_WHEEL = RGB.new(1.0, 0.27058823529411763, 0.0)
    # Red-purple: #E40078: (228, 0, 120)
    RED_PURPLE = RGB.new(0.8941176470588236, 0.0, 0.47058823529411764)
    # Red rum: #973A4A: (151, 58, 74)
    RED_RUM = RGB.new(0.592156862745098, 0.22745098039215686, 0.2901960784313726)
    # Red Salsa: #FD3A4A: (253, 58, 74)
    RED_SALSA = RGB.new(0.9921568627450981, 0.22745098039215686, 0.2901960784313726)
    # Red strawberry: #EC0304: (236, 3, 1)
    RED_STRAWBERRY = RGB.new(0.9254901960784314, 0.011764705882352941, 0.00392156862745098)
    # Red-violet: #C71585: (199, 21, 133)
    RED_VIOLET = RGB.new(0.7803921568627451, 0.08235294117647059, 0.5215686274509804)
    # Red-violet (Crayola): #C0448F: (192, 68, 143)
    RED_VIOLET_CRAYOLA = RGB.new(0.7529411764705882, 0.26666666666666666, 0.5607843137254902)
    # Red-violet (Color wheel): #922B3E: (146, 43, 62)
    RED_VIOLET_COLOR_WHEEL = RGB.new(0.5725490196078431, 0.16862745098039217, 0.24313725490196078)
    # Redwood: #A45A52: (164, 90, 82)
    REDWOOD = RGB.new(0.6431372549019608, 0.35294117647058826, 0.3215686274509804)
    # Registration black: #000000: (0, 0, 0)
    REGISTRATION_BLACK = RGB.new(0.0, 0.0, 0.0)
    # Resolution blue: #002387: (0, 35, 135)
    RESOLUTION_BLUE = RGB.new(0.0, 0.13725490196078433, 0.5294117647058824)
    # Rhythm: #777696: (119, 118, 150)
    RHYTHM = RGB.new(0.4666666666666667, 0.4627450980392157, 0.5882352941176471)
    # Rich brilliant lavender: #F1A7FE: (241, 167, 254)
    RICH_BRILLIANT_LAVENDER = RGB.new(0.9450980392156862, 0.6549019607843137, 0.996078431372549)
    # Rich electric blue: #0892D0: (8, 146, 208)
    RICH_ELECTRIC_BLUE = RGB.new(0.03137254901960784, 0.5725490196078431, 0.8156862745098039)
    # Rich lavender: #A76BCF: (167, 107, 207)
    RICH_LAVENDER = RGB.new(0.6549019607843137, 0.4196078431372549, 0.8117647058823529)
    # Rich lilac: #B666D2: (182, 102, 210)
    RICH_LILAC = RGB.new(0.7137254901960784, 0.4, 0.8235294117647058)
    # Rich maroon: #B03060: (176, 48, 96)
    RICH_MAROON = RGB.new(0.6901960784313725, 0.18823529411764706, 0.3764705882352941)
    # Rifle green: #444C38: (68, 76, 56)
    RIFLE_GREEN = RGB.new(0.26666666666666666, 0.2980392156862745, 0.2196078431372549)
    # Ripe mango: #FFC324: (255, 195, 36)
    RIPE_MANGO = RGB.new(1.0, 0.7647058823529411, 0.1411764705882353)
    # Roast coffee: #704241: (112, 66, 65)
    ROAST_COFFEE = RGB.new(0.4392156862745098, 0.25882352941176473, 0.2549019607843137)
    # Robin egg blue: #00CCCC: (0, 204, 204)
    ROBIN_EGG_BLUE = RGB.new(0.0, 0.8, 0.8)
    # Rocket metallic: #8A7F80: (138, 127, 128)
    ROCKET_METALLIC = RGB.new(0.5411764705882353, 0.4980392156862745, 0.5019607843137255)
    # Roman silver: #838996: (131, 137, 150)
    ROMAN_SILVER = RGB.new(0.5137254901960784, 0.5372549019607843, 0.5882352941176471)
    # Root beer: #290E05: (41, 14, 5)
    ROOT_BEER = RGB.new(0.1607843137254902, 0.054901960784313725, 0.0196078431372549)
    # Rose: #FF007F: (255, 0, 127)
    ROSE = RGB.new(1.0, 0.0, 0.4980392156862745)
    # Rose bonbon: #F9429E: (249, 66, 158)
    ROSE_BONBON = RGB.new(0.9764705882352941, 0.25882352941176473, 0.6196078431372549)
    # Rose Dust: #9E5E6F: (158, 94, 111)
    ROSE_DUST = RGB.new(0.6196078431372549, 0.3686274509803922, 0.43529411764705883)
    # Rose ebony: #674846: (103, 72, 70)
    ROSE_EBONY = RGB.new(0.403921568627451, 0.2823529411764706, 0.27450980392156865)
    # Rose garnet: #960145: (150, 1, 69)
    ROSE_GARNET = RGB.new(0.5882352941176471, 0.00392156862745098, 0.27058823529411763)
    # Rose gold: #B76E79: (183, 110, 121)
    ROSE_GOLD = RGB.new(0.7176470588235294, 0.43137254901960786, 0.4745098039215686)
    # Rose madder: #E32636: (227, 38, 54)
    ROSE_MADDER = RGB.new(0.8901960784313725, 0.14901960784313725, 0.21176470588235294)
    # Rose pink: #FF66CC: (255, 102, 204)
    ROSE_PINK = RGB.new(1.0, 0.4, 0.8)
    # Rose quartz: #AA98A9: (170, 152, 169)
    ROSE_QUARTZ = RGB.new(0.6666666666666666, 0.596078431372549, 0.6627450980392157)
    # Rose quartz pink: #BD559C: (189, 85, 156)
    ROSE_QUARTZ_PINK = RGB.new(0.7411764705882353, 0.3333333333333333, 0.611764705882353)
    # Rose red: #C21E56: (194, 30, 86)
    ROSE_RED = RGB.new(0.7607843137254902, 0.11764705882352941, 0.33725490196078434)
    # Rose taupe: #905D5D: (144, 93, 93)
    ROSE_TAUPE = RGB.new(0.5647058823529412, 0.36470588235294116, 0.36470588235294116)
    # Rose vale: #AB4E52: (171, 78, 82)
    ROSE_VALE = RGB.new(0.6705882352941176, 0.3058823529411765, 0.3215686274509804)
    # Rosewood: #65000B: (101, 0, 11)
    ROSEWOOD = RGB.new(0.396078431372549, 0.0, 0.043137254901960784)
    # Rosy brown: #BC8F8F: (188, 143, 143)
    ROSY_BROWN = RGB.new(0.7372549019607844, 0.5607843137254902, 0.5607843137254902)
    # Royal azure: #0038A8: (0, 56, 168)
    ROYAL_AZURE = RGB.new(0.0, 0.2196078431372549, 0.6588235294117647)
    # Royal blue: #002366: (0, 35, 102)
    ROYAL_BLUE = RGB.new(0.0, 0.13725490196078433, 0.4)
    # Royal brown: #523B35: (82, 59, 53)
    ROYAL_BROWN = RGB.new(0.3215686274509804, 0.23137254901960785, 0.20784313725490197)
    # Royal fuchsia: #CA2C92: (202, 44, 146)
    ROYAL_FUCHSIA = RGB.new(0.792156862745098, 0.17254901960784313, 0.5725490196078431)
    # Royal green: #136207: (19, 98, 7)
    ROYAL_GREEN = RGB.new(0.07450980392156863, 0.3843137254901961, 0.027450980392156862)
    # Royal orange: #F99245: (249, 146, 69)
    ROYAL_ORANGE = RGB.new(0.9764705882352941, 0.5725490196078431, 0.27058823529411763)
    # Royal pink: #E73895: (231, 56, 149)
    ROYAL_PINK = RGB.new(0.9058823529411765, 0.2196078431372549, 0.5843137254901961)
    # Royal red: #9B1C31: (155, 28, 49)
    ROYAL_RED = RGB.new(0.6078431372549019, 0.10980392156862745, 0.19215686274509805)
    # Royal purple: #7851A9: (120, 81, 169)
    ROYAL_PURPLE = RGB.new(0.47058823529411764, 0.3176470588235294, 0.6627450980392157)
    # Royal yellow: #FADA5E: (250, 218, 94)
    ROYAL_YELLOW = RGB.new(0.9803921568627451, 0.8549019607843137, 0.3686274509803922)
    # Ruber: #CE4676: (206, 70, 118)
    RUBER = RGB.new(0.807843137254902, 0.27450980392156865, 0.4627450980392157)
    # Rubine red: #D10056: (209, 0, 86)
    RUBINE_RED = RGB.new(0.8196078431372549, 0.0, 0.33725490196078434)
    # Ruby: #E0115F: (224, 17, 95)
    RUBY = RGB.new(0.8784313725490196, 0.06666666666666667, 0.37254901960784315)
    # Ruby red: #9B111E: (155, 17, 30)
    RUBY_RED = RGB.new(0.6078431372549019, 0.06666666666666667, 0.11764705882352941)
    # Rufous: #A81C07: (168, 28, 7)
    RUFOUS = RGB.new(0.6588235294117647, 0.10980392156862745, 0.027450980392156862)
    # Rum: #9A4E40: (154, 78, 64)
    RUM = RGB.new(0.6039215686274509, 0.3058823529411765, 0.25098039215686274)
    # Russet: #80461B: (128, 70, 27)
    RUSSET = RGB.new(0.5019607843137255, 0.27450980392156865, 0.10588235294117647)
    # Russian green: #679267: (103, 146, 103)
    RUSSIAN_GREEN = RGB.new(0.403921568627451, 0.5725490196078431, 0.403921568627451)
    # Russian violet: #32174D: (50, 23, 77)
    RUSSIAN_VIOLET = RGB.new(0.19607843137254902, 0.09019607843137255, 0.30196078431372547)
    # Rust: #B7410E: (183, 65, 14)
    RUST = RGB.new(0.7176470588235294, 0.2549019607843137, 0.054901960784313725)
    # Rusty red: #DA2C43: (218, 44, 67)
    RUSTY_RED = RGB.new(0.8549019607843137, 0.17254901960784313, 0.2627450980392157)
    # Sacramento State green: #043927: (4, 57, 39)
    SACRAMENTO_STATE_GREEN = RGB.new(0.01568627450980392, 0.2235294117647059, 0.15294117647058825)
    # Saddle brown: #8B4513: (139, 69, 19)
    SADDLE_BROWN = RGB.new(0.5450980392156862, 0.27058823529411763, 0.07450980392156863)
    # Safety orange: #FF7800: (255, 120, 0)
    SAFETY_ORANGE = RGB.new(1.0, 0.47058823529411764, 0.0)
    # Safety orange (blaze orange): #FF6700: (255, 103, 0)
    SAFETY_ORANGE_BLAZE_ORANGE = RGB.new(1.0, 0.403921568627451, 0.0)
    # Safety yellow: #EED202: (238, 210, 2)
    SAFETY_YELLOW = RGB.new(0.9333333333333333, 0.8235294117647058, 0.00784313725490196)
    # Saffron: #F4C430: (244, 196, 48)
    SAFFRON = RGB.new(0.9568627450980393, 0.7686274509803922, 0.18823529411764706)
    # Sage: #BCB88A: (188, 184, 138)
    SAGE = RGB.new(0.7372549019607844, 0.7215686274509804, 0.5411764705882353)
    # St. Patrick's blue: #23297A: (35, 41, 122)
    ST_PATRICKS_BLUE = RGB.new(0.13725490196078433, 0.1607843137254902, 0.47843137254901963)
    # Salem: #177B4D: (23, 123, 77)
    SALEM = RGB.new(0.09019607843137255, 0.4823529411764706, 0.30196078431372547)
    # Salmon: #FA8072: (250, 128, 114)
    SALMON = RGB.new(0.9803921568627451, 0.5019607843137255, 0.4470588235294118)
    # Salmon Rose: #E7968B: (231, 150, 139)
    SALMON_ROSE = RGB.new(0.9058823529411765, 0.5882352941176471, 0.5450980392156862)
    # Salmon pink: #FF91A4: (255, 145, 164)
    SALMON_PINK = RGB.new(1.0, 0.5686274509803921, 0.6431372549019608)
    # Samsung blue: #12279E: (18, 39, 158)
    SAMSUNG_BLUE = RGB.new(0.07058823529411765, 0.15294117647058825, 0.6196078431372549)
    # Sand: #C2B280: (194, 178, 128)
    SAND = RGB.new(0.7607843137254902, 0.6980392156862745, 0.5019607843137255)
    # Sand dune: #967117: (150, 113, 23)
    SAND_DUNE = RGB.new(0.5882352941176471, 0.44313725490196076, 0.09019607843137255)
    # Sandstorm: #ECD540: (236, 213, 64)
    SANDSTORM = RGB.new(0.9254901960784314, 0.8352941176470589, 0.25098039215686274)
    # Sandy brown: #F4A460: (244, 164, 96)
    SANDY_BROWN = RGB.new(0.9568627450980393, 0.6431372549019608, 0.3764705882352941)
    # Sandy Tan: #FDD9B5: (253, 217, 181)
    SANDY_TAN = RGB.new(0.9921568627450981, 0.8509803921568627, 0.7098039215686275)
    # Sandy taupe: #967117: (150, 113, 23)
    SANDY_TAUPE = RGB.new(0.5882352941176471, 0.44313725490196076, 0.09019607843137255)
    # Sap green: #507D2A: (80, 125, 42)
    SAP_GREEN = RGB.new(0.3137254901960784, 0.49019607843137253, 0.16470588235294117)
    # Sapphire: #0F52BA: (15, 82, 186)
    SAPPHIRE = RGB.new(0.058823529411764705, 0.3215686274509804, 0.7294117647058823)
    # Sapphire blue: #0067A5: (0, 103, 165)
    SAPPHIRE_BLUE = RGB.new(0.0, 0.403921568627451, 0.6470588235294118)
    # Sasquatch Socks: #FF4681: (255, 70, 129)
    SASQUATCH_SOCKS = RGB.new(1.0, 0.27450980392156865, 0.5058823529411764)
    # Satin sheen gold: #CBA135: (203, 161, 53)
    SATIN_SHEEN_GOLD = RGB.new(0.796078431372549, 0.6313725490196078, 0.20784313725490197)
    # Scarlet: #FF2400: (255, 36, 0)
    SCARLET = RGB.new(1.0, 0.1411764705882353, 0.0)
    # Schauss pink: #FF91AF: (255, 145, 175)
    SCHAUSS_PINK = RGB.new(1.0, 0.5686274509803921, 0.6862745098039216)
    # School bus yellow: #FFD800: (255, 216, 0)
    SCHOOL_BUS_YELLOW = RGB.new(1.0, 0.8470588235294118, 0.0)
    # Screamin' Green: #66FF66: (102, 255, 102)
    SCREAMIN_GREEN = RGB.new(0.4, 1.0, 0.4)
    # Sea blue: #006994: (0, 105, 148)
    SEA_BLUE = RGB.new(0.0, 0.4117647058823529, 0.5803921568627451)
    # Sea Foam Green: #9FE2BF: (195, 226, 191)
    SEA_FOAM_GREEN = RGB.new(0.7647058823529411, 0.8862745098039215, 0.7490196078431373)
    # Sea green: #2E8B57: (46, 139, 87)
    SEA_GREEN = RGB.new(0.1803921568627451, 0.5450980392156862, 0.3411764705882353)
    # Sea green (Crayola): #00FFCD: (1, 255, 205)
    SEA_GREEN_CRAYOLA = RGB.new(0.00392156862745098, 1.0, 0.803921568627451)
    # Sea Serpent: #4BC7CF: (75, 199, 207)
    SEA_SERPENT = RGB.new(0.29411764705882354, 0.7803921568627451, 0.8117647058823529)
    # Seal brown: #59260B: (50, 20, 20)
    SEAL_BROWN = RGB.new(0.19607843137254902, 0.0784313725490196, 0.0784313725490196)
    # Seashell: #FFF5EE: (255, 245, 238)
    SEASHELL = RGB.new(1.0, 0.9607843137254902, 0.9333333333333333)
    # Selective yellow: #FFBA00: (255, 186, 0)
    SELECTIVE_YELLOW = RGB.new(1.0, 0.7294117647058823, 0.0)
    # Sepia: #704214: (112, 66, 20)
    SEPIA = RGB.new(0.4392156862745098, 0.25882352941176473, 0.0784313725490196)
    # Shadow: #8A795D: (138, 121, 93)
    SHADOW = RGB.new(0.5411764705882353, 0.4745098039215686, 0.36470588235294116)
    # Shadow blue: #778BA5: (119, 139, 165)
    SHADOW_BLUE = RGB.new(0.4666666666666667, 0.5450980392156862, 0.6470588235294118)
    # Shampoo: #FFCFF1: (255, 207, 241)
    SHAMPOO = RGB.new(1.0, 0.8117647058823529, 0.9450980392156862)
    # Shamrock green: #009E60: (0, 158, 96)
    SHAMROCK_GREEN = RGB.new(0.0, 0.6196078431372549, 0.3764705882352941)
    # Shandy: #FFE670: (255, 230, 112)
    SHANDY = RGB.new(1.0, 0.9019607843137255, 0.4392156862745098)
    # Sheen green: #8FD400: (143, 212, 0)
    SHEEN_GREEN = RGB.new(0.5607843137254902, 0.8313725490196079, 0.0)
    # Shimmering Blush: #D98695: (217, 134, 149)
    SHIMMERING_BLUSH = RGB.new(0.8509803921568627, 0.5254901960784314, 0.5843137254901961)
    # Shiny Shamrock: #5FA778: (95, 167, 120)
    SHINY_SHAMROCK = RGB.new(0.37254901960784315, 0.6549019607843137, 0.47058823529411764)
    # Shocking pink: #FC0FC0: (252, 15, 192)
    SHOCKING_PINK = RGB.new(0.9882352941176471, 0.058823529411764705, 0.7529411764705882)
    # Shocking pink (Crayola): #FF6FFF: (255, 111, 255)
    SHOCKING_PINK_CRAYOLA = RGB.new(1.0, 0.43529411764705883, 1.0)
    # Sienna: #882D17: (136, 45, 23)
    SIENNA = RGB.new(0.5333333333333333, 0.17647058823529413, 0.09019607843137255)
    # Silver: #C0C0C0: (192, 192, 192)
    SILVER = RGB.new(0.7529411764705882, 0.7529411764705882, 0.7529411764705882)
    # Silver (Crayola): #C9C0BB: (201, 192, 187)
    SILVER_CRAYOLA = RGB.new(0.788235294117647, 0.7529411764705882, 0.7333333333333333)
    # Silver (Metallic): #AAA9AD: (170, 169, 173)
    SILVER_METALLIC = RGB.new(0.6666666666666666, 0.6627450980392157, 0.6784313725490196)
    # Silver chalice: #ACACAC: (172, 172, 172)
    SILVER_CHALICE = RGB.new(0.6745098039215687, 0.6745098039215687, 0.6745098039215687)
    # Silver foil: #AFB1AE: (175, 177, 174)
    SILVER_FOIL = RGB.new(0.6862745098039216, 0.6941176470588235, 0.6823529411764706)
    # Silver Lake blue: #5D89BA: (93, 137, 186)
    SILVER_LAKE_BLUE = RGB.new(0.36470588235294116, 0.5372549019607843, 0.7294117647058823)
    # Silver pink: #C4AEAD: (196, 174, 173)
    SILVER_PINK = RGB.new(0.7686274509803922, 0.6823529411764706, 0.6784313725490196)
    # Silver sand: #BFC1C2: (191, 193, 194)
    SILVER_SAND = RGB.new(0.7490196078431373, 0.7568627450980392, 0.7607843137254902)
    # Sinopia: #CB410B: (203, 65, 11)
    SINOPIA = RGB.new(0.796078431372549, 0.2549019607843137, 0.043137254901960784)
    # Sizzling Red: #FF3855: (255, 56, 85)
    SIZZLING_RED = RGB.new(1.0, 0.2196078431372549, 0.3333333333333333)
    # Sizzling Sunrise: #FFDB00: (255, 219, 0)
    SIZZLING_SUNRISE = RGB.new(1.0, 0.8588235294117647, 0.0)
    # Skobeloff: #007474: (0, 116, 116)
    SKOBELOFF = RGB.new(0.0, 0.4549019607843137, 0.4549019607843137)
    # Sky blue: #87CEEB: (135, 206, 235)
    SKY_BLUE = RGB.new(0.5294117647058824, 0.807843137254902, 0.9215686274509803)
    # Sky blue (Crayola): #76D7EA: (118, 215, 234)
    SKY_BLUE_CRAYOLA = RGB.new(0.4627450980392157, 0.8431372549019608, 0.9176470588235294)
    # Sky magenta: #CF71AF: (207, 113, 175)
    SKY_MAGENTA = RGB.new(0.8117647058823529, 0.44313725490196076, 0.6862745098039216)
    # Slate blue: #6A5ACD: (106, 90, 205)
    SLATE_BLUE = RGB.new(0.41568627450980394, 0.35294117647058826, 0.803921568627451)
    # Slate gray: #708090: (112, 128, 144)
    SLATE_GRAY = RGB.new(0.4392156862745098, 0.5019607843137255, 0.5647058823529412)
    # Slimy green: #299617: (41, 150, 23)
    SLIMY_GREEN = RGB.new(0.1607843137254902, 0.5882352941176471, 0.09019607843137255)
    # Smalt (Dark powder blue): #003399: (0, 51, 153)
    SMALT_DARK_POWDER_BLUE = RGB.new(0.0, 0.2, 0.6)
    # Smashed Pumpkin: #FF6D3A: (255, 109, 58)
    SMASHED_PUMPKIN = RGB.new(1.0, 0.42745098039215684, 0.22745098039215686)
    # Smitten: #C84186: (200, 65, 134)
    SMITTEN = RGB.new(0.7843137254901961, 0.2549019607843137, 0.5254901960784314)
    # Smoke: #738276: (115, 130, 118)
    SMOKE = RGB.new(0.45098039215686275, 0.5098039215686274, 0.4627450980392157)
    # Smokey Topaz: #832A0D: (131, 42, 34)
    SMOKEY_TOPAZ = RGB.new(0.5137254901960784, 0.16470588235294117, 0.13333333333333333)
    # Smoky black: #100C08: (16, 12, 8)
    SMOKY_BLACK = RGB.new(0.06274509803921569, 0.047058823529411764, 0.03137254901960784)
    # Snow: #FFFAFA: (255, 250, 250)
    SNOW = RGB.new(1.0, 0.9803921568627451, 0.9803921568627451)
    # Soap: #CEC8EF: (206, 200, 239)
    SOAP = RGB.new(0.807843137254902, 0.7843137254901961, 0.9372549019607843)
    # Solid pink: #893843: (137, 56, 67)
    SOLID_PINK = RGB.new(0.5372549019607843, 0.2196078431372549, 0.2627450980392157)
    # Sonic silver: #757575: (117, 117, 117)
    SONIC_SILVER = RGB.new(0.4588235294117647, 0.4588235294117647, 0.4588235294117647)
    # Spartan Crimson: #9E1316: (158, 19, 22)
    SPARTAN_CRIMSON = RGB.new(0.6196078431372549, 0.07450980392156863, 0.08627450980392157)
    # Space cadet: #1D2951: (29, 41, 81)
    SPACE_CADET = RGB.new(0.11372549019607843, 0.1607843137254902, 0.3176470588235294)
    # Spanish bistre: #807532: (128, 117, 50)
    SPANISH_BISTRE = RGB.new(0.5019607843137255, 0.4588235294117647, 0.19607843137254902)
    # Spanish blue: #0070B8: (0, 112, 184)
    SPANISH_BLUE = RGB.new(0.0, 0.4392156862745098, 0.7215686274509804)
    # Spanish carmine: #D10047: (209, 0, 71)
    SPANISH_CARMINE = RGB.new(0.8196078431372549, 0.0, 0.2784313725490196)
    # Spanish crimson: #E51A4C: (229, 26, 76)
    SPANISH_CRIMSON = RGB.new(0.8980392156862745, 0.10196078431372549, 0.2980392156862745)
    # Spanish gray: #989898: (152, 152, 152)
    SPANISH_GRAY = RGB.new(0.596078431372549, 0.596078431372549, 0.596078431372549)
    # Spanish green: #009150: (0, 145, 80)
    SPANISH_GREEN = RGB.new(0.0, 0.5686274509803921, 0.3137254901960784)
    # Spanish orange: #E86100: (232, 97, 0)
    SPANISH_ORANGE = RGB.new(0.9098039215686274, 0.3803921568627451, 0.0)
    # Spanish pink: #F7BFBE: (247, 191, 190)
    SPANISH_PINK = RGB.new(0.9686274509803922, 0.7490196078431373, 0.7450980392156863)
    # Spanish purple: #66033C: (102, 3, 60)
    SPANISH_PURPLE = RGB.new(0.4, 0.011764705882352941, 0.23529411764705882)
    # Spanish red: #E60026: (230, 0, 38)
    SPANISH_RED = RGB.new(0.9019607843137255, 0.0, 0.14901960784313725)
    # Spanish sky blue: #00FFFF: (0, 255, 255)
    SPANISH_SKY_BLUE = RGB.new(0.0, 1.0, 1.0)
    # Spanish violet: #4C2882: (76, 40, 130)
    SPANISH_VIOLET = RGB.new(0.2980392156862745, 0.1568627450980392, 0.5098039215686274)
    # Spanish viridian: #007F5C: (0, 127, 92)
    SPANISH_VIRIDIAN = RGB.new(0.0, 0.4980392156862745, 0.3607843137254902)
    # Spanish yellow: #F6B511: (246, 181, 17)
    SPANISH_YELLOW = RGB.new(0.9647058823529412, 0.7098039215686275, 0.06666666666666667)
    # Spicy mix: #8B5f4D: (139, 95, 77)
    SPICY_MIX = RGB.new(0.5450980392156862, 0.37254901960784315, 0.30196078431372547)
    # Spiro Disco Ball: #0FC0FC: (15, 192, 252)
    SPIRO_DISCO_BALL = RGB.new(0.058823529411764705, 0.7529411764705882, 0.9882352941176471)
    # Spring bud: #A7FC00: (167, 252, 0)
    SPRING_BUD = RGB.new(0.6549019607843137, 0.9882352941176471, 0.0)
    # Spring Frost: #87FF2A: (135, 255, 42)
    SPRING_FROST = RGB.new(0.5294117647058824, 1.0, 0.16470588235294117)
    # Spring green: #00FF7F: (0, 255, 127)
    SPRING_GREEN = RGB.new(0.0, 1.0, 0.4980392156862745)
    # Spring green (Crayola): #ECEBBD: (236, 235, 189)
    SPRING_GREEN_CRAYOLA = RGB.new(0.9254901960784314, 0.9215686274509803, 0.7411764705882353)
    # Star command blue: #007BB8: (0, 123, 184)
    STAR_COMMAND_BLUE = RGB.new(0.0, 0.4823529411764706, 0.7215686274509804)
    # Steel blue: #4682B4: (70, 130, 180)
    STEEL_BLUE = RGB.new(0.27450980392156865, 0.5098039215686274, 0.7058823529411765)
    # Steel pink: #CC33CC: (204, 51, 204)
    STEEL_PINK = RGB.new(0.8, 0.2, 0.8)
    # Steel Teal: #5F8A8B: (95, 138, 139)
    STEEL_TEAL = RGB.new(0.37254901960784315, 0.5411764705882353, 0.5450980392156862)
    # Stil de grain yellow: #FADA5E: (250, 218, 94)
    STIL_DE_GRAIN_YELLOW = RGB.new(0.9803921568627451, 0.8549019607843137, 0.3686274509803922)
    # Straw: #E4D96F: (228, 217, 111)
    STRAW = RGB.new(0.8941176470588236, 0.8509803921568627, 0.43529411764705883)
    # Strawberry: #FC5A8D: (252, 90, 141)
    STRAWBERRY = RGB.new(0.9882352941176471, 0.35294117647058826, 0.5529411764705883)
    # Stop red: #CF142B: (207, 20, 43)
    STOP_RED = RGB.new(0.8117647058823529, 0.0784313725490196, 0.16862745098039217)
    # Strawberry iced tea: #FC5A8D: (252, 90, 141)
    STRAWBERRY_ICED_TEA = RGB.new(0.9882352941176471, 0.35294117647058826, 0.5529411764705883)
    # Strawberry red: #C83F49: (200, 63, 73)
    STRAWBERRY_RED = RGB.new(0.7843137254901961, 0.24705882352941178, 0.28627450980392155)
    # Sugar Plum: #914E75: (145, 78, 117)
    SUGAR_PLUM = RGB.new(0.5686274509803921, 0.3058823529411765, 0.4588235294117647)
    # Sunburnt Cyclops: #FF404C: (255, 64, 76)
    SUNBURNT_CYCLOPS = RGB.new(1.0, 0.25098039215686274, 0.2980392156862745)
    # Sunglow: #FFCC33: (255, 204, 51)
    SUNGLOW = RGB.new(1.0, 0.8, 0.2)
    # Sunny: #F2F27A: (242, 242, 122)
    SUNNY = RGB.new(0.9490196078431372, 0.9490196078431372, 0.47843137254901963)
    # Sunray: #E3AB57: (227, 171, 87)
    SUNRAY = RGB.new(0.8901960784313725, 0.6705882352941176, 0.3411764705882353)
    # Sunset: #FAD6A5: (250, 214, 165)
    SUNSET = RGB.new(0.9803921568627451, 0.8392156862745098, 0.6470588235294118)
    # Sunset orange: #FD5E53: (253, 94, 83)
    SUNSET_ORANGE = RGB.new(0.9921568627450981, 0.3686274509803922, 0.3254901960784314)
    # Super pink: #CF6BA9: (207, 107, 169)
    SUPER_PINK = RGB.new(0.8117647058823529, 0.4196078431372549, 0.6627450980392157)
    # Sweet Brown: #A83731: (168, 55, 49)
    SWEET_BROWN = RGB.new(0.6588235294117647, 0.21568627450980393, 0.19215686274509805)
    # Tan: #D2B48C: (210, 180, 140)
    TAN = RGB.new(0.8235294117647058, 0.7058823529411765, 0.5490196078431373)
    # Tan (Crayola): #D99A6C: (217, 154, 108)
    TAN_CRAYOLA = RGB.new(0.8509803921568627, 0.6039215686274509, 0.4235294117647059)
    # Tangelo: #F94D00: (249, 77, 0)
    TANGELO = RGB.new(0.9764705882352941, 0.30196078431372547, 0.0)
    # Tangerine: #F28500: (242, 133, 0)
    TANGERINE = RGB.new(0.9490196078431372, 0.5215686274509804, 0.0)
    # Tangerine yellow: #FFCC00: (255, 204, 0)
    TANGERINE_YELLOW = RGB.new(1.0, 0.8, 0.0)
    # Tango pink: #E4717A: (228, 113, 122)
    TANGO_PINK = RGB.new(0.8941176470588236, 0.44313725490196076, 0.47843137254901963)
    # Tart Orange: #FB4D46: (251, 77, 70)
    TART_ORANGE = RGB.new(0.984313725490196, 0.30196078431372547, 0.27450980392156865)
    # Taupe: #483C32: (72, 60, 50)
    TAUPE = RGB.new(0.2823529411764706, 0.23529411764705882, 0.19607843137254902)
    # Taupe gray: #8B8589: (139, 133, 137)
    TAUPE_GRAY = RGB.new(0.5450980392156862, 0.5215686274509804, 0.5372549019607843)
    # Tea green: #D0F0C0: (208, 240, 192)
    TEA_GREEN = RGB.new(0.8156862745098039, 0.9411764705882353, 0.7529411764705882)
    # Tea rose: #F88379: (248, 131, 121)
    TEA_ROSE = RGB.new(0.9725490196078431, 0.5137254901960784, 0.4745098039215686)
    # Teal: #008080: (0, 128, 128)
    TEAL = RGB.new(0.0, 0.5019607843137255, 0.5019607843137255)
    # Teal blue: #367588: (54, 117, 136)
    TEAL_BLUE = RGB.new(0.21176470588235294, 0.4588235294117647, 0.5333333333333333)
    # Teal deer: #99E6B3: (153, 230, 179)
    TEAL_DEER = RGB.new(0.6, 0.9019607843137255, 0.7019607843137254)
    # Teal green: #00827F: (0, 130, 127)
    TEAL_GREEN = RGB.new(0.0, 0.5098039215686274, 0.4980392156862745)
    # Telemagenta: #CF3476: (207, 52, 118)
    TELEMAGENTA = RGB.new(0.8117647058823529, 0.20392156862745098, 0.4627450980392157)
    # Temptress: #3C2126: (60, 33, 38)
    TEMPTRESS = RGB.new(0.23529411764705882, 0.12941176470588237, 0.14901960784313725)
    # Tenné (tawny): #CD5700: (205, 87, 0)
    TAWNY = RGB.new(0.803921568627451, 0.3411764705882353, 0.0)
    # Terra cotta: #E2725B: (226, 114, 91)
    TERRA_COTTA = RGB.new(0.8862745098039215, 0.4470588235294118, 0.3568627450980392)
    # Thistle: #D8BFD8: (216, 191, 216)
    THISTLE = RGB.new(0.8470588235294118, 0.7490196078431373, 0.8470588235294118)
    # Thistle (Crayola): #EBB0D7: (235, 176, 215)
    THISTLE_CRAYOLA = RGB.new(0.9215686274509803, 0.6901960784313725, 0.8431372549019608)
    # Thulian pink: #DE6FA1: (222, 111, 161)
    THULIAN_PINK = RGB.new(0.8705882352941177, 0.43529411764705883, 0.6313725490196078)
    # Tickle Me Pink: #FC89AC: (252, 137, 172)
    TICKLE_ME_PINK = RGB.new(0.9882352941176471, 0.5372549019607843, 0.6745098039215687)
    # Tiffany Blue: #0ABAB5: (10, 186, 181)
    TIFFANY_BLUE = RGB.new(0.0392156862745098, 0.7294117647058823, 0.7098039215686275)
    # Tiger's eye: #E08D3C: (224, 141, 60)
    TIGERS_EYE = RGB.new(0.8784313725490196, 0.5529411764705883, 0.23529411764705882)
    # Timberwolf: #DBD7D2: (219, 215, 210)
    TIMBERWOLF = RGB.new(0.8588235294117647, 0.8431372549019608, 0.8235294117647058)
    # Titanium: #878681: (135, 134, 129)
    TITANIUM = RGB.new(0.5294117647058824, 0.5254901960784314, 0.5058823529411764)
    # Titanium yellow: #EEE600: (238, 230, 0)
    TITANIUM_YELLOW = RGB.new(0.9333333333333333, 0.9019607843137255, 0.0)
    # Tomato: #FF6347: (255, 99, 71)
    TOMATO = RGB.new(1.0, 0.38823529411764707, 0.2784313725490196)
    # Tomato sauce: #B21807: (178, 24, 7)
    TOMATO_SAUCE = RGB.new(0.6980392156862745, 0.09411764705882353, 0.027450980392156862)
    # Toolbox: #746CC0: (116, 108, 192)
    TOOLBOX = RGB.new(0.4549019607843137, 0.4235294117647059, 0.7529411764705882)
    # Tooth: #FFFAFA: (255, 250, 250)
    TOOTH = RGB.new(1.0, 0.9803921568627451, 0.9803921568627451)
    # Topaz: #FFC87C: (255, 200, 124)
    TOPAZ = RGB.new(1.0, 0.7843137254901961, 0.48627450980392156)
    # Tractor red: #FD0E35: (253, 14, 53)
    TRACTOR_RED = RGB.new(0.9921568627450981, 0.054901960784313725, 0.20784313725490197)
    # Trolley grey: #808080: (128, 128, 128)
    TROLLEY_GREY = RGB.new(0.5019607843137255, 0.5019607843137255, 0.5019607843137255)
    # Tropical rain forest: #00755E: (0, 117, 94)
    TROPICAL_RAIN_FOREST = RGB.new(0.0, 0.4588235294117647, 0.3686274509803922)
    # Tropical violet: #CDA4DE: (205, 164, 222)
    TROPICAL_VIOLET = RGB.new(0.803921568627451, 0.6431372549019608, 0.8705882352941177)
    # True blue: #0073CF: (0, 115, 207)
    TRUE_BLUE = RGB.new(0.0, 0.45098039215686275, 0.8117647058823529)
    # Tufts blue: #3E8EDE: (62, 142, 222)
    TUFTS_BLUE = RGB.new(0.24313725490196078, 0.5568627450980392, 0.8705882352941177)
    # Tulip: #FF878D: (255, 135, 141)
    TULIP = RGB.new(1.0, 0.5294117647058824, 0.5529411764705883)
    # Tumbleweed: #DEAA88: (222, 170, 136)
    TUMBLEWEED = RGB.new(0.8705882352941177, 0.6666666666666666, 0.5333333333333333)
    # Turkish rose: #B57281: (181, 114, 129)
    TURKISH_ROSE = RGB.new(0.7098039215686275, 0.4470588235294118, 0.5058823529411764)
    # Turquoise: #40E0D0: (64, 224, 208)
    TURQUOISE = RGB.new(0.25098039215686274, 0.8784313725490196, 0.8156862745098039)
    # Turquoise blue: #00FFEF: (0, 255, 239)
    TURQUOISE_BLUE = RGB.new(0.0, 1.0, 0.9372549019607843)
    # Turquoise green: #A0D6B4: (160, 214, 180)
    TURQUOISE_GREEN = RGB.new(0.6274509803921569, 0.8392156862745098, 0.7058823529411765)
    # Turquoise Surf: #00C5CD: (0, 197, 205)
    TURQUOISE_SURF = RGB.new(0.0, 0.7725490196078432, 0.803921568627451)
    # Turtle green: #8A9A5B: (138, 154, 91)
    TURTLE_GREEN = RGB.new(0.5411764705882353, 0.6039215686274509, 0.3568627450980392)
    # Tuscan: #FAD6A5: (250, 214, 165)
    TUSCAN = RGB.new(0.9803921568627451, 0.8392156862745098, 0.6470588235294118)
    # Tuscan brown: #6F4E37: (111, 78, 55)
    TUSCAN_BROWN = RGB.new(0.43529411764705883, 0.3058823529411765, 0.21568627450980393)
    # Tuscan red: #7C4848: (124, 72, 72)
    TUSCAN_RED = RGB.new(0.48627450980392156, 0.2823529411764706, 0.2823529411764706)
    # Tuscan tan: #A67B5B: (166, 123, 91)
    TUSCAN_TAN = RGB.new(0.6509803921568628, 0.4823529411764706, 0.3568627450980392)
    # Tuscany: #C09999: (192, 153, 153)
    TUSCANY = RGB.new(0.7529411764705882, 0.6, 0.6)
    # Twilight lavender: #8A496B: (138, 73, 107)
    TWILIGHT_LAVENDER = RGB.new(0.5411764705882353, 0.28627450980392155, 0.4196078431372549)
    # Twitter blue: #26A7DE: (38, 167, 222)
    TWITTER_BLUE = RGB.new(0.14901960784313725, 0.6549019607843137, 0.8705882352941177)
    # Tyrian purple: #66023C: (102, 2, 60)
    TYRIAN_PURPLE = RGB.new(0.4, 0.00784313725490196, 0.23529411764705882)
    # Ultramarine: #3F00FF: (18, 10, 143)
    ULTRAMARINE = RGB.new(0.07058823529411765, 0.0392156862745098, 0.5607843137254902)
    # Ultramarine blue: #4166F5: (65, 102, 245)
    ULTRAMARINE_BLUE = RGB.new(0.2549019607843137, 0.4, 0.9607843137254902)
    # Ultramarine blue (Caran d'Ache): #2111EF: (33, 17, 239)
    ULTRAMARINE_BLUE_CARAN_DACHE = RGB.new(0.12941176470588237, 0.06666666666666667, 0.9372549019607843)
    # Ultra pink: #FF6FFF: (255, 111, 255)
    ULTRA_PINK = RGB.new(1.0, 0.43529411764705883, 1.0)
    # Ultra red: #FC6C85: (252, 108, 133)
    ULTRA_RED = RGB.new(0.9882352941176471, 0.4235294117647059, 0.5215686274509804)
    # Umber: #635147: (99, 81, 71)
    UMBER = RGB.new(0.38823529411764707, 0.3176470588235294, 0.2784313725490196)
    # Unbleached silk: #FFDDCA: (255, 221, 202)
    UNBLEACHED_SILK = RGB.new(1.0, 0.8666666666666667, 0.792156862745098)
    # United Nations blue: #5B92E5: (91, 146, 229)
    UNITED_NATIONS_BLUE = RGB.new(0.3568627450980392, 0.5725490196078431, 0.8980392156862745)
    # Unmellow yellow: #FFFF66: (255, 255, 102)
    UNMELLOW_YELLOW = RGB.new(1.0, 1.0, 0.4)
    # UP maroon: #7B1113: (123, 17, 19)
    UP_MAROON = RGB.new(0.4823529411764706, 0.06666666666666667, 0.07450980392156863)
    # Upsdell red: #AE2029: (174, 32, 41)
    UPSDELL_RED = RGB.new(0.6823529411764706, 0.12549019607843137, 0.1607843137254902)
    # Urobilin: #E1AD21: (225, 173, 33)
    UROBILIN = RGB.new(0.8823529411764706, 0.6784313725490196, 0.12941176470588237)
    # Vampire black: #080808: (8, 8, 8)
    VAMPIRE_BLACK = RGB.new(0.03137254901960784, 0.03137254901960784, 0.03137254901960784)
    # Van Dyke brown: #664228: (102, 66, 40)
    VAN_DYKE_BROWN = RGB.new(0.4, 0.25882352941176473, 0.1568627450980392)
    # Vanilla: #F3E5AB: (243, 229, 171)
    VANILLA = RGB.new(0.9529411764705882, 0.8980392156862745, 0.6705882352941176)
    # Vanilla ice: #F38FA9: (243, 143, 169)
    VANILLA_ICE = RGB.new(0.9529411764705882, 0.5607843137254902, 0.6627450980392157)
    # Vegas gold: #C5B358: (197, 179, 88)
    VEGAS_GOLD = RGB.new(0.7725490196078432, 0.7019607843137254, 0.34509803921568627)
    # Venetian red: #C80815: (200, 8, 21)
    VENETIAN_RED = RGB.new(0.7843137254901961, 0.03137254901960784, 0.08235294117647059)
    # Verdigris: #43B3AE: (67, 179, 174)
    VERDIGRIS = RGB.new(0.2627450980392157, 0.7019607843137254, 0.6823529411764706)
    # Vermilion: #E34234: (227, 66, 52)
    VERMILION = RGB.new(0.8901960784313725, 0.25882352941176473, 0.20392156862745098)
    # Veronica: #A020F0: (160, 32, 240)
    VERONICA = RGB.new(0.6274509803921569, 0.12549019607843137, 0.9411764705882353)
    # Verse green: #18880d: (24, 136, 13)
    VERSE_GREEN = RGB.new(0.09411764705882353, 0.5333333333333333, 0.050980392156862744)
    # Very light azure: #74BBFB: (116, 187, 251)
    VERY_LIGHT_AZURE = RGB.new(0.4549019607843137, 0.7333333333333333, 0.984313725490196)
    # Very light blue: #6666FF: (102, 102, 255)
    VERY_LIGHT_BLUE = RGB.new(0.4, 0.4, 1.0)
    # Very light malachite green: #64E986: (100, 233, 134)
    VERY_LIGHT_MALACHITE_GREEN = RGB.new(0.39215686274509803, 0.9137254901960784, 0.5254901960784314)
    # Very light tangelo: #FFB077: (255, 176, 119)
    VERY_LIGHT_TANGELO = RGB.new(1.0, 0.6901960784313725, 0.4666666666666667)
    # Very pale orange: #FFDFBF: (255, 223, 191)
    VERY_PALE_ORANGE = RGB.new(1.0, 0.8745098039215686, 0.7490196078431373)
    # Very pale yellow: #FFFFBF: (255, 255, 191)
    VERY_PALE_YELLOW = RGB.new(1.0, 1.0, 0.7490196078431373)
    # Vine Green: #164010: (22, 64, 16)
    VINE_GREEN = RGB.new(0.08627450980392157, 0.25098039215686274, 0.06274509803921569)
    # Violet: #8F00FF: (143, 0, 255)
    VIOLET = RGB.new(0.5607843137254902, 0.0, 1.0)
    # Violet (Caran d'Ache): #6E00C0: (110, 0, 192)
    VIOLET_CARAN_DACHE = RGB.new(0.43137254901960786, 0.0, 0.7529411764705882)
    # Violet (color wheel): #7F00FF: (127, 0, 255)
    VIOLET_COLOR_WHEEL = RGB.new(0.4980392156862745, 0.0, 1.0)
    # Violet (crayola): #963D7F: (150, 61, 127)
    VIOLET_CRAYOLA = RGB.new(0.5882352941176471, 0.23921568627450981, 0.4980392156862745)
    # Violet (RYB): #8601AF: (134, 1, 175)
    VIOLET_RYB = RGB.new(0.5254901960784314, 0.00392156862745098, 0.6862745098039216)
    # Violet (web): #EE82EE: (238, 130, 238)
    VIOLET_WEB = RGB.new(0.9333333333333333, 0.5098039215686274, 0.9333333333333333)
    # Violet-blue: #324AB2: (50, 74, 178)
    VIOLET_BLUE = RGB.new(0.19607843137254902, 0.2901960784313726, 0.6980392156862745)
    # Violet-blue (Crayola): #766EC8: (118, 110, 200)
    VIOLET_BLUE_CRAYOLA = RGB.new(0.4627450980392157, 0.43137254901960786, 0.7843137254901961)
    # Violet-red: #F75394: (247, 83, 148)
    VIOLET_RED = RGB.new(0.9686274509803922, 0.3254901960784314, 0.5803921568627451)
    # Violin Brown: #674403: (103, 68, 3)
    VIOLIN_BROWN = RGB.new(0.403921568627451, 0.26666666666666666, 0.011764705882352941)
    # Viridian: #40826D: (64, 130, 109)
    VIRIDIAN = RGB.new(0.25098039215686274, 0.5098039215686274, 0.42745098039215684)
    # Viridian green: #009698: (0, 150, 152)
    VIRIDIAN_GREEN = RGB.new(0.0, 0.5882352941176471, 0.596078431372549)
    # Vista blue: #7C9ED9: (124, 158, 217)
    VISTA_BLUE = RGB.new(0.48627450980392156, 0.6196078431372549, 0.8509803921568627)
    # Vivid amber: #cc9900: (204, 153, 0)
    VIVID_AMBER = RGB.new(0.8, 0.6, 0.0)
    # Vivid auburn: #922724: (146, 39, 36)
    VIVID_AUBURN = RGB.new(0.5725490196078431, 0.15294117647058825, 0.1411764705882353)
    # Vivid burgundy: #9F1D35: (159, 29, 53)
    VIVID_BURGUNDY = RGB.new(0.6235294117647059, 0.11372549019607843, 0.20784313725490197)
    # Vivid cerise: #DA1D81: (218, 29, 129)
    VIVID_CERISE = RGB.new(0.8549019607843137, 0.11372549019607843, 0.5058823529411764)
    # Vivid cerulean: #00AAEE: (0, 170, 238)
    VIVID_CERULEAN = RGB.new(0.0, 0.6666666666666666, 0.9333333333333333)
    # Vivid crimson: #CC0033: (204, 0, 51)
    VIVID_CRIMSON = RGB.new(0.8, 0.0, 0.2)
    # Vivid gamboge: #FF9900: (255, 153, 0)
    VIVID_GAMBOGE = RGB.new(1.0, 0.6, 0.0)
    # Vivid lime green: #a6d608: (166, 214, 8)
    VIVID_LIME_GREEN = RGB.new(0.6509803921568628, 0.8392156862745098, 0.03137254901960784)
    # Vivid malachite: #00cc33: (0, 204, 51)
    VIVID_MALACHITE = RGB.new(0.0, 0.8, 0.2)
    # Vivid mulberry: #B80CE3: (184, 12, 227)
    VIVID_MULBERRY = RGB.new(0.7215686274509804, 0.047058823529411764, 0.8901960784313725)
    # Vivid orange: #FF5F00: (255, 95, 0)
    VIVID_ORANGE = RGB.new(1.0, 0.37254901960784315, 0.0)
    # Vivid orange peel: #FFA000: (255, 160, 0)
    VIVID_ORANGE_PEEL = RGB.new(1.0, 0.6274509803921569, 0.0)
    # Vivid orchid: #CC00FF: (204, 0, 255)
    VIVID_ORCHID = RGB.new(0.8, 0.0, 1.0)
    # Vivid raspberry: #FF006C: (255, 0, 108)
    VIVID_RASPBERRY = RGB.new(1.0, 0.0, 0.4235294117647059)
    # Vivid red: #F70D1A: (247, 13, 26)
    VIVID_RED = RGB.new(0.9686274509803922, 0.050980392156862744, 0.10196078431372549)
    # Vivid red-tangelo: #DF6124: (223, 97, 36)
    VIVID_RED_TANGELO = RGB.new(0.8745098039215686, 0.3803921568627451, 0.1411764705882353)
    # Vivid sky blue: #00CCFF: (0, 204, 255)
    VIVID_SKY_BLUE = RGB.new(0.0, 0.8, 1.0)
    # Vivid tangelo: #F07427: (240, 116, 39)
    VIVID_TANGELO = RGB.new(0.9411764705882353, 0.4549019607843137, 0.15294117647058825)
    # Vivid tangerine: #FFA089: (255, 160, 137)
    VIVID_TANGERINE = RGB.new(1.0, 0.6274509803921569, 0.5372549019607843)
    # Vivid vermilion: #e56024: (229, 96, 36)
    VIVID_VERMILION = RGB.new(0.8980392156862745, 0.3764705882352941, 0.1411764705882353)
    # Vivid violet: #9F00FF: (159, 0, 255)
    VIVID_VIOLET = RGB.new(0.6235294117647059, 0.0, 1.0)
    # Vivid yellow: #FFE302: (255, 227, 2)
    VIVID_YELLOW = RGB.new(1.0, 0.8901960784313725, 0.00784313725490196)
    # Water: #D4F1F9: (212, 241, 249)
    WATER = RGB.new(0.8313725490196079, 0.9450980392156862, 0.9764705882352941)
    # Watermelon: #F05C85: (240, 92, 133)
    WATERMELON = RGB.new(0.9411764705882353, 0.3607843137254902, 0.5215686274509804)
    # Watermelon red: #BF4147: (190, 65, 71)
    WATERMELON_RED = RGB.new(0.7450980392156863, 0.2549019607843137, 0.2784313725490196)
    # Watermelon Yellow: #EEFF1B: (238, 255, 27)
    WATERMELON_YELLOW = RGB.new(0.9333333333333333, 1.0, 0.10588235294117647)
    # Waterspout: #A4F4F9: (164, 244, 249)
    WATERSPOUT = RGB.new(0.6431372549019608, 0.9568627450980393, 0.9764705882352941)
    # Weldon Blue: #7C98AB: (124, 152, 171)
    WELDON_BLUE = RGB.new(0.48627450980392156, 0.596078431372549, 0.6705882352941176)
    # Wenge: #645452: (100, 84, 82)
    WENGE = RGB.new(0.39215686274509803, 0.32941176470588235, 0.3215686274509804)
    # Wheat: #F5DEB3: (245, 222, 179)
    WHEAT = RGB.new(0.9607843137254902, 0.8705882352941177, 0.7019607843137254)
    # White: #FFFFFF: (255, 255, 255)
    WHITE = RGB.new(1.0, 1.0, 1.0)
    # White chocolate: #EDE6D6: (237, 230, 214)
    WHITE_CHOCOLATE = RGB.new(0.9294117647058824, 0.9019607843137255, 0.8392156862745098)
    # White coffee: #E6E0D4: (230, 224, 212)
    WHITE_COFFEE = RGB.new(0.9019607843137255, 0.8784313725490196, 0.8313725490196079)
    # White smoke: #F5F5F5: (245, 245, 245)
    WHITE_SMOKE = RGB.new(0.9607843137254902, 0.9607843137254902, 0.9607843137254902)
    # Wild orchid: #D470A2: (212, 112, 162)
    WILD_ORCHID = RGB.new(0.8313725490196079, 0.4392156862745098, 0.6352941176470588)
    # Wild Strawberry: #FF43A4: (255, 67, 164)
    WILD_STRAWBERRY = RGB.new(1.0, 0.2627450980392157, 0.6431372549019608)
    # Wild watermelon: #FC6C85: (252, 108, 133)
    WILD_WATERMELON = RGB.new(0.9882352941176471, 0.4235294117647059, 0.5215686274509804)
    # Willpower orange: #FD5800: (253, 88, 0)
    WILLPOWER_ORANGE = RGB.new(0.9921568627450981, 0.34509803921568627, 0.0)
    # Windsor tan: #A75502: (167, 85, 2)
    WINDSOR_TAN = RGB.new(0.6549019607843137, 0.3333333333333333, 0.00784313725490196)
    # Wine: #722F37: (114, 47, 55)
    WINE = RGB.new(0.4470588235294118, 0.1843137254901961, 0.21568627450980393)
    # Wine dregs: #673147: (103, 49, 71)
    WINE_DREGS = RGB.new(0.403921568627451, 0.19215686274509805, 0.2784313725490196)
    # Wine red: #B11226: (177, 18, 38)
    WINE_RED = RGB.new(0.6941176470588235, 0.07058823529411765, 0.14901960784313725)
    # Winter Sky: #FF007C: (255, 0, 124)
    WINTER_SKY = RGB.new(1.0, 0.0, 0.48627450980392156)
    # Winter Wizard: #A0E6FF: (160, 230, 255)
    WINTER_WIZARD = RGB.new(0.6274509803921569, 0.9019607843137255, 1.0)
    # Wintergreen Dream: #56887D: (86, 136, 125)
    WINTERGREEN_DREAM = RGB.new(0.33725490196078434, 0.5333333333333333, 0.49019607843137253)
    # Wisteria: #C9A0DC: (201, 160, 220)
    WISTERIA = RGB.new(0.788235294117647, 0.6274509803921569, 0.8627450980392157)
    # Wood brown: #C19A6B: (193, 154, 107)
    WOOD_BROWN = RGB.new(0.7568627450980392, 0.6039215686274509, 0.4196078431372549)
    # Xanadu: #738678: (115, 134, 120)
    XANADU = RGB.new(0.45098039215686275, 0.5254901960784314, 0.47058823529411764)
    # Yellow: #FFFF00: (255, 255, 0)
    YELLOW = RGB.new(1.0, 1.0, 0.0)
    # Yellow (Crayola): #FCE883: (252, 232, 131)
    YELLOW_CRAYOLA = RGB.new(0.9882352941176471, 0.9098039215686274, 0.5137254901960784)
    # Yellow (Munsell): #EFCC00: (239, 204, 0)
    YELLOW_MUNSELL = RGB.new(0.9372549019607843, 0.8, 0.0)
    # Yellow (NCS): #FFD300: (255, 211, 0)
    YELLOW_NCS = RGB.new(1.0, 0.8274509803921568, 0.0)
    # Yellow (Pantone): #FEDF00: (254, 223, 0)
    YELLOW_PANTONE = RGB.new(0.996078431372549, 0.8745098039215686, 0.0)
    # Yellow (process): #FFEF00: (255, 239, 0)
    YELLOW_PROCESS = RGB.new(1.0, 0.9372549019607843, 0.0)
    # Yellow (RYB): #FEFE33: (254, 254, 51)
    YELLOW_RYB = RGB.new(0.996078431372549, 0.996078431372549, 0.2)
    # Yellow-green: #9ACD32: (154, 205, 50)
    YELLOW_GREEN = RGB.new(0.6039215686274509, 0.803921568627451, 0.19607843137254902)
    # Yellow-green (Crayola): #C5E384: (197, 227, 132)
    YELLOW_GREEN_CRAYOLA = RGB.new(0.7725490196078432, 0.8901960784313725, 0.5176470588235295)
    # Yellow Orange: #FFAE42: (255, 174, 66)
    YELLOW_ORANGE = RGB.new(1.0, 0.6823529411764706, 0.25882352941176473)
    # Yellow Orange (Color Wheel): #FF9505: (255, 149, 5)
    YELLOW_ORANGE_COLOR_WHEEL = RGB.new(1.0, 0.5843137254901961, 0.0196078431372549)
    # Yellow rose: #FFF000: (255, 240, 0)
    YELLOW_ROSE = RGB.new(1.0, 0.9411764705882353, 0.0)
    # Yellow Sunshine: #FFF700: (255, 247, 0)
    YELLOW_SUNSHINE = RGB.new(1.0, 0.9686274509803922, 0.0)
    # YInMn Blue: #2E5090: (46, 80, 144)
    YINMN_BLUE = RGB.new(0.1803921568627451, 0.3137254901960784, 0.5647058823529412)
    # Zaffre: #0014A8: (0, 20, 168)
    ZAFFRE = RGB.new(0.0, 0.0784313725490196, 0.6588235294117647)
    # Zebra White: #F5F5F5: (245, 245, 245)
    ZEBRA_WHITE = RGB.new(0.9607843137254902, 0.9607843137254902, 0.9607843137254902)
    # Zinnwaldite: #2C1608: (44, 22, 8)
    ZINNWALDITE = RGB.new(0.17254901960784313, 0.08627450980392157, 0.03137254901960784)

    module X11
      # Alice Blue: #F0F8FF: (240, 248, 255)
      ALICE_BLUE = RGB.new(0.9411764705882353, 0.9725490196078431, 1.0)
      # Antique White: #FAEBD7: (250, 235, 215)
      ANTIQUE_WHITE = RGB.new(0.9803921568627451, 0.9215686274509803, 0.8431372549019608)
      # Aqua: #00FFFF: (0, 255, 255)
      AQUA = RGB.new(0.0, 1.0, 1.0)
      # Aquamarine: #7FFFD4: (127, 255, 212)
      AQUAMARINE = RGB.new(0.4980392156862745, 1.0, 0.8313725490196079)
      # Azure: #F0FFFF: (240, 255, 255)
      AZURE = RGB.new(0.9411764705882353, 1.0, 1.0)
      # Beige: #F5F5DC: (245, 245, 220)
      BEIGE = RGB.new(0.9607843137254902, 0.9607843137254902, 0.8627450980392157)
      # Bisque: #FFE4C4: (255, 228, 196)
      BISQUE = RGB.new(1.0, 0.8941176470588236, 0.7686274509803922)
      # Black: #000000: (0, 0, 0)
      BLACK = RGB.new(0.0, 0.0, 0.0)
      # Blanched Almond: #FFEBCD: (255, 235, 205)
      BLANCHED_ALMOND = RGB.new(1.0, 0.9215686274509803, 0.803921568627451)
      # Blue: #0000FF: (0, 0, 255)
      BLUE = RGB.new(0.0, 0.0, 1.0)
      # Blue Violet: #8A2BE2: (138, 43, 226)
      BLUE_VIOLET = RGB.new(0.5411764705882353, 0.16862745098039217, 0.8862745098039215)
      # Brown: #A52A2A: (165, 42, 42)
      BROWN = RGB.new(0.6470588235294118, 0.16470588235294117, 0.16470588235294117)
      # Burlywood: #DEB887: (222, 184, 135)
      BURLYWOOD = RGB.new(0.8705882352941177, 0.7215686274509804, 0.5294117647058824)
      # Cadet Blue: #5F9EA0: (95, 158, 160)
      CADET_BLUE = RGB.new(0.37254901960784315, 0.6196078431372549, 0.6274509803921569)
      # Chartreuse: #7FFF00: (127, 255, 0)
      CHARTREUSE = RGB.new(0.4980392156862745, 1.0, 0.0)
      # Chocolate: #D2691E: (210, 105, 30)
      CHOCOLATE = RGB.new(0.8235294117647058, 0.4117647058823529, 0.11764705882352941)
      # Coral: #FF7F50: (255, 127, 80)
      CORAL = RGB.new(1.0, 0.4980392156862745, 0.3137254901960784)
      # Cornflower Blue: #6495ED: (100, 149, 237)
      CORNFLOWER_BLUE = RGB.new(0.39215686274509803, 0.5843137254901961, 0.9294117647058824)
      # Cornsilk: #FFF8DC: (255, 248, 220)
      CORNSILK = RGB.new(1.0, 0.9725490196078431, 0.8627450980392157)
      # Crimson: #DC143C: (220, 20, 60)
      CRIMSON = RGB.new(0.8627450980392157, 0.0784313725490196, 0.23529411764705882)
      # Cyan: #00FFFF: (0, 255, 255)
      CYAN = RGB.new(0.0, 1.0, 1.0)
      # Dark Blue: #00008B: (0, 0, 139)
      DARK_BLUE = RGB.new(0.0, 0.0, 0.5450980392156862)
      # Dark Cyan: #008B8B: (0, 139, 139)
      DARK_CYAN = RGB.new(0.0, 0.5450980392156862, 0.5450980392156862)
      # Dark Goldenrod: #B8860B: (184, 134, 11)
      DARK_GOLDENROD = RGB.new(0.7215686274509804, 0.5254901960784314, 0.043137254901960784)
      # Dark Gray: #A9A9A9: (169, 169, 169)
      DARK_GRAY = RGB.new(0.6627450980392157, 0.6627450980392157, 0.6627450980392157)
      # Dark Green: #006400: (0, 100, 0)
      DARK_GREEN = RGB.new(0.0, 0.39215686274509803, 0.0)
      # Dark Khaki: #BDB76B: (189, 183, 107)
      DARK_KHAKI = RGB.new(0.7411764705882353, 0.7176470588235294, 0.4196078431372549)
      # Dark Magenta: #8B008B: (139, 0, 139)
      DARK_MAGENTA = RGB.new(0.5450980392156862, 0.0, 0.5450980392156862)
      # Dark Olive Green: #556B2F: (85, 107, 47)
      DARK_OLIVE_GREEN = RGB.new(0.3333333333333333, 0.4196078431372549, 0.1843137254901961)
      # Dark Orange: #FF8C00: (255, 140, 0)
      DARK_ORANGE = RGB.new(1.0, 0.5490196078431373, 0.0)
      # Dark Orchid: #9932CC: (153, 50, 204)
      DARK_ORCHID = RGB.new(0.6, 0.19607843137254902, 0.8)
      # Dark Red: #8B0000: (139, 0, 0)
      DARK_RED = RGB.new(0.5450980392156862, 0.0, 0.0)
      # Dark Salmon: #E9967A: (233, 150, 122)
      DARK_SALMON = RGB.new(0.9137254901960784, 0.5882352941176471, 0.47843137254901963)
      # Dark Sea Green: #8FBC8F: (143, 188, 143)
      DARK_SEA_GREEN = RGB.new(0.5607843137254902, 0.7372549019607844, 0.5607843137254902)
      # Dark Slate Blue: #483D8B: (72, 61, 139)
      DARK_SLATE_BLUE = RGB.new(0.2823529411764706, 0.23921568627450981, 0.5450980392156862)
      # Dark Slate Gray: #2F4F4F: (47, 79, 79)
      DARK_SLATE_GRAY = RGB.new(0.1843137254901961, 0.30980392156862746, 0.30980392156862746)
      # Dark Turquoise: #00CED1: (0, 206, 209)
      DARK_TURQUOISE = RGB.new(0.0, 0.807843137254902, 0.8196078431372549)
      # Dark Violet: #9400D3: (148, 0, 211)
      DARK_VIOLET = RGB.new(0.5803921568627451, 0.0, 0.8274509803921568)
      # Deep Pink: #FF1493: (255, 20, 147)
      DEEP_PINK = RGB.new(1.0, 0.0784313725490196, 0.5764705882352941)
      # Deep Sky Blue: #00BFFF: (0, 191, 255)
      DEEP_SKY_BLUE = RGB.new(0.0, 0.7490196078431373, 1.0)
      # Dim Gray: #696969: (105, 105, 105)
      DIM_GRAY = RGB.new(0.4117647058823529, 0.4117647058823529, 0.4117647058823529)
      # Dodger Blue: #1E90FF: (30, 144, 255)
      DODGER_BLUE = RGB.new(0.11764705882352941, 0.5647058823529412, 1.0)
      # Firebrick: #B22222: (178, 34, 34)
      FIREBRICK = RGB.new(0.6980392156862745, 0.13333333333333333, 0.13333333333333333)
      # Floral White: #FFFAF0: (255, 250, 240)
      FLORAL_WHITE = RGB.new(1.0, 0.9803921568627451, 0.9411764705882353)
      # Forest Green: #228B22: (34, 139, 34)
      FOREST_GREEN = RGB.new(0.13333333333333333, 0.5450980392156862, 0.13333333333333333)
      # Fuchsia: #FF00FF: (255, 0, 255)
      FUCHSIA = RGB.new(1.0, 0.0, 1.0)
      # Gainsboro: #DCDCDC: (220, 220, 220)
      GAINSBORO = RGB.new(0.8627450980392157, 0.8627450980392157, 0.8627450980392157)
      # Ghost White: #F8F8FF: (248, 248, 255)
      GHOST_WHITE = RGB.new(0.9725490196078431, 0.9725490196078431, 1.0)
      # Gold: #FFD700: (255, 215, 0)
      GOLD = RGB.new(1.0, 0.8431372549019608, 0.0)
      # Goldenrod: #DAA520: (218, 165, 32)
      GOLDENROD = RGB.new(0.8549019607843137, 0.6470588235294118, 0.12549019607843137)
      # Gray: #BEBEBE: (190, 190, 190)
      GRAY = RGB.new(0.7450980392156863, 0.7450980392156863, 0.7450980392156863)
      # Web Gray: #808080: (128, 128, 128)
      WEB_GRAY = RGB.new(0.5019607843137255, 0.5019607843137255, 0.5019607843137255)
      # Green: #00FF00: (0, 255, 0)
      GREEN = RGB.new(0.0, 1.0, 0.0)
      # Web Green: #008000: (0, 128, 0)
      WEB_GREEN = RGB.new(0.0, 0.5019607843137255, 0.0)
      # Green Yellow: #ADFF2F: (173, 255, 47)
      GREEN_YELLOW = RGB.new(0.6784313725490196, 1.0, 0.1843137254901961)
      # Honeydew: #F0FFF0: (240, 255, 240)
      HONEYDEW = RGB.new(0.9411764705882353, 1.0, 0.9411764705882353)
      # Hot Pink: #FF69B4: (255, 105, 180)
      HOT_PINK = RGB.new(1.0, 0.4117647058823529, 0.7058823529411765)
      # Indian Red: #CD5C5C: (205, 92, 92)
      INDIAN_RED = RGB.new(0.803921568627451, 0.3607843137254902, 0.3607843137254902)
      # Indigo: #4B0082: (75, 0, 130)
      INDIGO = RGB.new(0.29411764705882354, 0.0, 0.5098039215686274)
      # Ivory: #FFFFF0: (255, 255, 240)
      IVORY = RGB.new(1.0, 1.0, 0.9411764705882353)
      # Khaki: #F0E68C: (240, 230, 140)
      KHAKI = RGB.new(0.9411764705882353, 0.9019607843137255, 0.5490196078431373)
      # Lavender: #E6E6FA: (230, 230, 250)
      LAVENDER = RGB.new(0.9019607843137255, 0.9019607843137255, 0.9803921568627451)
      # Lavender Blush: #FFF0F5: (255, 240, 245)
      LAVENDER_BLUSH = RGB.new(1.0, 0.9411764705882353, 0.9607843137254902)
      # Lawn Green: #7CFC00: (124, 252, 0)
      LAWN_GREEN = RGB.new(0.48627450980392156, 0.9882352941176471, 0.0)
      # Lemon Chiffon: #FFFACD: (255, 250, 205)
      LEMON_CHIFFON = RGB.new(1.0, 0.9803921568627451, 0.803921568627451)
      # Light Blue: #ADD8E6: (173, 216, 230)
      LIGHT_BLUE = RGB.new(0.6784313725490196, 0.8470588235294118, 0.9019607843137255)
      # Light Coral: #F08080: (240, 128, 128)
      LIGHT_CORAL = RGB.new(0.9411764705882353, 0.5019607843137255, 0.5019607843137255)
      # Light Cyan: #E0FFFF: (224, 255, 255)
      LIGHT_CYAN = RGB.new(0.8784313725490196, 1.0, 1.0)
      # Light Goldenrod: #FAFAD2: (250, 250, 210)
      LIGHT_GOLDENROD = RGB.new(0.9803921568627451, 0.9803921568627451, 0.8235294117647058)
      # Light Gray: #D3D3D3: (211, 211, 211)
      LIGHT_GRAY = RGB.new(0.8274509803921568, 0.8274509803921568, 0.8274509803921568)
      # Light Green: #90EE90: (144, 238, 144)
      LIGHT_GREEN = RGB.new(0.5647058823529412, 0.9333333333333333, 0.5647058823529412)
      # Light Pink: #FFB6C1: (255, 182, 193)
      LIGHT_PINK = RGB.new(1.0, 0.7137254901960784, 0.7568627450980392)
      # Light Salmon: #FFA07A: (255, 160, 122)
      LIGHT_SALMON = RGB.new(1.0, 0.6274509803921569, 0.47843137254901963)
      # Light Sea Green: #20B2AA: (32, 178, 170)
      LIGHT_SEA_GREEN = RGB.new(0.12549019607843137, 0.6980392156862745, 0.6666666666666666)
      # Light Sky Blue: #87CEFA: (135, 206, 250)
      LIGHT_SKY_BLUE = RGB.new(0.5294117647058824, 0.807843137254902, 0.9803921568627451)
      # Light Slate Gray: #778899: (119, 136, 153)
      LIGHT_SLATE_GRAY = RGB.new(0.4666666666666667, 0.5333333333333333, 0.6)
      # Light Steel Blue: #B0C4DE: (176, 196, 222)
      LIGHT_STEEL_BLUE = RGB.new(0.6901960784313725, 0.7686274509803922, 0.8705882352941177)
      # Light Yellow: #FFFFE0: (255, 255, 224)
      LIGHT_YELLOW = RGB.new(1.0, 1.0, 0.8784313725490196)
      # Lime: #00FF00: (0, 255, 0)
      LIME = RGB.new(0.0, 1.0, 0.0)
      # Lime Green: #32CD32: (50, 205, 50)
      LIME_GREEN = RGB.new(0.19607843137254902, 0.803921568627451, 0.19607843137254902)
      # Linen: #FAF0E6: (250, 240, 230)
      LINEN = RGB.new(0.9803921568627451, 0.9411764705882353, 0.9019607843137255)
      # Magenta: #FF00FF: (255, 0, 255)
      MAGENTA = RGB.new(1.0, 0.0, 1.0)
      # Maroon: #B03060: (176, 48, 96)
      MAROON = RGB.new(0.6901960784313725, 0.18823529411764706, 0.3764705882352941)
      # Web Maroon: #800000: (128, 0, 0)
      WEB_MAROON = RGB.new(0.5019607843137255, 0.0, 0.0)
      # Medium Aquamarine: #66CDAA: (102, 205, 170)
      MEDIUM_AQUAMARINE = RGB.new(0.4, 0.803921568627451, 0.6666666666666666)
      # Medium Blue: #0000CD: (0, 0, 205)
      MEDIUM_BLUE = RGB.new(0.0, 0.0, 0.803921568627451)
      # Medium Orchid: #BA55D3: (186, 85, 211)
      MEDIUM_ORCHID = RGB.new(0.7294117647058823, 0.3333333333333333, 0.8274509803921568)
      # Medium Purple: #9370DB: (147, 112, 219)
      MEDIUM_PURPLE = RGB.new(0.5764705882352941, 0.4392156862745098, 0.8588235294117647)
      # Medium Sea Green: #3CB371: (60, 179, 113)
      MEDIUM_SEA_GREEN = RGB.new(0.23529411764705882, 0.7019607843137254, 0.44313725490196076)
      # Medium Slate Blue: #7B68EE: (123, 104, 238)
      MEDIUM_SLATE_BLUE = RGB.new(0.4823529411764706, 0.40784313725490196, 0.9333333333333333)
      # Medium Spring Green: #00FA9A: (0, 250, 154)
      MEDIUM_SPRING_GREEN = RGB.new(0.0, 0.9803921568627451, 0.6039215686274509)
      # Medium Turquoise: #48D1CC: (72, 209, 204)
      MEDIUM_TURQUOISE = RGB.new(0.2823529411764706, 0.8196078431372549, 0.8)
      # Medium Violet Red: #C71585: (199, 21, 133)
      MEDIUM_VIOLET_RED = RGB.new(0.7803921568627451, 0.08235294117647059, 0.5215686274509804)
      # Midnight Blue: #191970: (25, 25, 112)
      MIDNIGHT_BLUE = RGB.new(0.09803921568627451, 0.09803921568627451, 0.4392156862745098)
      # Mint Cream: #F5FFFA: (245, 255, 250)
      MINT_CREAM = RGB.new(0.9607843137254902, 1.0, 0.9803921568627451)
      # Misty Rose: #FFE4E1: (255, 228, 225)
      MISTY_ROSE = RGB.new(1.0, 0.8941176470588236, 0.8823529411764706)
      # Moccasin: #FFE4B5: (255, 228, 181)
      MOCCASIN = RGB.new(1.0, 0.8941176470588236, 0.7098039215686275)
      # Navajo White: #FFDEAD: (255, 222, 173)
      NAVAJO_WHITE = RGB.new(1.0, 0.8705882352941177, 0.6784313725490196)
      # Navy Blue: #000080: (0, 0, 128)
      NAVY_BLUE = RGB.new(0.0, 0.0, 0.5019607843137255)
      # Old Lace: #FDF5E6: (253, 245, 230)
      OLD_LACE = RGB.new(0.9921568627450981, 0.9607843137254902, 0.9019607843137255)
      # Olive: #808000: (128, 128, 0)
      OLIVE = RGB.new(0.5019607843137255, 0.5019607843137255, 0.0)
      # Olive Drab: #6B8E23: (107, 142, 35)
      OLIVE_DRAB = RGB.new(0.4196078431372549, 0.5568627450980392, 0.13725490196078433)
      # Orange: #FFA500: (255, 165, 0)
      ORANGE = RGB.new(1.0, 0.6470588235294118, 0.0)
      # Orange Red: #FF4500: (255, 69, 0)
      ORANGE_RED = RGB.new(1.0, 0.27058823529411763, 0.0)
      # Orchid: #DA70D6: (218, 112, 214)
      ORCHID = RGB.new(0.8549019607843137, 0.4392156862745098, 0.8392156862745098)
      # Pale Goldenrod: #EEE8AA: (238, 232, 170)
      PALE_GOLDENROD = RGB.new(0.9333333333333333, 0.9098039215686274, 0.6666666666666666)
      # Pale Green: #98FB98: (152, 251, 152)
      PALE_GREEN = RGB.new(0.596078431372549, 0.984313725490196, 0.596078431372549)
      # Pale Turquoise: #AFEEEE: (175, 238, 238)
      PALE_TURQUOISE = RGB.new(0.6862745098039216, 0.9333333333333333, 0.9333333333333333)
      # Pale Violet Red: #DB7093: (219, 112, 147)
      PALE_VIOLET_RED = RGB.new(0.8588235294117647, 0.4392156862745098, 0.5764705882352941)
      # Papaya Whip: #FFEFD5: (255, 239, 213)
      PAPAYA_WHIP = RGB.new(1.0, 0.9372549019607843, 0.8352941176470589)
      # Peach Puff: #FFDAB9: (255, 218, 185)
      PEACH_PUFF = RGB.new(1.0, 0.8549019607843137, 0.7254901960784313)
      # Peru: #CD853F: (205, 133, 63)
      PERU = RGB.new(0.803921568627451, 0.5215686274509804, 0.24705882352941178)
      # Pink: #FFC0CB: (255, 192, 203)
      PINK = RGB.new(1.0, 0.7529411764705882, 0.796078431372549)
      # Plum: #DDA0DD: (221, 160, 221)
      PLUM = RGB.new(0.8666666666666667, 0.6274509803921569, 0.8666666666666667)
      # Powder Blue: #B0E0E6: (176, 224, 230)
      POWDER_BLUE = RGB.new(0.6901960784313725, 0.8784313725490196, 0.9019607843137255)
      # Purple: #A020F0: (160, 32, 240)
      PURPLE = RGB.new(0.6274509803921569, 0.12549019607843137, 0.9411764705882353)
      # Web Purple: #800080: (128, 0, 128)
      WEB_PURPLE = RGB.new(0.5019607843137255, 0.0, 0.5019607843137255)
      # Rebecca Purple: #663399: (102, 51, 153)
      REBECCA_PURPLE = RGB.new(0.4, 0.2, 0.6)
      # Red: #FF0000: (255, 0, 0)
      RED = RGB.new(1.0, 0.0, 0.0)
      # Rosy Brown: #BC8F8F: (188, 143, 143)
      ROSY_BROWN = RGB.new(0.7372549019607844, 0.5607843137254902, 0.5607843137254902)
      # Royal Blue: #4169E1: (65, 105, 225)
      ROYAL_BLUE = RGB.new(0.2549019607843137, 0.4117647058823529, 0.8823529411764706)
      # Saddle Brown: #8B4513: (139, 69, 19)
      SADDLE_BROWN = RGB.new(0.5450980392156862, 0.27058823529411763, 0.07450980392156863)
      # Salmon: #FA8072: (250, 128, 114)
      SALMON = RGB.new(0.9803921568627451, 0.5019607843137255, 0.4470588235294118)
      # Sandy Brown: #F4A460: (244, 164, 96)
      SANDY_BROWN = RGB.new(0.9568627450980393, 0.6431372549019608, 0.3764705882352941)
      # Sea Green: #2E8B57: (46, 139, 87)
      SEA_GREEN = RGB.new(0.1803921568627451, 0.5450980392156862, 0.3411764705882353)
      # Seashell: #FFF5EE: (255, 245, 238)
      SEASHELL = RGB.new(1.0, 0.9607843137254902, 0.9333333333333333)
      # Sienna: #A0522D: (160, 82, 45)
      SIENNA = RGB.new(0.6274509803921569, 0.3215686274509804, 0.17647058823529413)
      # Silver: #C0C0C0: (192, 192, 192)
      SILVER = RGB.new(0.7529411764705882, 0.7529411764705882, 0.7529411764705882)
      # Sky Blue: #87CEEB: (135, 206, 235)
      SKY_BLUE = RGB.new(0.5294117647058824, 0.807843137254902, 0.9215686274509803)
      # Slate Blue: #6A5ACD: (106, 90, 205)
      SLATE_BLUE = RGB.new(0.41568627450980394, 0.35294117647058826, 0.803921568627451)
      # Slate Gray: #708090: (112, 128, 144)
      SLATE_GRAY = RGB.new(0.4392156862745098, 0.5019607843137255, 0.5647058823529412)
      # Snow: #FFFAFA: (255, 250, 250)
      SNOW = RGB.new(1.0, 0.9803921568627451, 0.9803921568627451)
      # Spring Green: #00FF7F: (0, 255, 127)
      SPRING_GREEN = RGB.new(0.0, 1.0, 0.4980392156862745)
      # Steel Blue: #4682B4: (70, 130, 180)
      STEEL_BLUE = RGB.new(0.27450980392156865, 0.5098039215686274, 0.7058823529411765)
      # Tan: #D2B48C: (210, 180, 140)
      TAN = RGB.new(0.8235294117647058, 0.7058823529411765, 0.5490196078431373)
      # Teal: #008080: (0, 128, 128)
      TEAL = RGB.new(0.0, 0.5019607843137255, 0.5019607843137255)
      # Thistle: #D8BFD8: (216, 191, 216)
      THISTLE = RGB.new(0.8470588235294118, 0.7490196078431373, 0.8470588235294118)
      # Tomato: #FF6347: (255, 99, 71)
      TOMATO = RGB.new(1.0, 0.38823529411764707, 0.2784313725490196)
      # Turquoise: #40E0D0: (64, 224, 208)
      TURQUOISE = RGB.new(0.25098039215686274, 0.8784313725490196, 0.8156862745098039)
      # Violet: #EE82EE: (238, 130, 238)
      VIOLET = RGB.new(0.9333333333333333, 0.5098039215686274, 0.9333333333333333)
      # Wheat: #F5DEB3: (245, 222, 179)
      WHEAT = RGB.new(0.9607843137254902, 0.8705882352941177, 0.7019607843137254)
      # White: #FFFFFF: (255, 255, 255)
      WHITE = RGB.new(1.0, 1.0, 1.0)
      # White Smoke: #F5F5F5: (245, 245, 245)
      WHITE_SMOKE = RGB.new(0.9607843137254902, 0.9607843137254902, 0.9607843137254902)
      # Yellow: #FFFF00: (255, 255, 0)
      YELLOW = RGB.new(1.0, 1.0, 0.0)
      # Yellow Green: #9ACD32: (154, 205, 50)
      YELLOW_GREEN = RGB.new(0.6039215686274509, 0.803921568627451, 0.19607843137254902)
    end
    include X11
  end
end
