/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: syslog.c,v 1.5 2000/08/24 02:54:45 mbp Exp $
 * 
 * Copyright (C) 1999, 2000 by Martin Pool <mbp@linuxcare.com>
 * Copyright (C) 1999 by Andrew Tridgell <tridge@linuxcare.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Interface to syslog.  This is pretty simple because syslog has a
 * pretty friendly interface.
 */

/*
 * TODO: Eventually we might have to support a non-syslog way of
 * logging, for systems that don't have syslog (?) or for people that
 * don't want to use it.  It's not so important.
 */

#include "config.h"
#include "sysheaders.h"

#include "rproxy.h"
#include "trace.h"

/* name mapping stolen from glibc */

typedef struct _code {
    const char	*c_name;
    int	c_val;
} syslog_code_t;

const syslog_code_t facilitynames[] =
{
    { "auth", LOG_AUTH },
    { "authpriv", LOG_AUTHPRIV },
    { "cron", LOG_CRON },
    { "daemon", LOG_DAEMON },
    { "ftp", LOG_FTP },
    { "kern", LOG_KERN },
    { "lpr", LOG_LPR },
    { "mail", LOG_MAIL },
    { "news", LOG_NEWS },
    { "security", LOG_AUTH },		/* DEPRECATED */
    { "syslog", LOG_SYSLOG },
    { "user", LOG_USER },
    { "uucp", LOG_UUCP },
    { "local0", LOG_LOCAL0 },
    { "local1", LOG_LOCAL1 },
    { "local2", LOG_LOCAL2 },
    { "local3", LOG_LOCAL3 },
    { "local4", LOG_LOCAL4 },
    { "local5", LOG_LOCAL5 },
    { "local6", LOG_LOCAL6 },
    { "local7", LOG_LOCAL7 },
    { NULL, -1 }
};

void
rp_setup_syslog(void)
{
    int fac = LOG_LOCAL6;
    syslog_code_t const *p;
    char const *want = config.syslog_facility;

    if (want) {
        for (p = facilitynames; ; p++) {
            if (p->c_name == NULL) {
                syslog(LOG_WARNING,
                       "warning: syslog facility \"%s\" unknown",
                       want);
                break;
            }
            if (!strcmp(p->c_name, want)) {
                fac = p->c_val;
                break;
            }
        }
    }
    
    openlog(PACKAGE, LOG_PID, fac);
}
