% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_likert.R
\name{plot_likert}
\alias{plot_likert}
\title{Plot likert scales as centered stacked bars}
\usage{
plot_likert(items, title = NULL, legend.title = NULL,
  legend.labels = NULL, axis.titles = NULL, axis.labels = NULL,
  catcount = NULL, cat.neutral = NULL, sort.frq = NULL,
  weight.by = NULL, title.wtd.suffix = NULL, wrap.title = 50,
  wrap.labels = 30, wrap.legend.title = 30, wrap.legend.labels = 28,
  geom.size = 0.6, geom.colors = "BrBG",
  cat.neutral.color = "grey70", intercept.line.color = "grey50",
  reverse.colors = FALSE, values = "show", show.n = TRUE,
  show.legend = TRUE, show.prc.sign = FALSE, grid.range = 1,
  grid.breaks = 0.2, expand.grid = TRUE, digits = 1,
  coord.flip = TRUE)
}
\arguments{
\item{items}{Data frame, with each column representing one item.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.
For effect-plots, may also be a character vector of length > 1,
to define titles for each sub-plot or facet.}

\item{legend.title}{character vector, used as title for the plot legend.}

\item{legend.labels}{character vector with labels for the guide/legend.}

\item{axis.titles}{character vector of length one or two, defining the title(s)
for the x-axis and y-axis.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{catcount}{Optional, amount of categories of \code{items} (e.g. \emph{"strongly disagree",
"disagree", "agree"} and \emph{"strongly agree"} would be \code{catcount = 4}).
Note that this argument only applies to "valid" answers, i.e. if you
have an additional neutral category (see \code{cat.neutral}) like \emph{"don't know"},
this won't count for \code{catcount} (e.g. "strongly disagree",
"disagree", "agree", "strongly agree" and neutral category "don't know"
would still mean that \code{catcount = 4}). See 'Note'.}

\item{cat.neutral}{If there's a neutral category (like "don't know" etc.), specify
the index number (value) for this category. Else, set \code{cat.neutral = NULL} (default).
The proportions of neutral category answers are plotted as grey bars on the left side of
the figure.}

\item{sort.frq}{Indicates whether the items of \code{items} should be ordered by
total sum of positive or negative answers.
\describe{
  \item{\code{"pos.asc"}}{to order ascending by sum of positive answers}
  \item{\code{"pos.desc"}}{to order descending by sum of positive answers}
  \item{\code{"neg.asc"}}{for sorting ascending negative answers}
  \item{\code{"neg.desc"}}{for sorting descending negative answers}
  \item{\code{NULL}}{(default) for no sorting}
}}

\item{weight.by}{Vector of weights that will be applied to weight all cases.
Must be a vector of same length as the input vector. Default is
\code{NULL}, so no weights are used.}

\item{title.wtd.suffix}{Suffix (as string) for the title, if \code{weight.by} is specified,
e.g. \code{title.wtd.suffix=" (weighted)"}. Default is \code{NULL}, so
title will not have a suffix when cases are weighted.}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis
labels are displayed in one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{wrap.legend.labels}{numeric, determines how many chars of the legend labels are
displayed in one line and when a line break is inserted.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size,
depending on plot type and function). Note that bar and bin widths mostly
need smaller values than dot sizes.}

\item{geom.colors}{user defined color for geoms. See 'Details' in \code{\link{sjp.grpfrq}}.}

\item{cat.neutral.color}{Color of the neutral category, if plotted (see \code{cat.neutral}).}

\item{intercept.line.color}{Color of the vertical intercept line that divides positive and negative values.}

\item{reverse.colors}{Logical, if \code{TRUE}, the color scale from \code{geom.colors} will be reversed,
so positive and negative values switch colors.}

\item{values}{Determines style and position of percentage value labels on the bars:
\describe{
  \item{\code{"show"}}{(default) shows percentage value labels in the middle of each category bar}
  \item{\code{"hide"}}{hides the value labels, so no percentage values on the bars are printed}
  \item{\code{"sum.inside"}}{shows the sums of percentage values for both negative and positive values and prints them inside the end of each bar}
  \item{\code{"sum.outside"}}{shows the sums of percentage values for both negative and positive values and prints them outside the end of each bar}
}}

\item{show.n}{logical, if \code{TRUE}, adds total number of cases for each
group or category to the labels.}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{show.prc.sign}{Logical, if \code{TRUE}, \%-signs for value labels are shown.}

\item{grid.range}{Numeric, limits of the x-axis-range, as proportion of 100.
Default is 1, so the x-scale ranges from zero to 100\% on
both sides from the center. You can use values beyond 1
(100\%) in case bar labels are not printed because they exceed the axis range.
E.g. \code{grid.range = 1.4} will set the axis from -140 to +140\%, however, only
(valid) axis labels from -100 to +100\% are printed. Neutral categories are
adjusted to the most left limit.}

\item{grid.breaks}{numeric; sets the distance between breaks for the axis,
i.e. at every \code{grid.breaks}'th position a major grid is being printed.}

\item{expand.grid}{logical, if \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{digits}{Numeric, amount of digits after decimal point when rounding
estimates or values.}

\item{coord.flip}{logical, if \code{TRUE}, the x and y axis are swapped.}
}
\value{
A ggplot-object.
}
\description{
Plot likert scales as centered stacked bars.
}
\note{
Note that only even numbers of categories are possible to plot, so the "positive"
       and "negative" values can be splitted into two halfs. A neutral category (like "don't know")
       can be used, but must be indicated by \code{cat.neutral}. \cr \cr
       The \code{catcount}-argument indicates how many item categories are in the
       Likert scale. Normally, this argument can be ignored because the amount of
       valid categories is retrieved automatically. However, sometimes (for instance,
       if a certain category is missing in all items), auto-detection of the amount
       of categories fails. In such cases, specify the amount of categories
       with the \code{catcount}-argument.
}
\examples{
library(sjmisc)
data(efc)
# find all variables from COPE-Index, which all have a "cop" in their
# variable name, and then plot that subset as likert-plot
find_var(efc, pattern = "cop", out = "df") \%>\% plot_likert()

plot_likert(
  find_var(efc, pattern = "cop", out = "df"),
  grid.range = 1.2,
  expand.grid = FALSE,
  values = "sum.outside",
  show.prc.sign = TRUE
)

}
