

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Swap.i,v 1.6 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_swap_i
#define quantlib_swap_i

%include Date.i
%include Instruments.i
%include TermStructures.i
%include CashFlows.i
%include Indexes.i
%include Vectors.i

%{
using QuantLib::Instruments::Swap;
typedef Handle<Swap> SwapHandle;
%}

%name(Swap) class SwapHandle
: public InstrumentHandle {
  public:
    // constructor redefined below
    ~SwapHandle();
};

%addmethods SwapHandle {
    void crash() {}
    SwapHandle(CashFlowHandleVector firstLeg,
               CashFlowHandleVector secondLeg,
               TermStructureRelinkableHandle termStructure) {
        return new SwapHandle(
            new Swap(firstLeg, secondLeg, termStructure,
                     "","interest rate swap"));
    }
    double firstLegBPS() {
        return (*self)->firstLegBPS();
    }
    double secondLegBPS() {
        return (*self)->secondLegBPS();
    }
}


#endif
