#ifndef RELAXATION_H
#define RELAXATION_H

#include <assert.h>
#include <iostream>

template<class I, class T>
void gauss_seidel(const I n_row,
			      const I Ap[], 
                  const I Aj[], 
                  const T Ax[],
                        T  x[],
                  const T  b[],
                  const I row_start,
                  const I row_stop,
                  const I row_step)
{
    for(I i = row_start; i != row_stop; i += row_step) {
        I start = Ap[i];
        I end   = Ap[i+1];
        T rsum = 0;
        T diag = 0;
        
        for(I jj = start; jj < end; jj++){
            I j = Aj[jj];
            if (i == j)
                diag  = Ax[jj];
            else
                rsum += Ax[jj]*x[j];
        }
        
        assert(diag != 0);
        
        x[i] = (b[i] - rsum)/diag;
    }
}

template<class I, class T>
void jacobi(const I n_row,
			const I Ap[], 
            const I Aj[], 
            const T Ax[],
                  T  x[],
            const T  b[],
                  T temp[],
            const I row_start,
            const I row_stop,
            const I row_step,
            const T omega)
{
    std::copy(x,x+n_row,temp);
    
    for(I i = row_start; i != row_stop; i += row_step) {
        I start = Ap[i];
        I end   = Ap[i+1];
        T rsum = 0;
        T diag = 0;
        
        for(I jj = start; jj < end; jj++){
            I j = Aj[jj];
            if (i == j)
                diag  = Ax[jj];
            else
                rsum += Ax[jj]*temp[j];
        }
        
        assert(diag != 0);
        
        x[i] = (1 - omega) * temp[i] + omega * ((b[i] - rsum)/diag);
    }
}


#endif

