#!/usr/bin/env python

"""**************************************************************************
** $Id: listbox.py,v 1.1 2003/05/30 17:47:57 phil Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from qt import *

FALSE = 0
TRUE  = 1

class ListBoxDemo( QWidget ):
    def __init__( self, parent=None, name=None ):
        QWidget.__init__( self, parent, name )
        b = FALSE
        g = QGridLayout( self, 2, 2, 6 )

        g.addWidget( QLabel( "<b>Configuration:</b>", self ), 0, 0 )
        g.addWidget( QLabel( "<b>Result:</b>", self ), 0, 1 )

        self.l = QListBox( self )
        g.addWidget( self.l, 1, 1 )
        self.l.setFocusPolicy( QWidget.StrongFocus )

        v = QVBoxLayout( )
        g.addLayout( v, 1, 0 )
                
        bg = QButtonGroup( self, None )

        b = QRadioButton( "Fixed number of columns,\n"
                          "as many rows as needed.",
                          self )
        bg.insert( b )
        v.addWidget( b )
        b.setChecked( TRUE )
        self.connect( b, SIGNAL("clicked()"), self.setNumCols )
        h = QHBoxLayout()
        v.addLayout( h )
        h.addSpacing( 30 )
        h.addSpacing( 100 )
        h.addWidget( QLabel( "Columns:", self ) )
        self.columns = QSpinBox( self )
        h.addWidget( self.columns )

        v.addSpacing( 12 )

        b = QRadioButton( "As many columns as fit on-screen,\n"
                          "as many rows as needed.",
                          self )
        bg.insert( b )
        v.addWidget( b )
        self.connect( b, SIGNAL("clicked()"), self.setColsByWidth )

        v.addSpacing( 12 )

        b = QRadioButton( "Fixed number of rows,\n"
                          "as many columns as needed.",
                          self )
        bg.insert( b )
        v.addWidget( b )
        self.connect( b, SIGNAL("clicked()"), self.setNumRows )
        h = QHBoxLayout()
        v.addLayout( h )
        h.addSpacing( 30 )
        h.addSpacing( 100 )
        h.addWidget( QLabel( "Rows:", self ) )
        self.rows = QSpinBox( self )
        self.rows.setEnabled( FALSE )
        h.addWidget( self.rows )

        v.addSpacing( 12 )

        b = QRadioButton( "As many rows as fit on-screen,\n"
                          "as many columns as needed.",
                          self )
        bg.insert( b )
        v.addWidget( b )
        self.connect( b, SIGNAL("clicked()"), self.setRowsByHeight )

        v.addSpacing( 12 )

        cb = QCheckBox( "Variable-height rows", self )
        cb.setChecked( TRUE )
        self.connect( cb, SIGNAL("toggled(bool)"), self.setVariableHeight )
        v.addWidget( cb )
        v.addSpacing( 6 )
        
        cb = QCheckBox( "Variable-width columns", self )
        self.connect( cb, SIGNAL("toggled(bool)"), self.setVariableWidth )
        v.addWidget( cb )

        cb = QCheckBox( "Extended-Selection", self )
        self.connect( cb, SIGNAL("toggled(bool)"), self.setMultiSelection )
        v.addWidget( cb )

        pb = QPushButton( "Sort ascending", self )
        self.connect( pb, SIGNAL("clicked()"), self.sortAscending )
        v.addWidget( pb )

        pb = QPushButton( "Sort descending", self )
        self.connect( pb, SIGNAL("clicked()"), self.sortDescending )
        v.addWidget( pb )

        v.addStretch( 100 )

        i = 0
        while i <= 2560:
            i+=1
            self.l.insertItem( str(QString.fromLatin1( "Item " )) + str(QString.number( i )), i )
        self.columns.setRange( 1, 256 )
        self.columns.setValue( 1 )
        self.rows.setRange( 1, 256 )
        self.rows.setValue( 256 )

        self.connect( self.columns, SIGNAL("valueChanged(int)"), self.setNumCols )
        self.connect( self.rows, SIGNAL("valueChanged(int)"), self.setNumRows )

    # slots
    def setNumCols( self ):
        self.columns.setEnabled( TRUE )
        self.rows.setEnabled( FALSE )
        self.l.setColumnMode( self.columns.value() )

    def setNumRows( self ):
        self.columns.setEnabled( FALSE )
        self.rows.setEnabled( TRUE )
        self.l.setRowMode( self.rows.value() )

    def setRowsByHeight( self ):
        self.columns.setEnabled( FALSE )
        self.rows.setEnabled( FALSE )
        self.l.setRowMode( QListBox.FitToHeight )

    def setColsByWidth( self ):
        self.columns.setEnabled( FALSE )
        self.rows.setEnabled( FALSE )
        self.l.setColumnMode( QListBox.FitToWidth )

    def setVariableWidth( self, b ):
        self.l.setVariableWidth( b )

    def setVariableHeight( self, b ):
        self.l.setVariableHeight( b )

    def setMultiSelection( self, b ):
        self.l.clearSelection()
        if b :
            self.l.setSelectionMode( QListBox.Extended )
        else:
            self.l.setSelectionMode( QListBox.Single )
            
    def sortAscending( self ):
        self.l.sort( TRUE )

    def sortDescending( self ):
        self.l.sort( FALSE )

    
def main( args ):
    a = QApplication( args )
    t = ListBoxDemo()
    t.setCaption( "Qt Example - Listbox" )
    a.setMainWidget( t )
    t.show()
    
    a.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
