#!/usr/bin/env python
try:
	from Numeric import *
except:
	print "This demo requires the Numeric extension, sorry"
	import sys
	sys.exit()
from RandomArray import *
import string, sys
from OpenGL.GL import *
from OpenGL.GLUT import *

MY_LIST=1
NUMDOTS = 500
NUMDOTS2 = 600
x = random(NUMDOTS)*2-1
y = random(NUMDOTS)*2-1
MAX_AGE = 13
age = randint(0,MAX_AGE,(NUMDOTS,))
move_length = .005  # 1.0 = screen width
angle = 0          # in radians
delta_angle = .2  # in radians
move_x = move_length*cos(angle)
move_y = move_length*sin(angle)
halted = 0

def display(*args):
    global x, y, move_x, move_y, NUMDOTS, NUMDOTS2, MAX_AGE, age
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glClear(GL_COLOR_BUFFER_BIT)
    glColor3f(1.0,1.0,0.0)
    glBegin(GL_POINTS)
    x = x + move_x
    y = y + move_y
    age = age + 1
    which = greater(age, MAX_AGE)
    x = choose(which, (x, random(NUMDOTS)))
    y = choose(which, (y, random(NUMDOTS)))
    age = choose(which, (age, 0))
    x = choose(greater(x,1.0),(x,x-1.0))  # very cool - wraparound
    y = choose(greater(y,1.0),(y,y-1.0))
    glVertex(transpose(array([x,y])))
    glVertex(transpose(array([x-.005,y+.005])))
    glVertex(transpose(array([x+.005,y-.005])))
    x2 = random(NUMDOTS2)
    y2 = random(NUMDOTS2)
    glVertex(transpose(array([x2,y2])))
    glEnd()
    glFlush()
    glutSwapBuffers()


def halt():
    pass

def keyboard(*args):
    sys.exit()

def mouse(button, state, x, y):
    global angle, delta_angle, move_x, move_y, move_length, halted
    if button == GLUT_LEFT_BUTTON:
	angle = angle + delta_angle
    elif button == GLUT_RIGHT_BUTTON:
	angle = angle - delta_angle
    elif button == GLUT_MIDDLE_BUTTON and state == GLUT_DOWN:
	if halted:
	    glutSetIdleFuncCallback(display)
	    halted = 0
	else:
	    glutSetIdleFuncCallback(halt)
	    halted = 1
    move_x = move_length * cos(angle)
    move_y = move_length * sin(angle)

def setup_viewport():
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glOrtho(0.0, 1.0, 0.0, 1.0, 0.0, 1.0)

def reshape(w, h):
    glViewport(0, 0, w, h)
    setup_viewport()

def main():
    glutInit('foo')
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB)
#    glutInitDisplayMode(GLUT_RGB)
    glutInitWindowSize(300, 300)
    glutCreateWindow('Dots')
    setup_viewport()
    glutSetReshapeFuncCallback(reshape)
    glutReshapeFunc()
    glutSetDisplayFuncCallback(display)
    glutDisplayFunc()
    glutSetIdleFuncCallback(display)
    glutIdleFunc()
    glutSetMouseFuncCallback(mouse)
    glutMouseFunc()
    glutSetKeyboardFuncCallback(keyboard)
    glutKeyboardFunc()
    glutMainLoop()

print "Use the mouse buttons to control some of the dots."
print "Hit any key to quit."
main()



