from qt import QFrame, QHBoxLayout, QVBoxLayout, SIGNAL
from kdecore import i18n
from kdeui import KPushButton, KPasswordDialog, KTextEdit

iconName = 'password'
labelText = 'KPasswordDialog'
docParts = ('kdeui', 'KPasswordDialog')
helpText = ("KDE provides two variations on the password dialog.  The simple "
            "one shown here prompts for a password.  The other type allows the "
            "user to enter a new password, and provides a second field to "
            "confirm the first entry.")


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Password Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showPasswordDialog)


    def showPasswordDialog(self):
        old = 'foo bar baz'
        prompt = "Enter your super-secret password (enter anything, it's just an example):"
        result = KPasswordDialog.getPassword(old, prompt)
        if result == KPasswordDialog.Accepted:
            pass

