/* glpkpi.c (C functions for setting/canceling printing in the stdout) */

/*----------------------------------------------------------------------
-- This code is part of the Python-GLPK interface.
--
-- Copyright (C) 2005, Joao Pedro Pedroso
-- Faculdade de Ciencias, Universidade do Porto
-- Porto, Portugal. All rights reserved. E-mail: <jpp@fc.up.pt>.
--
-- GLPK is free software; you can redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2, or (at your option)
-- any later version.
--
-- GLPK is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
-- License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with GLPK; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
-- 02110-1301, USA.
----------------------------------------------------------------------*/

#include <stdlib.h>
#include <glpk.h>

/* 
   copied from glplib.h:
*/
void _glp_lib_print_hook(int (*func)(void *info, char *buf), void *info);
/* install print hook routine */


/*
  written by jpp
*/
int no_print_hook(void *info,  char *msg) {
  return 1;
}

void lpx_no_print() {
  _glp_lib_print_hook(no_print_hook, NULL);
}

void lpx_do_print() {
  _glp_lib_print_hook(NULL, NULL);
}

