/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "ClippedSphereVolPy.h"

using namespace boost::python;

    void exportClippedSphereVol()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      class_<ClippedSphereVol, bases<AVolume3D> >(
        "ClippedSphereVol",
        "A class defining a spherical volume in 3D clipped by planes.",
        init<>()
      )
      .def(init<const ClippedSphereVol &>())
      .def(
        init<Vector3,double>(
          ( arg("centre"), arg("radius") ),
          "Constructs a sphere with the specified centre and radius.\n"
          "@type centre: L{Vector3}\n"
          "@kwarg centre: Coordinates of the centre of the sphere\n"
          "@type radius: double\n"
          "@kwarg radius: Radius of the sphere\n"
        )
      )
      .def(
        "addPlane",
        &ClippedSphereVol::addPlane,
        ( arg("plane"), arg("fit") ),
        "Adds a plane to the volume for clipping the sphere.\n"
        "@type plane: L{Plane}\n"
        "@kwarg plane: the plane to add to the volume\n"
        "@rtype: void\n"
      )
      .def(self_ns::str(self))
      ;
    }



