# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DataLakeStoreAccount(Model):
    """Data Lake Store account information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location: the account regional location.
    :type location: str
    :param name: the account name.
    :type name: str
    :ivar type: the namespace and type of the account.
    :vartype type: str
    :ivar id: the account subscription ID.
    :vartype id: str
    :param identity: The Key vault encryption identity, if any.
    :type identity: :class:`EncryptionIdentity
     <azure.mgmt.datalake.store.account.models.EncryptionIdentity>`
    :param tags: the value of custom properties.
    :type tags: dict
    :param properties: the Data Lake Store account properties.
    :type properties: :class:`DataLakeStoreAccountProperties
     <azure.mgmt.datalake.store.account.models.DataLakeStoreAccountProperties>`
    """ 

    _validation = {
        'type': {'readonly': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'EncryptionIdentity'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'DataLakeStoreAccountProperties'},
    }

    def __init__(self, location=None, name=None, identity=None, tags=None, properties=None):
        self.location = location
        self.name = name
        self.type = None
        self.id = None
        self.identity = identity
        self.tags = tags
        self.properties = properties
