# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ProfileCreateParameters(Model):
    """Profile properties required for profile creation.

    :param location: Profile location
    :type location: str
    :param tags: Profile tags
    :type tags: dict
    :param sku: The SKU (pricing tier) of the CDN profile.
    :type sku: :class:`Sku <azure.mgmt.cdn.models.Sku>`
    """ 

    _validation = {
        'location': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(self, location, sku, tags=None):
        self.location = location
        self.tags = tags
        self.sku = sku
