########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Commands/Stop.py,v 1.7 2006/02/14 03:04:24 mbrown Exp $
"""
4Suite repository stop command (4ss_manager stop)

Copyright 2006 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """\
The stop command is used to stop any or all of the 4SS servers.  To stop
all the servers, execute the stop command with out any arguments.  To stop
an individual server, specify their names as command line arguments.  You
will be prompted for authentication before you can stop the servers.
"""

from Ft.Server.Server import Launcher
from Ft.Server.Server.Commands.CommandUtil import GetRepository
from Ft.Server.Common import ResourceTypes
def Run(options, args):

    username, password, properties, repo = GetRepository(options,
                                                         '4ss_manager.stop')
    if args.has_key('server-uri'):
        print "Setting the status of server " + args['server-uri'] + ' to stopped'
        server = repo.fetchResource(args['server-uri'])
        if server.resourceType != ResourceTypes.ResourceType.SERVER:
            print args['server-uri'] + " is not a server"
            repo.txRollback()
            return
        server.setStopped()
        repo.txCommit()
        return
    repo.txRollback()

    try:
        launcher = Launcher.Launcher(username, password, properties)
        launcher.stop()
    except Exception, error:
        print str(error)
    return


def Register():
    from Ft.Lib.CommandLine import Command, Arguments

    cmd = Command.Command('stop',
                          "Stop the 4Suite server (controller)",
                          '',
                          __doc__,
                          function=Run,
                          fileName=__file__,
                          arguments = [Arguments.OptionalArgument('server-uri',
								  "If specified, set the running state of this server to 'off'.  This does not stop the 4ss daemon",
								  str
								  ),
				       ]
			  )
    return cmd

