import os

import os,sys, test_util
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import Database, FixedString

odl_string = '''
module Test {
  const string <5> TOP_LEVEL = "Hello World";
  typedef string <10> tnames;
  class Student
  {
    attribute string <10> name;
    attribute list<tnames > nameList;
    attribute tnames tdname;
    attribute dictionary<tnames,tnames > nameDict;
  };

};

'''

DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')
        pass

def _Test(tester):

    tester.startGroup("Fixed Length Strings %s Driver" % tester.test_data['driver'])

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        import Test
        from Test import Student
        reload(Test)
        reload(Student)
    except:
        tester.error('Error in syntax', 1)


    tester.testDone()

    
    db = Database.Database()
    db.open(DBNAME)
    try:
        tx = db.new()
        tx.begin()
        tester.startTest("Test Constant Values")
        tester.compare("Hello",Test.TOP_LEVEL)
        tx.abort()
        tester.testDone()

        tx = db.new()
        tx.begin()
        tester.startTest("Test Attribute Values")
        s = Student.new(db)

        db.bind(s,'Student')

        s.name = "Mike Olson"
        s.tdname.value = "Uche Ogbuj"

        s.nameList.insert_element(Test.tnames(db,"A new Name"))
        s.nameDict[Test.tnames(db,"Key")] = Test.tnames(db,"Value")

        tester.compare("Mike Olson",s.name)
        tester.compare("Uche Ogbuj",s.tdname)
        tester.compare(1,len(s.nameList))
        tester.compareIn(s.nameList,"A new Name")
        tester.compare(1,len(s.nameDict.keys()))
        tester.compareIn(s.nameDict.keys(),"Key")
        tester.compare(1,len(s.nameDict.values()))
        tester.compareIn(s.nameDict.values(),"Value")
        tx.commit()

        tester.testDone()

        tx = db.new()
        tx.begin()
        tester.startTest("Test Persistence")

        s = db.lookup('Student')
        
        tester.compare("Mike Olson",s.name)
        tester.compare("Uche Ogbuj",s.tdname)
        tester.compare(1,len(s.nameList))
        tester.compareIn(s.nameList,"A new Name")
        tester.compare(1,len(s.nameDict.keys()))
        tester.compareIn(s.nameDict.keys(),"Key")
        tester.compare(1,len(s.nameDict.values()))
        tester.compareIn(s.nameDict.values(),"Value")
        tx.commit()

        tester.testDone()

        tx = db.new()
        tx.begin()
        tester.startTest("Test Exceptions")

        s = db.lookup('Student')

        tester.testException(setattr,(s,'name',"A string that is too long"),ValueError)
        tester.testException(Test.tnames,(db,"A new Name that is too long"),ValueError)

        tx.abort()

        tester.testDone()



    finally:
        db.close()
    tester.groupDone()
    return





if 0:

	fs = FixedString(None,("Hello %s",8))
	fs
	repr(fs)
	str(fs)
	len(fs)
	fs * 2
	2 * fs
	fs + "World"
	"World" + fs
	"formatted %s" % fs
	fs % "World"
	str(fs)
	repr(fs)
	hash(fs)
	if fs: print 'yah'

	min(fs)
	max(fs)
	fs[0]
	fs[0:3]
	list(fs)
	'e' in fs
	'X' in fs
	for c in fs: print c,

	chopped = FixedString(None,("Hello World",5))
	str(chopped)


