########################################################################
#
# File Name: 	        Member.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Member.py.html
#
"""
Implements the Member meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods.MetaData import Specifier
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Member(Specifier.Specifier):
    def __init__(self,db,data):
        Specifier.Specifier.__init__(self,db,data,MetaKind.mk_member)

    def form_structure_type(self,target,inverse = 1):
        from Ft.Ods.MetaData import Structure
        self._4ods_formRelationship('structure_type',Structure.Structure,'fields','add',target,inverse)
    def drop_structure_type(self,target,inverse = 1):
        self._4ods_dropRelationship('structure_type','fields','remove',target,inverse)

    def _4ods_getOdl(self,indent):
        return indent + "%s %s" % (self.type._4ods_getOdl(''),self.name)

    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)
        self.type._4ods_getGeneratedMetaClasses(found,checked)



    _tupleNames =  (('structure_type',),)


    _tupleDefinitions = {'structure_type':{td.TYPE:Constants.Types.ROBJECT,
                                           td.READONLY:1,
                                           td.RELATIONSHIP:1,
                                           },
                         }
                    
    _localExtents = ()
