from Xslt import test_harness

from Ft.Lib import ReaderBase
from Ft.Lib import pDomlette
from Ft.Lib import cDomlette
from xml.xslt import StylesheetReader
from xml.dom.ext.reader import Sax2
from xml.xslt import XsltException, Error

sheet_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

  <xsl:variable name='spam' select='"original"'/>
  <xsl:import href='Xslt/Core/addr_book3.xsl'/>

</xsl:stylesheet>
"""

sheet = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">
  <xsl:import href='Xslt/Core/addr_book3.xsl'/>

  <xsl:variable name='spam' select='"original"'/>

  <xsl:template match="ENTRY">
    <xsl:text>ENTRY from original: </xsl:text>
        <TR>
          <xsl:value-of select='@ID'/>
          <xsl:apply-templates select='NAME | PHONENUM'/>
        </TR>
  </xsl:template>

  <xsl:template match='PHONENUM'>
    <xsl:text>PHONENUM from original: </xsl:text>
      <xsl:element name='TD'>
        <xsl:attribute name='ALIGN'>CENTER</xsl:attribute>
        <xsl:text>Type: </xsl:text><xsl:value-of select='@DESC'/>
        <xsl:apply-templates/>
      </xsl:element>
  </xsl:template>
</xsl:stylesheet>
"""

expected = """<HTML>
  <HEAD>
    <META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=iso-8859-1'>
    <TITLE>Address Book</TITLE>
  </HEAD>
  <BODY>
    <H1>Tabulate just the Names</H1>
    <TABLE>ADDRBOOK from imported: original</TABLE>
  </BODY>
</HTML>"""

class GenericReader(ReaderBase.DomletteReader):
    def __init__(self,reader,allArgs):
        ReaderBase.DomletteReader.__init__(self)
        self._used = 0
        self._reader = reader
        self._allArgs = allArgs

    def releaseNode(self,node):
        r = pDomlette.PyExpatReader()
        r.releaseNode(node)

    def fromStream(self, stream, baseUri='', ownerDoc=None,
                   stripElements=None):
        self._used = self._used + 1
        if self._allArgs:
            src = self._reader.fromStream(stream, baseUri,
                                          ownerDoc=ownerDoc,
                                          stripElements=stripElements)
        else:
            src = self._reader.fromStream(stream,ownerDoc=ownerDoc)
        sty = StylesheetReader.FromDocument(src, baseUri = baseUri)
        return sty


readers = [('pDomlette.PyExpatReader',GenericReader(pDomlette.PyExpatReader(),1)),
           ('cDomlette.RawExpatReader',GenericReader(cDomlette.RawExpatReader(),1)),
           ('Sax2Reader',GenericReader(Sax2.Reader(),0)),
           ]


def Test(tester):

    #Unused anyway
    expected_1 = expected
    tester.startGroup("Illegal import at root")
    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml")
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    expectedException = XsltException,
                                    exceptionValues = {'errorCode':Error.ILLEGAL_IMPORT},
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Default reader")
    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml")
    sty = test_harness.FileInfo(string=sheet)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected,
                                    )
    xtest.test(tester)
    tester.groupDone()

    for name, reader in readers:
        tester.startGroup(name)
        source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml")
        sty = test_harness.FileInfo(string=sheet)
        xtest = test_harness.XsltTester(source,
                                        [sty],
                                        expected,
                                        stylesheetReader = reader
                                        )
        
        res = xtest.test(tester)
        tester.groupDone()
    return
