import os

#
#Note: While testing it might be useful to use
#
#export TRACEOUT=4ODS:4Suite.PgDatabase
#export TRACEOUT_FLAGS=LABEL
#
#Requires the database to be set up with the schema from varsity4.odl
#
#Typical test process:
#
#python ../Tools/4odb_destroy.py test
#python ../Tools/4odb_create.py test
#python basic_test1.py
#
odl_string = '''
module Test {
enum WeekDays {Mon,Tue,Wed,Thu,Fri,Sat,Sun};

class Professor {
  attribute WeekDays day_off;
};
};
'''

DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

import sys, test_util
from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')
        pass

def _Test(tester):

    
    tester.startGroup("Enumeration %s Driver" % tester.ods_driver_name)

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        from Test import Professor
        import Test
        reload(Professor)
        reload(Test)
    except:
        tester.error('Error in syntax', 1)


    tester.testDone()


    db = Database.Database()
    db.open(DBNAME)

    tx = db.new()
    tx.begin()

    tester.startTest("Create classes")

    p = Professor.new(db)

    p.day_off = Test.WeekDays.Wed

    tester.testResults(p.day_off, Test.WeekDays.Wed,done=0,msg="Invalid Enum value")


    tx.commit()
    id = p._4ods_getId()
    tester.testDone()

    tester.startTest("Loading Enum")
    tx = db.new()
    tx.begin()
    p = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,id)
    tester.testResults(p.day_off, Test.WeekDays.Wed,done=0,msg="Invalid Enum value")
    tester.testDone()
    tester.groupDone()
    tx.abort()
    db.close()


if __name__ == '__main__':

    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1, 1)
    from Ft.Ods.StorageManager import Adapters
    tester.ods_driver_name = Adapters.g_driverName

    retVal = Test(tester)
    sys.exit(retVal)

