import os

#
#Note: While testing it might be useful to use
#
#export TRACEOUT=4ODS:4Suite.PgDatabase
#export TRACEOUT_FLAGS=LABEL
#
#Requires the database to be set up with the schema from varsity1.odl or varsity2.odl
#
#Typical test process:
#
#python ../Tools/4odb_destroy.py test
#python ../Tools/4odb_create.py test
#python basic_test1.py
#


from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.Exception import FtodsOperationNotImplemented,FtodsOperationBadParam
from Ft.Ods import Database
import os,sys
import test_util

odl_string = """
module Test {

typedef list <float> GradeList;

exception InvalidGrade {
  float grade;
  string reason;
};

class Student (extent students)
{
	attribute string name;
        float calcGPA(in GradeList grades) raises (InvalidGrade);
};

};

"""
#"


DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

def Test(tester):
    try:
        _Test(tester)
    finally:
##         if os.path.exists('Test'):
##            from distutils import dir_util
##            dir_util.remove_tree('Test')
        pass

def _Test(tester):

    tester.startGroup('Basic support for operations %s driver' % tester.ods_driver_name)

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        from Test import Student
        import Test
    except:
        tester.error('Error in syntax', 1)
    tester.testDone()

    reload(Student)
    reload(Test)
    
    db = Database.Database()
    db.open(DBNAME)

    tx = db.new()
    tx.begin()

    tester.startTest('Execute a unregistered operation')

    s = Student.new(db)
    s.name = 'Mike Olson'

    gl = Test.GradeList(db)
    gl.insert_element(4)
    gl.insert_element(3)
    
    tester.testException(s.calcGPA,(gl,),FtodsOperationNotImplemented)
    tester.testException(s.calcGPA,(1,),FtodsOperationBadParam)

    tx.commit()
    tester.testDone()


    tester.startTest('Test Register of an operation')
    
    sid = s._4ods_getOid()

    tx = db.new()
    tx.begin()

    s = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,sid)

    tx.abort()

    tester.testDone()


    db.close()
    tester.groupDone()

    return

if __name__ == '__main__':


    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1, 1)
    from Ft.Ods.StorageManager import Adapters
    tester.ods_driver_name = Adapters.g_driverName

    retVal = Test(tester)
    sys.exit(retVal)

