#include "Python.h"
#include "domlette.h"

/*Internal Interfaces*/


/*External Interfaces*/

static char PyDOMImplementation_hasFeature__doc__[] =
"Get an attribute from a namespace";
PyObject *PyDOMImplementation_hasFeature(PyObject * self, PyObject * args) {
/*     _features = {'CORE' : 2.0, */
/*                  'XML' : 2.0, */
/*                  } */

/*     def hasFeature(self, feature, version=''): */
/*         fv = self._features.get(string.upper(feature)) */
/*         if fv: */
/*             if version: */
/*                 try: */
/*                     return float(version) == fv */
/*                 except: */
/*                     return 0 */
/*             return 1 */
/*         return 0 */


  char *feature;
  char *version;
  PyObject *res;

  if(!PyArg_ParseTuple(args,"ss:hasFeature",&feature,&version)) 
    return NULL;

  if (strcasecmp(feature,"core") ) {
    res = PyInt_FromLong(0);
  }
  else if (atoi(version) <= 2.0 ) {
    res = PyInt_FromLong(1);
  } else {
    res = PyInt_FromLong(0);
  }
  return res;
}



static struct PyMethodDef DOMImplementation_methods[] = {
  {"hasFeature",   (PyCFunction)PyDOMImplementation_hasFeature,  METH_VARARGS, PyDOMImplementation_hasFeature__doc__},
  {NULL,     NULL}      /* sentinel */
};





/*
  Type Interfaces
*/

static PyObject *domimp_getattr(PyTextObject *self, char *name)
{
  return Py_FindMethod(DOMImplementation_methods, (PyObject *)self, name);
}


static void
domimp_dealloc(PyTextObject *node)
{
  PyMem_DEL(node);
}


void domimp_build_display_string(char * buf, PyDOMImplementationObject *v)
{
  sprintf(buf, "<cDomlette DOMImplemntation at %x>", (long)v);
}

static int
domimp_print(v, fp, flags)
     PyDOMImplementationObject *v;
     FILE *fp;
     int flags; /* Not used but required by interface */
{
  char buf[256];
  domimp_build_display_string(buf,v);
  fputs(buf, fp);
  return 0;
}


PyTypeObject PyDomletteDOMImplementation_Type = {
    PyObject_HEAD_INIT(0)
    0,
    "cDomlette.DOMImplmentation",
    sizeof(PyDOMImplementationObject),
    0,
    (destructor)domimp_dealloc,   /*tp_dealloc*/
    (printfunc)domimp_print,  /*tp_print*/
    (getattrfunc)domimp_getattr,  /*tp_getattr*/
    0,              /*tp_setattr*/
    0,                          /*tp_compare*/
    0,          /*tp_repr*/
    0,                          /*tp_as_number*/
    0,              /*tp_as_sequence*/
    0,              /*tp_as_mapping*/
    0,                             /*tp_hash*/
    0,          /*tp_call*/
    0,          /*tp_str*/
    0,                      /*tp_getattro*/
    0,          /*tp_setattro*/
};

