--TEST--
maxdb_fetch_fields_oo
--SKIPIF--
<?php require 'skipifoo.inc'; ?>
--FILE--
<?php
$maxdb = new maxdb("localhost", "MONA", "RED", "DEMODB");

/* check connection */
if (maxdb_connect_errno()) {
   printf("Connect failed: %s\n", maxdb_connect_error());
   exit();
}

$query = "SELECT name, cno from hotel.customer ORDER BY cno";

if ($result = $maxdb->query($query)) {

   /* Get field information for all columns */
   $finfo = $result->fetch_fields();

   for ($i=0; $i < count($finfo); $i++) { 
       printf("Name:     %s\n", $finfo[$i]->name);
       printf("Table:    %s\n", $finfo[$i]->table);
       printf("max. Len: %d\n", $finfo[$i]->max_length);
       printf("Flags:    %d\n", $finfo[$i]->flags);
       printf("Type:     %d\n\n", $finfo[$i]->type);
   }    
   $result->close();
}

/* close connection */
$maxdb->close();
?>
--EXPECTF--
Name:     NAME
Table: %s
max. Len: 10
Flags:    -1
Type:     2

Name:     CNO
Table: %s
max. Len: 4
Flags:    -1
Type:     0
