<?php

    //
    // $Id: radius.php,v 1.1 2002/01/20 11:52:59 mavetju Exp $
    //

    //
    // This script is protected. Only people who are able to
    // authenticate themselves against a Radius server will be
    // allowed to watch this.
    //

    //
    // To make sure that the radius-server isn't overflown by
    // requests and that it still works if the Radius server
    // is using a one-time-password, we keep a local cache
    // of the already authenticated people. The cache is valid
    // for 15 minutes, but refreshed everytime a user is
    // requesting this page (within the 15 minutes of course).
    //
    // The name of the cache is /tmp/radiuscache
    // The name of the cookie is radius_test
    //
    // To use dbm-files you should compile PHP with --with-ndbm --with-db

    if ($PHP_AUTH_USER=="") {
	header("HTTP/1.0 401 Unauthorized");
	Header("WWW-Authenticate: Basic realm=\"PHP Radius test script\"");
	echo "<html><head><title>401 Unauthorized access</title></head><body>";
	echo "<h1>401 Unauthorized access</h1>";
	echo "You must login using your username and password.</body></html>";
	exit;
    }

    require "radius_authentication.inc";
    function radius_authenticate($user,$password) {
	global $HTTP_COOKIE_VARS;
	global $REMOTE_ADDR;

	if (($db=dba_open("/tmp/radiuscache","c","ndbm"))==FALSE) {
	    echo "Couldn't open /tmp/radiuscache<br>\n";
	}

	$cookie=$HTTP_COOKIE_VARS["radius_test"];
	if ($cookie!="") {
	    $lastid=dba_fetch($cookie."_id",$db);
	    $laston=dba_fetch($cookie."_laston",$db);
	    $lasthost=dba_fetch($cookie."_fromip",$db);
	    $lastuserid=dba_fetch($cookie."_userid",$db);
	}

	//
	// Sanity checking
	//
	if ($cookie=="" || $lastid=="" ||
	    $laston==0 || $laston<time()-15*60 ||
	    $lasthost!=$REMOTE_ADDR || $lastuserid!=$user) {

	    // 2 -> Access-Accept
	    // 3 -> Access-Reject
	    if (($retval=RADIUS_AUTHENTICATION($user,$password))==2) {
		if ($cookie=="") $cookie=md5(uniqid(rand()));
		setcookie("radius_test",$cookie);
		dba_replace($cookie."_id",$cookie,$db);
		dba_replace($cookie."_userid",$user,$db);
		dba_replace($cookie."_fromip",$REMOTE_ADDR,$db);
		dba_replace($cookie."_laston",time(),$db);
	    }
	} else {
	    setcookie("radius_test",$cookie);
	    dba_replace($cookie."_laston",time(),$db);
	    $retval=2;
	}

	dba_close($db);
	return $retval==2;
    }

    if (!radius_authenticate($PHP_AUTH_USER,$PHP_AUTH_PW)) {
	header("HTTP/1.0 401 Unauthorized");
	Header("WWW-Authenticate: Basic realm=\"PHP Radius test script\"");
	echo "<html><head><title>401 Unauthorized access</title></head><body>";
	echo "<h1>401 Unauthorized access</h1>";
	echo "You must login using a valid username and password</body></html>";
	echo "Used was '$PHP_AUTH_USER' '$PHP_AUTH_PW'<br>\n";
	exit;
    }
	
    echo "<html><head><title>200 Welcome!</title></head><body>";
    echo "<h1>200 Welcome</h1>";
    echo "You logged in using a valid username and password</body></html>";

?>
