<?php
/*
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the MIT license.
 */

namespace ProxyManagerTest\ProxyGenerator\Hydrator\PropertyGenerator;

use ProxyManager\ProxyGenerator\Hydrator\PropertyGenerator\PropertyAccessor;
use ProxyManager\ProxyGenerator\LazyLoadingValueHolder\PropertyGenerator\InitializerProperty;
use ProxyManagerTest\ProxyGenerator\PropertyGenerator\AbstractUniquePropertyNameTest;
use ReflectionProperty;

/**
 * Tests for {@see \ProxyManager\ProxyGenerator\Hydrator\PropertyGenerator\PropertyAccessor}
 *
 * @author Marco Pivetta <ocramius@gmail.com>
 * @license MIT
 *
 * @covers \ProxyManager\ProxyGenerator\Hydrator\PropertyGenerator\PropertyAccessor
 */
class PropertyAccessorTest extends AbstractUniquePropertyNameTest
{
    /**
     * {@inheritDoc}
     */
    protected function createProperty()
    {
        $property = new ReflectionProperty('ProxyManagerTestAsset\\BaseClass', 'publicProperty');

        return new PropertyAccessor($property);
    }

    /**
     * @covers \ProxyManager\ProxyGenerator\Hydrator\PropertyGenerator\PropertyAccessor::__construct
     * @covers \ProxyManager\ProxyGenerator\Hydrator\PropertyGenerator\PropertyAccessor::getOriginalProperty
     */
    public function testGetOriginalProperty()
    {
        $property = new ReflectionProperty('ProxyManagerTestAsset\\BaseClass', 'publicProperty');

        $accessor = new PropertyAccessor($property);

        $this->assertSame($property, $accessor->getOriginalProperty());
    }

    /**
     * @covers \ProxyManager\ProxyGenerator\Hydrator\PropertyGenerator\PropertyAccessor::__construct
     */
    public function testHasCorrectName()
    {
        $property = new ReflectionProperty('ProxyManagerTestAsset\\BaseClass', 'publicProperty');

        $accessor = new PropertyAccessor($property);

        $this->assertStringMatchesFormat('publicPropertyAccessor%s', $accessor->getName());
    }
}
