#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npserver.h"

int NP_Server::do_connect( const char *server, char *mode,
                           int ( *callback )( void *, int, int ),
                           void *data )
{
   if ( server == NULL )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Server: doconnect(): NULL address passed as argument." );
      return 1;
   }

   if ( mode == NULL || ( strcmp( mode, "r" ) && strcmp( mode, "rw" )))
   {
      snprintf( error_message, sizeof error_message, "NP_Server: doconnect(): "
                "invalid mode: %s", mode );
      return 1;
   }
   
   if ( address != NULL )
      free( ( char *)address );
   
   if (( address = strdup( server )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   char buffer[ 1024 ];
   if ( open_server( ( char *)address, callback, data, -1 ))
      return 1;
   
   char *test;
   int i;
   
   if ( mode[ 1 ] == '\0' )
    {
       test = "20";
       i = 2;
    }
   else
   {
      test = "200";
      i = 3;
   }

   if ( np_fgets( buffer, sizeof buffer ))
      return 1;
   
   if ( strncmp( buffer, test, i ))
   {
      snprintf( error_message, sizeof error_message, "NP_Server: "
                "do_connect(): server responded with: %s.", buffer );
      return 1;
   }

   return 0;
}


