#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "npfile.h"
#include "npgeneral.h"

int NP_General::save()
{
   int existing;
   char buffer[ 1024 ], *local_email, *local_editor, *local_browser, *pointer;

   if ( config.openr( config_path ))
   {
      if ( errno != ENOENT )
      {
         config.print_error();
         return 1;
      }
      existing = 0;
   }
   else
      existing = 1;

   if ( temp.openw( temp_path ))
   {
      temp.print_error();
      config.close();
      return 1;
   }

   char *none = "(none)";
   
   local_email = (( email == NULL ) ? none : email );
   local_editor = (( editor == NULL ) ? none : editor );
   local_browser = (( browser == NULL ) ? none : browser );
   
   snprintf( buffer, sizeof buffer, "%s\n%s\n%s\n%d\n",
             local_email, local_editor, local_browser, expiry );
   if ( temp.put_string( buffer ))
   {
      temp.print_error();
      temp.close();
      config.close();
      return 1;
   }

   if ( existing )
   {
      int x = 4;

      while( x-- )
         if ( config.get_string() == NULL )
            break;
   
      while(( pointer = config.get_string()) != NULL )
         if ( temp.put_string( pointer ))
         {
            temp.print_error();
            temp.close();
            config.close();
            return 1;
         }
   }

   temp.close();
   config.close();
   
   if ( rename( temp_path, config_path ))
      return 1;

   return 0;
}
