#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npstringarray.h"

int NP_Stringarray::add_item( const char *source )
{
   if ( mutex )
      return 3;

   mutex = 1;
   
   if ( source == NULL )
   {
      strcpy( error_message, "NP_Stringarray: add_item(): NULL source item"
              " passed as argument." );
      mutex = 0;
      return 1;
   }
   
   if ( total && !duplicates_allowed )
   {
      char **pointer = item_list;
      int i;
      for( i = 0; i < total; ++i )
      {
         if ( !strcmp( source, *pointer ))
            break;
         ++pointer;
      }
      
      if ( i != total )
      {
         snprintf( error_message, sizeof error_message, "NP_Stringarray: "
                   " add_item(): %s has already been added to this object.",
                   source );
         mutex = 0;
         return 2;
      }
   }

   if (( item_list = ( char **)realloc( item_list,
                                        ++total * sizeof *item_list ))
       == NULL )
   {
      perror( "realloc" );
      exit( 1 );
   }

   if (( item_list[ total - 1 ] = strdup( source )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   mutex = 0;
   return 0;
}
