//
// C++ Interface: filenameviewimpl
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __FILENAMEVIEWIMPL_H_2005_06_14
#define __FILENAMEVIEWIMPL_H_2005_06_14

#include "filenameview.h"

#include <processcontainer.h>
//Added by qt3to4:
#include <QMouseEvent>

class QWidget;
class QMouseEvent;

namespace NPlugin
{
	class IProvider;
}

/** @brief This subclasses the FilenameView to allow easy extension.
  *
  * It is used to display a set of files to the user, or alternatively an error message.
  * Use the addEntry() function to add a new file to the list of files
  * and the setErrorMessage() to set an error message. If an error message is displayed,
  * the entries will not be shown. 
  *
  * Additionally a context menu can be shown which allows the user to copy the 
  * file path or to view the file using the <tt>see</tt> command. For <tt>see</tt>
  * the function viewFile(QString) is called.
  *
  * The FilenameView is capable of filtering the items according to the input in a textbox
  * on top of the filelist.
  * 
  * @author Benjamin Mesing
  */
class FilenameViewImpl : public FilenameView
{
	Q_OBJECT
	NApplication::ProcessContainer _processContainer;
	NPlugin::IProvider* _pProvider;
public:
	/** @brief Create the widget using pProvider to give feedback to the user.
	  */
	FilenameViewImpl(QWidget* pParent, QString name, NPlugin::IProvider* pProvider);

	~FilenameViewImpl();
	/** @brief Views the file using the <tt>see</tt> command. 
	 * 
	 * Reports an error to the provider if the viewing fails.
	 */
	virtual void viewFile(QString filename);
	/** @brief Called whenever one of the processes (executing see) exited.
	  *
	  * It tries to detect if the process exited successfully and if not it 
	  * tries to relaunch see handing the mime-type text/plain as fallback.
	  * 
	  * If the process exited successfully or a try with text/plain was already
	  * attempted, the process will be deleted.
	  */
	virtual void onProcessExited(Q3Process* pProcess);
protected slots:
	virtual void onItemDoubleClicked(Q3ListViewItem* pItem, const QPoint& pos, int column);
};

#endif	// __FILENAMEVIEWIMPL_H_2005_06_14

