//
// C++ Interface: debtagssettingswidget
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __DEBTAGSSETTINGSWIDGET_H_2005_08_28
#define __DEBTAGSSETTINGSWIDGET_H_2005_08_28

#include <set>


#include <qwidget.h>

#include <ui_debtagssettingswidget.h>

using namespace std;

/** @brief Widget used to let the user select facets to be hidden and shown.
  *
  * @author Benjamin Mesing
  */
class DebtagsSettingsWidget : public QWidget, public Ui::DebtagsSettingsWidget
{
Q_OBJECT
public:
	/**
	  * @param hiddenFacets the facets which are selected to be hidden	
	  */
	DebtagsSettingsWidget(const set<string>& hiddenFacets, QWidget *parent = 0, const char *name = 0);
	~DebtagsSettingsWidget();
	/** @brief This returns all facets that where selected to be hidden. */
	set<string> hiddenFacets();
	/** @brief This returns all facets that where selected to be shown. */
	set<string> shownFacets();
protected slots:
	/** @brief The button to add facets to the hidden facets was clicked. */
	void on__pAddButton_clicked();
	/** @brief The button to remove facets from the hidden facets was clicked. */
	void on__pRemoveButton_clicked();
signals:
	/** @brief Emitted whenever the user hid a facet. */
	void facetHidden(const string& facet);
	/** @brief Emitted whenever the user showed a facet. */
	void facetShown(const string& facet);
};

#endif	// __DEBTAGSSETTINGSWIDGET_H_2005_08_28
