// -*- C++ -*- 
/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef TASK_H
#define TASK_H

#include <cstdio>
#include <string>
#include <vector>
#include <cstdarg>
using namespace std;

#include "base.h"

#include "namedid.h"
#include "timeblock.h"
#include "note.h"
#include "resource.h"
#include "item.h"

class TASK : public NAMED_ID
{
public:

    typedef vector<TASK *> PTRLIST;

    TASK(char *id, char *name, int duration);
    virtual ~TASK(){}

    const char * desc() const  { return mDesc; };
    const char * overrun() const  { return mOverrun; };
    void setOverrun( char * overrun ) { mOverrun = strdup(overrun); };
    void AddNote(const string & note);
    NOTE_ITERATOR begin_notes() { return mNotes.begin(); };
    NOTE_ITERATOR end_notes() { return mNotes.end(); };
    
    void setDaysDone(int days);
    int  nDays() { return mnDays; };
    void Blockify();
    int block() { return mBlock; };
    void setDesc( char * desc );
    void setPercentComplete( double c );
    double percent_complete() const { return mPercentComplete; };
    void setStart( int day ) { mStart = day; };
    int  start() const { return mStart; };
    void setFinish( int day ) { mFinish = day; };
    int  finish() { return mFinish; };
    void setDuration( int d ) { mDuration = d; };
    int  duration() { return mDuration; };
    void setAssigned( RESOURCE *res ) { mAssigned = res; };
    RESOURCE *assigned() const { return mAssigned; };
  // Seems to doesn't exist
  /// \todo check
  //    void StartTask( int d, int type );
  //    void FinishTask( int d, int type );
  //    void WorkBlock( RESOURCE * r, int d1, int d2, TimeBlock::Type type);
    int fullduration() const { return mFullduration; }; 
    void setFullduration( int fd ) { mFullduration = fd; }; 
    int origfullduration() const { return mOrigfullduration; }; 
    // this shouldn't be needed. It should be autoloaded when we set the
    // full duration!!!!!!!!!!
    void setOrigfullduration() { mOrigfullduration = mFullduration; }; 
    int bstart() const { return mBstart; }; 
    void setBstart( int day ) { mBstart = day; };
    int bfinish() const { return mBfinish; }; 
    void setBfinish( int day ) { mBfinish = day; };
    int astart() const { return mAstart; }; 
    void setAstart( int day ) { mAstart = day; };
    int afinish() const { return mAfinish; }; 
    void setAfinish( int day ) { mAfinish = day; };
    void setLstart( int day ) { mLstart = day; };
    int  lstart() { return mLstart; };
    void setLfinish( int day ) { mLfinish = day; };
    int  lfinish() { return mLfinish; };
    int slack() { return mSlack; };
    void setSlack( int s )  { mSlack = s; };

    int children() { return mChildren; };
    int parents() { return mParents; };
    void addDepends( TASK * depends );
    PTRLIST::const_iterator begin_depends() { return mDepends.begin(); }; 
    PTRLIST::const_iterator end_depends() { return mDepends.end(); }; 
    void addFollows( TASK * follows );
    PTRLIST::const_iterator begin_follows() { return mFollows.begin(); }; 
    PTRLIST::const_iterator end_follows() { return mFollows.end(); }; 

    virtual bool isVacation() const { return false; }

    void addTimeBlock(RESOURCE *r, int start, int finish, TimeBlock::Type type);
    TaskTimeBlockIterator begin_when()  { return mWhen.begin(); };
    TaskTimeBlockIterator end_when()  { return mWhen.end(); };
    void addReverseTimeBlock(RESOURCE *r, int start, int finish, TimeBlock::Type type);
    TaskTimeBlockIterator begin_rwhen()  { return mRwhen.begin(); };
    TaskTimeBlockIterator end_rwhen()  { return mRwhen.end(); };
    void copyWhenToReverseWhen();
    bool DayBooked( int dayNo );

    bool overlap(int start, int finish);
    bool isActiveDuring(int start, int finish);

    void addCandidate(RESOURCE *res);
    RESOURCE::PTRLIST::const_iterator begin_cando() { return mCando.begin(); };
    RESOURCE::PTRLIST::const_iterator end_cando() { return mCando.end(); };
    int numCandidates() { return mCando.size(); };

    void addItem(ITEM * item) { mItems.push_back(item); };

    double timeCost();
    double itemCost();
    int numItems() { return mItems.size(); };
    ITEM::PTRLIST::const_iterator begin_items() { return mItems.begin(); };
    ITEM::PTRLIST::const_iterator end_items() { return mItems.end(); };

    // THESE ARE REALLY ATTRIBUTES OF THE SCHEDULER
    // BUT THERE IS ONE PER TASK. LEAVE AS TASK PUBLIC ATTRIBUTES
    // FOR NOW
    int scheduled;    ///< if 1, has been scheduled
    int remaining;    ///< used during schedule
    int rscheduled;   ///< if 1, has been scheduled on reverse run
    int rremaining;   ///< used during reverse schedule

    // THESE ARE REALLY ATTRIBUTES OF THE OUTPUT ROUTINES
    // BUT THERE IS ONE PER TASK. LEAVE AS TASK PUBLIC ATTRIBUTES
    // FOR NOW
    int x1,y1,x2,y2;  ///< gannt chart drawing coordinates
    int nx, ny;	      ///< network diagram drawing coordinates

private:

    char *mDesc;        ///< longer name
    char *mOverrun;     ///< text that describes why the task is running late
    int  mDuration;     ///< number of days of work
    int  mFullduration; ///< adjusted for efficiency of the resource and
                        ///< slippage
    int  mOrigfullduration; ///< fullduration before slippage adjustment
    int  mStart;        ///< when the assigned resource starts doing this
    int  mFinish;       ///< the last day of work
    int  mLstart;       ///< last day assigned resource can start doing this
    int  mLfinish;      ///< last day assigned resource can finish this
    int  mSlack;        ///< float in dates
    int  mAstart;       ///< Actual Start
    int  mAfinish;      ///< Actual Finish
    int  mBstart;       ///< Baseline Start
    int  mBfinish;      ///< Baseline Finish
    bool mBlock;        ///< if true, must be scheduled as a consecutive block
                        ///< of time
    double mPercentComplete; ///< fraction of this task already finished
    RESOURCE *mAssigned;     ///< who is doing this?
    NOTES mNotes;            ///< notes about this task.
    int mnDays;              ///< number of days worked so far

    PTRLIST mDepends; ///< what other tasks must be finished first?
    int  mChildren;   ///< number of dependencies -- increases scheduling priority
    PTRLIST mFollows; ///< what other tasks will be finished after?
    int mParents;     ///< number of follows

    TaskTimeBlockList mWhen;  ///< when is this task scheduled to be done?
    TaskTimeBlockList mRwhen; ///< when is this task scheduled to be done
                              ///< (reverse)?

    RESOURCE::PTRLIST mCando;

  // Doesn't exists in TASK
  /// \todo check
  //    void BookResource(RESOURCE *parent, RESOURCE *r,
  //		      int tstart, int tfinish, TimeBlock::Type type);
  //    void ReverseBookResource(RESOURCE *parent, RESOURCE *r,
  //			     int tstart, int tfinish, TimeBlock::Type type);

    ITEM::PTRLIST mItems; ///< list of materials associated with task

    void Error(char *fmt, ...);
};


class CompareTaskStarts
{
public:
    bool operator()(const TASK * t1, const TASK * t2) const
	{ return t1->start() < t2->start(); };
};

class CompareTaskResources
{
public:
    bool operator()(const TASK * t1, const TASK * t2) const ;
};

    

#endif
